/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser;

public final class CppFoldRecord {
    public static final int INITIAL_COMMENT_FOLD = 1;
    public static final int BLOCK_COMMENT_FOLD = 2;
    public static final int COMMENTS_FOLD = 3;
    public static final int INCLUDES_FOLD = 4;
    public static final int IFDEF_FOLD = 5;
    public static final int CLASS_FOLD = 6;
    public static final int FUNCTION_FOLD = 7;
    public static final int CONSTRUCTOR_FOLD = 8;
    public static final int DESTRUCTOR_FOLD = 9;
    public static final int NAMESPACE_FOLD = 10;
    public static final int COMPOUND_BLOCK_FOLD = 11;
    private final int type;
    private final int startOffset;
    private final int endOffset;

    public CppFoldRecord(int type, int startLnum, int startOffset, int endLnum, int endOffset) {
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public CppFoldRecord(int type, int startOffset, int endOffset) {
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public int getType() {
        return this.type;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String toString() {
        String kind = "Unknown Fold";
        switch (this.type) {
            case 1: {
                kind = "INITIAL_COMMENT_FOLD";
                break;
            }
            case 2: {
                kind = "BLOCK_COMMENT_FOLD";
                break;
            }
            case 3: {
                kind = "COMMENTS_FOLD";
                break;
            }
            case 4: {
                kind = "INCLUDES_FOLD";
                break;
            }
            case 5: {
                kind = "IFDEF_FOLD";
                break;
            }
            case 6: {
                kind = "CLASS_FOLD";
                break;
            }
            case 7: {
                kind = "FUNCTION_FOLD";
                break;
            }
            case 8: {
                kind = "CONSTRUCTOR_FOLD";
                break;
            }
            case 9: {
                kind = "DESTRUCTOR_FOLD";
                break;
            }
            case 10: {
                kind = "NAMESPACE_FOLD";
                break;
            }
            case 11: {
                kind = "COMPOUND_BLOCK_FOLD";
                break;
            }
        }
        return kind + " (" + this.startOffset + ", " + this.endOffset + ")";
    }
}

