/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessageChangedPath;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.historystore.Storage;
import org.netbeans.modules.versioning.historystore.StorageManager;
import org.openide.util.NbBundle;

public class HistoryRegistry {
    private static HistoryRegistry instance;
    private static final Logger LOG;
    static final String PERSISTED_DATA_VERSION = "1.0";
    private Map<VCSFileProxy, List<HgLogMessage>> logs = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<HgLogMessageChangedPath>> changesets = Collections.synchronizedMap(new LinkedHashMap<String, List<HgLogMessageChangedPath>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, List<HgLogMessageChangedPath>> eldest) {
            return this.size() >= 100;
        }
    });

    private HistoryRegistry() {
    }

    public static synchronized HistoryRegistry getInstance() {
        if (instance == null) {
            instance = new HistoryRegistry();
        }
        return instance;
    }

    public HgLogMessage[] getLogs(VCSFileProxy repository, VCSFileProxy[] files, String fromRevision, String toRevision) {
        HgLogMessage[] history = HgCommand.getLogMessages(repository, new HashSet<VCSFileProxy>(Arrays.asList(files)), fromRevision, toRevision, false, false, false, -1, Collections.emptyList(), OutputLogger.getLogger(repository), false);
        if (history.length > 0) {
            for (VCSFileProxy f : files) {
                this.logs.put(f, Arrays.asList(history));
            }
        }
        return history;
    }

    HgLogMessage getLog(VCSFileProxy repository, VCSFileProxy file, String changesetId) {
        HgLogMessage[] history;
        List<HgLogMessage> knownLogs = this.logs.get(file);
        if (knownLogs != null) {
            for (HgLogMessage logMessage : knownLogs) {
                if (!logMessage.getCSetShortID().equals(changesetId)) continue;
                return logMessage;
            }
        }
        return (history = HgCommand.getRevisionInfo(repository, Collections.singletonList(changesetId), OutputLogger.getLogger(repository))) == null || history.length == 0 ? null : history[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSFileProxy getHistoryFile(final VCSFileProxy repository, final VCSFileProxy originalFile, final String revision, final boolean dryTry) {
        VCSFileProxy vCSFileProxy;
        block7: {
            String originalPath;
            long t;
            block5: {
                block6: {
                    t = System.currentTimeMillis();
                    originalPath = HgUtils.getRelativePath(originalFile);
                    try {
                        final List<HgLogMessage> history = this.logs.get(originalFile);
                        final String path = originalPath;
                        final String[] ret = new String[]{null};
                        if (history != null) {
                            HgProgressSupport support = new HgProgressSupport(NbBundle.getMessage(HistoryRegistry.class, (String)"LBL_LookingUp"), null){

                                @Override
                                protected void perform() {
                                    ret[0] = HistoryRegistry.this.getRepositoryPathIntern(history, revision, repository, originalFile, path, dryTry, this);
                                }
                            };
                            support.start(Mercurial.getInstance().getRequestProcessor(repository)).waitFinished();
                        }
                        if (ret[0] == null || ret[0].equals(originalPath)) break block5;
                        vCSFileProxy = VCSFileProxy.createFileProxy((VCSFileProxy)repository, (String)ret[0]);
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                    }
                    catch (Throwable throwable) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
                        }
                        throw throwable;
                    }
                    LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
                }
                return vCSFileProxy;
            }
            vCSFileProxy = null;
            if (!LOG.isLoggable(Level.FINE)) break block7;
            LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
        }
        return vCSFileProxy;
    }

    private String getRepositoryPathIntern(List<HgLogMessage> history, String revision, VCSFileProxy repository, VCSFileProxy originalFile, String path, boolean dryTry, HgProgressSupport support) {
        HgLogMessage lm;
        String historyRevision;
        int count = 0;
        String historyPath = path;
        Iterator<HgLogMessage> it = history.iterator();
        while (it.hasNext() && !revision.equals(it.next().getHgRevision().getChangesetId())) {
            ++count;
        }
        support.getProgressHandle().switchToDeterminate(count);
        block1: for (int i = 0; i < history.size() && !support.isCanceled() && !(historyRevision = (lm = history.get(i)).getHgRevision().getChangesetId()).equals(revision); ++i) {
            List<HgLogMessageChangedPath> changePaths;
            support.getProgressHandle().progress(NbBundle.getMessage(HistoryRegistry.class, (String)"LBL_LookingUpAtRevision", (Object)originalFile.getName(), (Object)historyRevision), i);
            List<HgLogMessageChangedPath> list = changePaths = lm.getChangedPaths().length == 0 ? this.initializeChangePaths(repository, new DefaultChangePathCollector(repository, OutputLogger.getLogger(repository), lm.getCSetShortID()), lm, dryTry) : Arrays.asList(lm.getChangedPaths());
            if (changePaths == null) continue;
            for (HgLogMessageChangedPath cp : changePaths) {
                String copy = cp.getCopySrcPath();
                if (copy == null || !historyPath.equals(cp.getPath())) continue;
                historyPath = copy;
                continue block1;
            }
        }
        return support.isCanceled() ? path : historyPath;
    }

    public List<HgLogMessageChangedPath> initializeChangePaths(VCSFileProxy repository, ChangePathCollector collector, HgLogMessage lm, boolean onlyCached) {
        assert (lm.getChangedPaths().length == 0) : "Why refreshing already loaded change paths??? length=" + lm.getChangedPaths().length;
        String changesetId = lm.getCSetShortID();
        List<HgLogMessageChangedPath> changePaths = this.changesets.get(changesetId);
        if (changePaths == null) {
            long t1 = System.currentTimeMillis();
            boolean persist = true;
            if (!"false".equals(System.getProperty("versioning.mercurial.historycache.enable", "true"))) {
                LOG.log(Level.FINE, "loading changePaths from disk cache for {0}", new Object[]{changesetId});
                persist = false;
                changePaths = this.loadCachedChangePaths(repository, lm.getCSetShortID());
                if (changePaths == null) {
                    persist = true;
                    LOG.log(Level.FINE, "loading changePaths from disk cache failed for {0}", new Object[]{changesetId});
                }
            }
            if (changePaths == null && !onlyCached) {
                LOG.log(Level.FINE, "loading changePaths via hg for {0}", new Object[]{changesetId});
                HgLogMessageChangedPath[] cps = collector.getChangePaths();
                changePaths = Arrays.asList(cps == null ? new HgLogMessageChangedPath[]{} : cps);
            }
            if (changePaths != null) {
                lm.refreshChangedPaths(changePaths.toArray(new HgLogMessageChangedPath[changePaths.size()]));
                this.changesets.put(changesetId, changePaths);
                if (persist && !changePaths.isEmpty() && !"false".equals(System.getProperty("versioning.mercurial.historycache.enable", "true"))) {
                    this.persistPaths(repository, changePaths, lm.getCSetShortID());
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " loading changePaths for {0} took {1}", new Object[]{changesetId, System.currentTimeMillis() - t1});
            }
        } else {
            lm.refreshChangedPaths(changePaths.toArray(new HgLogMessageChangedPath[changePaths.size()]));
        }
        return changePaths;
    }

    private void persistPaths(VCSFileProxy repository, List<HgLogMessageChangedPath> changePaths, String revision) {
        Storage storage = StorageManager.getInstance().getStorage(repository.getPath());
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(content);
        try {
            dos.writeUTF(PERSISTED_DATA_VERSION);
            dos.writeInt(changePaths.size());
            for (HgLogMessageChangedPath path : changePaths) {
                dos.writeUTF(path.getPath());
                dos.writeChar(path.getAction());
                dos.writeUTF(path.getCopySrcPath() == null ? "" : path.getCopySrcPath());
            }
            dos.close();
            LOG.log(Level.FINE, "persisting changePaths to disk cache for {0}", new Object[]{revision});
            storage.setRevisionInfo(revision, (InputStream)new ByteArrayInputStream(content.toByteArray()));
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Cannot persist data", ex);
        }
    }

    private List<HgLogMessageChangedPath> loadCachedChangePaths(VCSFileProxy repository, String revision) {
        Storage storage = StorageManager.getInstance().getStorage(repository.getPath());
        byte[] buff = storage.getRevisionInfo(revision);
        if (buff == null) {
            return null;
        }
        ArrayList<HgLogMessageChangedPath> changePaths = null;
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buff));
        try {
            String version = dis.readUTF();
            if (PERSISTED_DATA_VERSION.equals(version)) {
                int len = dis.readInt();
                changePaths = len == 0 ? null : new ArrayList<HgLogMessageChangedPath>(len);
                for (int i = 0; i < len; ++i) {
                    String path = dis.readUTF();
                    char action = dis.readChar();
                    String copyPath = dis.readUTF();
                    changePaths.add(new HgLogMessageChangedPath(path, copyPath.isEmpty() ? null : copyPath, action));
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "changePaths from disk cache corrupted {0}", new Object[]{revision});
        }
        return changePaths;
    }

    List<HgLogMessageChangedPath> getCachedPaths(String revision) {
        return this.changesets.get(revision);
    }

    void flushCached() {
        this.changesets.clear();
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.mercurial.HistoryRegistry");
    }

    public static final class DefaultChangePathCollector
    implements ChangePathCollector {
        private final VCSFileProxy repositoryRoot;
        private final OutputLogger logger;
        private final String changesetId;

        public DefaultChangePathCollector(VCSFileProxy repositoryRoot, OutputLogger logger, String changesetId) {
            this.repositoryRoot = repositoryRoot;
            this.logger = logger;
            this.changesetId = changesetId;
        }

        @Override
        public HgLogMessageChangedPath[] getChangePaths() {
            HgLogMessage[] messages = HgCommand.getLogMessages(this.repositoryRoot, null, this.changesetId, this.changesetId, true, true, false, 1, Collections.emptyList(), this.logger, true);
            return messages == null || messages.length == 0 ? new HgLogMessageChangedPath[]{} : messages[0].getChangedPaths();
        }
    }

    public static interface ChangePathCollector {
        public HgLogMessageChangedPath[] getChangePaths();
    }
}

