/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.RequestProcessor;

public class WorkingCopyInfo {
    public static final String PROPERTY_WORKING_COPY_PARENT = WorkingCopyInfo.class.getName() + ".workingCopyParents";
    public static final String PROPERTY_CURRENT_BRANCH = WorkingCopyInfo.class.getName() + ".currBranch";
    private static final WeakHashMap<VCSFileProxy, WorkingCopyInfo> cache = new WeakHashMap(5);
    private static final Logger LOG = Logger.getLogger(WorkingCopyInfo.class.getName());
    private static final RequestProcessor rp = new RequestProcessor("WorkingCopyInfo", 1, true);
    private static final RequestProcessor.Task refreshTask = rp.create((Runnable)new RepositoryRefreshTask());
    private static final Set<WorkingCopyInfo> repositoriesToRefresh = new HashSet<WorkingCopyInfo>(2);
    private final WeakReference<VCSFileProxy> rootRef;
    private final PropertyChangeSupport propertyChangeSupport;
    private HgLogMessage[] parents = new HgLogMessage[0];
    private String branch = "default";

    private WorkingCopyInfo(VCSFileProxy root) {
        this.rootRef = new WeakReference<VCSFileProxy>(root);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkingCopyInfo getInstance(VCSFileProxy repositoryRoot) {
        WorkingCopyInfo info = null;
        VCSFileProxy repositoryRootSingleInstance = Mercurial.getInstance().getRepositoryRoot(repositoryRoot);
        if (repositoryRoot.equals((Object)repositoryRootSingleInstance)) {
            boolean refresh = false;
            WeakHashMap<VCSFileProxy, WorkingCopyInfo> weakHashMap = cache;
            synchronized (weakHashMap) {
                info = cache.get(repositoryRootSingleInstance);
                if (info == null) {
                    info = new WorkingCopyInfo(repositoryRootSingleInstance);
                    cache.put(repositoryRootSingleInstance, info);
                    refresh = true;
                }
            }
            if (refresh) {
                info.refresh();
            }
        }
        return info;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void refresh() {
        assert (!EventQueue.isDispatchThread());
        VCSFileProxy root = (VCSFileProxy)this.rootRef.get();
        try {
            if (root == null) {
                LOG.log(Level.WARNING, "refresh (): root is null, it has been collected in the meantime");
            } else {
                LOG.log(Level.FINE, "refresh (): starting for {0}", root);
                List<HgLogMessage> parentInfo = HgCommand.getParents(root, null, null);
                this.setParents(parentInfo);
                String branch = HgCommand.getBranch(root);
                this.setBranch(branch);
            }
        }
        catch (HgException.HgCommandCanceledException parentInfo) {
        }
        catch (HgException ex) {
            Level level = root.exists() ? Level.INFO : Level.FINE;
            LOG.log(level, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshAsync(VCSFileProxy repositoryRoot) {
        WorkingCopyInfo info = null;
        WeakHashMap<VCSFileProxy, WorkingCopyInfo> weakHashMap = cache;
        synchronized (weakHashMap) {
            info = cache.get(repositoryRoot);
        }
        if (info != null) {
            boolean start = false;
            Set<WorkingCopyInfo> set = repositoriesToRefresh;
            synchronized (set) {
                start = repositoriesToRefresh.add(info);
            }
            if (start) {
                LOG.log(Level.FINE, "Planning refresh for {0}", repositoryRoot);
                refreshTask.schedule(3000);
            }
        }
    }

    public HgLogMessage[] getWorkingCopyParents() {
        return this.parents;
    }

    public String getCurrentBranch() {
        return this.branch;
    }

    private void setParents(List<HgLogMessage> parents) {
        boolean changed;
        HgLogMessage[] oldParents = this.parents;
        boolean bl = changed = oldParents.length != parents.size();
        if (!changed) {
            for (HgLogMessage newParent : parents) {
                boolean contains = false;
                for (HgLogMessage oldParent : oldParents) {
                    if (!oldParent.getCSetShortID().equals(newParent.getCSetShortID()) || oldParent.getTags().length != newParent.getTags().length || !new HashSet<String>(Arrays.asList(oldParent.getTags())).equals(new HashSet<String>(Arrays.asList(newParent.getTags())))) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            HgLogMessage[] newParents = parents.toArray(new HgLogMessage[parents.size()]);
            this.parents = newParents;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_WORKING_COPY_PARENT, oldParents, newParents);
        }
    }

    private void setBranch(String branch) {
        if (branch == null) {
            branch = "default";
        }
        String oldBranch = this.branch;
        this.branch = branch;
        if (!oldBranch.equals(this.branch)) {
            this.propertyChangeSupport.firePropertyChange(PROPERTY_CURRENT_BRANCH, oldBranch, branch);
        }
    }

    private static class RepositoryRefreshTask
    implements Runnable {
        private RepositoryRefreshTask() {
        }

        @Override
        public void run() {
            WorkingCopyInfo info;
            while ((info = this.getNextRepositoryInfo()) != null) {
                info.refresh();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WorkingCopyInfo getNextRepositoryInfo() {
            WorkingCopyInfo info = null;
            Set set = repositoriesToRefresh;
            synchronized (set) {
                Iterator it = repositoriesToRefresh.iterator();
                if (it.hasNext()) {
                    info = (WorkingCopyInfo)it.next();
                    it.remove();
                }
            }
            return info;
        }
    }
}

