/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.pull;

import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.pull.Bundle;
import org.netbeans.modules.mercurial.remote.ui.pull.PullAction;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PullCurrentBranchAction
extends ContextAction {
    public static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/pull.png";

    public PullCurrentBranchAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PullBranchLocal";
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<VCSFileProxy> roots = HgUtils.getRepositoryRoots(ctx);
        return roots.size() == 1 ? NbBundle.getMessage(PullCurrentBranchAction.class, (String)"CTL_MenuItem_PullBranchRoot", (Object)roots.iterator().next().getName()) : NbBundle.getMessage(PullCurrentBranchAction.class, (String)"CTL_MenuItem_PullBranchLocal");
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<VCSFileProxy> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = repositoryRoots.iterator();
                while (iterator.hasNext()) {
                    VCSFileProxy repositoryRoot;
                    final VCSFileProxy root = repositoryRoot = (VCSFileProxy)iterator.next();
                    try {
                        final String branch = HgCommand.getBranch(root);
                        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                        HgProgressSupport support = new HgProgressSupport(){

                            @Override
                            public void perform() {
                                PullAction.getDefaultAndPerformPull(root, null, branch, this);
                            }
                        };
                        support.start(rp, root, Bundle.MSG_PULL_BRANCH_PROGRESS(branch)).waitFinished();
                        if (!support.isCanceled()) continue;
                        break;
                    }
                    catch (HgException.HgCommandCanceledException rp) {
                    }
                    catch (HgException ex) {
                        HgUtils.notifyException(ex);
                    }
                }
            }
        });
    }
}

