/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.web.struts.config.model.Action;
import org.netbeans.modules.web.struts.config.model.ActionMappings;
import org.netbeans.modules.web.struts.config.model.FormBean;
import org.netbeans.modules.web.struts.config.model.FormBeans;
import org.netbeans.modules.web.struts.config.model.MessageResources;
import org.netbeans.modules.web.struts.config.model.StrutsConfig;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class StrutsConfigUtilities {
    public static String DEFAULT_MODULE_NAME = "config";
    private static final int TYPE_ACTION = 0;
    private static final int TYPE_FORM_BEAN = 1;
    private static final int TYPE_MESSAGE_RESOURCES = 2;

    public static List getAllActionsInModule(StrutsConfigDataObject data) {
        return StrutsConfigUtilities.createConfigElements(0, data);
    }

    public static List getAllFormBeansInModule(StrutsConfigDataObject data) {
        return StrutsConfigUtilities.createConfigElements(1, data);
    }

    public static List getAllMessageResourcesInModule(StrutsConfigDataObject data) {
        return StrutsConfigUtilities.createConfigElements(2, data);
    }

    private static List createConfigElements(int elementType, StrutsConfigDataObject data) {
        FileObject ddFo;
        FileObject config = data.getPrimaryFile();
        ArrayList list = new ArrayList();
        WebModule wm = WebModule.getWebModule((FileObject)config);
        if (wm != null && (ddFo = wm.getDeploymentDescriptor()) != null) {
            String moduleName = StrutsConfigUtilities.getModuleName(config, ddFo);
            if (moduleName == null) {
                try {
                    StrutsConfig sConfig = data.getStrutsConfig(true);
                    switch (elementType) {
                        case 0: {
                            StrutsConfigUtilities.addActions(list, sConfig);
                            break;
                        }
                        case 1: {
                            StrutsConfigUtilities.addFormBeans(list, sConfig);
                            break;
                        }
                        case 2: {
                            StrutsConfigUtilities.addMessageResource(list, sConfig);
                        }
                    }
                }
                catch (IOException sConfig) {}
            } else {
                FileObject[] configs = StrutsConfigUtilities.getConfigFiles(moduleName, ddFo);
                for (int i = 0; i < configs.length; ++i) {
                    DataObject dOb;
                    try {
                        dOb = DataObject.find((FileObject)configs[i]);
                    }
                    catch (DataObjectNotFoundException e) {
                        dOb = null;
                    }
                    if (dOb == null || !(dOb instanceof StrutsConfigDataObject)) continue;
                    StrutsConfigDataObject con = (StrutsConfigDataObject)dOb;
                    try {
                        StrutsConfig sConfig = con.getStrutsConfig(true);
                        switch (elementType) {
                            case 0: {
                                StrutsConfigUtilities.addActions(list, sConfig);
                                break;
                            }
                            case 1: {
                                StrutsConfigUtilities.addFormBeans(list, sConfig);
                                break;
                            }
                            case 2: {
                                StrutsConfigUtilities.addMessageResource(list, sConfig);
                            }
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return list;
    }

    private static void addActions(List list, StrutsConfig sConfig) {
        ActionMappings mappings = null;
        if (sConfig != null) {
            mappings = sConfig.getActionMappings();
        }
        if (mappings == null) {
            return;
        }
        Action[] actions = mappings.getAction();
        for (int j = 0; j < actions.length; ++j) {
            list.add(actions[j]);
        }
    }

    private static void addFormBeans(List list, StrutsConfig sConfig) {
        FormBeans formBeans = sConfig.getFormBeans();
        if (formBeans == null) {
            return;
        }
        FormBean[] beans = formBeans.getFormBean();
        for (int j = 0; j < beans.length; ++j) {
            list.add(beans[j]);
        }
    }

    private static void addMessageResource(List list, StrutsConfig sConfig) {
        MessageResources[] rosources = sConfig.getMessageResources();
        for (int j = 0; j < rosources.length; ++j) {
            list.add(rosources[j]);
        }
    }

    public static FileObject[] getConfigFiles(String module, FileObject dd) {
        WebModule wm = WebModule.getWebModule((FileObject)dd);
        if (wm == null) {
            return null;
        }
        FileObject docBase = wm.getDocumentBase();
        if (docBase == null) {
            return null;
        }
        Servlet servlet = StrutsConfigUtilities.getActionServlet(dd);
        InitParam param = null;
        param = module.equals(DEFAULT_MODULE_NAME) ? (InitParam)servlet.findBeanByName("InitParam", "ParamName", DEFAULT_MODULE_NAME) : (InitParam)servlet.findBeanByName("InitParam", "ParamName", DEFAULT_MODULE_NAME + "/" + module);
        FileObject[] configs = null;
        if (param != null) {
            StringTokenizer st = new StringTokenizer(param.getParamValue(), ",");
            configs = new FileObject[st.countTokens()];
            int index = 0;
            while (st.hasMoreTokens()) {
                String name = st.nextToken().trim();
                configs[index] = docBase.getFileObject(name);
                ++index;
            }
        }
        return configs;
    }

    public static String getModuleName(FileObject config, FileObject dd) {
        Servlet servlet;
        String moduleName = null;
        if (dd != null && (servlet = StrutsConfigUtilities.getActionServlet(dd)) != null) {
            InitParam[] param = servlet.getInitParam();
            Object st = null;
            block0: for (int index = 0; moduleName == null && index < param.length; ++index) {
                if (!param[index].getParamName().trim().startsWith(DEFAULT_MODULE_NAME)) continue;
                String[] files = param[index].getParamValue().split(",");
                for (int i = 0; i < files.length; ++i) {
                    String file = files[i];
                    if (!config.getPath().endsWith(file)) continue;
                    if (!param[index].getParamName().trim().equals(DEFAULT_MODULE_NAME)) {
                        moduleName = param[index].getParamName().trim().substring(DEFAULT_MODULE_NAME.length() + 1);
                        continue block0;
                    }
                    moduleName = DEFAULT_MODULE_NAME;
                    continue block0;
                }
            }
        }
        return moduleName;
    }

    public static Servlet getActionServlet(FileObject dd) {
        if (dd == null) {
            return null;
        }
        try {
            WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
            Servlet servlet = (Servlet)webApp.findBeanByName("Servlet", "ServletClass", "org.apache.struts.action.ActionServlet");
            if (servlet != null) {
                return servlet;
            }
            final Servlet[] servlets = webApp.getServlet();
            if (servlets.length == 0) {
                return null;
            }
            ClasspathInfo cpi = ClasspathInfo.create((FileObject)dd);
            JavaSource js = JavaSource.create((ClasspathInfo)cpi, (Collection)Collections.EMPTY_LIST);
            final int[] index = new int[]{-1};
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    Elements elements = cc.getElements();
                    TypeElement strutsServletElement = elements.getTypeElement("org.apache.struts.action.ActionServlet");
                    if (strutsServletElement != null) {
                        for (int i = 0; i < servlets.length; ++i) {
                            TypeElement servletElement;
                            String servletClass = servlets[i].getServletClass();
                            if (servletClass == null || (servletElement = elements.getTypeElement(servletClass)) == null || !cc.getTypes().isSubtype(servletElement.asType(), strutsServletElement.asType())) continue;
                            index[0] = i;
                            break;
                        }
                    }
                }
            }, false);
            if (index[0] > -1) {
                servlet = servlets[index[0]];
            }
            return servlet;
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
            return null;
        }
    }

    public static String getActionServletMapping(FileObject dd) {
        Servlet servlet = StrutsConfigUtilities.getActionServlet(dd);
        if (servlet != null) {
            try {
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                ServletMapping[] mappings = webApp.getServletMapping();
                for (int i = 0; i < mappings.length; ++i) {
                    if (!mappings[i].getServletName().equals(servlet.getServletName())) continue;
                    return ((ServletMapping25)mappings[i]).getUrlPatterns()[0];
                }
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        return null;
    }

    public static String[] getConfigFiles(FileObject dd) {
        Servlet servlet;
        if (dd != null && (servlet = StrutsConfigUtilities.getActionServlet(dd)) != null) {
            InitParam[] params = servlet.getInitParam();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < params.length; ++i) {
                String paramName = params[i].getParamName();
                if (paramName == null || !paramName.startsWith(DEFAULT_MODULE_NAME)) continue;
                String[] files = params[i].getParamValue().split(",");
                for (int j = 0; j < files.length; ++j) {
                    list.add(files[j]);
                }
            }
            String[] result = new String[list.size()];
            list.toArray(result);
            return result;
        }
        return new String[0];
    }

    public static FileObject[] getConfigFilesFO(FileObject dd) {
        if (dd != null) {
            WebModule wm = WebModule.getWebModule((FileObject)dd);
            if (wm == null) {
                return null;
            }
            FileObject docBase = wm.getDocumentBase();
            if (docBase == null) {
                return null;
            }
            Servlet servlet = StrutsConfigUtilities.getActionServlet(dd);
            if (servlet != null) {
                InitParam[] params = servlet.getInitParam();
                ArrayList<FileObject> list = new ArrayList<FileObject>();
                for (int i = 0; i < params.length; ++i) {
                    String paramName = params[i].getParamName();
                    if (paramName == null || !paramName.startsWith(DEFAULT_MODULE_NAME)) continue;
                    String[] files = params[i].getParamValue().split(",");
                    for (int j = 0; j < files.length; ++j) {
                        FileObject file = docBase.getFileObject(files[j]);
                        if (file == null) continue;
                        list.add(file);
                    }
                }
                FileObject[] result = new FileObject[list.size()];
                list.toArray(result);
                return result;
            }
        }
        return new FileObject[0];
    }

    public static SourceGroup[] getDocBaseGroups(FileObject fo) throws IOException {
        Project proj = FileOwnerQuery.getOwner((FileObject)fo);
        if (proj == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)proj);
        return sources.getSourceGroups("doc_root");
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator, boolean withExt) {
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (relativePath != null) {
                int index;
                if (separator != '/') {
                    relativePath = relativePath.replace('/', separator);
                }
                if (!withExt && (index = relativePath.lastIndexOf(46)) > 0) {
                    relativePath = relativePath.substring(0, index);
                }
                return relativePath;
            }
            return "";
        }
        return "";
    }

    public static String getWelcomeFile(String URLPattern, String pageName) {
        int indWild = URLPattern.indexOf("*");
        if (indWild >= 0) {
            String pPrefix = URLPattern.substring(0, indWild);
            String pSuffix = URLPattern.substring(indWild + 1);
            if (pPrefix.length() > 0) {
                while (pPrefix.startsWith("/")) {
                    pPrefix = pPrefix.substring(1);
                }
            }
            return pPrefix + pageName + pSuffix;
        }
        return "do/" + pageName;
    }

    public static String getActionAsResource(WebModule wm, String action) {
        String resource = "";
        String mapping = StrutsConfigUtilities.getActionServletMapping(wm.getDeploymentDescriptor());
        if (mapping != null && mapping.length() > 0) {
            if (mapping.startsWith("*.")) {
                resource = action + mapping.substring(1);
            } else if (mapping.endsWith("/*")) {
                resource = mapping.substring(0, mapping.length() - 2) + action;
            }
        }
        return resource;
    }

    public static String getActionAsResource(String mapping, String action) {
        String resource = "";
        if (mapping != null && mapping.length() > 0) {
            if (mapping.startsWith("*.")) {
                resource = action + mapping.substring(1);
            } else if (mapping.endsWith("/*")) {
                resource = mapping.substring(0, mapping.length() - 2) + action;
            }
        }
        return resource;
    }

    public static MessageResources getDefatulMessageResource(FileObject dd) {
        FileObject[] files = StrutsConfigUtilities.getConfigFilesFO(dd);
        if (files == null) {
            return null;
        }
        MessageResources resource = null;
        try {
            block3: for (int index = 0; resource == null && index < files.length; ++index) {
                StrutsConfig strutsConfig;
                DataObject configDO = DataObject.find((FileObject)files[index]);
                if (configDO == null || !(configDO instanceof StrutsConfigDataObject) || (strutsConfig = ((StrutsConfigDataObject)configDO).getStrutsConfig()) == null) continue;
                MessageResources[] resources = strutsConfig.getMessageResources();
                for (int i = 0; i < resources.length; ++i) {
                    if (resources[i].getAttributeValue("key") != null) continue;
                    resource = resources[i];
                    continue block3;
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            Logger.getLogger("global").log(Level.WARNING, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger("global").log(Level.WARNING, null, ex);
        }
        return resource;
    }
}

