/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.maven.embedder.ArtifactFixer;
import org.openide.util.Lookup;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.repository.WorkspaceRepository;

public class NbWorkspaceReader
implements WorkspaceReader {
    private final WorkspaceRepository repo = new WorkspaceRepository("ide", this.getClass());
    private final Collection<? extends ArtifactFixer> fixers = Lookup.getDefault().lookupAll(ArtifactFixer.class);
    boolean silence = false;

    public WorkspaceRepository getRepository() {
        return this.repo;
    }

    public File findArtifact(Artifact artifact) {
        if (this.silence) {
            return null;
        }
        for (ArtifactFixer artifactFixer : this.fixers) {
            File f = artifactFixer.resolve(artifact);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        if (this.silence) {
            return Collections.emptyList();
        }
        for (ArtifactFixer artifactFixer : this.fixers) {
            File f = artifactFixer.resolve(artifact);
            if (f == null) continue;
            return Collections.singletonList(artifact.getBaseVersion());
        }
        return Collections.emptyList();
    }

    void normal() {
        this.silence = false;
    }

    void silence() {
        this.silence = true;
    }
}

