/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.RemoteJavaExecution;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.AnalyzeFolder;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.source.SourceFile;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class AnalyzeExecutable
extends BaseDwarfProvider {
    public static final String EXECUTABLE_PROVIDER_ID = "dwarf-executable";
    private final Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    private final ProviderProperty<String> EXECUTABLE_PROPERTY;
    private final ProviderProperty<String[]> LIBRARIES_PROPERTY;
    private final ProviderProperty<Boolean> FIND_MAIN_PROPERTY;

    public AnalyzeExecutable() {
        this.myProperties.clear();
        this.EXECUTABLE_PROPERTY = new ProviderProperty<String>(){
            private String myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Executable_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Executable_Files_Description");
            }

            public String getValue() {
                return this.myPath;
            }

            public void setValue(String value) {
                this.myPath = value;
            }

            public ProviderPropertyType<String> getPropertyType() {
                return ProviderPropertyType.ExecutablePropertyType;
            }
        };
        this.myProperties.put(this.EXECUTABLE_PROPERTY.getPropertyType().key(), this.EXECUTABLE_PROPERTY);
        this.LIBRARIES_PROPERTY = new ProviderProperty<String[]>(){
            private String[] myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Libraries_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Libraries_Files_Description");
            }

            public String[] getValue() {
                return this.myPath;
            }

            public void setValue(String[] value) {
                this.myPath = value;
            }

            public ProviderPropertyType<String[]> getPropertyType() {
                return ProviderPropertyType.LibrariesPropertyType;
            }
        };
        this.myProperties.put(this.LIBRARIES_PROPERTY.getPropertyType().key(), this.LIBRARIES_PROPERTY);
        this.FIND_MAIN_PROPERTY = new ProviderProperty<Boolean>(){
            private Boolean findMain = Boolean.TRUE;

            public String getName() {
                return "";
            }

            public String getDescription() {
                return "";
            }

            public Boolean getValue() {
                return this.findMain;
            }

            public void setValue(Boolean value) {
                this.findMain = value;
            }

            public ProviderPropertyType<Boolean> getPropertyType() {
                return ProviderPropertyType.FindMainPropertyType;
            }
        };
        this.myProperties.put(this.FIND_MAIN_PROPERTY.getPropertyType().key(), this.FIND_MAIN_PROPERTY);
        this.myProperties.put(this.BYNARY_FILESYSTEM_PROPERTY.getPropertyType().key(), this.BYNARY_FILESYSTEM_PROPERTY);
        this.myProperties.put(this.RESTRICT_SOURCE_ROOT_PROPERTY.getPropertyType().key(), this.RESTRICT_SOURCE_ROOT_PROPERTY);
        this.myProperties.put(this.RESTRICT_COMPILE_ROOT_PROPERTY.getPropertyType().key(), this.RESTRICT_COMPILE_ROOT_PROPERTY);
    }

    public String getID() {
        return EXECUTABLE_PROVIDER_ID;
    }

    public String getName() {
        return AnalyzeExecutable.i18n("Executable_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeExecutable.i18n("Executable_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project, Interrupter interrupter) {
        this.init(project);
        String set = (String)this.EXECUTABLE_PROPERTY.getValue();
        if (set == null || set.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"NoExecutable")));
        }
        String[] additionalLibs = (String[])this.LIBRARIES_PROPERTY.getValue();
        boolean findMain = (Boolean)this.FIND_MAIN_PROPERTY.getValue();
        HashSet<String> dlls = new HashSet<String>();
        FileSystem fs = (FileSystem)this.BYNARY_FILESYSTEM_PROPERTY.getValue();
        if (fs == null || CndFileUtils.isLocalFileSystem((FileSystem)fs)) {
            ApplicableImpl applicable;
            ArrayList<String> list = new ArrayList<String>();
            list.add(set);
            if (additionalLibs != null) {
                for (String l : additionalLibs) {
                    list.add(l);
                }
            }
            if ((applicable = this.sizeComilationUnit(project, list, dlls, findMain)).isApplicable()) {
                return new ApplicableImpl(true, applicable.getErrors(), applicable.getCompilerName(), 70, applicable.isSunStudio(), applicable.getDependencies(), applicable.getSearchPaths(), applicable.getSourceRoot(), applicable.getMainFunction());
            }
            if (applicable.getErrors().size() > 0) {
                return ApplicableImpl.getNotApplicable((List)applicable.getErrors());
            }
        } else {
            ExecutionEnvironment ee = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
            if (ee.isRemote() && !ConnectionManager.getInstance().isConnectedTo(ee)) {
                return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"CannotAnalyzeExecutable", (Object)set)));
            }
            RemoteJavaExecution processor = new RemoteJavaExecution(fs);
            List<SourceFile> compileLines = processor.getCompileLines(set, false);
            if (compileLines != null) {
                ElfReader.SharedLibraries libs;
                DiscoveryExtensionInterface.Position main = null;
                for (final SourceFile source : compileLines) {
                    if (!source.hasMain()) continue;
                    main = new DiscoveryExtensionInterface.Position(){

                        public String getFilePath() {
                            return source.getSourceFileAbsolutePath();
                        }

                        public int getLine() {
                            return source.getMainLine();
                        }
                    };
                    break;
                }
                if ((libs = processor.getDlls(set)) == null) {
                    return new ApplicableImpl(true, null, null, 0, false, Collections.emptyList(), Collections.emptyList(), processor.getSourceRoot(compileLines), main);
                }
                return new ApplicableImpl(true, null, null, 0, false, libs.getDlls(), libs.getPaths(), processor.getSourceRoot(compileLines), main);
            }
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"CannotAnalyzeExecutable", (Object)set)));
    }

    public List<Configuration> analyze(final ProjectProxy project, Progress progress, Interrupter interrupter) {
        this.resetStopInterrupter(interrupter);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.init(project);
        if (!this.getStopInterrupter().cancelled()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;
                private Set<String> myDependencies;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    if (this.myDependencies == null) {
                        this.getSourcesConfiguration();
                    }
                    return new ArrayList<String>(this.myDependencies);
                }

                public List<String> getBuildArtifacts() {
                    return null;
                }

                public Map<ItemProperties.LanguageKind, Map<String, Integer>> getBuildTools() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        this.myDependencies = new HashSet<String>();
                        String set = (String)AnalyzeExecutable.this.EXECUTABLE_PROPERTY.getValue();
                        if (set != null && set.length() > 0) {
                            String[] add = (String[])AnalyzeExecutable.this.LIBRARIES_PROPERTY.getValue();
                            if (add == null || add.length == 0) {
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(new String[]{set}, null, project, this.myDependencies, null, null, new CompileLineStorage());
                            } else {
                                String[] all = new String[add.length + 1];
                                all[0] = set;
                                System.arraycopy(add, 0, all, 1, add.length);
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(all, null, project, this.myDependencies, null, null, new CompileLineStorage());
                            }
                            AnalyzeExecutable.this.store(project);
                        }
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            if (AnalyzeExecutable.this.getStopInterrupter().cancelled()) break;
                            if (!(source instanceof DwarfSource)) continue;
                            set.addAll(((DwarfSource)source).getIncludedFiles());
                            set.add(source.getItemPath());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            String s;
                            if (AnalyzeExecutable.this.getStopInterrupter().cancelled()) break;
                            FileObject file = AnalyzeExecutable.this.getSourceFileSystem().findResource(path);
                            if (file == null || !file.isValid()) continue;
                            String absolutePath = CndFileUtils.normalizePath((FileObject)file);
                            if (project.resolveSymbolicLinks() && (s = DiscoveryUtils.resolveSymbolicLink((FileSystem)AnalyzeExecutable.this.getSourceFileSystem(), (String)absolutePath)) != null) {
                                absolutePath = s;
                            }
                            unique.add(absolutePath);
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeFolder.class, (String)id);
    }
}

