/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.ProviderPropertyType;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AnalyzeFolder
extends BaseDwarfProvider {
    public static final String FOLDER_PROVIDER_ID = "dwarf-folder";
    private final Map<String, ProviderProperty> myProperties = new HashMap<String, ProviderProperty>();
    private final ProviderProperty<String> BINARY_FOLDER_PROPERTY;

    public AnalyzeFolder() {
        this.myProperties.clear();
        this.BINARY_FOLDER_PROPERTY = new ProviderProperty<String>(){
            private String myPath;

            public String getName() {
                return AnalyzeFolder.i18n("Folder_Files_Name");
            }

            public String getDescription() {
                return AnalyzeFolder.i18n("Folder_Files_Description");
            }

            public String getValue() {
                return this.myPath;
            }

            public void setValue(String value) {
                this.myPath = value;
            }

            public ProviderPropertyType<String> getPropertyType() {
                return ProviderPropertyType.ExecutableFolderPropertyType;
            }
        };
        this.myProperties.put(this.BINARY_FOLDER_PROPERTY.getPropertyType().key(), this.BINARY_FOLDER_PROPERTY);
        this.myProperties.put(this.BYNARY_FILESYSTEM_PROPERTY.getPropertyType().key(), this.BYNARY_FILESYSTEM_PROPERTY);
        this.myProperties.put(this.RESTRICT_SOURCE_ROOT_PROPERTY.getPropertyType().key(), this.RESTRICT_SOURCE_ROOT_PROPERTY);
        this.myProperties.put(this.RESTRICT_COMPILE_ROOT_PROPERTY.getPropertyType().key(), this.RESTRICT_COMPILE_ROOT_PROPERTY);
    }

    public String getID() {
        return FOLDER_PROVIDER_ID;
    }

    public String getName() {
        return AnalyzeFolder.i18n("Folder_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeFolder.i18n("Folder_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String key) {
        return this.myProperties.get(key);
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy project, Interrupter interrupter) {
        this.init(project);
        this.resetStopInterrupter(interrupter);
        String root = (String)this.BINARY_FOLDER_PROPERTY.getValue();
        if (root == null || root.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NoBaseFolder")));
        }
        Set<String> set = this.getObjectFiles(root);
        if (set.isEmpty()) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutablesInFolder", (Object)root)));
        }
        int i = 0;
        for (String obj : set) {
            ++i;
            ApplicableImpl applicable = this.sizeComilationUnit(project, Collections.singleton(obj), null, false);
            if (applicable.isApplicable()) {
                return new ApplicableImpl(true, applicable.getErrors(), applicable.getCompilerName(), 50, applicable.isSunStudio(), null, null, null, null);
            }
            if (i <= 25) continue;
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutableWithDebugInformation", (Object)root)));
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeFolder.class, (String)"NotFoundExecutableWithDebugInformation", (Object)root)));
    }

    public List<Configuration> analyze(final ProjectProxy project, final Progress progress, Interrupter interrupter) {
        this.resetStopInterrupter(interrupter);
        ArrayList<Configuration> confs = new ArrayList<Configuration>();
        this.init(project);
        if (!this.getStopInterrupter().cancelled()) {
            Configuration conf = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration(), (ProjectProxy)project);
                }

                public List<String> getDependencies() {
                    return null;
                }

                public List<String> getBuildArtifacts() {
                    return null;
                }

                public Map<ItemProperties.LanguageKind, Map<String, Integer>> getBuildTools() {
                    return null;
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        if (progress != null) {
                            progress.start();
                        }
                        try {
                            Set set = AnalyzeFolder.this.getObjectFiles((String)AnalyzeFolder.this.BINARY_FOLDER_PROPERTY.getValue());
                            if (progress != null) {
                                progress.start(set.size());
                            }
                            if (set.size() > 0) {
                                this.myFileProperties = AnalyzeFolder.this.getSourceFileProperties(set.toArray(new String[set.size()]), progress, project, null, null, null, new CompileLineStorage());
                                AnalyzeFolder.this.store(project);
                            } else {
                                this.myFileProperties = new ArrayList<SourceFileProperties>();
                            }
                        }
                        finally {
                            if (progress != null) {
                                progress.done();
                            }
                        }
                    }
                    return this.myFileProperties;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> set = new HashSet<String>();
                        for (SourceFileProperties source : this.getSourcesConfiguration()) {
                            if (AnalyzeFolder.this.getStopInterrupter().cancelled()) break;
                            set.addAll(((DwarfSource)source).getIncludedFiles());
                            set.add(source.getItemPath());
                        }
                        if (progress != null) {
                            progress.start(set.size());
                        }
                        HashSet<String> unique = new HashSet<String>();
                        for (String path : set) {
                            String s;
                            FileObject file;
                            if (AnalyzeFolder.this.getStopInterrupter().cancelled()) break;
                            if (progress != null) {
                                Progress progress2 = progress;
                                synchronized (progress2) {
                                    progress.increment(path);
                                }
                            }
                            if ((file = AnalyzeFolder.this.getSourceFileSystem().findResource(path)) == null || !file.isValid()) continue;
                            String absolutePath = CndFileUtils.normalizePath((FileObject)file);
                            if (project.resolveSymbolicLinks() && (s = DiscoveryUtils.resolveSymbolicLink((FileSystem)AnalyzeFolder.this.getSourceFileSystem(), (String)absolutePath)) != null) {
                                absolutePath = s;
                            }
                            unique.add(absolutePath);
                        }
                        if (progress != null) {
                            progress.done();
                        }
                        this.myIncludedFiles = new ArrayList<String>(unique);
                    }
                    return this.myIncludedFiles;
                }
            };
            confs.add(conf);
        }
        return confs;
    }

    private Set<String> getObjectFiles(String root) {
        FileSystem fs = (FileSystem)this.BYNARY_FILESYSTEM_PROPERTY.getValue();
        if (fs == null) {
            fs = CndFileUtils.getLocalFileSystem();
        }
        FileObject rootFO = fs.findResource(root);
        HashSet<String> map = new HashSet<String>();
        this.gatherSubFolders(rootFO, map, new HashSet<String>());
        return map;
    }

    private boolean isExecutable(FileObject file) {
        String name = file.getNameExt();
        if (CndFileUtils.isLocalFileSystem((FileObject)file) && Utilities.isWindows()) {
            return name.endsWith(".exe") || name.endsWith(".dll");
        }
        try {
            return name.indexOf(46) < 0 && MIMENames.isBinaryExecutable((String)file.getMIMEType());
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private void gatherSubFolders(FileObject d, HashSet<String> map, HashSet<String> antiLoop) {
        if (this.getStopInterrupter().cancelled()) {
            return;
        }
        if (d != null && d.isValid() && d.isFolder() && d.canRead()) {
            String canPath;
            if (CndPathUtilities.isIgnoredFolder((String)d.getPath())) {
                return;
            }
            try {
                canPath = CndFileUtils.getCanonicalPath((FileObject)d);
            }
            catch (IOException ex) {
                return;
            }
            if (!antiLoop.contains(canPath)) {
                antiLoop.add(canPath);
                FileObject[] ff = d.getChildren();
                if (ff != null) {
                    for (int i = 0; i < ff.length && !this.getStopInterrupter().cancelled(); ++i) {
                        String name;
                        if (ff[i].isFolder()) {
                            this.gatherSubFolders(ff[i], map, antiLoop);
                            continue;
                        }
                        if (!ff[i].isData() || !(name = ff[i].getNameExt()).endsWith(".o") && !name.endsWith(".so") && !name.endsWith(".dylib") && !name.endsWith(".a") && !this.isExecutable(ff[i])) continue;
                        String path = ff[i].getPath();
                        if (Utilities.isWindows()) {
                            path = path.replace('\\', '/');
                        }
                        map.add(path);
                    }
                }
            }
        }
    }

    private static String i18n(String id) {
        return NbBundle.getMessage(AnalyzeFolder.class, (String)id);
    }
}

