/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FixItHint;
import org.clang.basic.LangOptions;
import org.clang.basic.PresumedLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.StoredDiagnostic;
import org.clang.frontend.DiagnosticRenderer;
import org.clang.frontend.impl.SourceColumnMap;
import org.clang.frontend.impl.TextDiagnosticStatics;
import org.clang.lex.Lexer;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.PointerUnion;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class TextDiagnostic
extends DiagnosticRenderer
implements Destructors.ClassWithDestructor {
    private raw_ostream OS;

    public TextDiagnostic(raw_ostream OS, LangOptions LangOpts, DiagnosticOptions DiagOpts) {
        super(LangOpts, DiagOpts);
        this.OS = OS;
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public static void printDiagnosticLevel(raw_ostream OS, DiagnosticsEngine.Level Level2, boolean ShowColors) {
        TextDiagnostic.printDiagnosticLevel(OS, Level2, ShowColors, false);
    }

    public static void printDiagnosticLevel(raw_ostream OS, DiagnosticsEngine.Level Level2, boolean ShowColors, boolean CLFallbackMode) {
        if (ShowColors) {
            switch (Level2) {
                case Ignored: {
                    throw new llvm_unreachable("Invalid diagnostic type");
                }
                case Note: {
                    OS.changeColor(TextDiagnosticStatics.noteColor, true);
                    break;
                }
                case Remark: {
                    OS.changeColor(TextDiagnosticStatics.remarkColor, true);
                    break;
                }
                case Warning: {
                    OS.changeColor(TextDiagnosticStatics.warningColor, true);
                    break;
                }
                case Error: {
                    OS.changeColor(TextDiagnosticStatics.errorColor, true);
                    break;
                }
                case Fatal: {
                    OS.changeColor(TextDiagnosticStatics.fatalColor, true);
                }
            }
        }
        switch (Level2) {
            case Ignored: {
                throw new llvm_unreachable("Invalid diagnostic type");
            }
            case Note: {
                OS.$out(NativePointer.$((String)"note"));
                break;
            }
            case Remark: {
                OS.$out(NativePointer.$((String)"remark"));
                break;
            }
            case Warning: {
                OS.$out(NativePointer.$((String)"warning"));
                break;
            }
            case Error: {
                OS.$out(NativePointer.$((String)"error"));
                break;
            }
            case Fatal: {
                OS.$out(NativePointer.$((String)"fatal error"));
            }
        }
        if (CLFallbackMode) {
            OS.$out(NativePointer.$((String)"(clang)"));
        }
        OS.$out(NativePointer.$((String)": "));
        if (ShowColors) {
            OS.resetColor();
        }
    }

    public static void printDiagnosticMessage(raw_ostream OS, boolean IsSupplemental, StringRef Message, long CurrentColumn, int Columns, boolean ShowColors) {
        boolean Bold = false;
        if (ShowColors && !IsSupplemental) {
            OS.changeColor(TextDiagnosticStatics.savedColor, true);
            Bold = true;
        }
        if (Columns != 0) {
            TextDiagnosticStatics.printWordWrapped(OS, new StringRef(Message), Columns, Unsigned.$long2uint((long)CurrentColumn), Bold);
        } else {
            bool.ref Normal = NativePointer.create_bool$ref((boolean)true);
            TextDiagnosticStatics.applyTemplateHighlighting(OS, Message, Normal, Bold);
            assert (Normal.$deref()) : "Formatting should have returned to normal";
        }
        if (ShowColors) {
            OS.resetColor();
        }
        OS.$out_char(NativePointer.$((char)'\n'));
    }

    @Override
    protected void emitDiagnosticMessage(SourceLocation Loc, PresumedLoc PLoc, DiagnosticsEngine.Level Level2, StringRef Message, ArrayRef<CharSourceRange> Ranges, SourceManager SM, PointerUnion<Diagnostic, StoredDiagnostic> D) {
        long StartOfLocationInfo = this.OS.tell();
        if (Loc.isValid()) {
            this.emitDiagnosticLoc(new SourceLocation(Loc), new PresumedLoc(PLoc), Level2, (ArrayRef<CharSourceRange>)new ArrayRef(Ranges), SM);
        }
        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
            this.OS.resetColor();
        }
        TextDiagnostic.printDiagnosticLevel(this.OS, Level2, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors, ((DiagnosticOptions)this.DiagOpts.$arrow()).CLFallbackMode);
        TextDiagnostic.printDiagnosticMessage(this.OS, Level2 == DiagnosticsEngine.Level.Note, new StringRef(Message), this.OS.tell() - StartOfLocationInfo, ((DiagnosticOptions)this.DiagOpts.$arrow()).MessageLength, ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors);
    }

    @Override
    protected void emitDiagnosticLoc(SourceLocation Loc, PresumedLoc PLoc, DiagnosticsEngine.Level Level2, ArrayRef<CharSourceRange> Ranges, SourceManager SM) {
        int ColNo;
        if (PLoc.isInvalid()) {
            FileEntry FE;
            FileID FID = SM.getFileID(new SourceLocation(Loc));
            if (FID.isValid() && (FE = SM.getFileEntryForID(new FileID(FID))) != null && FE.isValid()) {
                this.OS.$out(FE.getName());
                if (FE.isInPCH()) {
                    this.OS.$out(NativePointer.$((String)" (in PCH)"));
                }
                this.OS.$out(NativePointer.$((String)": "));
            }
            return;
        }
        int LineNo = PLoc.getLine();
        if (!((DiagnosticOptions)this.DiagOpts.$arrow()).ShowLocation) {
            return;
        }
        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
            this.OS.changeColor(TextDiagnosticStatics.savedColor, true);
        }
        this.OS.$out(PLoc.getFilename());
        switch (((DiagnosticOptions)this.DiagOpts.$arrow()).getFormat()) {
            case Clang: {
                this.OS.$out_char(NativePointer.$((char)':')).$out_uint(LineNo);
                break;
            }
            case MSVC: {
                this.OS.$out_char(NativePointer.$((char)'(')).$out_uint(LineNo);
                break;
            }
            case Vi: {
                this.OS.$out(NativePointer.$((String)" +")).$out_uint(LineNo);
            }
        }
        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColumn && (ColNo = PLoc.getColumn()) != 0) {
            if (((DiagnosticOptions)this.DiagOpts.$arrow()).getFormat() == DiagnosticOptions.TextDiagnosticFormat.MSVC) {
                this.OS.$out_char(NativePointer.$((char)','));
                if (this.LangOpts.MSCompatibilityVersion != 0 && this.LangOpts.MSCompatibilityVersion < 170000000) {
                    --ColNo;
                }
            } else {
                this.OS.$out_char(NativePointer.$((char)':'));
            }
            this.OS.$out_uint(ColNo);
        }
        switch (((DiagnosticOptions)this.DiagOpts.$arrow()).getFormat()) {
            case Clang: 
            case Vi: {
                this.OS.$out_char(NativePointer.$((char)':'));
                break;
            }
            case MSVC: {
                this.OS.$out(NativePointer.$((String)") : "));
            }
        }
        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowSourceRanges && !Ranges.empty()) {
            FileID CaretFileID = SM.getFileID(SM.getExpansionLoc(new SourceLocation(Loc)));
            boolean PrintedRange = false;
            type.ptr RI = Ranges.begin();
            type.ptr RE = Ranges.end();
            while (RI.$noteq((Object)RE)) {
                if (((CharSourceRange)RI.$star()).isValid()) {
                    SourceLocation E;
                    SourceLocation B = SM.getExpansionLoc(((CharSourceRange)RI.$star()).getBegin());
                    if (BasicClangGlobals.$eq_SourceLocation((SourceLocation)B, (SourceLocation)(E = SM.getExpansionLoc(((CharSourceRange)RI.$star()).getEnd()))) && ((CharSourceRange)RI.$star()).getEnd().isMacroID()) {
                        E.$assign((SourceLocation)SM.getExpansionRange((SourceLocation)((CharSourceRange)RI.$star()).getEnd()).second);
                    }
                    std_pair.pairTypeUInt BInfo = SM.getDecomposedLoc(new SourceLocation(B));
                    std_pair.pairTypeUInt EInfo = SM.getDecomposedLoc(new SourceLocation(E));
                    if (!((FileID)BInfo.first).$noteq(CaretFileID) && !((FileID)EInfo.first).$noteq(CaretFileID)) {
                        int TokSize = 0;
                        if (((CharSourceRange)RI.$star()).isTokenRange()) {
                            TokSize = Lexer.MeasureTokenLength((SourceLocation)new SourceLocation(E), (SourceManager)SM, (LangOptions)this.LangOpts);
                        }
                        this.OS.$out_char(NativePointer.$((char)'{')).$out_uint(SM.getLineNumber(new FileID((FileID)BInfo.first), BInfo.second)).$out_char(NativePointer.$((char)':')).$out_uint(SM.getColumnNumber(new FileID((FileID)BInfo.first), BInfo.second)).$out_char(NativePointer.$((char)'-')).$out_uint(SM.getLineNumber(new FileID((FileID)EInfo.first), EInfo.second)).$out_char(NativePointer.$((char)':')).$out_uint(SM.getColumnNumber(new FileID((FileID)EInfo.first), EInfo.second) + TokSize).$out_char(NativePointer.$((char)'}'));
                        PrintedRange = true;
                    }
                }
                RI.$preInc();
            }
            if (PrintedRange) {
                this.OS.$out_char(NativePointer.$((char)':'));
            }
        }
        this.OS.$out_char(NativePointer.$((char)' '));
    }

    @Override
    protected void emitCodeContext(SourceLocation Loc, DiagnosticsEngine.Level Level2, SmallVectorImpl<CharSourceRange> Ranges, ArrayRef<FixItHint> Hints, SourceManager SM) {
        this.emitSnippetAndCaret(new SourceLocation(Loc), Level2, Ranges, (ArrayRef<FixItHint>)new ArrayRef(Hints), SM);
    }

    @Override
    protected void emitIncludeLocation(SourceLocation Loc, PresumedLoc PLoc, SourceManager SM) {
        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowLocation) {
            this.OS.$out(NativePointer.$((String)"In file included from ")).$out(PLoc.getFilename()).$out_char(NativePointer.$((char)':')).$out_uint(PLoc.getLine()).$out(NativePointer.$((String)":\n"));
        } else {
            this.OS.$out(NativePointer.$((String)"In included file:\n"));
        }
    }

    @Override
    protected void emitImportLocation(SourceLocation Loc, PresumedLoc PLoc, StringRef ModuleName, SourceManager SM) {
        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowLocation) {
            this.OS.$out(NativePointer.$((String)"In module '")).$out(new StringRef(ModuleName)).$out(NativePointer.$((String)"' imported from ")).$out(PLoc.getFilename()).$out_char(NativePointer.$((char)':')).$out_uint(PLoc.getLine()).$out(NativePointer.$((String)":\n"));
        } else {
            this.OS.$out(NativePointer.$((String)"In module ")).$out(new StringRef(ModuleName)).$out(NativePointer.$((String)"':\n"));
        }
    }

    @Override
    protected void emitBuildingModuleLocation(SourceLocation Loc, PresumedLoc PLoc, StringRef ModuleName, SourceManager SM) {
        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowLocation && PLoc.getFilename() != null) {
            this.OS.$out(NativePointer.$((String)"While building module '")).$out(new StringRef(ModuleName)).$out(NativePointer.$((String)"' imported from ")).$out(PLoc.getFilename()).$out_char(NativePointer.$((char)':')).$out_uint(PLoc.getLine()).$out(NativePointer.$((String)":\n"));
        } else {
            this.OS.$out(NativePointer.$((String)"While building module '")).$out(new StringRef(ModuleName)).$out(NativePointer.$((String)"':\n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitSnippetAndCaret(SourceLocation Loc, DiagnosticsEngine.Level Level2, SmallVectorImpl<CharSourceRange> Ranges, ArrayRef<FixItHint> Hints, SourceManager SM) {
        std.string SourceLine = null;
        SourceColumnMap sourceColMap = null;
        std.string CaretLine = null;
        std.string FixItInsertionLine = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            assert (!Loc.isInvalid()) : "must have a valid source location here";
            assert (Loc.isFileID()) : "must have a file location here";
            if (!((DiagnosticOptions)this.DiagOpts.$arrow()).ShowCarets) {
                return;
            }
            if (BasicClangGlobals.$eq_SourceLocation((SourceLocation)Loc, (SourceLocation)this.LastLoc) && Ranges.empty() && Hints.empty() && (this.LastLevel != DiagnosticsEngine.Level.Note || Level2 == this.LastLevel)) {
                return;
            }
            std_pair.pairTypeUInt LocInfo = SM.getDecomposedLoc(new SourceLocation(Loc));
            FileID FID = new FileID((FileID)LocInfo.first);
            int FileOffset = LocInfo.second;
            bool.ptr Invalid = null;
            StringRef bufferData = SM.getBufferData(FID, Invalid);
            if (bufferData == SourceManager.INVALID_BUFFER_DATA) {
                return;
            }
            char.ptr BufStart = Native.$tryClone((char.ptr)bufferData.data());
            int LineNo = SM.getLineNumber(new FileID(FID), FileOffset);
            int ColNo = SM.getColumnNumber(new FileID(FID), FileOffset);
            int MaxLineLengthToPrint = 4096;
            if (ColNo > 4096) {
                return;
            }
            char.ptr TokPtr = Native.$tryClone((char.ptr)((char.ptr)BufStart.$add(FileOffset)));
            char.ptr LineStart = Native.$tryClone((char.ptr)((char.ptr)((char.ptr)TokPtr.$sub(ColNo)).$add(1)));
            char.ptr LineEnd = Native.$tryClone((char.ptr)TokPtr);
            while (LineEnd.$star() != NativePointer.$((char)'\n') && LineEnd.$star() != NativePointer.$((char)'\r') && LineEnd.$star() != NativePointer.$((char)'\u0000')) {
                LineEnd.$preInc();
            }
            if (LineEnd.$sub((abstract_iterator)LineStart) > 4096) {
                return;
            }
            SourceLine = new std.string((char.iterator)LineStart, (char.iterator)LineEnd);
            sourceColMap = new SourceColumnMap(new StringRef(SourceLine), ((DiagnosticOptions)this.DiagOpts.$arrow()).TabStop);
            CaretLine = new std.string(sourceColMap.columns(), NativePointer.$((char)' '));
            SmallVectorImpl.iterator I = Ranges.begin();
            SmallVectorImpl.iterator E = Ranges.end();
            while (I.$noteq((Object)E)) {
                TextDiagnosticStatics.highlightRange((CharSourceRange)I.$star(), LineNo, new FileID(FID), sourceColMap, CaretLine, SM, this.LangOpts);
                I.$preInc();
            }
            ColNo = sourceColMap.byteToContainingColumn(ColNo - 1);
            if (CaretLine.size() < ColNo + 1) {
                CaretLine.resize(ColNo + 1, NativePointer.$((char)' '));
            }
            CaretLine.$set(ColNo, NativePointer.$((char)'^'));
            FixItInsertionLine = TextDiagnosticStatics.buildFixItInsertionLine(LineNo, sourceColMap, (ArrayRef<FixItHint>)new ArrayRef(Hints), SM, (DiagnosticOptions)this.DiagOpts.get());
            int Columns = ((DiagnosticOptions)this.DiagOpts.$arrow()).MessageLength;
            if (Columns != 0) {
                TextDiagnosticStatics.selectInterestingSourceRegion(SourceLine, CaretLine, FixItInsertionLine, Columns, sourceColMap);
            }
            if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowSourceRanges) {
                $c$.clean((Object)SourceLine.$assign((std.string)$c$.track((Object)std.$add_T_str((Object)NativePointer.$((char)' '), (std.string)SourceLine))));
                $c$.clean((Object)CaretLine.$assign((std.string)$c$.track((Object)std.$add_T_str((Object)NativePointer.$((char)' '), (std.string)CaretLine))));
            }
            while (CaretLine.$at(CaretLine.size() - 1) == NativePointer.$((char)' ')) {
                CaretLine.erase((char.ptr)CaretLine.end().$sub(1));
            }
            this.emitSnippet(new StringRef(SourceLine));
            if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
                this.OS.changeColor(TextDiagnosticStatics.caretColor, true);
            }
            this.OS.$out(CaretLine).$out_char(NativePointer.$((char)'\n'));
            if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
                this.OS.resetColor();
            }
            if (!FixItInsertionLine.empty()) {
                if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
                    this.OS.changeColor(TextDiagnosticStatics.fixitColor, false);
                }
                if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowSourceRanges) {
                    this.OS.$out_char(NativePointer.$((char)' '));
                }
                this.OS.$out(FixItInsertionLine).$out_char(NativePointer.$((char)'\n'));
                if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
                    this.OS.resetColor();
                }
            }
            this.emitParseableFixits((ArrayRef<FixItHint>)new ArrayRef(Hints), SM);
        }
        finally {
            if (FixItInsertionLine != null) {
                FixItInsertionLine.$destroy();
            }
            if (CaretLine != null) {
                CaretLine.$destroy();
            }
            if (sourceColMap != null) {
                sourceColMap.$destroy();
            }
            if (SourceLine != null) {
                SourceLine.$destroy();
            }
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitSnippet(StringRef line) {
        std.string to_print = null;
        try {
            if (line.empty()) {
                return;
            }
            int.ptr i = NativePointer.create_int$ptr((int)0);
            to_print = new std.string();
            boolean print_reversed = false;
            while (i.$star() < line.size()) {
                std_pair.pairTypeBool<SmallString> res = null;
                try {
                    res = TextDiagnosticStatics.printableTextForNextCharacter(new StringRef(line), i, ((DiagnosticOptions)this.DiagOpts.$arrow()).TabStop);
                    boolean was_printable = res.second;
                    if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors && was_printable == print_reversed) {
                        if (print_reversed) {
                            this.OS.reverseColor();
                        }
                        this.OS.$out(to_print);
                        to_print.clear();
                        if (((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
                            this.OS.resetColor();
                        }
                    }
                    print_reversed = !was_printable;
                    llvm.$addassign_str_StringRef((std.string)to_print, (StringRef)((SmallString)res.first).str());
                }
                finally {
                    if (res == null) continue;
                    res.$destroy();
                }
            }
            if (print_reversed && ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
                this.OS.reverseColor();
            }
            this.OS.$out(to_print);
            if (print_reversed && ((DiagnosticOptions)this.DiagOpts.$arrow()).ShowColors) {
                this.OS.resetColor();
            }
            this.OS.$out_char(NativePointer.$((char)'\n'));
        }
        finally {
            if (to_print != null) {
                to_print.$destroy();
            }
        }
    }

    private void emitParseableFixits(ArrayRef<FixItHint> Hints, SourceManager SM) {
        if (!((DiagnosticOptions)this.DiagOpts.$arrow()).ShowParseableFixits) {
            return;
        }
        type.ptr I = Hints.begin();
        type.ptr E = Hints.end();
        while (I.$noteq((Object)E)) {
            if (((FixItHint)I.$star()).RemoveRange.isInvalid() || ((FixItHint)I.$star()).RemoveRange.getBegin().isMacroID() || ((FixItHint)I.$star()).RemoveRange.getEnd().isMacroID()) {
                return;
            }
            I.$preInc();
        }
        I = Hints.begin();
        E = Hints.end();
        while (I.$noteq((Object)E)) {
            PresumedLoc PLoc;
            SourceLocation BLoc = ((FixItHint)I.$star()).RemoveRange.getBegin();
            SourceLocation ELoc = ((FixItHint)I.$star()).RemoveRange.getEnd();
            std_pair.pairTypeUInt BInfo = SM.getDecomposedLoc(new SourceLocation(BLoc));
            std_pair.pairTypeUInt EInfo = SM.getDecomposedLoc(new SourceLocation(ELoc));
            if (((FixItHint)I.$star()).RemoveRange.isTokenRange()) {
                EInfo.second += Lexer.MeasureTokenLength((SourceLocation)new SourceLocation(ELoc), (SourceManager)SM, (LangOptions)this.LangOpts);
            }
            if ((PLoc = SM.getPresumedLoc(new SourceLocation(BLoc))).isInvalid()) break;
            this.OS.$out(NativePointer.$((String)"fix-it:\""));
            this.OS.write_escaped(new StringRef(PLoc.getFilename()));
            this.OS.$out(NativePointer.$((String)"\":{")).$out_uint(SM.getLineNumber(new FileID((FileID)BInfo.first), BInfo.second)).$out_char(NativePointer.$((char)':')).$out_uint(SM.getColumnNumber(new FileID((FileID)BInfo.first), BInfo.second)).$out_char(NativePointer.$((char)'-')).$out_uint(SM.getLineNumber(new FileID((FileID)EInfo.first), EInfo.second)).$out_char(NativePointer.$((char)':')).$out_uint(SM.getColumnNumber(new FileID((FileID)EInfo.first), EInfo.second)).$out(NativePointer.$((String)"}:\""));
            this.OS.write_escaped(new StringRef(((FixItHint)I.$star()).CodeToInsert));
            this.OS.$out(NativePointer.$QUOTE_LF);
            I.$preInc();
        }
    }

    public String toString() {
        return "OS=" + this.OS + super.toString();
    }
}

