/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import java.util.Comparator;
import java.util.Iterator;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticErrorTrap;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.VfsGlobals;
import org.clang.driver.Action;
import org.clang.driver.AnalyzeJobAction;
import org.clang.driver.AssembleJobAction;
import org.clang.driver.BackendJobAction;
import org.clang.driver.BindArchAction;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.CompileJobAction;
import org.clang.driver.CrashReportInfo;
import org.clang.driver.DriverGlobals;
import org.clang.driver.DsymutilJobAction;
import org.clang.driver.InputAction;
import org.clang.driver.JobAction;
import org.clang.driver.LTOKind;
import org.clang.driver.LinkJobAction;
import org.clang.driver.LipoJobAction;
import org.clang.driver.MigrateJobAction;
import org.clang.driver.Multilib;
import org.clang.driver.OffloadAction;
import org.clang.driver.PrecompileJobAction;
import org.clang.driver.PreprocessJobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.VerifyDebugInfoJobAction;
import org.clang.driver.VerifyJobAction;
import org.clang.driver.VerifyPCHJobAction;
import org.clang.driver.impl.DriverStatics;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.options;
import org.clang.driver.phases;
import org.clang.driver.toolchains.impl.AMDGPUToolChain;
import org.clang.driver.toolchains.impl.Bitrig;
import org.clang.driver.toolchains.impl.CloudABI;
import org.clang.driver.toolchains.impl.CrossWindowsToolChain;
import org.clang.driver.toolchains.impl.CudaToolChain;
import org.clang.driver.toolchains.impl.DarwinClang;
import org.clang.driver.toolchains.impl.DragonFly;
import org.clang.driver.toolchains.impl.FreeBSD;
import org.clang.driver.toolchains.impl.Generic_ELF;
import org.clang.driver.toolchains.impl.Generic_GCC;
import org.clang.driver.toolchains.impl.Haiku;
import org.clang.driver.toolchains.impl.HexagonToolChain;
import org.clang.driver.toolchains.impl.LanaiToolChain;
import org.clang.driver.toolchains.impl.Linux;
import org.clang.driver.toolchains.impl.MSVCToolChain;
import org.clang.driver.toolchains.impl.MachO;
import org.clang.driver.toolchains.impl.MinGW;
import org.clang.driver.toolchains.impl.Minix;
import org.clang.driver.toolchains.impl.MipsLLVMToolChain;
import org.clang.driver.toolchains.impl.MyriadToolChain;
import org.clang.driver.toolchains.impl.NaClToolChain;
import org.clang.driver.toolchains.impl.NetBSD;
import org.clang.driver.toolchains.impl.OpenBSD;
import org.clang.driver.toolchains.impl.PS4CPU;
import org.clang.driver.toolchains.impl.Solaris;
import org.clang.driver.toolchains.impl.TCEToolChain;
import org.clang.driver.toolchains.impl.WebAssembly;
import org.clang.driver.toolchains.impl.XCoreToolChain;
import org.clang.driver.tools.impl.DarwinStatics;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdMap;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.MutableArrayRefUInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.StringSwitchUInt;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.InputArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.option.Option;
import org.llvm.option.arg_iterator;
import org.llvm.support.PrettyStackTraceString;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;

public class Driver
implements Destructors.ClassWithDestructor {
    private OptTable Opts = DriverGlobals.createDriverOptTable();
    private DiagnosticsEngine Diags;
    private IntrusiveRefCntPtr<FileSystem> VFS;
    private DriverMode Mode;
    private SaveTempsMode SaveTemps;
    private BitcodeEmbedMode BitcodeEmbed;
    private LTOKind LTOMode;
    public std.string Name;
    public std.string Dir;
    public std.string ClangExecutable;
    public std.string InstalledDir;
    public std.string ResourceDir;
    public SmallVector<std.string> PrefixDirs;
    public std.string SysRoot;
    public std.string DyldPrefix;
    public boolean UseStdLib;
    public std.string DefaultTargetTriple;
    public std.string DriverTitle;
    public std.string HostBits;
    public std.string HostMachine;
    public std.string HostSystem;
    public std.string HostRelease;
    public char.ptr CCPrintOptionsFilename;
    public char.ptr CCPrintHeadersFilename;
    public char.ptr CCLogDiagnosticsFilename;
    public boolean CCCPrintBindings;
    public boolean CCPrintOptions;
    public boolean CCPrintHeaders;
    public boolean CCLogDiagnostics;
    public boolean CCGenDiagnostics;
    private std.string CCCGenericGCCName;
    private boolean CheckInputsExist;
    public boolean CCCUsePCH;
    private boolean SuppressMissingInputWarning;
    private std.list<std.string> TempFiles;
    private std.list<std.string> ResultFiles;
    private StringMap<ToolChain> ToolChains;
    private static final Comparator<std_pair.pair<Action, std.string>> CACHED_RESULT_COMPARATOR = new Comparator<std_pair.pair<Action, std.string>>(){

        @Override
        public int compare(std_pair.pair<Action, std.string> o1, std_pair.pair<Action, std.string> o2) {
            if (o1.first == o2.first) {
                return ((std.string)o1.second).compare((std.string)o2.second);
            }
            return o1.hashCode() - o2.hashCode();
        }
    };

    public DiagnosticBuilder Diag(int DiagID) {
        return this.Diags.Report(DiagID);
    }

    public boolean CCCIsCXX() {
        return this.Mode == DriverMode.GXXMode;
    }

    public boolean CCCIsCPP() {
        return this.Mode == DriverMode.CPPMode;
    }

    public boolean IsCLMode() {
        return this.Mode == DriverMode.CLMode;
    }

    private DerivedArgList TranslateInputArgs(InputArgList Args) {
        DerivedArgList DAL = new DerivedArgList(Args);
        boolean HasNostdlib = Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()));
        boolean HasNodefaultlib = Args.hasArg(new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()));
        for (Arg A : Args) {
            if ((A.getOption().matches(new OptSpecifier(options.ID.OPT_Wl_COMMA.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_Xlinker.getValue()))) && A.containsValue(new StringRef("--no-demangle"))) {
                DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier(options.ID.OPT_Z_Xlinker__no_demangle.getValue())));
                for (char.ptr Val : A.getValues()) {
                    if (!llvm.$noteq_StringRef((char.ptr)Val, (String)"--no-demangle")) continue;
                    DAL.AddSeparateArg(A, this.Opts.getOption(new OptSpecifier(options.ID.OPT_Xlinker.getValue())), new StringRef(Val));
                }
                continue;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_Wp_COMMA.getValue())) && (llvm.$eq_StringRef((char.ptr)A.getValue(0), (String)"-MD") || llvm.$eq_StringRef((char.ptr)A.getValue(0), (String)"-MMD"))) {
                if (llvm.$eq_StringRef((char.ptr)A.getValue(0), (String)"-MD")) {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier(options.ID.OPT_MD.getValue())));
                } else {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier(options.ID.OPT_MMD.getValue())));
                }
                if (A.getNumValues() != 2) continue;
                DAL.AddSeparateArg(A, this.Opts.getOption(new OptSpecifier(options.ID.OPT_MF.getValue())), new StringRef(A.getValue(1)));
                continue;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_l.getValue()))) {
                StringRef Value = new StringRef(A.getValue());
                if (!HasNostdlib && !HasNodefaultlib && llvm.$eq_StringRef((StringRef)Value, (String)"stdc++")) {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier(options.ID.OPT_Z_reserved_lib_stdcxx.getValue())));
                    continue;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"cc_kext")) {
                    DAL.AddFlagArg(A, this.Opts.getOption(new OptSpecifier(options.ID.OPT_Z_reserved_lib_cckext.getValue())));
                    continue;
                }
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT__DASH_DASH.getValue()))) {
                A.claim();
                for (char.ptr Val : A.getValues()) {
                    DAL.append(DriverStatics.MakeInputArg(DAL, this.Opts, new StringRef(Val)));
                }
                continue;
            }
            DAL.append(A);
        }
        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_miamcu.getValue()), new OptSpecifier(options.ID.OPT_mno_iamcu.getValue()), false)) {
            DAL.AddFlagArg((Arg)null, this.Opts.getOption(new OptSpecifier(options.ID.OPT_static.getValue())));
        }
        return DAL;
    }

    private phases.ID getFinalPhase(DerivedArgList DAL) {
        return this.getFinalPhase(DAL, (type.ptr<Arg>)((type.ptr)null));
    }

    private phases.ID getFinalPhase(DerivedArgList DAL, type.ptr<Arg> FinalPhaseArg) {
        Arg PhaseArg = null;
        phases.ID FinalPhase = this.CCCIsCPP() || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_E.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_EP.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_M.getValue()), new OptSpecifier(options.ID.OPT_MM.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_P.getValue()))) != null ? phases.ID.Preprocess : ((PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_fsyntax_only.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_module_file_info.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_verify_pch.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_rewrite_objc.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_rewrite_legacy_objc.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT__migrate.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT__analyze.getValue()), new OptSpecifier(options.ID.OPT__analyze_auto.getValue()))) != null || (PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_emit_ast.getValue()))) != null ? phases.ID.Compile : ((PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_S.getValue()))) != null ? phases.ID.Backend : ((PhaseArg = DAL.getLastArg(new OptSpecifier(options.ID.OPT_c.getValue()))) != null ? phases.ID.Assemble : phases.ID.Link)));
        if (FinalPhaseArg != null) {
            FinalPhaseArg.$set(PhaseArg);
        }
        return FinalPhase;
    }

    private void setUpResponseFiles(Compilation C, Command Cmd) {
        if (Cmd.getCreator().getResponseFilesSupport() == Tool.ResponseFileSupport.RF_None || sys.commandLineFitsWithinSystemLimits((StringRef)new StringRef(Cmd.getExecutable()), (ArrayRef)new ArrayRef((SmallVectorImpl)Cmd.getArguments()))) {
            return;
        }
        std.string TmpName = this.GetTemporaryPath(new StringRef("response"), NativePointer.$((String)"txt"));
        Cmd.setResponseFile(C.addTempFile(C.getArgs().MakeArgString(new Twine(TmpName.c_str()))));
    }

    private void generatePrefixedToolNames(char.ptr Tool2, ToolChain TC, SmallVectorImpl<std.string> Names) {
        Names.emplace_back((Object)std.$add_string_T((std.string)std.$add_string$C_T((std.string)this.DefaultTargetTriple, (String)"-"), (char.ptr)Tool2));
        Names.emplace_back((Object)new std.string(Tool2));
        std.string LLVMDefaultTargetTriple = sys.getDefaultTargetTriple();
        if (std.$noteq_string$C((std.string)LLVMDefaultTargetTriple, (std.string)this.DefaultTargetTriple)) {
            Names.emplace_back((Object)std.$add_string_T((std.string)std.$add_string$C_T((std.string)LLVMDefaultTargetTriple, (String)"-"), (char.ptr)Tool2));
        }
    }

    public Driver(StringRef ClangExecutable, StringRef DefaultTargetTriple, DiagnosticsEngine Diags) {
        this(ClangExecutable, DefaultTargetTriple, Diags, (IntrusiveRefCntPtr<FileSystem>)new IntrusiveRefCntPtr((Object)null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver(StringRef ClangExecutable, StringRef DefaultTargetTriple, DiagnosticsEngine Diags, IntrusiveRefCntPtr<FileSystem> VFS) {
        this.Diags = Diags;
        this.VFS = new IntrusiveRefCntPtr(JavaDifferentiators.JD.Move.INSTANCE, (IntrusiveRefCntPtr)std.move(VFS));
        this.Mode = DriverMode.GCCMode;
        this.SaveTemps = SaveTempsMode.SaveTempsNone;
        this.BitcodeEmbed = BitcodeEmbedMode.EmbedNone;
        this.LTOMode = LTOKind.LTOK_None;
        this.Name = new std.string();
        this.Dir = new std.string();
        this.ClangExecutable = ClangExecutable.$basic_string();
        this.InstalledDir = new std.string();
        this.ResourceDir = new std.string();
        this.PrefixDirs = new SmallVector(4, (Object)new std.string());
        this.SysRoot = new std.string((CharSequence)"");
        this.DyldPrefix = new std.string();
        this.UseStdLib = true;
        this.DefaultTargetTriple = DefaultTargetTriple.$basic_string();
        this.DriverTitle = new std.string((CharSequence)"clang LLVM compiler");
        this.HostBits = new std.string();
        this.HostMachine = new std.string();
        this.HostSystem = new std.string();
        this.HostRelease = new std.string();
        this.CCPrintOptionsFilename = null;
        this.CCPrintHeadersFilename = null;
        this.CCLogDiagnosticsFilename = null;
        this.CCCPrintBindings = false;
        this.CCPrintHeaders = false;
        this.CCLogDiagnostics = false;
        this.CCGenDiagnostics = false;
        this.CCCGenericGCCName = new std.string(NativePointer.$EMPTY);
        this.CheckInputsExist = true;
        this.CCCUsePCH = true;
        this.SuppressMissingInputWarning = false;
        this.TempFiles = new std.list();
        this.ResultFiles = new std.list();
        this.ToolChains = new StringMap(null);
        if (!this.VFS.$bool()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)this.VFS.$assign((IntrusiveRefCntPtr)$c$.track((Object)VfsGlobals.getRealFileSystem())));
            }
            finally {
                $c$.$destroy();
            }
        }
        this.Name.$assignMove(path.filename((StringRef)ClangExecutable).$basic_string());
        this.Dir.$assignMove(path.parent_path((StringRef)ClangExecutable).$basic_string());
        this.InstalledDir.$assign(this.Dir);
        StringRef ClangResourceDir = new StringRef("");
        SmallString P = new SmallString(new StringRef(this.Dir), 128);
        if (llvm.$noteq_StringRef((StringRef)ClangResourceDir, (String)"")) {
            path.append((SmallString)P, (Twine)new Twine(ClangResourceDir));
        } else {
            StringRef ClangLibdirSuffix = new StringRef("");
            path.append((SmallString)P, (Twine)new Twine(NativePointer.$DOT_DOT), (Twine)llvm.$add_Twine((Twine)new Twine("lib"), (Twine)new Twine(ClangLibdirSuffix)), (Twine)new Twine("clang"), (Twine)new Twine("3.9.0"));
        }
        this.ResourceDir.$assignMove(P.str().$basic_string());
    }

    public void $destroy() {
        if (this.Opts != null) {
            this.Opts.$destroy();
        }
        llvm.DeleteContainerSeconds(this.ToolChains);
        this.ToolChains.$destroy();
        this.ResultFiles.$destroy();
        this.TempFiles.$destroy();
        this.CCCGenericGCCName.$destroy();
        this.HostRelease.$destroy();
        this.HostSystem.$destroy();
        this.HostMachine.$destroy();
        this.HostBits.$destroy();
        this.DriverTitle.$destroy();
        this.DefaultTargetTriple.$destroy();
        this.DyldPrefix.$destroy();
        this.SysRoot.$destroy();
        this.PrefixDirs.$destroy();
        this.ResourceDir.$destroy();
        this.InstalledDir.$destroy();
        this.ClangExecutable.$destroy();
        this.Dir.$destroy();
        this.Name.$destroy();
        this.VFS.$destroy();
    }

    public std.string getCCCGenericGCCName() {
        return this.CCCGenericGCCName;
    }

    public OptTable getOpts() {
        return this.Opts;
    }

    public DiagnosticsEngine getDiags() {
        return this.Diags;
    }

    public FileSystem getVFS() {
        return (FileSystem)this.VFS.$star();
    }

    public boolean getCheckInputsExist() {
        return this.CheckInputsExist;
    }

    public void setCheckInputsExist(boolean Value) {
        this.CheckInputsExist = Value;
    }

    public std.string getTitle() {
        return this.DriverTitle;
    }

    public void setTitle(std.string Value) {
        this.DriverTitle.$assign(Value);
    }

    public char.ptr getClangProgramPath() {
        return this.ClangExecutable.c_str();
    }

    public char.ptr getInstalledDir() {
        if (!this.InstalledDir.empty()) {
            return this.InstalledDir.c_str();
        }
        return this.Dir.c_str();
    }

    public void setInstalledDir(StringRef Value) {
        this.InstalledDir.$assignMove(Value.$basic_string());
    }

    public boolean isSaveTempsEnabled() {
        return this.SaveTemps != SaveTempsMode.SaveTempsNone;
    }

    public boolean isSaveTempsObj() {
        return this.SaveTemps == SaveTempsMode.SaveTempsObj;
    }

    public boolean embedBitcodeEnabled() {
        return this.BitcodeEmbed == BitcodeEmbedMode.EmbedBitcode;
    }

    public boolean embedBitcodeMarkerOnly() {
        return this.BitcodeEmbed == BitcodeEmbedMode.EmbedMarker;
    }

    public void CreateOffloadingDeviceToolChains(Compilation C, SmallVector<std_pair.pair<types.ID, Arg>> Inputs) {
        if (llvm.any_of(Inputs, I -> types.isCuda((types.ID)((Object)((Object)I.first))))) {
            ToolChain TC = this.getToolChain((ArgList)C.getInputArgs(), new Triple(new Twine(C.getSingleOffloadToolChain(1).getTriple().isArch64Bit() ? NativePointer.$((String)"nvptx64-nvidia-cuda") : NativePointer.$((String)"nvptx-nvidia-cuda"))));
            C.addOffloadDeviceToolChain(TC, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Compilation BuildCompilation(ArrayRef<char.ptr> ArgList2) {
        PrettyStackTraceString CrashInfo = null;
        InputArgList Args = null;
        std_ptr.unique_ptr UArgs = null;
        try {
            Object $c$;
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Compilation construction"));
            char.ptr env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"COMPILER_PATH")));
            if (env != null) {
                StringRef CompilerPath = new StringRef(env);
                while (!CompilerPath.empty()) {
                    std_pair.pair Split = CompilerPath.split(sys.EnvPathSeparator);
                    this.PrefixDirs.push_back((Object)((StringRef)Split.first).$basic_string());
                    CompilerPath.$assign((StringRef)Split.second);
                }
            }
            this.ParseDriverMode((ArrayRef<char.ptr>)ArgList2.slice(1));
            Args = this.ParseArgStrings((ArrayRef<char.ptr>)ArgList2.slice(1));
            this.Diags.setIgnoreAllWarnings(Args.hasArg(new OptSpecifier(options.ID.OPT_w.getValue())));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_no_canonical_prefixes.getValue()));
            Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_pipe.getValue()));
            boolean CCCPrintPhases = Args.hasArg(new OptSpecifier(options.ID.OPT_ccc_print_phases.getValue()));
            this.CCCPrintBindings = Args.hasArg(new OptSpecifier(options.ID.OPT_ccc_print_bindings.getValue()));
            Object A = Args.getLastArg(new OptSpecifier(options.ID.OPT_ccc_gcc_name.getValue()));
            if (A != null) {
                this.CCCGenericGCCName.$assign(A.getValue());
            }
            this.CCCUsePCH = Args.hasFlag(new OptSpecifier(options.ID.OPT_ccc_pch_is_pch.getValue()), new OptSpecifier(options.ID.OPT_ccc_pch_is_pth.getValue()));
            if (this.IsCLMode()) {
                Triple T = new Triple(new Twine(this.DefaultTargetTriple));
                T.setOS(Triple.OSType.Win32);
                T.setVendor(Triple.VendorType.PC);
                T.setEnvironment(Triple.EnvironmentType.MSVC);
                this.DefaultTargetTriple.$assign(T.str());
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_target.getValue()))) != null) {
                this.DefaultTargetTriple.$assign(A.getValue());
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_ccc_install_dir.getValue()))) != null) {
                this.Dir.$assign(this.InstalledDir.$assign(A.getValue()));
            }
            for (Arg A2 : Args.filtered(new OptSpecifier(options.ID.OPT_B.getValue()))) {
                A2.claim();
                this.PrefixDirs.push_back((Object)new std.string(A2.getValue(0)));
            }
            A = Args.getLastArg(new OptSpecifier(options.ID.OPT__sysroot_EQ.getValue()));
            if (A != null) {
                this.SysRoot.$assign(A.getValue());
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT__dyld_prefix_EQ.getValue()))) != null) {
                this.DyldPrefix.$assign(A.getValue());
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()))) {
                this.UseStdLib = false;
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_resource_dir.getValue()))) != null) {
                this.ResourceDir.$assign(A.getValue());
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_save_temps_EQ.getValue()))) != null) {
                this.SaveTemps = (SaveTempsMode)((Object)new StringSwitch(A.getValue()).Case("cwd", (Object)SaveTempsMode.SaveTempsCwd).Case("obj", (Object)SaveTempsMode.SaveTempsObj).Default((Object)SaveTempsMode.SaveTempsCwd));
            }
            this.setLTOMode((ArgList)Args);
            if (this.getLTOMode() == LTOKind.LTOK_None) {
                A = Args.getLastArg(new OptSpecifier(options.ID.OPT_fembed_bitcode_EQ.getValue()));
                if (A != null) {
                    StringRef Name = new StringRef(A.getValue());
                    int Model = new StringSwitchUInt(Name).Case("off", BitcodeEmbedMode.EmbedNone.getValue()).Case("all", BitcodeEmbedMode.EmbedBitcode.getValue()).Case("bitcode", BitcodeEmbedMode.EmbedBitcode.getValue()).Case("marker", BitcodeEmbedMode.EmbedMarker.getValue()).Default(-1);
                    if (Model == -1) {
                        $c$ = Native.$createJavaCleaner();
                        try {
                            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(337))), (StringRef)new StringRef(A.getAsString((ArgList)Args))), (StringRef)Name));
                        }
                        finally {
                            $c$.$destroy();
                        }
                    } else {
                        this.BitcodeEmbed = BitcodeEmbedMode.valueOf(Model);
                    }
                }
            } else {
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_fembed_bitcode_EQ.getValue()));
            }
            UArgs = llvm.make_unique((Object)new InputArgList(JavaDifferentiators.JD.Move.INSTANCE, (InputArgList)std.move((Object)Args)));
            DerivedArgList TranslatedArgs = this.TranslateInputArgs((InputArgList)UArgs.$star());
            ToolChain TC = this.getToolChain((ArgList)UArgs.$star(), DriverStatics.computeTargetTriple(this, new StringRef(this.DefaultTargetTriple), (ArgList)UArgs.$star()));
            Compilation C = new Compilation(this, TC, (InputArgList)UArgs.release(), TranslatedArgs);
            if (!this.HandleImmediateArgs(C)) {
                $c$ = C;
                return $c$;
            }
            SmallVector Inputs = new SmallVector(16, (Object)new std_pair.pair((Object)types.ID.TY_INVALID, null));
            this.BuildInputs(C.getDefaultToolChain(), TranslatedArgs, (SmallVector<std_pair.pair<types.ID, Arg>>)Inputs);
            this.CreateOffloadingDeviceToolChains(C, (SmallVector<std_pair.pair<types.ID, Arg>>)Inputs);
            if (TC.getTriple().isOSBinFormatMachO()) {
                this.BuildUniversalActions(C, C.getDefaultToolChain(), (SmallVector<std_pair.pair<types.ID, Arg>>)Inputs);
            } else {
                this.BuildActions(C, C.getArgs(), (SmallVector<std_pair.pair<types.ID, Arg>>)Inputs, C.getActions());
            }
            if (CCCPrintPhases) {
                this.PrintActions(C);
                Compilation compilation = C;
                return compilation;
            }
            this.BuildJobs(C);
            Compilation compilation = C;
            return compilation;
        }
        finally {
            if (UArgs != null) {
                UArgs.$destroy();
            }
            if (Args != null) {
                Args.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ParseDriverMode(ArrayRef<char.ptr> Args) {
        std.string OptName = this.getOpts().getOption(new OptSpecifier(options.ID.OPT_driver_mode.getValue())).getPrefixedName();
        for (char.ptr ArgPtr : Args) {
            StringRef Arg2;
            if (Native.$eq_ptr((void.ptr)ArgPtr, null) || !(Arg2 = new StringRef(ArgPtr)).startswith(new StringRef(OptName))) continue;
            StringRef Value = Arg2.drop_front(OptName.size());
            int M = new StringSwitchUInt(Value).Case("gcc", DriverMode.GCCMode.getValue()).Case("g++", DriverMode.GXXMode.getValue()).Case("cpp", DriverMode.CPPMode.getValue()).Case("cl", DriverMode.CLMode.getValue()).Default(-1);
            if (M != -1) {
                this.Mode = DriverMode.valueOf(M);
                continue;
            }
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(366))), (StringRef)new StringRef(OptName)), (StringRef)Value));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputArgList ParseArgStrings(ArrayRef<char.ptr> ArgStrings) {
        PrettyStackTraceString CrashInfo = null;
        InputArgList Args = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Command line argument parsing"));
            std_pair.pairUIntUInt includeExcludeOptionFlagMasks = this.getIncludeExcludeOptionFlagMasks();
            int IncludedFlagsBitmask = includeExcludeOptionFlagMasks.first;
            int ExcludedFlagsBitmask = includeExcludeOptionFlagMasks.second;
            uint.ref MissingArgIndex = NativePointer.create_uint$ref((int)0);
            uint.ref MissingArgCount = NativePointer.create_uint$ref((int)0);
            Args = this.getOpts().ParseArgs(new ArrayRef(ArgStrings), MissingArgIndex, MissingArgCount, IncludedFlagsBitmask, ExcludedFlagsBitmask);
            if (MissingArgCount.$deref() != 0) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_uint((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(341))), (char.ptr)Args.getArgString(MissingArgIndex.$deref())), (int)MissingArgCount.$deref()));
            }
            for (Arg A : Args) {
                if (A.getOption().hasFlag(128)) {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(364))), (StringRef)new StringRef(A.getAsString((ArgList)Args))));
                    continue;
                }
                if (!A.getOption().matches(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue())) || !A.containsValue(new StringRef(NativePointer.$EMPTY))) continue;
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(384))), (StringRef)new StringRef(A.getAsString((ArgList)Args))));
            }
            for (Arg A : Args.filtered(new OptSpecifier(options.ID.OPT_UNKNOWN.getValue()))) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diags.Report(this.IsCLMode() ? 399 : 358))), (StringRef)new StringRef(A.getAsString((ArgList)Args))));
            }
            Iterator iterator2 = new InputArgList(JavaDifferentiators.JD.Move.INSTANCE, Args);
            return iterator2;
        }
        finally {
            if (Args != null) {
                Args.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildInputs(ToolChain TC, DerivedArgList Args, SmallVector<std_pair.pair<types.ID, Arg>> Inputs) {
        JavaCleaner $c$;
        types.ID InputType = types.ID.TY_Nothing;
        Arg InputTypeArg = null;
        Arg TCTP = Args.getLastArgNoClaim(new OptSpecifier(options.ID.OPT__SLASH_TC.getValue()), new OptSpecifier(options.ID.OPT__SLASH_TP.getValue()));
        if (TCTP != null) {
            InputTypeArg = TCTP;
            InputType = TCTP.getOption().matches(new OptSpecifier(options.ID.OPT__SLASH_TC.getValue())) ? types.ID.TY_C : types.ID.TY_CXX;
            arg_iterator it = Args.filtered_begin(new OptSpecifier(options.ID.OPT__SLASH_TC.getValue()), new OptSpecifier(options.ID.OPT__SLASH_TP.getValue()));
            arg_iterator ie = Args.filtered_end();
            Arg Previous = it.$postInc().$star();
            boolean ShowNote = false;
            while (arg_iterator.$noteq_arg_iterator((arg_iterator)it, (arg_iterator)ie)) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(392))), (StringRef)Previous.getSpelling()), (StringRef)it.$star().getSpelling()));
                    Previous = it.$postInc().$star();
                    ShowNote = true;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (ShowNote) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean($c$.track((Object)this.Diag(376)));
                }
                finally {
                    $c$.$destroy();
                }
            }
            assert (!Args.hasArg(new OptSpecifier(options.ID.OPT_x.getValue()))) : "-x and /TC or /TP is not allowed";
        }
        for (Arg A : Args) {
            Arg InputArg;
            char.ptr Value;
            if (A.getOption().getKind() == 1) {
                Value = Native.$tryClone((char.ptr)A.getValue());
                types.ID Ty = types.ID.TY_INVALID;
                if (InputType == types.ID.TY_Nothing) {
                    if (InputTypeArg != null) {
                        InputTypeArg.claim();
                    }
                    if (std.memcmp((char.ptr)Value, (char.ptr)NativePointer.$MINUS, (int)2) == 0) {
                        if (!Args.hasArgNoClaim(new OptSpecifier(options.ID.OPT_E.getValue())) && !this.CCCIsCPP()) {
                            JavaCleaner $c$2 = Native.$createJavaCleaner();
                            try {
                                $c$2.clean($c$2.track((Object)this.Diag(this.IsCLMode() ? 362 : 361)));
                            }
                            finally {
                                $c$2.$destroy();
                            }
                        }
                        Ty = types.ID.TY_C;
                    } else {
                        char.ptr Ext = Native.$tryClone((char.ptr)std.strrchr((char.ptr)Value, (byte)46));
                        if (Ext != null) {
                            Ty = TC.LookupTypeForExtension((char.ptr)Ext.$add(1));
                        }
                        if (Ty == types.ID.TY_INVALID) {
                            Ty = this.CCCIsCPP() ? types.ID.TY_C : types.ID.TY_Object;
                        }
                        if (this.CCCIsCXX()) {
                            types.ID OldTy = Ty;
                            if ((Ty = types.lookupCXXTypeForCType(Ty)) != OldTy) {
                                $c$ = Native.$createJavaCleaner();
                                try {
                                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(397))), (char.ptr)types.getTypeName(OldTy)), (char.ptr)types.getTypeName(Ty)));
                                }
                                finally {
                                    $c$.$destroy();
                                }
                            }
                        }
                    }
                    if (Ty != types.ID.TY_Object) {
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_ObjC.getValue()))) {
                            Ty = types.ID.TY_ObjC;
                        } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_ObjCXX.getValue()))) {
                            Ty = types.ID.TY_ObjCXX;
                        }
                    }
                } else {
                    char.ptr Ext;
                    assert (InputTypeArg != null) : "InputType set w/o InputTypeArg";
                    if (!InputTypeArg.getOption().matches(new OptSpecifier(options.ID.OPT_x.getValue())) && (Ext = Native.$tryClone((char.ptr)std.strrchr((char.ptr)Value, (byte)46))) != null && TC.LookupTypeForExtension((char.ptr)Ext.$add(1)) == types.ID.TY_Object) {
                        Ty = types.ID.TY_Object;
                    }
                    if (Ty == types.ID.TY_INVALID) {
                        Ty = InputType;
                        InputTypeArg.claim();
                    }
                }
                if (!DriverStatics.DiagnoseInputExistence(this, Args, new StringRef(Value), Ty)) continue;
                Inputs.push_back((Object)new std_pair.pair(std.make_pair_E_Ptr((Object)((Object)Ty), (Object)A)));
                continue;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT__SLASH_Tc.getValue()))) {
                Value = new StringRef(A.getValue());
                if (DriverStatics.DiagnoseInputExistence(this, Args, new StringRef((StringRef)Value), types.ID.TY_C)) {
                    InputArg = DriverStatics.MakeInputArg(Args, this.Opts, new StringRef(A.getValue()));
                    Inputs.push_back((Object)new std_pair.pair(std.make_pair_E_Ptr((Object)((Object)types.ID.TY_C), (Object)InputArg)));
                }
                A.claim();
                continue;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT__SLASH_Tp.getValue()))) {
                Value = new StringRef(A.getValue());
                if (DriverStatics.DiagnoseInputExistence(this, Args, new StringRef((StringRef)Value), types.ID.TY_CXX)) {
                    InputArg = DriverStatics.MakeInputArg(Args, this.Opts, new StringRef(A.getValue()));
                    Inputs.push_back((Object)new std_pair.pair(std.make_pair_E_Ptr((Object)((Object)types.ID.TY_CXX), (Object)InputArg)));
                }
                A.claim();
                continue;
            }
            if (A.getOption().hasFlag(32)) {
                Inputs.push_back((Object)new std_pair.pair(std.make_pair_E_Ptr((Object)((Object)types.ID.TY_Object), (Object)A)));
                continue;
            }
            if (!A.getOption().matches(new OptSpecifier(options.ID.OPT_x.getValue()))) continue;
            InputTypeArg = A;
            InputType = types.lookupTypeForTypeSpecifier(A.getValue());
            A.claim();
            if (InputType.getValue() != 0) continue;
            JavaCleaner $c$3 = Native.$createJavaCleaner();
            try {
                $c$3.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$3.track((Object)this.Diag(359))), (char.ptr)A.getValue()));
                InputType = types.ID.TY_Object;
            }
            finally {
                $c$3.$destroy();
            }
        }
        if (this.CCCIsCPP() && Inputs.empty()) {
            Arg A = DriverStatics.MakeInputArg(Args, this.Opts, StringRef.R$MINUS);
            Inputs.push_back((Object)new std_pair.pair(std.make_pair_E_Ptr((Object)((Object)types.ID.TY_C), (Object)A)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildActions(Compilation C, DerivedArgList Args, SmallVector<std_pair.pair<types.ID, Arg>> Inputs, SmallVector<Action> Actions) {
        block88: {
            JavaCleaner $c$;
            StringRef V;
            JavaCleaner $c$2;
            Arg A;
            PrettyStackTraceString CrashInfo;
            block77: {
                CrashInfo = null;
                CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Building compilation actions"));
                if (this.SuppressMissingInputWarning || !Inputs.empty()) break block77;
                JavaCleaner $c$3 = Native.$createJavaCleaner();
                try {
                    $c$3.clean($c$3.track((Object)this.Diag(345)));
                    return;
                }
                finally {
                    $c$3.$destroy();
                }
            }
            type.ptr FinalPhaseArg = NativePointer.create_type$ptr((Object)null);
            phases.ID FinalPhase = this.getFinalPhase(Args, (type.ptr<Arg>)FinalPhaseArg);
            if (FinalPhase == phases.ID.Link && Args.hasArg(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()))) {
                JavaCleaner $c$4 = Native.$createJavaCleaner();
                try {
                    $c$4.clean($c$4.track((Object)this.Diag(318)));
                }
                finally {
                    $c$4.$destroy();
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_Z_Joined.getValue()))) != null) {
                $c$2 = Native.$createJavaCleaner();
                try {
                    $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)this.Diag(368))), (StringRef)new StringRef(A.getAsString((ArgList)Args))));
                }
                finally {
                    $c$2.$destroy();
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Fo.getValue()))) != null) {
                V = new StringRef(A.getValue());
                if (Unsigned.$greater_uint((int)Inputs.size(), (int)1) && !V.empty() && !path.is_separator((byte)V.back())) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(354))), (StringRef)A.getSpelling()), (StringRef)V));
                        Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Fo.getValue()));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Fa.getValue()))) != null) {
                V = new StringRef(A.getValue());
                if (Unsigned.$greater_uint((int)Inputs.size(), (int)1) && !V.empty() && !path.is_separator((byte)V.back())) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(354))), (StringRef)A.getSpelling()), (StringRef)V));
                        Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Fa.getValue()));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
            if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_o.getValue()))) != null && A.getValue().$at(0) == 0) {
                $c$2 = Native.$createJavaCleaner();
                try {
                    $c$2.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$2.track((Object)this.Diag(341))), (StringRef)A.getSpelling()), (int)1));
                    Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_o.getValue()));
                }
                finally {
                    $c$2.$destroy();
                }
            }
            Arg YcArg = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Yc.getValue()));
            Arg YuArg = Args.getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Yu.getValue()));
            if (YcArg != null && YcArg.getValue().$at(0) == 0) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(403))), (StringRef)YcArg.getSpelling()));
                    Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yc.getValue()));
                    YcArg = null;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (YuArg != null && YuArg.getValue().$at(0) == 0) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(403))), (StringRef)YuArg.getSpelling()));
                    Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yu.getValue()));
                    YuArg = null;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (YcArg != null && YuArg != null && std.strcmp((char.ptr)YcArg.getValue(), (char.ptr)YuArg.getValue()) != 0) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean($c$.track((Object)this.Diag(402)));
                    Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yc.getValue()));
                    Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yu.getValue()));
                    YuArg = null;
                    YcArg = null;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (YcArg != null || YuArg != null) {
                StringRef Val = new StringRef(YcArg != null ? YcArg.getValue() : YuArg.getValue());
                boolean FoundMatchingInclude = false;
                for (Arg Inc : Args.filtered(new OptSpecifier(options.ID.OPT_include.getValue()))) {
                    if (!llvm.$eq_StringRef((char.ptr)Inc.getValue(), (StringRef)Val)) continue;
                    FoundMatchingInclude = true;
                }
                if (!FoundMatchingInclude) {
                    JavaCleaner $c$5 = Native.$createJavaCleaner();
                    try {
                        $c$5.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$5.track((Object)this.Diag(404))), (StringRef)(YcArg != null ? YcArg : YuArg).getSpelling()));
                        Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yc.getValue()));
                        Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yu.getValue()));
                        YuArg = null;
                        YcArg = null;
                    }
                    finally {
                        $c$5.$destroy();
                    }
                }
            }
            if (YcArg != null && Unsigned.$greater_uint((int)Inputs.size(), (int)1)) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean($c$.track((Object)this.Diag(401)));
                    Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yc.getValue()));
                    YcArg = null;
                }
                finally {
                    $c$.$destroy();
                }
            }
            if (Args.hasArg(new OptSpecifier(options.ID.OPT__SLASH_Y_.getValue()))) {
                Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Fp.getValue()));
                Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yc.getValue()));
                Args.eraseArg(new OptSpecifier(options.ID.OPT__SLASH_Yu.getValue()));
                YuArg = null;
                YcArg = null;
            }
            int CompilationActiveOffloadHostKinds = 0;
            SmallVector LinkerInputs = new SmallVector(3, (Object)null);
            SmallVector PL = new SmallVector(phases.MaxNumberOfPhases);
            for (std_pair.pair I : Inputs) {
                phases.ID Phase;
                types.ID InputType = (types.ID)((Object)I.first);
                Arg InputArg = (Arg)I.second;
                PL.clear();
                types.getCompilationPhases(InputType, (SmallVectorImpl<phases.ID>)PL);
                phases.ID InitialPhase = (phases.ID)((Object)PL.$at(0));
                if (InitialPhase.getValue() > FinalPhase.getValue()) {
                    JavaCleaner $c$6;
                    InputArg.claim();
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_Qunused_arguments.getValue()))) continue;
                    if (this.CCCIsCPP()) {
                        $c$6 = Native.$createJavaCleaner();
                        try {
                            $c$6.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$6.track((Object)this.Diag(387))), (StringRef)new StringRef(InputArg.getAsString((ArgList)Args))), (char.ptr)phases.getPhaseName(InitialPhase)));
                            continue;
                        }
                        finally {
                            $c$6.$destroy();
                            continue;
                        }
                    }
                    if (InitialPhase == phases.ID.Compile && FinalPhase == phases.ID.Preprocess && types.getPreprocessedType(InputType) == types.ID.TY_INVALID) {
                        $c$6 = Native.$createJavaCleaner();
                        try {
                            $c$6.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out$Same2Bool((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$6.track((Object)this.Diag(394))), (StringRef)new StringRef(InputArg.getAsString((ArgList)Args))), (FinalPhaseArg != null ? 1 : 0) != 0), (StringRef)(FinalPhaseArg != null ? ((Arg)FinalPhaseArg.$star()).getOption().getName() : new StringRef(NativePointer.$EMPTY))));
                            continue;
                        }
                        finally {
                            $c$6.$destroy();
                            continue;
                        }
                    }
                    $c$6 = Native.$createJavaCleaner();
                    try {
                        $c$6.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out$Same2Bool((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$6.track((Object)this.Diag(386))), (StringRef)new StringRef(InputArg.getAsString((ArgList)Args))), (char.ptr)phases.getPhaseName(InitialPhase)), (FinalPhaseArg != null ? 1 : 0) != 0), (StringRef)(FinalPhaseArg != null ? ((Arg)FinalPhaseArg.$star()).getOption().getName() : new StringRef(NativePointer.$EMPTY))));
                        continue;
                    }
                    finally {
                        $c$6.$destroy();
                        continue;
                    }
                }
                if (YcArg != null && FinalPhase.getValue() >= phases.ID.Compile.getValue()) {
                    SmallVector PCHPL = new SmallVector(phases.MaxNumberOfPhases);
                    types.getCompilationPhases(types.ID.TY_CXXHeader, (SmallVectorImpl<phases.ID>)PCHPL);
                    Arg PchInputArg = DriverStatics.MakeInputArg(Args, this.Opts, new StringRef(YcArg.getValue()));
                    Action ClangClPch = C.MakeAction(new InputAction(PchInputArg, InputType));
                    for (phases.ID Phase2 : PCHPL) {
                        ClangClPch = this.ConstructPhaseAction(C, (ArgList)Args, Phase2, ClangClPch);
                    }
                    assert (ClangClPch != null);
                    Actions.push_back((Object)ClangClPch);
                }
                phases.ID CudaInjectionPhase = phases.ID.Compile.getValue() < FinalPhase.getValue() && llvm.find((Native.NativeIterable)PL, (Object)((Object)phases.ID.Compile)) != PL.end() ? phases.ID.Compile : FinalPhase;
                int InputActiveOffloadHostKinds = 0;
                Action Current = C.MakeAction(new InputAction(InputArg, InputType));
                SmallVectorImpl.iterator i = PL.begin();
                SmallVectorImpl.iterator e = PL.end();
                while (Native.$noteq_iter((abstract_iterator)i, (abstract_iterator)e) && (Phase = (phases.ID)((Object)i.$star())).getValue() <= FinalPhase.getValue()) {
                    if (Phase == phases.ID.Link) {
                        assert (Native.$eq_iter((abstract_iterator)i.$add(1), (abstract_iterator)e)) : "linking must be final compilation step.";
                        LinkerInputs.push_back((Object)Current);
                        Current = null;
                        break;
                    }
                    if (Phase != phases.ID.Assemble || Current.getType() == types.ID.TY_PP_Asm) {
                        Current = this.ConstructPhaseAction(C, (ArgList)Args, Phase, Current);
                        if (InputType == types.ID.TY_CUDA && Phase == CudaInjectionPhase) {
                            if ((Current = DriverStatics.buildCudaActions(C, Args, InputArg, Current, Actions)) == null) break;
                            InputActiveOffloadHostKinds |= 2;
                            CompilationActiveOffloadHostKinds |= 2;
                        }
                        if (Current.getType() == types.ID.TY_Nothing) break;
                    }
                    i.$preInc();
                }
                if (Current == null) continue;
                if (InputActiveOffloadHostKinds != 0) {
                    Current.propagateHostOffloadInfo(InputActiveOffloadHostKinds, null);
                }
                Actions.push_back((Object)Current);
            }
            if (!LinkerInputs.empty()) {
                Actions.push_back((Object)C.MakeAction(new LinkJobAction((SmallVector<Action>)LinkerInputs, types.ID.TY_Image)));
                ((Action)Actions.back()).propagateHostOffloadInfo(CompilationActiveOffloadHostKinds, null);
            }
            if (FinalPhase == phases.ID.Link && PL.size() == 1) {
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_CompileOnly_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_cl_compile_Group.getValue()));
            }
            break block88;
            finally {
                if (CrashInfo != null) {
                    CrashInfo.$destroy();
                }
            }
        }
        Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_cl_ignored_Group.getValue()));
        Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_cuda_host_only.getValue()));
        Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_cuda_compile_host_device.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildUniversalActions(Compilation C, ToolChain TC, SmallVector<std_pair.pair<types.ID, Arg>> BAInputs) {
        PrettyStackTraceString CrashInfo = null;
        StringSet ArchNames = null;
        try {
            JavaCleaner $c$;
            DerivedArgList Args = C.getArgs();
            SmallVector<Action> Actions = C.getActions();
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Building universal build actions"));
            ArchNames = new StringSet();
            SmallVector Archs = new SmallVector(4, null);
            for (Arg A : Args) {
                if (!A.getOption().matches(new OptSpecifier(options.ID.OPT_arch.getValue()))) continue;
                Triple.ArchType Arch = DarwinStatics.getArchTypeForMachOArchName(new StringRef(A.getValue()));
                if (Arch == Triple.ArchType.UnknownArch) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(322))), (StringRef)new StringRef(A.getAsString((ArgList)Args))));
                        continue;
                    }
                    finally {
                        $c$.$destroy();
                        continue;
                    }
                }
                A.claim();
                if (!ArchNames.insert((StringRef)new StringRef((char.ptr)A.getValue())).second) continue;
                Archs.push_back((Object)A.getValue());
            }
            if (Archs.size() == 0) {
                Archs.push_back((Object)Args.MakeArgString(new Twine(TC.getDefaultUniversalArchName())));
            }
            SmallVector SingleActions = new SmallVector(3, (Object)null);
            this.BuildActions(C, Args, BAInputs, (SmallVector<Action>)SingleActions);
            for (Action Act : SingleActions) {
                Arg A;
                if (Unsigned.$greater_uint((int)Archs.size(), (int)1) && !types.canLipoType(Act.getType())) {
                    $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(331))), (char.ptr)types.getTypeName(Act.getType())));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                SmallVector Inputs = new SmallVector(3, (Object)null);
                int e = Archs.size();
                for (int i = 0; i != e; ++i) {
                    Inputs.push_back((Object)C.MakeAction(new BindArchAction(Act, (char.ptr)Archs.$at(i))));
                }
                if (Inputs.size() == 1 || Act.getType() == types.ID.TY_Nothing) {
                    Actions.append((type.iterator)Inputs.begin(), (type.iterator)Inputs.end());
                } else {
                    Actions.push_back((Object)C.MakeAction(new LipoJobAction((SmallVector<Action>)Inputs, Act.getType())));
                }
                if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_g_Group.getValue()))) == null || A.getOption().matches(new OptSpecifier(options.ID.OPT_g0.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_gstabs.getValue())) || !DriverStatics.ContainsCompileOrAssembleAction((Action)Actions.back())) continue;
                if (Act.getType() == types.ID.TY_Image) {
                    SmallVector _Inputs = new SmallVector(3, (Object)null);
                    _Inputs.push_back(Actions.back());
                    Actions.pop_back();
                    Actions.push_back((Object)C.MakeAction(new DsymutilJobAction((SmallVector<Action>)_Inputs, types.ID.TY_dSYM)));
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_verify_debug_info.getValue()))) continue;
                Action LastAction = (Action)Actions.back();
                Actions.pop_back();
                Actions.push_back((Object)C.MakeAction(new VerifyDebugInfoJobAction(LastAction, types.ID.TY_Nothing)));
            }
        }
        finally {
            if (ArchNames != null) {
                ArchNames.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BuildJobs(Compilation C) {
        PrettyStackTraceString CrashInfo = null;
        StringSet ArchNames = null;
        std.map CachedResults = null;
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Building compilation jobs"));
            Arg FinalOutput = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT_o.getValue()));
            if (FinalOutput != null) {
                int NumOutputs = 0;
                for (Action A : C.getActions()) {
                    if (A.getType() == types.ID.TY_Nothing) continue;
                    ++NumOutputs;
                }
                if (Unsigned.$greater_uint((int)NumOutputs, (int)1)) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean($c$.track((Object)this.Diag(355)));
                        FinalOutput = null;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
            ArchNames = new StringSet();
            if (C.getDefaultToolChain().getTriple().isOSBinFormatMachO()) {
                for (Object A : C.getArgs()) {
                    if (!A.getOption().matches(new OptSpecifier(options.ID.OPT_arch.getValue()))) continue;
                    ArchNames.insert(new StringRef(A.getValue()));
                }
            }
            CachedResults = new std.map(CACHED_RESULT_COMPARATOR, (Object)new InputInfo());
            for (Object A : C.getActions()) {
                char.ptr LinkingOutput = null;
                if (llvm.isa(LipoJobAction.class, (Object)A)) {
                    LinkingOutput = FinalOutput != null ? Native.$tryClone((char.ptr)FinalOutput.getValue()) : Native.$tryClone((char.ptr)this.getDefaultImageName());
                }
                this.BuildJobsForAction(C, (Action)A, C.getDefaultToolChain(), null, true, Unsigned.$greater_uint((int)ArchNames.size(), (int)1), LinkingOutput, (std.map<std_pair.pair<Action, std.string>, InputInfo>)CachedResults, false);
            }
            if (this.Diags.hasErrorOccurred() || C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_Qunused_arguments.getValue()))) {
                return;
            }
            C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__HASH_HASH_HASH.getValue()));
            C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_driver_mode.getValue()));
            C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_rsp_quoting.getValue()));
            for (Object A : C.getArgs()) {
                if (A.isClaimed() || A.getOption().hasFlag(64)) continue;
                Option Opt = A.getOption();
                if (Opt.getKind() == 3) {
                    boolean DuplicateClaimed = false;
                    for (Arg AA : C.getArgs().filtered(new OptSpecifier(Opt))) {
                        if (!AA.isClaimed()) continue;
                        DuplicateClaimed = true;
                        break;
                    }
                    if (DuplicateClaimed) continue;
                }
                if (this.IsCLMode() && A.getOption().matches(new OptSpecifier(options.ID.OPT_UNKNOWN.getValue()))) continue;
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(400))), (StringRef)new StringRef(A.getAsString((ArgList)C.getArgs()))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        finally {
            if (CachedResults != null) {
                CachedResults.$destroy();
            }
            if (ArchNames != null) {
                ArchNames.$destroy();
            }
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ExecuteCompilation(Compilation C, SmallVectorImpl<std_pair.pairIntType<Command>> FailingCommands) {
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__HASH_HASH_HASH.getValue()))) {
            C.getJobs().Print(llvm.errs(), NativePointer.$LF, true);
            return 0;
        }
        if (this.Diags.hasErrorOccurred()) {
            return 1;
        }
        for (Command Job : C.getJobs()) {
            this.setUpResponseFiles(C, Job);
        }
        C.ExecuteJobs(C.getJobs(), FailingCommands);
        C.CleanupFileList(C.getTempFiles());
        if (FailingCommands.empty()) {
            return 0;
        }
        for (std_pair.pairIntType CmdPair : FailingCommands) {
            JavaCleaner $c$;
            int Res = CmdPair.first;
            Command FailingCommand = (Command)CmdPair.second;
            if (!this.isSaveTempsEnabled()) {
                JobAction JA = (JobAction)llvm.cast(JobAction.class, (Object)FailingCommand.getSource());
                C.CleanupFileMap(C.getResultFiles(), JA, true);
                if (Res < 0) {
                    C.CleanupFileMap(C.getFailureResultFiles(), JA, true);
                }
            }
            Tool FailingTool = FailingCommand.getCreator();
            if (FailingCommand.getCreator().hasGoodDiagnostics() && Res == 1) continue;
            if (Res < 0) {
                $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(314))), (char.ptr)FailingTool.getShortName()));
                    continue;
                }
                finally {
                    $c$.$destroy();
                    continue;
                }
            }
            $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(312))), (char.ptr)FailingTool.getShortName()), (int)Res));
            }
            finally {
                $c$.$destroy();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCompilationDiagnostics(Compilation C, Command FailingCommand) {
        StringSet ArchNames = null;
        raw_fd_ostream ScriptOS = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_fno_crash_diagnostics.getValue()))) {
                return;
            }
            if (FailingCommand.getCreator().isLinkJob() || FailingCommand.getCreator().isDsymutilJob()) {
                return;
            }
            this.PrintVersion(C, llvm.errs());
            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"PLEASE submit a bug report to http://llvm.org/bugs/ and include the crash backtrace, preprocessed source, and associated run script."));
            this.Mode = DriverMode.CPPMode;
            this.CCGenDiagnostics = true;
            Command Cmd = new Command(FailingCommand);
            DiagnosticErrorTrap Trap = new DiagnosticErrorTrap(this.Diags);
            C.initCompilationForDiagnostics();
            SmallVector Inputs = new SmallVector(16, (Object)new std_pair.pair((Object)types.ID.TY_INVALID, null));
            this.BuildInputs(C.getDefaultToolChain(), C.getArgs(), (SmallVector<std_pair.pair<types.ID, Arg>>)Inputs);
            Object it = Inputs.begin();
            SmallVectorImpl.iterator ie = Inputs.end();
            while (Native.$noteq_iter((abstract_iterator)it, (abstract_iterator)ie)) {
                boolean IgnoreInput = false;
                if (types.getPreprocessedType((types.ID)((Object)((std_pair.pair)it.$star()).first)) == types.ID.TY_INVALID) {
                    IgnoreInput = true;
                } else if (std.strcmp((char.ptr)((Arg)((std_pair.pair)it.$star()).second).getValue(), (CharSequence)"-") == 0) {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"Error generating preprocessed source(s) - ignoring input from stdin."));
                    IgnoreInput = true;
                }
                if (IgnoreInput) {
                    it = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)Inputs.erase((SmallVectorImpl.iterator)it));
                    ie = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)Inputs.end());
                    continue;
                }
                it.$preInc();
            }
            if (Inputs.empty()) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"Error generating preprocessed source(s) - no preprocessable inputs."));
                return;
            }
            ArchNames = new StringSet();
            for (Arg A : C.getArgs()) {
                if (!A.getOption().matches(new OptSpecifier(options.ID.OPT_arch.getValue()))) continue;
                StringRef ArchName = new StringRef(A.getValue());
                ArchNames.insert(ArchName);
            }
            if (Unsigned.$greater_uint((int)ArchNames.size(), (int)1)) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"Error generating preprocessed source(s) - cannot generate preprocessed source with multiple -arch options."));
                return;
            }
            ToolChain TC = C.getDefaultToolChain();
            if (TC.getTriple().isOSBinFormatMachO()) {
                this.BuildUniversalActions(C, TC, (SmallVector<std_pair.pair<types.ID, Arg>>)Inputs);
            } else {
                this.BuildActions(C, C.getArgs(), (SmallVector<std_pair.pair<types.ID, Arg>>)Inputs, C.getActions());
            }
            this.BuildJobs(C);
            if (Trap.hasErrorOccurred()) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"Error generating preprocessed source(s)."));
                return;
            }
            SmallVector FailingCommands = new SmallVector(4, (Object)new std_pair.pairIntType(null));
            C.ExecuteJobs(C.getJobs(), (SmallVectorImpl<std_pair.pairIntType<Command>>)FailingCommands);
            if (!FailingCommands.empty()) {
                if (!this.isSaveTempsEnabled()) {
                    C.CleanupFileList(C.getTempFiles(), true);
                }
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"Error generating preprocessed source(s)."));
                return;
            }
            ArgStringList TempFiles = C.getTempFiles();
            if (TempFiles.empty()) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"Error generating preprocessed source(s)."));
                return;
            }
            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"\n********************\n\nPLEASE ATTACH THE FOLLOWING FILES TO THE BUG REPORT:\nPreprocessed source(s) and associated run script(s) are located at:"));
            SmallString VFS = new SmallString(128);
            for (char.ptr TempFile : TempFiles) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (char.ptr)TempFile));
                if (!new StringRef(TempFile).endswith(".cache")) continue;
                VFS.$assign(path.filename((StringRef)new StringRef(TempFile)));
                path.append((SmallString)VFS, (Twine)new Twine("vfs"), (Twine)new Twine("vfs.yaml"));
            }
            CrashReportInfo CrashInfo = new CrashReportInfo(new StringRef((char.ptr)TempFiles.$at(0)), VFS.$StringRef());
            std.string Script = std.$add_string_T((std.string)((StringRef)CrashInfo.Filename.rsplit((byte)46).first).str(), (String)".sh");
            std_errors.error_code EC = new std_errors.error_code();
            ScriptOS = new raw_fd_ostream(new StringRef(Script), EC, 1);
            if (EC.$bool()) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (StringRef)new StringRef(std.$add_string((std.string)std.$add_string_T((std.string)std.$add_T_string$C((String)"Error generating run script: ", (std.string)Script), (String)" "), (std.string)EC.message()))));
            } else {
                ScriptOS.$out("# Crash reproducer for ").$out(BasicClangGlobals.getClangFullVersion()).$out(NativePointer.$LF).$out("# Driver args: ");
                DriverStatics.printArgList((raw_ostream)ScriptOS, (ArgList)C.getInputArgs());
                ScriptOS.$out("# Original command: ");
                Cmd.Print((raw_ostream)ScriptOS, NativePointer.$LF, true);
                Cmd.Print((raw_ostream)ScriptOS, NativePointer.$LF, true, CrashInfo);
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (StringRef)new StringRef(Script)));
            }
            for (Arg A : C.getArgs().filtered(new OptSpecifier(options.ID.OPT_frewrite_map_file.getValue()), new OptSpecifier(options.ID.OPT_frewrite_map_file_EQ.getValue()))) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (char.ptr)A.getValue()));
            }
            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(375))), (String)"\n\n********************"));
        }
        finally {
            if (ScriptOS != null) {
                ScriptOS.$destroy();
            }
            if (ArchNames != null) {
                ArchNames.$destroy();
            }
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PrintActions(Compilation C) {
        std.mapTypeUInt Ids = null;
        try {
            Ids = new std.mapTypeUInt();
            for (Action A : C.getActions()) {
                DriverStatics.PrintActions1(C, A, (std.mapTypeUInt<Action>)Ids);
            }
        }
        finally {
            if (Ids != null) {
                Ids.$destroy();
            }
        }
    }

    public void PrintHelp(boolean ShowHidden) {
        std_pair.pairUIntUInt includeExcludeOptionFlagMasks = this.getIncludeExcludeOptionFlagMasks();
        int IncludedFlagsBitmask = includeExcludeOptionFlagMasks.first;
        int ExcludedFlagsBitmask = includeExcludeOptionFlagMasks.second;
        ExcludedFlagsBitmask |= 0x1000;
        if (!ShowHidden) {
            ExcludedFlagsBitmask |= 1;
        }
        this.getOpts().PrintHelp(llvm.outs(), this.Name.c_str(), this.DriverTitle.c_str(), IncludedFlagsBitmask, ExcludedFlagsBitmask);
    }

    public void PrintVersion(Compilation C, raw_ostream OS) {
        OS.$out(BasicClangGlobals.getClangFullVersion()).$out_char((byte)10);
        ToolChain TC = C.getDefaultToolChain();
        OS.$out("Target: ").$out(TC.getTripleString()).$out_char((byte)10);
        Arg A = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT_mthread_model.getValue()));
        if (A != null) {
            if (TC.isThreadModelSupported(new StringRef(A.getValue()))) {
                OS.$out("Thread model: ").$out(A.getValue());
            }
        } else {
            OS.$out("Thread model: ").$out(TC.getThreadModel());
        }
        OS.$out_char((byte)10);
        OS.$out("InstalledDir: ").$out(this.InstalledDir).$out_char((byte)10);
    }

    public std.string GetFilePath(char.ptr Name, ToolChain TC) {
        for (std.string Dir : this.PrefixDirs) {
            if (Dir.empty()) continue;
            SmallString P = new SmallString(new StringRef(Dir.$at(0) == 61 ? std.$add_string$C_string((std.string)this.SysRoot, (std.string)Dir.substr(1)) : new std.string(Dir)), 128);
            path.append((SmallString)P, (Twine)new Twine(Name));
            if (!fs.exists((Twine)new Twine(P))) continue;
            return P.str().$basic_string();
        }
        SmallString P = new SmallString(new StringRef(this.ResourceDir), 128);
        path.append((SmallString)P, (Twine)new Twine(Name));
        if (fs.exists((Twine)new Twine(P))) {
            return P.str().$basic_string();
        }
        for (std.string Dir : TC.getFilePaths()) {
            if (Dir.empty()) continue;
            SmallString _P = new SmallString(new StringRef(Dir.$at(0) == 61 ? std.$add_string$C_string((std.string)this.SysRoot, (std.string)Dir.substr(1)) : new std.string(Dir)), 128);
            path.append((SmallString)_P, (Twine)new Twine(Name));
            if (!fs.exists((Twine)new Twine(_P))) continue;
            return _P.str().$basic_string();
        }
        return new std.string(Name);
    }

    public std.string GetProgramPath(char.ptr Name, ToolChain TC) {
        SmallString P;
        SmallVector TargetSpecificExecutables = new SmallVector(2, (Object)new std.string());
        this.generatePrefixedToolNames(Name, TC, (SmallVectorImpl<std.string>)TargetSpecificExecutables);
        for (std.string PrefixDir : this.PrefixDirs) {
            SmallString P2;
            if (!(fs.is_directory((Twine)new Twine(PrefixDir)) ? DriverStatics.ScanDirForExecutable(P2 = new SmallString(new StringRef(PrefixDir), 128), (ArrayRef<std.string>)new ArrayRef((SmallVectorImpl)TargetSpecificExecutables)) : fs.can_execute((Twine)new Twine(P2 = new SmallString(new StringRef(std.$add_string$C_T((std.string)PrefixDir, (char.ptr)Name)), 128))))) continue;
            return P2.str().$basic_string();
        }
        SmallVector<std.string> List2 = TC.getProgramPaths();
        for (std.string Path : List2) {
            P = new SmallString(new StringRef(Path), 128);
            if (!DriverStatics.ScanDirForExecutable(P, (ArrayRef<std.string>)new ArrayRef((SmallVectorImpl)TargetSpecificExecutables))) continue;
            return P.str().$basic_string();
        }
        for (std.string TargetSpecificExecutable : TargetSpecificExecutables) {
            P = sys.findProgramByName((StringRef)new StringRef(TargetSpecificExecutable));
            if (!P.$bool()) continue;
            return new std.string((std.string)P.$star());
        }
        return new std.string(Name);
    }

    public boolean HandleImmediateArgs(Compilation C) {
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_dumpmachine.getValue()))) {
            llvm.outs().$out(C.getDefaultToolChain().getTripleString()).$out_char((byte)10);
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_dumpversion.getValue()))) {
            llvm.outs().$out("4.2.1\n");
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__print_diagnostic_categories.getValue()))) {
            DriverStatics.PrintDiagnosticCategories(llvm.outs());
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_help.getValue())) || C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__help_hidden.getValue()))) {
            this.PrintHelp(C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__help_hidden.getValue())));
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__version.getValue()))) {
            this.PrintVersion(C, llvm.outs());
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_v.getValue())) || C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__HASH_HASH_HASH.getValue()))) {
            this.PrintVersion(C, llvm.errs());
            this.SuppressMissingInputWarning = true;
        }
        ToolChain TC = C.getDefaultToolChain();
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_v.getValue()))) {
            TC.printVerboseInfo(llvm.errs());
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_print_search_dirs.getValue()))) {
            llvm.outs().$out("programs: =");
            boolean separator = false;
            for (Object Path : TC.getProgramPaths()) {
                if (separator) {
                    llvm.outs().$out_char((byte)58);
                }
                llvm.outs().$out((std.string)Path);
                separator = true;
            }
            llvm.outs().$out(NativePointer.$LF);
            llvm.outs().$out("libraries: =").$out(this.ResourceDir);
            StringRef sysroot = C.getSysRoot();
            for (std.string Path : TC.getFilePaths()) {
                llvm.outs().$out_char((byte)58);
                if (Path.$at(0) == 61) {
                    llvm.outs().$out(sysroot).$out(Path.substr(1));
                    continue;
                }
                llvm.outs().$out(Path);
            }
            llvm.outs().$out(NativePointer.$LF);
            return false;
        }
        Arg A = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT_print_file_name_EQ.getValue()));
        if (A != null) {
            llvm.outs().$out(this.GetFilePath(A.getValue(), TC)).$out(NativePointer.$LF);
            return false;
        }
        A = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT_print_prog_name_EQ.getValue()));
        if (A != null) {
            llvm.outs().$out(this.GetProgramPath(A.getValue(), TC)).$out(NativePointer.$LF);
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_print_libgcc_file_name.getValue()))) {
            llvm.outs().$out(this.GetFilePath(NativePointer.$((String)"libgcc.a"), TC)).$out(NativePointer.$LF);
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_print_multi_lib.getValue()))) {
            for (Multilib Multilib2 : TC.getMultilibs()) {
                DriverGlobals.$out_raw_ostream_Multilib(llvm.outs(), Multilib2).$out(NativePointer.$LF);
            }
            return false;
        }
        if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_print_multi_directory.getValue()))) {
            for (Multilib Multilib3 : TC.getMultilibs()) {
                if (Multilib3.gccSuffix().empty()) {
                    llvm.outs().$out(".\n");
                    continue;
                }
                StringRef Suffix = new StringRef(Multilib3.gccSuffix());
                assert (Suffix.front() == 47);
                llvm.outs().$out(Suffix.substr(1)).$out(NativePointer.$LF);
            }
            return false;
        }
        return true;
    }

    public Action ConstructPhaseAction(Compilation C, ArgList Args, phases.ID Phase, Action Input) {
        PrettyStackTraceString CrashInfo = null;
        try {
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Constructing phase actions"));
            switch (Phase) {
                case Link: {
                    throw new llvm_unreachable("link action invalid here.");
                }
                case Preprocess: {
                    types.ID OutputTy;
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_M.getValue()), new OptSpecifier(options.ID.OPT_MM.getValue()))) {
                        OutputTy = types.ID.TY_Dependencies;
                    } else {
                        OutputTy = Input.getType();
                        if (!Args.hasFlag(new OptSpecifier(options.ID.OPT_frewrite_includes.getValue()), new OptSpecifier(options.ID.OPT_fno_rewrite_includes.getValue()), false) && !this.CCGenDiagnostics) {
                            OutputTy = types.getPreprocessedType(OutputTy);
                        }
                        assert (OutputTy != types.ID.TY_INVALID) : "Cannot preprocess this input type!";
                    }
                    PreprocessJobAction preprocessJobAction = C.MakeAction(new PreprocessJobAction(Input, OutputTy));
                    return preprocessJobAction;
                }
                case Precompile: {
                    types.ID OutputTy = types.ID.TY_PCH;
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_fsyntax_only.getValue()))) {
                        OutputTy = types.ID.TY_Nothing;
                    }
                    PrecompileJobAction precompileJobAction = C.MakeAction(new PrecompileJobAction(Input, OutputTy));
                    return precompileJobAction;
                }
                case Compile: {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_fsyntax_only.getValue()))) {
                        CompileJobAction OutputTy = C.MakeAction(new CompileJobAction(Input, types.ID.TY_Nothing));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_rewrite_objc.getValue()))) {
                        CompileJobAction OutputTy = C.MakeAction(new CompileJobAction(Input, types.ID.TY_RewrittenObjC));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_rewrite_legacy_objc.getValue()))) {
                        CompileJobAction OutputTy = C.MakeAction(new CompileJobAction(Input, types.ID.TY_RewrittenLegacyObjC));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT__analyze.getValue()), new OptSpecifier(options.ID.OPT__analyze_auto.getValue()))) {
                        AnalyzeJobAction OutputTy = C.MakeAction(new AnalyzeJobAction(Input, types.ID.TY_Plist));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT__migrate.getValue()))) {
                        MigrateJobAction OutputTy = C.MakeAction(new MigrateJobAction(Input, types.ID.TY_Remap));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_emit_ast.getValue()))) {
                        CompileJobAction OutputTy = C.MakeAction(new CompileJobAction(Input, types.ID.TY_AST));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_module_file_info.getValue()))) {
                        CompileJobAction OutputTy = C.MakeAction(new CompileJobAction(Input, types.ID.TY_ModuleFile));
                        return OutputTy;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_verify_pch.getValue()))) {
                        VerifyPCHJobAction OutputTy = C.MakeAction(new VerifyPCHJobAction(Input, types.ID.TY_Nothing));
                        return OutputTy;
                    }
                    CompileJobAction OutputTy = C.MakeAction(new CompileJobAction(Input, types.ID.TY_LLVM_BC));
                    return OutputTy;
                }
                case Backend: {
                    if (this.isUsingLTO()) {
                        types.ID Output = Args.hasArg(new OptSpecifier(options.ID.OPT_S.getValue())) ? types.ID.TY_LTO_IR : types.ID.TY_LTO_BC;
                        BackendJobAction backendJobAction = C.MakeAction(new BackendJobAction(Input, Output));
                        return backendJobAction;
                    }
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()))) {
                        types.ID Output = Args.hasArg(new OptSpecifier(options.ID.OPT_S.getValue())) ? types.ID.TY_LLVM_IR : types.ID.TY_LLVM_BC;
                        BackendJobAction backendJobAction = C.MakeAction(new BackendJobAction(Input, Output));
                        return backendJobAction;
                    }
                    BackendJobAction backendJobAction = C.MakeAction(new BackendJobAction(Input, types.ID.TY_PP_Asm));
                    return backendJobAction;
                }
                case Assemble: {
                    AssembleJobAction assembleJobAction = C.MakeAction(new AssembleJobAction((Action)std.move((Object)Input), types.ID.TY_Object));
                    return assembleJobAction;
                }
            }
            throw new llvm_unreachable("invalid phase in ConstructPhaseAction");
        }
        finally {
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    public InputInfo BuildJobsForAction(Compilation C, Action A, ToolChain TC, char.ptr BoundArch, boolean AtTopLevel, boolean MultipleArchs, char.ptr LinkingOutput, std.map<std_pair.pair<Action, std.string>, InputInfo> CachedResults, boolean BuildForOffloadDevice) {
        std_pair.pair ActionTC;
        StdMap.iterator CachedResult;
        std.string TriplePlusArch = TC.getTriple().normalize();
        if (BoundArch != null) {
            TriplePlusArch.$addassign((CharSequence)"-");
            TriplePlusArch.$addassign(BoundArch);
        }
        if ((CachedResult = CachedResults.find((Object)(ActionTC = new std_pair.pair((Object)A, (Object)TriplePlusArch)))).$noteq((Object)CachedResults.end())) {
            return new InputInfo((InputInfo)CachedResult.$arrow().second);
        }
        InputInfo Result = this.BuildJobsForActionNoCache(C, A, TC, BoundArch, AtTopLevel, MultipleArchs, LinkingOutput, CachedResults, BuildForOffloadDevice);
        ((InputInfo)CachedResults.$at((Object)ActionTC)).$assign(Result);
        return Result;
    }

    public char.ptr getDefaultImageName() {
        Triple Target = new Triple(new Twine(Triple.normalize((StringRef)new StringRef(this.DefaultTargetTriple))));
        return Target.isOSWindows() ? NativePointer.$((String)"a.exe") : NativePointer.$((String)"a.out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char.ptr GetNamedOutputPath(Compilation C, JobAction JA, char.ptr BaseInput, char.ptr BoundArch, boolean AtTopLevel, boolean MultipleArchs, StringRef NormalizedTriple) {
        PrettyStackTraceString CrashInfo = null;
        try {
            char.ptr ptr2;
            char.ptr NamedOutput;
            StringRef Val;
            StringRef BaseName;
            Arg FinalOutput;
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Computing output path"));
            if (AtTopLevel && !llvm.isa(DsymutilJobAction.class, (Object)JA) && !llvm.isa(VerifyJobAction.class, (Object)JA) && (FinalOutput = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT_o.getValue()))) != null) {
                char.ptr ptr3 = C.addResultFile(FinalOutput.getValue(), JA);
                return ptr3;
            }
            if (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__SLASH_P.getValue()))) {
                assert (AtTopLevel && llvm.isa(PreprocessJobAction.class, (Object)JA));
                BaseName = path.filename((StringRef)new StringRef(BaseInput));
                StringRef NameArg = new StringRef();
                Arg A = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Fi.getValue()));
                if (A != null) {
                    NameArg.$assignMove(A.getValue());
                }
                A = C.addResultFile(DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), new StringRef(NameArg), new StringRef(BaseName), types.ID.TY_PP_C), JA);
                return A;
            }
            if (AtTopLevel && !this.CCGenDiagnostics && (llvm.isa(PreprocessJobAction.class, (Object)JA) || JA.getType() == types.ID.TY_ModuleFile)) {
                BaseName = NativePointer.$MINUS;
                return BaseName;
            }
            if (JA.getType() == types.ID.TY_PP_Asm && (C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__SLASH_FA.getValue())) || C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__SLASH_Fa.getValue())))) {
                BaseName = path.filename((StringRef)new StringRef(BaseInput));
                StringRef FaValue = C.getArgs().getLastArgValue(new OptSpecifier(options.ID.OPT__SLASH_Fa.getValue()));
                char.ptr A = C.addResultFile(DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), new StringRef(FaValue), new StringRef(BaseName), JA.getType()), JA);
                return A;
            }
            if (!AtTopLevel && !this.isSaveTempsEnabled() && !C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__SLASH_Fo.getValue())) || this.CCGenDiagnostics) {
                StringRef Name = path.filename((StringRef)new StringRef(BaseInput));
                std_pair.pair Split = Name.split((byte)46);
                std.string TmpName = this.GetTemporaryPath(new StringRef((StringRef)Split.first), types.getTypeTempSuffix(JA.getType(), this.IsCLMode()));
                char.ptr ptr4 = C.addTempFile(C.getArgs().MakeArgString(new Twine(TmpName.c_str())));
                return ptr4;
            }
            SmallString BasePath = new SmallString(new StringRef(BaseInput), 128);
            StringRef BaseName2 = new StringRef();
            if (llvm.isa(DsymutilJobAction.class, (Object)JA) || llvm.isa(VerifyJobAction.class, (Object)JA)) {
                BaseName2.$assignMove(BasePath.$StringRef());
            } else {
                BaseName2.$assignMove(path.filename((StringRef)BasePath.$StringRef()));
            }
            if (JA.getType() == types.ID.TY_Object && C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__SLASH_Fo.getValue()), new OptSpecifier(options.ID.OPT__SLASH_o.getValue()))) {
                Val = new StringRef(C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Fo.getValue()), new OptSpecifier(options.ID.OPT__SLASH_o.getValue())).getValue());
                NamedOutput = Native.$tryClone((char.ptr)DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), new StringRef(Val), new StringRef(BaseName2), types.ID.TY_Object));
            } else if (JA.getType() == types.ID.TY_Image && C.getArgs().hasArg(new OptSpecifier(options.ID.OPT__SLASH_Fe.getValue()), new OptSpecifier(options.ID.OPT__SLASH_o.getValue()))) {
                Val = new StringRef(C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Fe.getValue()), new OptSpecifier(options.ID.OPT__SLASH_o.getValue())).getValue());
                NamedOutput = Native.$tryClone((char.ptr)DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), new StringRef(Val), new StringRef(BaseName2), types.ID.TY_Image));
            } else if (JA.getType() == types.ID.TY_Image) {
                if (this.IsCLMode()) {
                    NamedOutput = Native.$tryClone((char.ptr)DriverStatics.MakeCLOutputFilename((ArgList)C.getArgs(), new StringRef(NativePointer.$EMPTY), new StringRef(BaseName2), types.ID.TY_Image));
                } else if (MultipleArchs && BoundArch != null) {
                    SmallString Output = new SmallString(new StringRef(this.getDefaultImageName()), 128);
                    Output.$addassign(new StringRef(JA.getOffloadingFileNamePrefix(new StringRef(NormalizedTriple))));
                    Output.$addassign("-");
                    Output.append(new StringRef(BoundArch));
                    NamedOutput = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(new Twine(Output.c_str())));
                } else {
                    NamedOutput = Native.$tryClone((char.ptr)this.getDefaultImageName());
                }
            } else if (JA.getType() == types.ID.TY_PCH && this.IsCLMode()) {
                NamedOutput = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(new Twine(this.GetClPchPath(C, new StringRef(BaseName2)).c_str())));
            } else {
                char.ptr Suffix = Native.$tryClone((char.ptr)types.getTypeTempSuffix(JA.getType(), this.IsCLMode()));
                assert (Suffix != null) : "All types used for output should have a suffix.";
                int End = std.string.npos;
                if (!types.appendSuffixForType(JA.getType())) {
                    End = BaseName2.rfind((byte)46);
                }
                SmallString Suffixed = new SmallString(BaseName2.substr(0, End), 128);
                Suffixed.$addassign(new StringRef(JA.getOffloadingFileNamePrefix(new StringRef(NormalizedTriple))));
                if (MultipleArchs && BoundArch != null) {
                    Suffixed.$addassign("-");
                    Suffixed.append(new StringRef(BoundArch));
                }
                if (!AtTopLevel && C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_emit_llvm.getValue())) && JA.getType() == types.ID.TY_LLVM_BC) {
                    Suffixed.$addassign(".tmp");
                }
                Suffixed.$addassign((byte)46);
                Suffixed.$addassign(Suffix);
                NamedOutput = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(new Twine(Suffixed.c_str())));
            }
            if (!AtTopLevel && this.isSaveTempsObj() && C.getArgs().hasArg(new OptSpecifier(options.ID.OPT_o.getValue())) && JA.getType() != types.ID.TY_PCH) {
                Arg FinalOutput2 = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT_o.getValue()));
                SmallString TempPath = new SmallString(new StringRef(FinalOutput2.getValue()), 128);
                path.remove_filename((SmallString)TempPath);
                StringRef OutputFileName = path.filename((StringRef)new StringRef(NamedOutput));
                path.append((SmallString)TempPath, (Twine)new Twine(OutputFileName));
                NamedOutput = Native.$tryClone((char.ptr)C.getArgs().MakeArgString(new Twine(TempPath.c_str())));
            }
            if (!AtTopLevel && this.isSaveTempsEnabled() && llvm.$eq_StringRef((char.ptr)NamedOutput, (StringRef)BaseName2)) {
                bool.ref SameFile = NativePointer.create_bool$ref((boolean)false);
                SmallString Result = new SmallString(256);
                fs.current_path((SmallString)Result);
                path.append((SmallString)Result, (Twine)new Twine(BaseName2));
                fs.equivalent((Twine)new Twine(BaseInput), (Twine)new Twine(Result.c_str()), (bool.ref)SameFile);
                if (SameFile.$deref()) {
                    StringRef Name = path.filename((StringRef)new StringRef(BaseInput));
                    std_pair.pair Split = Name.split((byte)46);
                    std.string TmpName = this.GetTemporaryPath(new StringRef((StringRef)Split.first), types.getTypeTempSuffix(JA.getType(), this.IsCLMode()));
                    char.ptr ptr5 = C.addTempFile(C.getArgs().MakeArgString(new Twine(TmpName.c_str())));
                    return ptr5;
                }
            }
            if (JA.getType() == types.ID.TY_PCH && !this.IsCLMode()) {
                path.remove_filename((SmallString)BasePath);
                if (BasePath.empty()) {
                    BasePath.$assign(NamedOutput);
                } else {
                    path.append((SmallString)BasePath, (Twine)new Twine(NamedOutput));
                }
                ptr2 = C.addResultFile(C.getArgs().MakeArgString(new Twine(BasePath.c_str())), JA);
                return ptr2;
            }
            ptr2 = C.addResultFile(NamedOutput, JA);
            return ptr2;
        }
        finally {
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string GetTemporaryPath(StringRef Prefix, char.ptr Suffix) {
        SmallString Path = new SmallString(128);
        std_errors.error_code EC = fs.createTemporaryFile((Twine)new Twine(Prefix), (StringRef)new StringRef(Suffix), (SmallString)Path);
        if (EC.$bool()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(45))), (StringRef)new StringRef(EC.message())));
                std.string string2 = new std.string(NativePointer.$EMPTY);
                return string2;
            }
            finally {
                $c$.$destroy();
            }
        }
        return Path.str().$basic_string();
    }

    public std.string GetClPchPath(Compilation C, StringRef BaseName) {
        SmallString Output = new SmallString(128);
        Arg FpArg = C.getArgs().getLastArg(new OptSpecifier(options.ID.OPT__SLASH_Fp.getValue()));
        if (FpArg != null) {
            Output.$assign(FpArg.getValue());
            if (!path.has_extension((Twine)new Twine(Output))) {
                Output.$addassign(".pch");
            }
        } else {
            Output.$assign(BaseName);
            path.replace_extension((SmallString)Output, (Twine)new Twine(".pch"));
        }
        return Output.str().$basic_string();
    }

    public boolean ShouldUseClangCompiler(JobAction JA) {
        if (JA.size() != 1 || !types.isAcceptedByClang(((Action)JA.input_begin().$star()).getType())) {
            return false;
        }
        return llvm.isa(PreprocessJobAction.class, (Object)JA) || llvm.isa(PrecompileJobAction.class, (Object)JA) || llvm.isa(CompileJobAction.class, (Object)JA) || llvm.isa(BackendJobAction.class, (Object)JA);
    }

    public boolean isUsingLTO() {
        return this.LTOMode != LTOKind.LTOK_None;
    }

    public LTOKind getLTOMode() {
        return this.LTOMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLTOMode(ArgList Args) {
        this.LTOMode = LTOKind.LTOK_None;
        if (!Args.hasFlag(new OptSpecifier(options.ID.OPT_flto.getValue()), new OptSpecifier(options.ID.OPT_flto_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_lto.getValue()), false)) {
            return;
        }
        StringRef LTOName = new StringRef("full");
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_flto_EQ.getValue()));
        if (A != null) {
            LTOName.$assignMove(A.getValue());
        }
        this.LTOMode = (LTOKind)((Object)new StringSwitch(LTOName).Case("full", (Object)LTOKind.LTOK_Full).Case("thin", (Object)LTOKind.LTOK_Thin).Default((Object)LTOKind.LTOK_Unknown));
        if (this.LTOMode == LTOKind.LTOK_Unknown) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                assert (A != null);
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.Diag(366))), (StringRef)A.getOption().getName()), (char.ptr)A.getValue()));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    private ToolChain getToolChain(ArgList Args, Triple Target) {
        ToolChain TC = (ToolChain)this.ToolChains.$at(new StringRef(Target.str()));
        if (TC == null) {
            block0 : switch (Target.getOS()) {
                case Haiku: {
                    TC = new Haiku(this, Target, Args);
                    break;
                }
                case CloudABI: {
                    TC = new CloudABI(this, Target, Args);
                    break;
                }
                case Darwin: 
                case MacOSX: 
                case IOS: 
                case TvOS: 
                case WatchOS: {
                    TC = new DarwinClang(this, Target, Args);
                    break;
                }
                case DragonFly: {
                    TC = new DragonFly(this, Target, Args);
                    break;
                }
                case OpenBSD: {
                    TC = new OpenBSD(this, Target, Args);
                    break;
                }
                case Bitrig: {
                    TC = new Bitrig(this, Target, Args);
                    break;
                }
                case NetBSD: {
                    TC = new NetBSD(this, Target, Args);
                    break;
                }
                case FreeBSD: {
                    TC = new FreeBSD(this, Target, Args);
                    break;
                }
                case Minix: {
                    TC = new Minix(this, Target, Args);
                    break;
                }
                case Linux: 
                case ELFIAMCU: {
                    if (Target.getArch() == Triple.ArchType.hexagon) {
                        TC = new HexagonToolChain(this, Target, Args);
                        break;
                    }
                    if (Target.getVendor() == Triple.VendorType.MipsTechnologies && !Target.hasEnvironment()) {
                        TC = new MipsLLVMToolChain(this, Target, Args);
                        break;
                    }
                    TC = new Linux(this, Target, Args);
                    break;
                }
                case NaCl: {
                    TC = new NaClToolChain(this, Target, Args);
                    break;
                }
                case Solaris: {
                    TC = new Solaris(this, Target, Args);
                    break;
                }
                case AMDHSA: {
                    TC = new AMDGPUToolChain(this, Target, Args);
                    break;
                }
                case Win32: {
                    switch (Target.getEnvironment()) {
                        default: {
                            if (Target.isOSBinFormatELF()) {
                                TC = new Generic_ELF(this, Target, Args);
                                break block0;
                            }
                            if (Target.isOSBinFormatMachO()) {
                                TC = new MachO(this, Target, Args);
                                break block0;
                            }
                            TC = new Generic_GCC(this, Target, Args);
                            break block0;
                        }
                        case GNU: {
                            TC = new MinGW(this, Target, Args);
                            break block0;
                        }
                        case Itanium: {
                            TC = new CrossWindowsToolChain(this, Target, Args);
                            break block0;
                        }
                        case MSVC: 
                        case UnknownEnvironment: 
                    }
                    TC = new MSVCToolChain(this, Target, Args);
                    break;
                }
                case CUDA: {
                    TC = new CudaToolChain(this, Target, Args);
                    break;
                }
                case PS4: {
                    TC = new PS4CPU(this, Target, Args);
                    break;
                }
                default: {
                    switch (Target.getArch()) {
                        case tce: {
                            TC = new TCEToolChain(this, Target, Args);
                            break block0;
                        }
                        case hexagon: {
                            TC = new HexagonToolChain(this, Target, Args);
                            break block0;
                        }
                        case lanai: {
                            TC = new LanaiToolChain(this, Target, Args);
                            break block0;
                        }
                        case xcore: {
                            TC = new XCoreToolChain(this, Target, Args);
                            break block0;
                        }
                        case wasm32: 
                        case wasm64: {
                            TC = new WebAssembly(this, Target, Args);
                            break block0;
                        }
                    }
                    TC = Target.getVendor() == Triple.VendorType.Myriad ? new MyriadToolChain(this, Target, Args) : (Target.isOSBinFormatELF() ? new Generic_ELF(this, Target, Args) : (Target.isOSBinFormatMachO() ? new MachO(this, Target, Args) : new Generic_GCC(this, Target, Args)));
                }
            }
        }
        return TC;
    }

    private std_pair.pairUIntUInt getIncludeExcludeOptionFlagMasks() {
        int IncludedFlagsBitmask = 0;
        int ExcludedFlagsBitmask = 4096;
        if (this.Mode == DriverMode.CLMode) {
            IncludedFlagsBitmask |= 0x200;
            IncludedFlagsBitmask |= 0x100;
        } else {
            ExcludedFlagsBitmask |= 0x200;
        }
        return std.make_pair_uint_uint((int)IncludedFlagsBitmask, (int)ExcludedFlagsBitmask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputInfo BuildJobsForActionNoCache(Compilation C, Action A, ToolChain TC, char.ptr BoundArch, boolean AtTopLevel, boolean MultipleArchs, char.ptr LinkingOutput, std.map<std_pair.pair<Action, std.string>, InputInfo> CachedResults, boolean BuildForOffloadDevice) {
        PrettyStackTraceString CrashInfo = null;
        try {
            InputAction IA;
            CrashInfo = new PrettyStackTraceString(NativePointer.$((String)"Building compilation jobs"));
            SmallVector OffloadDependencesInputInfo = new SmallVector(4, (Object)new InputInfo());
            OffloadAction OA = (OffloadAction)llvm.dyn_cast(OffloadAction.class, (Object)A);
            if (OA != null) {
                if (OA.hasSingleDeviceDependence()) {
                    InputInfo DevA = new InputInfo();
                    OA.doOnEachDeviceDependence((DepA, DepTC, DepBoundArch) -> DevA.$assignMove(this.BuildJobsForAction(C, DepA, DepTC, DepBoundArch, AtTopLevel, DepBoundArch != null, LinkingOutput, CachedResults, true)));
                    InputInfo inputInfo = DevA;
                    return inputInfo;
                }
                OA.doOnEachDependence(BuildForOffloadDevice, (DepA, DepTC, DepBoundArch) -> OffloadDependencesInputInfo.push_back((Object)this.BuildJobsForAction(C, DepA, DepTC, DepBoundArch, false, DepBoundArch != null, LinkingOutput, CachedResults, DepA.getOffloadingDeviceKind() != 0)));
                Action action = A = BuildForOffloadDevice ? OA.getSingleDeviceDependence(true) : OA.getHostDependence();
            }
            if ((IA = (InputAction)llvm.dyn_cast(InputAction.class, (Object)A)) != null) {
                Arg Input = IA.getInputArg();
                Input.claim();
                if (Input.getOption().matches(new OptSpecifier(options.ID.OPT_INPUT.getValue()))) {
                    char.ptr Name = Native.$tryClone((char.ptr)Input.getValue());
                    InputInfo inputInfo = new InputInfo(A, Name, Name);
                    return inputInfo;
                }
                InputInfo Name = new InputInfo(A, Input, NativePointer.$EMPTY);
                return Name;
            }
            BindArchAction BAA = (BindArchAction)llvm.dyn_cast(BindArchAction.class, (Object)A);
            if (BAA != null) {
                char.ptr ArchName = Native.$tryClone((char.ptr)BAA.getArchName());
                ToolChain _TC = ArchName != null ? this.getToolChain((ArgList)C.getArgs(), DriverStatics.computeTargetTriple(this, new StringRef(this.DefaultTargetTriple), (ArgList)C.getArgs(), new StringRef(ArchName))) : C.getDefaultToolChain();
                InputInfo inputInfo = this.BuildJobsForAction(C, (Action)BAA.input_begin().$star(), _TC, ArchName, AtTopLevel, MultipleArchs, LinkingOutput, CachedResults, BuildForOffloadDevice);
                return inputInfo;
            }
            SmallVector<Action> Inputs = A.getInputs();
            JobAction JA = (JobAction)llvm.cast(JobAction.class, (Object)A);
            SmallVector CollapsedOffloadActions = new SmallVector(3, (Object)null);
            Tool T = DriverStatics.selectToolForJob(C, this.isSaveTempsEnabled(), this.embedBitcodeEnabled(), TC, JA, Inputs, (SmallVector<Action>)CollapsedOffloadActions);
            if (T == null) {
                InputInfo inputInfo = new InputInfo();
                return inputInfo;
            }
            for (Object OA2 : CollapsedOffloadActions) {
                ((OffloadAction)llvm.cast(OffloadAction.class, (Object)OA2)).doOnEachDependence(BuildForOffloadDevice, (DepA, DepTC, DepBoundArch) -> OffloadDependencesInputInfo.push_back((Object)this.BuildJobsForAction(C, DepA, DepTC, DepBoundArch, AtTopLevel, DepBoundArch != null, LinkingOutput, CachedResults, DepA.getOffloadingDeviceKind() != 0)));
            }
            SmallVector InputInfos = new SmallVector(4, (Object)new InputInfo());
            for (Action Input : Inputs) {
                boolean SubJobAtTopLevel = AtTopLevel && (llvm.isa(DsymutilJobAction.class, (Object)A) || llvm.isa(VerifyJobAction.class, (Object)A));
                InputInfos.push_back((Object)this.BuildJobsForAction(C, Input, TC, BoundArch, SubJobAtTopLevel, MultipleArchs, LinkingOutput, CachedResults, BuildForOffloadDevice));
            }
            char.ptr BaseInput = Native.$tryClone((char.ptr)((InputInfo)InputInfos.$at(0)).getBaseInput());
            if (JA.getType() == types.ID.TY_dSYM) {
                BaseInput = Native.$tryClone((char.ptr)((InputInfo)InputInfos.$at(0)).getFilename());
            }
            if (!OffloadDependencesInputInfo.empty()) {
                InputInfos.append((type.iterator)OffloadDependencesInputInfo.begin(), (type.iterator)OffloadDependencesInputInfo.end());
            }
            InputInfo Result = new InputInfo();
            if (JA.getType() == types.ID.TY_Nothing) {
                Result.$assignMove(new InputInfo(A, BaseInput));
            } else {
                Result.$assignMove(new InputInfo(A, this.GetNamedOutputPath(C, JA, BaseInput, BoundArch, AtTopLevel, MultipleArchs, new StringRef(TC.getTriple().normalize())), BaseInput));
            }
            if (this.CCCPrintBindings && !this.CCGenDiagnostics) {
                llvm.errs().$out("# \"").$out(T.getToolChain().getTripleString()).$out_char((byte)34).$out(" - \"").$out(T.getName()).$out("\", inputs: [");
                int e = InputInfos.size();
                for (int i = 0; i != e; ++i) {
                    llvm.errs().$out(((InputInfo)InputInfos.$at(i)).getAsString());
                    if (i + 1 == e) continue;
                    llvm.errs().$out(NativePointer.$COMMA_SPACE);
                }
                llvm.errs().$out("], output: ").$out(Result.getAsString()).$out(NativePointer.$LF);
            } else {
                T.ConstructJob(C, JA, Result, (SmallVector<InputInfo>)InputInfos, (ArgList)C.getArgsForToolChain(TC, BoundArch), LinkingOutput);
            }
            InputInfo inputInfo = Result;
            return inputInfo;
        }
        finally {
            if (CrashInfo != null) {
                CrashInfo.$destroy();
            }
        }
    }

    public static boolean GetReleaseVersion(char.ptr Str, uint.ref Major, uint.ref Minor, uint.ref Micro, bool.ref HadExtra) {
        HadExtra.$set(false);
        Major.$set(Minor.$set(Micro.$set(0)));
        if (Str.$star() == 0) {
            return false;
        }
        char.ptr End = NativePointer.create_char$null$ptr();
        Major.$set((int)std.strtol((char.ptr)Str, (type.ptr)End.$addr(), (int)10));
        if (Str.$star() != 0 && End.$star() == 0) {
            return true;
        }
        if (End.$star() != 46) {
            return false;
        }
        Str = Native.$tryClone((char.ptr)((char.ptr)End.$add(1)));
        Minor.$set((int)std.strtol((char.ptr)Str, (type.ptr)End.$addr(), (int)10));
        if (Str.$star() != 0 && End.$star() == 0) {
            return true;
        }
        if (End.$star() != 46) {
            return false;
        }
        Str = Native.$tryClone((char.ptr)((char.ptr)End.$add(1)));
        Micro.$set((int)std.strtol((char.ptr)Str, (type.ptr)End.$addr(), (int)10));
        if (Str.$star() != 0 && End.$star() == 0) {
            return true;
        }
        if (Native.$eq_ptr((void.ptr)Str, (void.ptr)End)) {
            return false;
        }
        HadExtra.$set(true);
        return true;
    }

    public static boolean GetReleaseVersion(char.ptr Str, MutableArrayRefUInt Digits) {
        if (Str.$star() == 0) {
            return false;
        }
        char.ptr End = NativePointer.create_char$null$ptr();
        int CurDigit = 0;
        while (Unsigned.$less_uint((int)CurDigit, (int)Digits.size())) {
            int Digit = (int)std.strtol((char.ptr)Str, (type.ptr)End.$addr(), (int)10);
            Digits.$set(CurDigit, Digit);
            if (Str.$star() != 0 && End.$star() == 0) {
                return true;
            }
            if (End.$star() != 46 || Native.$eq_ptr((void.ptr)Str, (void.ptr)End)) {
                return false;
            }
            Str = Native.$tryClone((char.ptr)((char.ptr)End.$add(1)));
            ++CurDigit;
        }
        return false;
    }

    public String toString() {
        return "Opts=" + this.Opts + ", Diags=" + this.Diags + ", VFS=" + this.VFS + ", Mode=" + (Object)((Object)this.Mode) + ", SaveTemps=" + (Object)((Object)this.SaveTemps) + ", BitcodeEmbed=" + (Object)((Object)this.BitcodeEmbed) + ", LTOMode=" + (Object)((Object)this.LTOMode) + ", Name=" + this.Name + ", Dir=" + this.Dir + ", ClangExecutable=" + this.ClangExecutable + ", InstalledDir=" + this.InstalledDir + ", ResourceDir=" + this.ResourceDir + ", PrefixDirs=" + this.PrefixDirs + ", SysRoot=" + this.SysRoot + ", DyldPrefix=" + this.DyldPrefix + ", UseStdLib=" + this.UseStdLib + ", DefaultTargetTriple=" + this.DefaultTargetTriple + ", DriverTitle=" + this.DriverTitle + ", HostBits=" + this.HostBits + ", HostMachine=" + this.HostMachine + ", HostSystem=" + this.HostSystem + ", HostRelease=" + this.HostRelease + ", CCPrintOptionsFilename=" + this.CCPrintOptionsFilename + ", CCPrintHeadersFilename=" + this.CCPrintHeadersFilename + ", CCLogDiagnosticsFilename=" + this.CCLogDiagnosticsFilename + ", CCCPrintBindings=" + this.CCCPrintBindings + ", CCPrintOptions=" + this.CCPrintOptions + ", CCPrintHeaders=" + this.CCPrintHeaders + ", CCLogDiagnostics=" + this.CCLogDiagnostics + ", CCGenDiagnostics=" + this.CCGenDiagnostics + ", CCCGenericGCCName=" + this.CCCGenericGCCName + ", CheckInputsExist=" + this.CheckInputsExist + ", CCCUsePCH=" + this.CCCUsePCH + ", SuppressMissingInputWarning=" + this.SuppressMissingInputWarning + ", TempFiles=" + this.TempFiles + ", ResultFiles=" + this.ResultFiles + ", ToolChains=" + this.ToolChains;
    }

    private static final class BitcodeEmbedMode
    extends Enum<BitcodeEmbedMode>
    implements Native.ComparableLower {
        public static final /* enum */ BitcodeEmbedMode EmbedNone = new BitcodeEmbedMode(0);
        public static final /* enum */ BitcodeEmbedMode EmbedMarker = new BitcodeEmbedMode(EmbedNone.getValue() + 1);
        public static final /* enum */ BitcodeEmbedMode EmbedBitcode = new BitcodeEmbedMode(EmbedMarker.getValue() + 1);
        private final int value;
        private static final /* synthetic */ BitcodeEmbedMode[] $VALUES;

        public static BitcodeEmbedMode[] values() {
            return (BitcodeEmbedMode[])$VALUES.clone();
        }

        public static BitcodeEmbedMode valueOf(String name) {
            return Enum.valueOf(BitcodeEmbedMode.class, name);
        }

        public static BitcodeEmbedMode valueOf(int val) {
            BitcodeEmbedMode out;
            BitcodeEmbedMode bitcodeEmbedMode = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private BitcodeEmbedMode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((BitcodeEmbedMode)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((BitcodeEmbedMode)((Object)obj)).value);
        }

        static {
            $VALUES = new BitcodeEmbedMode[]{EmbedNone, EmbedMarker, EmbedBitcode};
        }

        private static final class Values {
            private static final BitcodeEmbedMode[] VALUES;
            private static final BitcodeEmbedMode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (BitcodeEmbedMode kind : BitcodeEmbedMode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new BitcodeEmbedMode[min < 0 ? 1 - min : 0];
                VALUES = new BitcodeEmbedMode[max >= 0 ? 1 + max : 0];
                for (BitcodeEmbedMode kind : BitcodeEmbedMode.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((BitcodeEmbedMode)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((BitcodeEmbedMode)kind).value] = kind;
                }
            }
        }
    }

    private static final class SaveTempsMode
    extends Enum<SaveTempsMode>
    implements Native.ComparableLower {
        public static final /* enum */ SaveTempsMode SaveTempsNone = new SaveTempsMode(0);
        public static final /* enum */ SaveTempsMode SaveTempsCwd = new SaveTempsMode(SaveTempsNone.getValue() + 1);
        public static final /* enum */ SaveTempsMode SaveTempsObj = new SaveTempsMode(SaveTempsCwd.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SaveTempsMode[] $VALUES;

        public static SaveTempsMode[] values() {
            return (SaveTempsMode[])$VALUES.clone();
        }

        public static SaveTempsMode valueOf(String name) {
            return Enum.valueOf(SaveTempsMode.class, name);
        }

        public static SaveTempsMode valueOf(int val) {
            SaveTempsMode out;
            SaveTempsMode saveTempsMode = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SaveTempsMode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((SaveTempsMode)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((SaveTempsMode)((Object)obj)).value);
        }

        static {
            $VALUES = new SaveTempsMode[]{SaveTempsNone, SaveTempsCwd, SaveTempsObj};
        }

        private static final class Values {
            private static final SaveTempsMode[] VALUES;
            private static final SaveTempsMode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SaveTempsMode kind : SaveTempsMode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SaveTempsMode[min < 0 ? 1 - min : 0];
                VALUES = new SaveTempsMode[max >= 0 ? 1 + max : 0];
                for (SaveTempsMode kind : SaveTempsMode.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((SaveTempsMode)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((SaveTempsMode)kind).value] = kind;
                }
            }
        }
    }

    private static final class DriverMode
    extends Enum<DriverMode>
    implements Native.ComparableLower {
        public static final /* enum */ DriverMode GCCMode = new DriverMode(0);
        public static final /* enum */ DriverMode GXXMode = new DriverMode(GCCMode.getValue() + 1);
        public static final /* enum */ DriverMode CPPMode = new DriverMode(GXXMode.getValue() + 1);
        public static final /* enum */ DriverMode CLMode = new DriverMode(CPPMode.getValue() + 1);
        private final int value;
        private static final /* synthetic */ DriverMode[] $VALUES;

        public static DriverMode[] values() {
            return (DriverMode[])$VALUES.clone();
        }

        public static DriverMode valueOf(String name) {
            return Enum.valueOf(DriverMode.class, name);
        }

        public static DriverMode valueOf(int val) {
            DriverMode out;
            DriverMode driverMode = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private DriverMode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((DriverMode)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((DriverMode)((Object)obj)).value);
        }

        static {
            $VALUES = new DriverMode[]{GCCMode, GXXMode, CPPMode, CLMode};
        }

        private static final class Values {
            private static final DriverMode[] VALUES;
            private static final DriverMode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (DriverMode kind : DriverMode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new DriverMode[min < 0 ? 1 - min : 0];
                VALUES = new DriverMode[max >= 0 ? 1 + max : 0];
                for (DriverMode kind : DriverMode.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((DriverMode)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((DriverMode)kind).value] = kind;
                }
            }
        }
    }
}

