/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.SanitizerKind;
import org.clang.basic.VersionTuple;
import org.clang.driver.Driver;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.MSVCToolChainStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.DarwinStatics;
import org.clang.driver.tools.impl.VisualstudioStatics;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.Optional;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.support.llvm;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;

public class MSVCToolChain
extends ToolChain
implements Destructors.ClassWithDestructor {
    public MSVCToolChain(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
        this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
        if (std.$noteq_T_string$C((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
            this.getProgramPaths().push_back((Object)this.getDriver().Dir);
        }
    }

    @Override
    public DerivedArgList TranslateArgs(DerivedArgList Args, char.ptr BoundArch) {
        DerivedArgList DAL = new DerivedArgList(Args.getBaseArgs());
        OptTable Opts = this.getDriver().getOpts();
        boolean SupportsForcingFramePointer = this.getArch() == Triple.ArchType.x86;
        char.ptr ExpandChar = null;
        for (Arg A : Args) {
            if (!A.getOption().matches(new OptSpecifier(options.ID.OPT__SLASH_O.getValue()))) continue;
            StringRef OptStr = new StringRef(A.getValue());
            int E = OptStr.size();
            for (int I = 0; I != E; ++I) {
                int PrevChar;
                byte OptChar = OptStr.$at(I);
                int n = PrevChar = Unsigned.$greater_uint((int)I, (int)0) ? (int)OptStr.$at(I - 1) : 48;
                if (PrevChar == 98 || OptChar != 49 && OptChar != 50 && OptChar != 120 && OptChar != 100) continue;
                ExpandChar = Native.$tryClone((char.ptr)((char.ptr)OptStr.data().$add(I)));
            }
        }
        for (Arg A : Args) {
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT__SLASH_O.getValue()))) {
                MSVCToolChainStatics.TranslateOptArg(A, DAL, SupportsForcingFramePointer, ExpandChar, Opts);
                continue;
            }
            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_D.getValue()))) {
                MSVCToolChainStatics.TranslateDArg(A, DAL, Opts);
                continue;
            }
            DAL.append(A);
        }
        return DAL;
    }

    @Override
    public boolean IsIntegratedAssemblerDefault() {
        return true;
    }

    @Override
    public boolean IsUnwindTablesDefault() {
        if (this.getTriple().isOSBinFormatMachO()) {
            return false;
        }
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPICDefault() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    @Override
    public boolean isPIEDefault() {
        return false;
    }

    @Override
    public boolean isPICDefaultForced() {
        return this.getArch() == Triple.ArchType.x86_64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            std.string VSDir;
            if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdinc.getValue()))) {
                return;
            }
            if (!DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nobuiltininc.getValue()))) {
                this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, this.getDriver().ResourceDir, new Twine(NativePointer.$include));
            }
            for (std.string Path : (std.vectorString)$c$.clean($c$.track((Object)DriverArgs.getAllArgValues(new OptSpecifier(options.ID.OPT__SLASH_imsvc.getValue()))))) {
                MSVCToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(Path));
            }
            if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue()))) {
                return;
            }
            char.ptr cl_include_dir = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"INCLUDE")));
            if (cl_include_dir != null) {
                SmallVector Dirs = new SmallVector(8, (Object)new StringRef());
                new StringRef(cl_include_dir).split((SmallVectorImpl)Dirs, ";", -1, false);
                for (StringRef Dir : Dirs) {
                    MSVCToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(Dir));
                }
                if (!Dirs.empty()) {
                    return;
                }
            }
            if (this.getVisualStudioInstallDir(VSDir = new std.string())) {
                std.string windowsSDKLibVersion;
                std.string windowsSDKIncludeVersion;
                int.ref major;
                std.string WindowsSDKDir;
                std.string UCRTVersion;
                std.string UniversalCRTSdkPath;
                this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, VSDir, new Twine("VC\\include"));
                if (this.useUniversalCRT(VSDir) && this.getUniversalCRTSdkDir(UniversalCRTSdkPath = new std.string(), UCRTVersion = new std.string())) {
                    this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, UniversalCRTSdkPath, new Twine("Include"), new Twine(UCRTVersion), new Twine("ucrt"));
                }
                if (this.getWindowsSDKDir(WindowsSDKDir = new std.string(), major = NativePointer.create_int$ref(), windowsSDKIncludeVersion = new std.string(), windowsSDKLibVersion = new std.string())) {
                    if (major.$deref() >= 8) {
                        this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, new Twine(NativePointer.$include), new Twine(windowsSDKIncludeVersion), new Twine("shared"));
                        this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, new Twine(NativePointer.$include), new Twine(windowsSDKIncludeVersion), new Twine("um"));
                        this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, new Twine(NativePointer.$include), new Twine(windowsSDKIncludeVersion), new Twine("winrt"));
                    } else {
                        this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, new Twine(NativePointer.$include));
                    }
                } else {
                    MSVCToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(VSDir));
                }
                return;
            }
            Object[] Paths = new StringRef[]{new StringRef("C:/Program Files/Microsoft Visual Studio 10.0/VC/include"), new StringRef("C:/Program Files/Microsoft Visual Studio 9.0/VC/include"), new StringRef("C:/Program Files/Microsoft Visual Studio 9.0/VC/PlatformSDK/Include"), new StringRef("C:/Program Files/Microsoft Visual Studio 8/VC/include"), new StringRef("C:/Program Files/Microsoft Visual Studio 8/VC/PlatformSDK/Include")};
            MSVCToolChain.addSystemIncludes(DriverArgs, CC1Args, (ArrayRef<StringRef>)new ArrayRef(Paths));
        }
        finally {
            $c$.$destroy();
        }
    }

    @Override
    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
    }

    public boolean getWindowsSDKDir(std.string Path, int.ref Major, std.string WindowsSDKIncludeVersion, std.string WindowsSDKLibVersion) {
        std.string RegistrySDKVersion = new std.string();
        if (!MSVCToolChainStatics.getSystemRegistryString(NativePointer.$((String)"SOFTWARE\\Microsoft\\Microsoft SDKs\\Windows\\$VERSION"), NativePointer.$((String)"InstallationFolder"), Path, RegistrySDKVersion)) {
            return false;
        }
        if (Path.empty() || RegistrySDKVersion.empty()) {
            return false;
        }
        WindowsSDKIncludeVersion.clear();
        WindowsSDKLibVersion.clear();
        Major.$set(0);
        std.sscanf((char.ptr)RegistrySDKVersion.c_str(), (char.ptr)NativePointer.$((String)"v%d."), (Object[])new Object[]{Major.deref$ptr()});
        if (Major.$deref() <= 7) {
            return true;
        }
        if (Major.$deref() == 8) {
            char.ptr[] Tests;
            for (char.ptr Test : Tests = new char.ptr[]{NativePointer.$((String)"winv6.3"), NativePointer.$((String)"win8"), NativePointer.$((String)"win7")}) {
                SmallString TestPath = new SmallString(new StringRef(Path), 128);
                path.append((SmallString)TestPath, (Twine)new Twine("Lib"), (Twine)new Twine(Test));
                if (!fs.exists((Twine)new Twine(TestPath.c_str()))) continue;
                WindowsSDKLibVersion.$assign(Test);
                break;
            }
            return !WindowsSDKLibVersion.empty();
        }
        if (Major.$deref() == 10) {
            if (!MSVCToolChainStatics.getWindows10SDKVersion(Path, WindowsSDKIncludeVersion)) {
                return false;
            }
            WindowsSDKLibVersion.$assign(WindowsSDKIncludeVersion);
            return true;
        }
        return false;
    }

    public boolean getWindowsSDKLibraryPath(std.string _path) {
        SmallString libPath;
        block8: {
            std.string windowsSDKLibVersion;
            block7: {
                std.string sdkPath = new std.string();
                int.ref sdkMajor = NativePointer.create_int$ref((int)0);
                std.string windowsSDKIncludeVersion = new std.string();
                windowsSDKLibVersion = new std.string();
                _path.clear();
                if (!this.getWindowsSDKDir(sdkPath, sdkMajor, windowsSDKIncludeVersion, windowsSDKLibVersion)) {
                    return false;
                }
                libPath = new SmallString(new StringRef(sdkPath), 128);
                path.append((SmallString)libPath, (Twine)new Twine("Lib"));
                if (sdkMajor.$deref() > 7) break block7;
                switch (this.getArch()) {
                    case x86: {
                        break block8;
                    }
                    case x86_64: {
                        path.append((SmallString)libPath, (Twine)new Twine("x64"));
                        break block8;
                    }
                    case arm: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            StringRef archName = MSVCToolChainStatics.getWindowsSDKArch(this.getArch());
            if (archName.empty()) {
                return false;
            }
            path.append((SmallString)libPath, (Twine)new Twine(windowsSDKLibVersion), (Twine)new Twine("um"), (Twine)new Twine(archName));
        }
        _path.$assignMove(libPath.str().$basic_string());
        return true;
    }

    public boolean useUniversalCRT(std.string VisualStudioDir) {
        SmallString TestPath = new SmallString(new StringRef(VisualStudioDir), 128);
        path.append((SmallString)TestPath, (Twine)new Twine("VC\\include\\stdlib.h"));
        return !fs.exists((Twine)new Twine(TestPath));
    }

    public boolean getUniversalCRTSdkDir(std.string Path, std.string UCRTVersion) {
        if (!MSVCToolChainStatics.getSystemRegistryString(NativePointer.$((String)"SOFTWARE\\Microsoft\\Windows Kits\\Installed Roots"), NativePointer.$((String)"KitsRoot10"), Path, null)) {
            return false;
        }
        return MSVCToolChainStatics.getWindows10SDKVersion(Path, UCRTVersion);
    }

    public boolean getUniversalCRTLibraryPath(std.string Path) {
        std.string UniversalCRTSdkPath = new std.string();
        std.string UCRTVersion = new std.string();
        Path.clear();
        if (!this.getUniversalCRTSdkDir(UniversalCRTSdkPath, UCRTVersion)) {
            return false;
        }
        StringRef ArchName = MSVCToolChainStatics.getWindowsSDKArch(this.getArch());
        if (ArchName.empty()) {
            return false;
        }
        SmallString LibPath = new SmallString(new StringRef(UniversalCRTSdkPath), 128);
        path.append((SmallString)LibPath, (Twine)new Twine("Lib"), (Twine)new Twine(UCRTVersion), (Twine)new Twine("ucrt"), (Twine)new Twine(ArchName));
        Path.$assignMove(LibPath.str().$basic_string());
        return true;
    }

    public boolean getVisualStudioInstallDir(std.string path2) {
        char.ptr vcinstalldir = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VCINSTALLDIR")));
        if (vcinstalldir != null) {
            path2.$assign(vcinstalldir);
            path2.$assignMove(path2.substr(0, path2.find((CharSequence)"\\VC")));
            return true;
        }
        std.string vsIDEInstallDir = new std.string();
        std.string vsExpressIDEInstallDir = new std.string();
        boolean hasVCDir = MSVCToolChainStatics.getSystemRegistryString(NativePointer.$((String)"SOFTWARE\\Microsoft\\VisualStudio\\$VERSION"), NativePointer.$((String)"InstallDir"), vsIDEInstallDir, null);
        if (hasVCDir && !vsIDEInstallDir.empty()) {
            path2.$assignMove(vsIDEInstallDir.substr(0, vsIDEInstallDir.find((CharSequence)"\\Common7\\IDE")));
            return true;
        }
        boolean hasVCExpressDir = MSVCToolChainStatics.getSystemRegistryString(NativePointer.$((String)"SOFTWARE\\Microsoft\\VCExpress\\$VERSION"), NativePointer.$((String)"InstallDir"), vsExpressIDEInstallDir, null);
        if (hasVCExpressDir && !vsExpressIDEInstallDir.empty()) {
            path2.$assignMove(vsExpressIDEInstallDir.substr(0, vsIDEInstallDir.find((CharSequence)"\\Common7\\IDE")));
            return true;
        }
        char.ptr vs120comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS120COMNTOOLS")));
        char.ptr vs100comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS100COMNTOOLS")));
        char.ptr vs90comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS90COMNTOOLS")));
        char.ptr vs80comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS80COMNTOOLS")));
        char.ptr vscomntools = null;
        if (vs120comntools != null) {
            vscomntools = Native.$tryClone((char.ptr)vs120comntools);
        } else if (vs100comntools != null) {
            vscomntools = Native.$tryClone((char.ptr)vs100comntools);
        } else if (vs90comntools != null) {
            vscomntools = Native.$tryClone((char.ptr)vs90comntools);
        } else if (vs80comntools != null) {
            vscomntools = Native.$tryClone((char.ptr)vs80comntools);
        }
        if (vscomntools != null && vscomntools.$star() != 0) {
            char.ptr p = Native.$tryClone((char.ptr)std.strstr((char.ptr)vscomntools, (char.ptr)NativePointer.$((String)"\\Common7\\Tools")));
            path2.$assignMove(p != null ? new std.string((char.iterator)vscomntools, (char.iterator)p) : new std.string(vscomntools));
            return true;
        }
        return false;
    }

    public boolean getVisualStudioBinariesFolder(char.ptr clangProgramPath, std.string _path) {
        _path.clear();
        SmallString BinDir = new SmallString(128);
        Optional VcInstallDir = Process.GetEnv((StringRef)new StringRef("VCINSTALLDIR"));
        if (VcInstallDir.hasValue()) {
            BinDir.$assign(new StringRef((std.string)VcInstallDir.getValue()));
            path.append((SmallString)BinDir, (Twine)new Twine("bin"));
        } else {
            std.string installDir;
            Optional OptPath = Process.GetEnv((StringRef)new StringRef("PATH"));
            if (OptPath.hasValue()) {
                byte[] EnvPathSeparatorStr = NativePointer.new$char((int)2, (byte[])new byte[]{sys.EnvPathSeparator, 0});
                SmallVector PathSegments = new SmallVector(8, (Object)new StringRef());
                llvm.SplitString((StringRef)new StringRef((std.string)OptPath.getValue()), (SmallVectorImpl)PathSegments, (StringRef)new StringRef(EnvPathSeparatorStr));
                for (StringRef PathSegment : PathSegments) {
                    if (PathSegment.empty()) continue;
                    SmallString FilePath = new SmallString(new StringRef(PathSegment), 128);
                    path.append((SmallString)FilePath, (Twine)new Twine("cl.exe"));
                    if (!fs.exists((Twine)new Twine(FilePath.c_str())) || fs.equivalent((Twine)new Twine(FilePath.c_str()), (Twine)new Twine(clangProgramPath))) continue;
                    _path.$assignMove(PathSegment.$basic_string());
                    return true;
                }
            }
            if (!this.getVisualStudioInstallDir(installDir = new std.string())) {
                return false;
            }
            BinDir.$assign(new StringRef(installDir));
            path.append((SmallString)BinDir, (Twine)new Twine("VC"), (Twine)new Twine("bin"));
            SmallString ClPath = new SmallString(BinDir);
            path.append((SmallString)ClPath, (Twine)new Twine("cl.exe"));
            if (!fs.can_execute((Twine)new Twine(ClPath.c_str()))) {
                return false;
            }
        }
        if (BinDir.empty()) {
            return false;
        }
        switch (this.getArch()) {
            case x86: {
                break;
            }
            case x86_64: {
                path.append((SmallString)BinDir, (Twine)new Twine("amd64"));
                break;
            }
            case arm: {
                path.append((SmallString)BinDir, (Twine)new Twine("arm"));
                break;
            }
            default: {
                return false;
            }
        }
        _path.$assignMove(BinDir.str().$basic_string());
        return true;
    }

    @Override
    public VersionTuple getMSVCVersionFromExe() {
        VersionTuple Version = new VersionTuple();
        return Version;
    }

    @Override
    public std.string ComputeEffectiveClangTriple(ArgList Args, types.ID InputType) {
        std.string TripleStr = super.ComputeEffectiveClangTriple(Args, InputType);
        Triple _Triple = new Triple(new Twine(TripleStr));
        VersionTuple MSVT = VisualstudioStatics.getMSVCVersion(null, this, _Triple, Args, true);
        if (MSVT.empty()) {
            return TripleStr;
        }
        MSVT.$assignMove(new VersionTuple(MSVT.getMajor(), MSVT.getMinor().getValueOr(0), MSVT.getSubminor().getValueOr(0)));
        if (_Triple.getEnvironment() == Triple.EnvironmentType.MSVC) {
            StringRef ObjFmt = new StringRef(JavaDifferentiators.JD.Move.INSTANCE, (StringRef)_Triple.getEnvironmentName().split((byte)45).second);
            if (ObjFmt.empty()) {
                _Triple.setEnvironmentName(new StringRef(llvm.$add_Twine((Twine)new Twine("msvc"), (Twine)new Twine(MSVT.getAsString())).str()));
            } else {
                _Triple.setEnvironmentName(new StringRef(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine("msvc"), (Twine)new Twine(MSVT.getAsString())), (Twine)new Twine(JavaDifferentiators.JD$Char.INSTANCE, 45)), (Twine)new Twine(ObjFmt)).str()));
            }
        }
        return new std.string(_Triple.getTriple());
    }

    @Override
    public long getSupportedSanitizers() {
        long Res = super.getSupportedSanitizers();
        return Res |= SanitizerKind.Address;
    }

    protected void AddSystemIncludeWithSubfolder(ArgList DriverArgs, ArgStringList CC1Args, std.string folder, Twine subfolder1) {
        this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, folder, subfolder1, new Twine(NativePointer.$EMPTY), new Twine(NativePointer.$EMPTY));
    }

    protected void AddSystemIncludeWithSubfolder(ArgList DriverArgs, ArgStringList CC1Args, std.string folder, Twine subfolder1, Twine subfolder2) {
        this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, folder, subfolder1, subfolder2, new Twine(NativePointer.$EMPTY));
    }

    protected void AddSystemIncludeWithSubfolder(ArgList DriverArgs, ArgStringList CC1Args, std.string folder, Twine subfolder1, Twine subfolder2, Twine subfolder3) {
        SmallString _path = new SmallString(new StringRef(folder), 128);
        path.append((SmallString)_path, (Twine)subfolder1, (Twine)subfolder2, (Twine)subfolder3);
        MSVCToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(_path));
    }

    @Override
    protected Tool buildLinker() {
        return new VisualstudioStatics.Linker(this);
    }

    @Override
    protected Tool buildAssembler() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (this.getTriple().isOSBinFormatMachO()) {
                DarwinStatics.Assembler assembler = new DarwinStatics.Assembler(this);
                return assembler;
            }
            $c$.clean($c$.track((Object)this.getDriver().Diag(369)));
            Tool tool = null;
            return tool;
        }
        finally {
            $c$.$destroy();
        }
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

