/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.osgi.AccessQueryImpl;
import org.netbeans.modules.maven.osgi.ForeignClassBundlerImpl;
import org.netbeans.spi.project.LookupProvider;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class OSGILookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup baseContext) {
        final InstanceContent ic = new InstanceContent();
        final Project prj = (Project)baseContext.lookup(Project.class);
        assert (prj != null);
        final AccessQueryImpl access = new AccessQueryImpl(prj);
        final ForeignClassBundlerImpl bundler = new ForeignClassBundlerImpl(prj);
        final RecommendedTemplates templates = new RecommendedTemplates(){

            public String[] getRecommendedTypes() {
                return new String[]{"osgi"};
            }
        };
        NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        nbprj.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    OSGILookupProvider.this.checkContent(prj, ic, access, bundler, templates);
                }
            }
        });
        this.checkContent(prj, ic, access, bundler, templates);
        return new AbstractLookup((AbstractLookup.Content)ic);
    }

    private void checkContent(Project prj, InstanceContent ic, AccessQueryImpl access, ForeignClassBundlerImpl bundler, RecommendedTemplates templates) {
        String[] types;
        NbMavenProject nbprj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        String effPackaging = nbprj.getPackagingType();
        boolean needToCheckFelixProjectTypes = true;
        if (!nbprj.isMavenProjectLoaded()) {
            List plugins;
            Model model;
            needToCheckFelixProjectTypes = false;
            try {
                model = nbprj.getRawModel();
            }
            catch (ModelBuildingException ex) {
                model = null;
                Logger.getLogger(OSGILookupProvider.class.getName()).log(Level.FINE, null, ex);
            }
            Build build = model != null ? model.getBuild() : null;
            List list = plugins = build != null ? build.getPlugins() : null;
            if (plugins != null) {
                for (Plugin plugin : plugins) {
                    if (!"org.apache.felix".equals(plugin.getGroupId()) || !"maven-bundle-plugin".equals(plugin.getArtifactId())) continue;
                    needToCheckFelixProjectTypes = true;
                    break;
                }
            }
        }
        if (needToCheckFelixProjectTypes && (types = PluginPropertyUtils.getPluginPropertyList((Project)prj, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"supportedProjectTypes", (String)"supportedProjectType", null)) != null) {
            for (String type : types) {
                if (!effPackaging.equals(type)) continue;
                effPackaging = "bundle";
            }
        }
        if ("bundle".equals(effPackaging)) {
            ic.add((Object)access);
            ic.add((Object)bundler);
            ic.add((Object)templates);
        } else {
            ic.remove((Object)access);
            ic.remove((Object)bundler);
            ic.remove((Object)templates);
        }
    }
}

