/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.completion;

import java.awt.Color;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.lib.api.DefaultHelpItem;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.HelpResolver;
import org.netbeans.modules.web.jsf.editor.completion.JsfDocumentation;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class JsfCompletionItem {
    private static final int JSF_DEFAULT_SORT_PRIORITY = 5;
    private static final Map<String, String> COLORING_REPLACEMENTS = new HashMap<String, String>(){
        {
            this.put("<p>", "<p" + JsfCompletionItem.getColorStyleAttribute() + ">");
            this.put("<div>", "<div" + JsfCompletionItem.getColorStyleAttribute() + ">");
            this.put("<ol>", "<ol" + JsfCompletionItem.getColorStyleAttribute() + ">");
            this.put("class=[^>]*", JsfCompletionItem.getColorStyleAttribute());
        }
    };
    private static final Pattern REPLACEMENT_PATTERN = JsfCompletionItem.getPattern();

    public static JsfTag createTag(int substitutionOffset, LibraryComponent component, String declaredPrefix, boolean autoimport, boolean isJsf22Plus) {
        return new JsfTag(substitutionOffset, component, declaredPrefix, autoimport, isJsf22Plus);
    }

    public static JsfTagAttribute createAttribute(String name, int substitutionOffset, Library library, Tag tag, Attribute attr) {
        return new JsfTagAttribute(name, substitutionOffset, library, tag, attr);
    }

    private static String convertTextColors(String content) {
        Matcher matcher = REPLACEMENT_PATTERN.matcher(content);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, JsfCompletionItem.getFromReplacementMap(matcher.group()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static String getFromReplacementMap(String string) {
        String result = COLORING_REPLACEMENTS.get(string);
        return result != null ? result : JsfCompletionItem.getColorStyleAttribute();
    }

    private static Pattern getPattern() {
        StringBuilder patternString = new StringBuilder("");
        String delimiter = "";
        for (String toReplace : COLORING_REPLACEMENTS.keySet()) {
            patternString.append(delimiter).append(toReplace);
            delimiter = "|";
        }
        return Pattern.compile(patternString.toString());
    }

    private static String getColorStyleAttribute() {
        Color textColor = UIManager.getColor("Tree.textForeground");
        return " style=\"color: #" + Integer.toHexString(textColor.getRGB()).substring(2, 8) + ";\"";
    }

    private static String getLibraryHelpHeader(Library library) {
        StringBuilder sb = new StringBuilder();
        sb.append("<div><b>Library:</b> ");
        sb.append(library.getNamespace());
        if (library.getLegacyNamespace() != null) {
            sb.append(", ").append(library.getLegacyNamespace());
        }
        if (library.getDisplayName() != null) {
            sb.append(" (");
            sb.append(library.getDisplayName());
            sb.append(")</div>");
        }
        return sb.toString();
    }

    public static class JsfTagAttribute
    extends HtmlCompletionItem.Attribute {
        private Library library;
        private Tag tag;
        private Attribute attr;

        public JsfTagAttribute(String value, int offset, Library library, Tag tag, Attribute attr) {
            super(value, offset, attr.isRequired(), "");
            assert (value != null);
            this.library = library;
            this.tag = tag;
            this.attr = attr;
        }

        private String getHelpContent() {
            StringBuilder sb = new StringBuilder();
            sb.append(JsfCompletionItem.getLibraryHelpHeader(this.library));
            sb.append("<div><b>Tag:</b> ");
            sb.append(this.tag.getName());
            sb.append("</div>");
            sb.append("<h1>");
            sb.append(this.attr.getName());
            sb.append("</h1>");
            if (this.attr.isRequired()) {
                sb.append("<p>");
                sb.append(NbBundle.getMessage(JsfCompletionItem.class, (String)"MSG_RequiredAttribute"));
                sb.append("</p>");
            }
            sb.append("<p>");
            if (this.attr.getDescription() != null) {
                sb.append(this.attr.getDescription());
            } else {
                sb.append(NbBundle.getMessage(JsfCompletionItem.class, (String)"MSG_NoAttributeDescription"));
            }
            sb.append("</p>");
            return JsfCompletionItem.convertTextColors(sb.toString());
        }

        public boolean hasHelp() {
            return this.attr.getDescription() != null;
        }

        public HelpItem getHelpItem() {
            return new DefaultHelpItem(null, (HelpResolver)JsfDocumentation.getDefault(), null, this.getHelpContent());
        }
    }

    public static class JsfTag
    extends HtmlCompletionItem.Tag {
        private static final String BOLD_OPEN_TAG = "<b>";
        private static final String BOLD_END_TAG = "</b>";
        private static final String AND_HTML_ENTITY = "&amp;";
        private static final String AND_HTML = "&";
        private LibraryComponent component;
        private boolean autoimport;
        private boolean isJsf22Plus;

        public JsfTag(int substitutionOffset, LibraryComponent component, String declaredPrefix, boolean autoimport, boolean isJsf22Plus) {
            super(JsfTag.generateItemText(component, declaredPrefix), substitutionOffset, null, true);
            this.component = component;
            this.autoimport = autoimport;
            this.isJsf22Plus = isJsf22Plus;
        }

        private static String generateItemText(LibraryComponent component, String declaredPrefix) {
            String libraryPrefix = component.getLibrary().getDefaultPrefix();
            return (declaredPrefix != null ? declaredPrefix : libraryPrefix) + ":" + component.getName();
        }

        protected String getRightHtmlText() {
            return this.component.getLibrary().getDisplayName();
        }

        public void defaultAction(JTextComponent component) {
            super.defaultAction(component);
            if (this.autoimport) {
                this.autoimportLibrary(component);
            }
        }

        private void autoimportLibrary(JTextComponent component) {
            BaseDocument doc = (BaseDocument)component.getDocument();
            Library lib = this.component.getLibrary();
            LibraryUtils.importLibrary((Document)doc, (Library)lib, null, (boolean)this.isJsf22Plus);
        }

        protected String getLeftHtmlText() {
            StringBuilder buff = new StringBuilder();
            buff.append(BOLD_OPEN_TAG);
            buff.append(super.getLeftHtmlText());
            buff.append(BOLD_END_TAG);
            return buff.toString();
        }

        public int getSortPriority() {
            return 5;
        }

        private String getHelpContent() {
            Tag tag;
            FileObject fo;
            AbstractFaceletsLibrary lib;
            URL url;
            StringBuilder sb = new StringBuilder();
            sb.append(JsfCompletionItem.getLibraryHelpHeader(this.component.getLibrary()));
            sb.append("<h1>");
            sb.append(this.component.getName());
            sb.append("</h1>");
            if (Boolean.getBoolean("show-facelets-libraries-locations") && this.component.getLibrary() instanceof AbstractFaceletsLibrary && (url = (lib = (AbstractFaceletsLibrary)this.component.getLibrary()).getLibraryDescriptorSource()) != null && (fo = URLMapper.findFileObject((URL)url)) != null) {
                sb.append("<div style=\"font-size: smaller; color: gray;\">");
                sb.append("Source: ");
                sb.append(FileUtil.getFileDisplayName((FileObject)fo));
                sb.append("</div>");
            }
            if ((tag = this.component.getTag()) != null) {
                sb.append("<div>");
                String[][] descr = tag.getDescription();
                if (descr == null) {
                    sb.append(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_NO_TLD_ITEM_DESCR"));
                } else {
                    sb.append((String)descr);
                }
                sb.append("</div>");
            } else {
                sb.append("<table border=\"1\">");
                for (String[] descr : this.component.getDescription()) {
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append("<div style=\"font-weight: bold\">");
                    sb.append(descr[0]);
                    sb.append("</div>");
                    sb.append("</td>");
                    sb.append("<td>");
                    sb.append(descr[1]);
                    sb.append("</td>");
                    sb.append("</tr>");
                }
                sb.append("</table>");
            }
            if (sb.indexOf(AND_HTML_ENTITY) >= 0) {
                Pattern pattern = Pattern.compile(AND_HTML_ENTITY);
                Matcher matcher = pattern.matcher(sb);
                while (matcher.find()) {
                    sb.replace(matcher.start(), matcher.end(), AND_HTML);
                    matcher.reset();
                }
            }
            return JsfCompletionItem.convertTextColors(sb.toString());
        }

        public boolean hasHelp() {
            return true;
        }

        public HelpItem getHelpItem() {
            return new DefaultHelpItem(null, (HelpResolver)JsfDocumentation.getDefault(), null, this.getHelpContent());
        }
    }
}

