/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JFileChooser;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectChooserAccessory;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class OpenProject
extends BasicAction {
    private static final String DISPLAY_NAME = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Name");
    private static final String _SHORT_DESCRIPTION = NbBundle.getMessage(OpenProject.class, (String)"LBL_OpenProjectAction_Tooltip");
    private static final RequestProcessor RP = new RequestProcessor(OpenProject.class);

    public OpenProject() {
        super(DISPLAY_NAME, null);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/openProject.png");
        this.putValue("ShortDescription", _SHORT_DESCRIPTION);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JFileChooser chooser = ProjectChooserAccessory.createProjectChooser(true);
        chooser.setMultiSelectionEnabled(true);
        for (DataObject d : Utilities.actionsGlobalContext().lookupAll(DataObject.class)) {
            File dir;
            Project selected = FileOwnerQuery.getOwner((FileObject)d.getPrimaryFile());
            if (selected == null || OpenProjectList.getDefault().isOpen(selected) || (dir = FileUtil.toFile((FileObject)selected.getProjectDirectory())) == null) continue;
            chooser.setCurrentDirectory(dir.getParentFile());
            chooser.setSelectedFiles(new File[]{dir});
            break;
        }
        OpenProject.show(chooser);
    }

    private static void show(final JFileChooser chooser) {
        File[] projectDirs;
        if (Boolean.getBoolean("nb.native.filechooser") && Utilities.isMac()) {
            String oldFileDialogProp = System.getProperty("apple.awt.fileDialogForDirectories");
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            FileDialog fileDialog = new FileDialog(WindowManager.getDefault().getMainWindow(), DISPLAY_NAME);
            fileDialog.setMode(0);
            fileDialog.setTitle(chooser.getDialogTitle());
            fileDialog.setVisible(true);
            if (null != oldFileDialogProp) {
                System.setProperty("apple.awt.fileDialogForDirectories", oldFileDialogProp);
            } else {
                System.clearProperty("apple.awt.fileDialogForDirectories");
            }
            if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
                String selFile = fileDialog.getFile();
                File dir = new File(fileDialog.getDirectory());
                projectDirs = new File[]{new File(dir, selFile)};
            } else {
                projectDirs = null;
            }
        } else {
            int option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
            projectDirs = option == 0 ? (chooser.isMultiSelectionEnabled() ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()}) : null;
        }
        if (projectDirs != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Project> projects = new ArrayList<Project>(projectDirs.length);
                    for (File d : projectDirs) {
                        Project p = OpenProjectList.fileToProject(FileUtil.normalizeFile((File)d));
                        if (p == null) continue;
                        projects.add(p);
                    }
                    if (projects.isEmpty()) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(OpenProject.class, (String)"MSG_notProjectDir"), 2));
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OpenProject.show(chooser);
                            }
                        });
                    } else {
                        Project[] projectsArray = new Project[projects.size()];
                        projects.toArray(projectsArray);
                        OpenProjectListSettings opls = OpenProjectListSettings.getInstance();
                        OpenProjectList.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if (evt.getPropertyName().equals("OpenProjects")) {
                                    Project projectToExpand;
                                    ArrayList<Project> oldProjectList = new ArrayList<Project>(Arrays.asList((Project[])evt.getOldValue()));
                                    ArrayList<Project> newProjectList = new ArrayList<Project>(Arrays.asList((Project[])evt.getNewValue()));
                                    newProjectList.removeAll(oldProjectList);
                                    Project project = projectToExpand = newProjectList.size() > 0 ? (Project)newProjectList.get(0) : null;
                                    if (projectToExpand != null) {
                                        ProjectTab.RP.post(new Runnable(){

                                            @Override
                                            public void run() {
                                                ProjectUtilities.selectAndExpandProject(projectToExpand);
                                            }
                                        });
                                    }
                                }
                            }
                        });
                        OpenProjectList.getDefault().open(projectsArray, opls.isOpenSubprojects(), true, null);
                        opls.setLastOpenProjectDir(chooser.getCurrentDirectory().getPath());
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProjectUtilities.makeProjectTabVisible();
                            }
                        });
                    }
                }
            });
        }
    }
}

