/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AddressingModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing10WsdlQName;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing10WsdlUsingAddressing;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing13WsdlAddressing;
import org.netbeans.modules.websvc.wsitmodelext.policy.All;
import org.netbeans.modules.websvc.wsitmodelext.policy.ExactlyOne;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyReference;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;

public class PolicyModelHelper {
    private static final String POLICY = "Policy";
    private static final Logger logger = Logger.getLogger(PolicyModelHelper.class.getName());
    private static HashMap<ConfigVersion, PolicyModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private PolicyModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final PolicyModelHelper getInstance(ConfigVersion configVersion) {
        PolicyModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new PolicyModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    public static ConfigVersion getConfigVersion(WSDLComponent c) {
        ConfigVersion cfg = PolicyModelHelper.getWrittenConfigVersion(c);
        return cfg == null ? ConfigVersion.getDefault() : cfg;
    }

    public static ConfigVersion getWrittenConfigVersion(WSDLComponent c) {
        Policy p = PolicyModelHelper.getPolicyForElement(c);
        if (p != null) {
            return PolicyQName.getConfigVersion((QName)p.getQName());
        }
        return null;
    }

    public static void setConfigVersion(Binding b, ConfigVersion cfgVersion, Project project) {
        ConfigVersion currentCfgVersion = PolicyModelHelper.getWrittenConfigVersion((WSDLComponent)b);
        if (!cfgVersion.equals((Object)currentCfgVersion)) {
            WSITModelSupport.moveCurrentConfig(b, currentCfgVersion, cfgVersion, project);
        }
    }

    All createTopExactlyOneAll(Policy p) {
        ExactlyOne eo = (ExactlyOne)this.createElement((WSDLComponent)p, PolicyQName.EXACTLYONE.getQName(this.configVersion), ExactlyOne.class, false);
        All all = (All)this.createElement((WSDLComponent)eo, PolicyQName.ALL.getQName(this.configVersion), All.class, false);
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    All createPolicy(WSDLComponent c, boolean addressing) {
        WSDLModel model = c.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        Definitions d = model.getDefinitions();
        String policyName = null;
        String msgName = null;
        Policy policy = null;
        policy = PolicyModelHelper.getPolicyForElement(c);
        if (policy == null) {
            policyName = PolicyModelHelper.getPolicyUriForElement(c);
            if (policyName == null) {
                Binding b;
                if (c instanceof Binding) {
                    policyName = ((Binding)c).getName() + POLICY;
                }
                if (c instanceof BindingInput) {
                    msgName = ((BindingInput)c).getName();
                    if (msgName == null) {
                        msgName = ((BindingOperation)c.getParent()).getName() + "_Input";
                    }
                    b = (Binding)((WSDLComponent)c.getParent()).getParent();
                    policyName = b.getName() + "_".concat(msgName).concat("_").concat(POLICY);
                }
                if (c instanceof BindingOutput) {
                    msgName = ((BindingOutput)c).getName();
                    if (msgName == null) {
                        msgName = ((BindingOperation)c.getParent()).getName() + "_Output";
                    }
                    b = (Binding)((WSDLComponent)c.getParent()).getParent();
                    policyName = b.getName() + "_".concat(msgName).concat("_").concat(POLICY);
                }
                if (c instanceof BindingFault) {
                    msgName = ((BindingFault)c).getName();
                    if (msgName == null) {
                        msgName = ((BindingOperation)c.getParent()).getName() + "_Fault";
                    }
                    b = (Binding)((WSDLComponent)c.getParent()).getParent();
                    policyName = b.getName() + "_".concat(msgName).concat("_").concat(POLICY);
                }
                if (c instanceof BindingOperation) {
                    msgName = ((BindingOperation)c).getName();
                    if (msgName == null) {
                        msgName = ((BindingOperation)c.getParent()).getName();
                    }
                    b = (Binding)c.getParent();
                    policyName = b.getName() + "_".concat(msgName).concat("_").concat(POLICY);
                }
            }
            List policies = d.getExtensibilityElements(Policy.class);
            boolean isTransaction = model.isIntransaction();
            try {
                if (!isTransaction) {
                    model.startTransaction();
                }
                for (Policy p : policies) {
                    if (!policyName.equals(p.getID())) continue;
                    List policyRefs = c.getExtensibilityElements(PolicyReference.class);
                    PolicyReference policyRef = policyRefs == null || policyRefs.isEmpty() ? (PolicyReference)wcf.create(c, PolicyQName.POLICYREFERENCE.getQName(this.configVersion)) : (PolicyReference)policyRefs.get(0);
                    policyRef.setPolicyURI("#".concat(policyName));
                    c.addExtensibilityElement((ExtensibilityElement)policyRef);
                    All all = this.createTopExactlyOneAll(p);
                    if (c instanceof Binding && addressing) {
                        this.createElement((WSDLComponent)all, Addressing10WsdlQName.USINGADDRESSING.getQName(), Addressing10WsdlUsingAddressing.class, false);
                    }
                    All all2 = all;
                    return all2;
                }
                policy = (Policy)wcf.create((WSDLComponent)d, PolicyQName.POLICY.getQName(this.configVersion));
                policy.setID(policyName);
                PolicyReference policyRef = null;
                policyRef = (PolicyReference)wcf.create(c, PolicyQName.POLICYREFERENCE.getQName(this.configVersion));
                policyRef.setPolicyURI("#".concat(policyName));
                c.addExtensibilityElement((ExtensibilityElement)policyRef);
                d.addExtensibilityElement((ExtensibilityElement)policy);
            }
            finally {
                if (!isTransaction) {
                    model.endTransaction();
                }
            }
        }
        All all = this.createTopExactlyOneAll(policy);
        if (c instanceof Binding && addressing) {
            AddressingModelHelper.getInstance(this.configVersion).enableAddressing((WSDLComponent)all, false);
        }
        return all;
    }

    public static <T extends ExtensibilityElement> T getTopLevelElement(WSDLComponent c, Class elementClass, boolean underPolicy) {
        ExtensibilityElement e = null;
        if (c == null) {
            return null;
        }
        if (c instanceof Policy) {
            ExactlyOne eo = ((Policy)c).getExactlyOne();
            if (eo != null) {
                All all = eo.getAll();
                e = (ExtensibilityElement)PolicyModelHelper.getTopLevelElement((WSDLComponent)all, elementClass, false);
            } else {
                List l = c.getExtensibilityElements(elementClass);
                if (l != null && !l.isEmpty()) {
                    e = (ExtensibilityElement)l.get(0);
                }
            }
        } else {
            List l;
            if (underPolicy) {
                Policy p = (Policy)PolicyModelHelper.getTopLevelElement(c, Policy.class, false);
                if (p != null) {
                    c = p;
                } else {
                    return null;
                }
            }
            if ((l = c.getExtensibilityElements(elementClass)) != null && !l.isEmpty()) {
                e = (ExtensibilityElement)l.get(0);
            }
        }
        return (T)e;
    }

    public static String getPolicyUriForElement(WSDLComponent c) {
        List extPRefElems = c.getExtensibilityElements(PolicyReference.class);
        if (extPRefElems != null && !extPRefElems.isEmpty()) {
            PolicyReference pref = (PolicyReference)extPRefElems.get(0);
            String policyURI = pref.getPolicyURI();
            return policyURI;
        }
        return null;
    }

    private static Policy getPolicyForPolicyUri(String policyURI, Definitions d) {
        if (policyURI != null && policyURI.startsWith("#")) {
            policyURI = policyURI.substring(1);
        }
        List extPElems = d.getExtensibilityElements(Policy.class);
        for (Policy p : extPElems) {
            String id = p.getID();
            if (!policyURI.equals(id)) continue;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachPolicyToElement(String policyURI, WSDLComponent c) {
        if (c == null) {
            return;
        }
        WSDLModel model = c.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        WSDLComponentFactory wcf = model.getFactory();
        try {
            List policyRefs = c.getExtensibilityElements(PolicyReference.class);
            PolicyReference ref = null;
            if (policyRefs != null && !policyRefs.isEmpty()) {
                ref = (PolicyReference)policyRefs.get(0);
                ((WSDLComponent)ref.getParent()).removeExtensibilityElement((ExtensibilityElement)ref);
            }
            if (policyURI != null) {
                ref = (PolicyReference)wcf.create(c, PolicyQName.POLICYREFERENCE.getQName(this.configVersion));
                ref.setPolicyURI(policyURI);
                c.addExtensibilityElement((ExtensibilityElement)ref);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    static Policy getPolicyForElement(WSDLComponent c) {
        if (c == null) {
            return null;
        }
        WSDLModel model = c.getModel();
        if (model != null) {
            String policyUri = PolicyModelHelper.getPolicyUriForElement(c);
            Definitions d = model.getDefinitions();
            if (d != null && policyUri != null) {
                Policy p = PolicyModelHelper.getPolicyForPolicyUri(policyUri, d);
                return p;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removePolicyForElement(WSDLComponent c) {
        assert (c != null);
        WSDLModel model = c.getModel();
        if (model != null) {
            String policyUri = PolicyModelHelper.getPolicyUriForElement(c);
            Definitions d = model.getDefinitions();
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            try {
                if (d != null && policyUri != null) {
                    List extPRefElems;
                    Policy p = PolicyModelHelper.getPolicyForPolicyUri(policyUri, d);
                    if (p != null) {
                        ((WSDLComponent)p.getParent()).removeExtensibilityElement((ExtensibilityElement)p);
                    }
                    if ((extPRefElems = c.getExtensibilityElements(PolicyReference.class)) != null && !extPRefElems.isEmpty()) {
                        PolicyReference pref = (PolicyReference)extPRefElems.get(0);
                        ((WSDLComponent)pref.getParent()).removeExtensibilityElement((ExtensibilityElement)pref);
                    }
                }
            }
            finally {
                if (!isTransaction) {
                    model.endTransaction();
                }
            }
        }
    }

    public static Binding getBinding(WSDLModel model, String bindingName) {
        Binding b = (Binding)model.findComponentByName(bindingName, Binding.class);
        if (b == null) {
            Collection imports = model.getDefinitions().getImports();
            for (Import i : imports) {
                try {
                    WSDLModel importedModel = i.getImportedWSDLModel();
                    return PolicyModelHelper.getBinding(importedModel, bindingName);
                }
                catch (CatalogModelException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends WSDLComponent> T createElement(WSDLComponent c, QName qname, Class cl, boolean withPolicy) {
        if (c == null) {
            return null;
        }
        WSDLModel model = c.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            if (withPolicy) {
                c = this.createElement((WSDLComponent)c, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            }
            List ts = c.getExtensibilityElements(cl);
            WSDLComponent t = null;
            if (ts == null || ts.isEmpty()) {
                t = wcf.create(c, qname);
                c.addExtensibilityElement((ExtensibilityElement)t);
            } else {
                t = (WSDLComponent)ts.get(0);
            }
            WSDLComponent wSDLComponent = t;
            return (T)wSDLComponent;
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeElement(WSDLComponent c, Class cl, boolean underPolicy) {
        if (c == null) {
            return;
        }
        WSDLModel model = c.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            List l;
            List policies;
            if (underPolicy && (policies = c.getExtensibilityElements(Policy.class)) != null && !policies.isEmpty()) {
                c = (WSDLComponent)policies.get(0);
            }
            if ((l = c.getExtensibilityElements(cl)) != null && !l.isEmpty()) {
                ExtensibilityElement tok = (ExtensibilityElement)l.get(0);
                ((WSDLComponent)tok.getParent()).removeExtensibilityElement(tok);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    static void removeElement(WSDLComponent c) {
        if (c == null) {
            return;
        }
        WSDLModel model = c.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            ((WSDLComponent)c.getParent()).removeExtensibilityElement((ExtensibilityElement)c);
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    static void cleanPolicies(WSDLComponent c) {
        Policy p = PolicyModelHelper.getPolicyForElement(c);
        if (p != null && PolicyModelHelper.isEmpty((WSDLComponent)p)) {
            PolicyModelHelper.removePolicyForElement(c);
        }
    }

    static boolean isEmpty(WSDLComponent comp) {
        List children = comp.getChildren();
        for (WSDLComponent c : children) {
            if (c instanceof Policy || c instanceof All || c instanceof ExactlyOne) {
                return PolicyModelHelper.isEmpty(c);
            }
            if (c instanceof Addressing10WsdlUsingAddressing || c instanceof Addressing13WsdlAddressing) continue;
            return false;
        }
        return true;
    }
}

