/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.option;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class Option {
    protected final OptTable.Info Info;
    protected final OptTable Owner;

    public Option(OptTable.Info info, OptTable owner) {
        this.Info = info;
        this.Owner = owner;
        assert (this.Info == null || !this.getAlias().isValid() || !this.getAlias().getAlias().isValid()) : "Multi-level aliases are not supported.";
        if (this.Info != null && this.getAliasArgs() != null) {
            assert (this.getAlias().isValid()) : "Only alias options can have alias args.";
            assert (this.getKind() == 3) : "Only Flag aliases can have alias args.";
            assert (this.getAlias().getKind() != 3) : "Cannot provide alias args to a flag option.";
        }
    }

    public boolean isValid() {
        return this.Info != null;
    }

    public int getID() {
        assert (this.Info != null) : "Must have a valid info!";
        return this.Info.ID;
    }

    public byte getKind() {
        assert (this.Info != null) : "Must have a valid info!";
        return this.Info.Kind;
    }

    public StringRef getName() {
        assert (this.Info != null) : "Must have a valid info!";
        return new StringRef(this.Info.Name);
    }

    public Option getGroup() {
        assert (this.Info != null) : "Must have a valid info!";
        assert (this.Owner != null) : "Must have a valid owner!";
        return this.Owner.getOption(new OptSpecifier(Unsigned.$ushort2uint((char)this.Info.GroupID)));
    }

    public Option getAlias() {
        assert (this.Info != null) : "Must have a valid info!";
        assert (this.Owner != null) : "Must have a valid owner!";
        return this.Owner.getOption(new OptSpecifier(Unsigned.$ushort2uint((char)this.Info.AliasID)));
    }

    public char.ptr getAliasArgs() {
        assert (this.Info != null) : "Must have a valid info!";
        assert (this.Info.AliasArgs == null || this.Info.AliasArgs.$at(0) != 0) : "AliasArgs should be either 0 or non-empty.";
        return this.Info.AliasArgs;
    }

    public StringRef getPrefix() {
        char.ptr Prefix = Native.$tryClone((char.ptr)((char.ptr)this.Info.Prefixes.$star()));
        return Prefix != null ? new StringRef(Prefix) : new StringRef();
    }

    public std.string getPrefixedName() {
        std.string Ret = this.getPrefix().$basic_string();
        llvm.$addassign_str_StringRef((std.string)Ret, (StringRef)this.getName());
        return Ret;
    }

    public int getNumArgs() {
        return Unsigned.$uchar2uint((byte)this.Info.Param);
    }

    public boolean hasNoOptAsInput() {
        return (Unsigned.$ushort2int((char)this.Info.Flags) & 2) != 0;
    }

    public RenderStyleKind getRenderStyle() {
        if ((Unsigned.$ushort2int((char)this.Info.Flags) & 4) != 0) {
            return RenderStyleKind.RenderJoinedStyle;
        }
        if ((Unsigned.$ushort2int((char)this.Info.Flags) & 8) != 0) {
            return RenderStyleKind.RenderSeparateStyle;
        }
        switch (this.getKind()) {
            case 0: 
            case 1: 
            case 2: {
                return RenderStyleKind.RenderValuesStyle;
            }
            case 4: 
            case 11: {
                return RenderStyleKind.RenderJoinedStyle;
            }
            case 8: {
                return RenderStyleKind.RenderCommaJoinedStyle;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return RenderStyleKind.RenderSeparateStyle;
            }
        }
        throw new llvm_unreachable("Unexpected kind!");
    }

    public boolean hasFlag(int Val) {
        return (Unsigned.$ushort2uint((char)this.Info.Flags) & Val) != 0;
    }

    public Option getUnaliasedOption() {
        Option Alias = this.getAlias();
        if (Alias.isValid()) {
            return Alias.getUnaliasedOption();
        }
        return this;
    }

    public StringRef getRenderName() {
        return this.getUnaliasedOption().getName();
    }

    public boolean matches(OptSpecifier Opt) {
        Option Alias = this.getAlias();
        if (Alias.isValid()) {
            return Alias.matches(Opt);
        }
        if (this.getID() == Opt.getID()) {
            return true;
        }
        Option Group = this.getGroup();
        if (Group.isValid()) {
            return Group.matches(Opt);
        }
        return false;
    }

    public Arg accept(ArgList Args, uint.ref Index, int ArgSize) {
        Option UnaliasedOption = this.getUnaliasedOption();
        StringRef Spelling = new StringRef();
        if (this.getID() == UnaliasedOption.getID()) {
            Spelling.$assignMove(new StringRef(Args.getArgString(Index.$deref()), ArgSize));
        } else {
            Spelling.$assignMove(Args.MakeArgString(llvm.$add_Twine((Twine)new Twine(UnaliasedOption.getPrefix()), (Twine)new Twine(UnaliasedOption.getName()))));
        }
        switch (this.getKind()) {
            case 3: {
                if (ArgSize != std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                    return null;
                }
                Arg A = new Arg(UnaliasedOption, Spelling, Index.$set$postInc());
                if (this.getAliasArgs() != null) {
                    char.ptr Val = Native.$tryClone((char.ptr)this.getAliasArgs());
                    while (Val.$star() != 0) {
                        A.getValues().push_back((Object)Val);
                        Val.$inc(std.strlen((char.ptr)Val) + 1);
                    }
                }
                if (UnaliasedOption.getKind() == 4 && this.getAliasArgs() == null) {
                    A.getValues().push_back((Object)NativePointer.$EMPTY);
                }
                return A;
            }
            case 4: {
                char.ptr Value = Native.$tryClone((char.ptr)((char.ptr)Args.getArgString(Index.$deref()).$add(ArgSize)));
                return new Arg(UnaliasedOption, Spelling, Index.$set$postInc(), Value);
            }
            case 8: {
                char.ptr Str = Native.$tryClone((char.ptr)((char.ptr)Args.getArgString(Index.$deref()).$add(ArgSize)));
                Arg A = new Arg(UnaliasedOption, Spelling, Index.$set$postInc());
                char.ptr Prev = Native.$tryClone((char.ptr)Str);
                while (true) {
                    byte c;
                    if ((c = Str.$star()) == 0 || c == 44) {
                        if (Native.$noteq_ptr((void.ptr)Prev, (void.ptr)Str)) {
                            char.ptr Value = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)(Str.$sub((abstract_iterator)Prev) + 1), (byte[])new byte[0]));
                            std.memcpy((char.ptr)Value, (char.ptr)Prev, (int)Str.$sub((abstract_iterator)Prev));
                            Value.$set(Str.$sub((abstract_iterator)Prev), (byte)0);
                            A.getValues().push_back((Object)Value);
                        }
                        if (c == 0) break;
                        Prev = Native.$tryClone((char.ptr)((char.ptr)Str.$add(1)));
                    }
                    Str.$preInc();
                }
                A.setOwnsValues(true);
                return A;
            }
            case 5: {
                if (ArgSize != std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                    return null;
                }
                Index.$set$addassign(2);
                if (Unsigned.$greater_uint((int)Index.$deref(), (int)Args.getNumInputArgStrings()) || Native.$eq_ptr((void.ptr)Args.getArgString(Index.$deref() - 1), null)) {
                    return null;
                }
                return new Arg(UnaliasedOption, Spelling, Index.$deref() - 2, Args.getArgString(Index.$deref() - 1));
            }
            case 9: {
                if (ArgSize != std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                    return null;
                }
                Index.$set$addassign(1 + this.getNumArgs());
                if (Unsigned.$greater_uint((int)Index.$deref(), (int)Args.getNumInputArgStrings())) {
                    return null;
                }
                Arg A = new Arg(UnaliasedOption, Spelling, Index.$deref() - 1 - this.getNumArgs(), Args.getArgString(Index.$deref() - this.getNumArgs()));
                for (int i = 1; i != this.getNumArgs(); ++i) {
                    A.getValues().push_back((Object)Args.getArgString(Index.$deref() - this.getNumArgs() + i));
                }
                return A;
            }
            case 10: {
                if (ArgSize != std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                    char.ptr Value = Native.$tryClone((char.ptr)((char.ptr)Args.getArgString(Index.$deref()).$add(ArgSize)));
                    return new Arg(this, Spelling, Index.$set$postInc(), Value);
                }
                Index.$set$addassign(2);
                if (Unsigned.$greater_uint((int)Index.$deref(), (int)Args.getNumInputArgStrings()) || Native.$eq_ptr((void.ptr)Args.getArgString(Index.$deref() - 1), null)) {
                    return null;
                }
                return new Arg(UnaliasedOption, Spelling, Index.$deref() - 2, Args.getArgString(Index.$deref() - 1));
            }
            case 11: {
                Index.$set$addassign(2);
                if (Unsigned.$greater_uint((int)Index.$deref(), (int)Args.getNumInputArgStrings()) || Native.$eq_ptr((void.ptr)Args.getArgString(Index.$deref() - 1), null)) {
                    return null;
                }
                return new Arg(UnaliasedOption, Spelling, Index.$deref() - 2, (char.ptr)Args.getArgString(Index.$deref() - 2).$add(ArgSize), Args.getArgString(Index.$deref() - 1));
            }
            case 6: {
                if (ArgSize != std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                    return null;
                }
                Arg A = new Arg(UnaliasedOption, Spelling, Index.$set$postInc());
                while (Unsigned.$less_uint((int)Index.$deref(), (int)Args.getNumInputArgStrings()) && Native.$noteq_ptr((void.ptr)Args.getArgString(Index.$deref()), null)) {
                    A.getValues().push_back((Object)Args.getArgString(Index.$set$postInc()));
                }
                return A;
            }
            case 7: {
                Arg A = new Arg(UnaliasedOption, Spelling, Index.$deref());
                if (ArgSize != std.strlen((char.ptr)Args.getArgString(Index.$deref()))) {
                    A.getValues().push_back((Object)Args.getArgString(Index.$deref()).$add(ArgSize));
                }
                Index.$set$postInc();
                while (Unsigned.$less_uint((int)Index.$deref(), (int)Args.getNumInputArgStrings()) && Native.$noteq_ptr((void.ptr)Args.getArgString(Index.$deref()), null)) {
                    A.getValues().push_back((Object)Args.getArgString(Index.$set$postInc()));
                }
                return A;
            }
        }
        throw new llvm_unreachable("Invalid option kind!");
    }

    public void print(raw_ostream O) {
        Option Alias;
        O.$out(NativePointer.$LT);
        switch (this.getKind()) {
            case 0: {
                O.$out("GroupClass");
                break;
            }
            case 1: {
                O.$out("InputClass");
                break;
            }
            case 2: {
                O.$out("UnknownClass");
                break;
            }
            case 3: {
                O.$out("FlagClass");
                break;
            }
            case 4: {
                O.$out("JoinedClass");
                break;
            }
            case 5: {
                O.$out("SeparateClass");
                break;
            }
            case 8: {
                O.$out("CommaJoinedClass");
                break;
            }
            case 9: {
                O.$out("MultiArgClass");
                break;
            }
            case 10: {
                O.$out("JoinedOrSeparateClass");
                break;
            }
            case 11: {
                O.$out("JoinedAndSeparateClass");
                break;
            }
            case 6: {
                O.$out("RemainingArgsClass");
                break;
            }
            case 7: {
                O.$out("RemainingArgsJoinedClass");
            }
        }
        if (this.Info.Prefixes != null) {
            O.$out(" Prefixes:[");
            type.ptr Pre = (type.ptr)Native.$tryClone(this.Info.Prefixes);
            while (Native.$noteq_ptr((void.ptr)((void.ptr)Pre.$star()), null)) {
                O.$out_char((byte)34).$out((char.ptr)Pre.$star()).$out(Native.$eq_ptr((void.ptr)((void.ptr)((type.ptr)Pre.$add(1)).$star()), (void.ptr)((char.ptr)null)) ? NativePointer.$DBL_QUOTE : NativePointer.$((String)"\", "));
                Pre.$preInc();
            }
            O.$out_char((byte)93);
        }
        O.$out(" Name:\"").$out(this.getName()).$out_char((byte)34);
        Option Group = this.getGroup();
        if (Group.isValid()) {
            O.$out(" Group:");
            Group.print(O);
        }
        if ((Alias = this.getAlias()).isValid()) {
            O.$out(" Alias:");
            Alias.print(O);
        }
        if (this.getKind() == 9) {
            O.$out(" NumArgs:").$out_uint(this.getNumArgs());
        }
        O.$out(NativePointer.$GT_LF);
    }

    public void dump() {
        this.print(llvm.dbgs());
    }

    public Option(Option $Prm0) {
        this.Info = $Prm0.Info;
        this.Owner = $Prm0.Owner;
    }

    public Option(JavaDifferentiators.JD.Move _dparam, Option $Prm0) {
        this.Info = $Prm0.Info;
        this.Owner = $Prm0.Owner;
    }

    public String toString() {
        return "Info=" + this.Info + ", Owner=" + this.Owner;
    }

    public static final class RenderStyleKind
    extends Enum<RenderStyleKind>
    implements Native.ComparableLower {
        public static final /* enum */ RenderStyleKind RenderCommaJoinedStyle = new RenderStyleKind(0);
        public static final /* enum */ RenderStyleKind RenderJoinedStyle = new RenderStyleKind(RenderCommaJoinedStyle.getValue() + 1);
        public static final /* enum */ RenderStyleKind RenderSeparateStyle = new RenderStyleKind(RenderJoinedStyle.getValue() + 1);
        public static final /* enum */ RenderStyleKind RenderValuesStyle = new RenderStyleKind(RenderSeparateStyle.getValue() + 1);
        private final int value;
        private static final /* synthetic */ RenderStyleKind[] $VALUES;

        public static RenderStyleKind[] values() {
            return (RenderStyleKind[])$VALUES.clone();
        }

        public static RenderStyleKind valueOf(String name) {
            return Enum.valueOf(RenderStyleKind.class, name);
        }

        public static RenderStyleKind valueOf(int val) {
            RenderStyleKind out;
            RenderStyleKind renderStyleKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private RenderStyleKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((RenderStyleKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((RenderStyleKind)((Object)obj)).value);
        }

        static {
            $VALUES = new RenderStyleKind[]{RenderCommaJoinedStyle, RenderJoinedStyle, RenderSeparateStyle, RenderValuesStyle};
        }

        private static final class Values {
            private static final RenderStyleKind[] VALUES;
            private static final RenderStyleKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (RenderStyleKind kind : RenderStyleKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new RenderStyleKind[min < 0 ? 1 - min : 0];
                VALUES = new RenderStyleKind[max >= 0 ? 1 + max : 0];
                for (RenderStyleKind kind : RenderStyleKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((RenderStyleKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((RenderStyleKind)kind).value] = kind;
                }
            }
        }
    }

    public static final class OptionClass {
        public static final byte GroupClass = 0;
        public static final byte InputClass = 1;
        public static final byte UnknownClass = 2;
        public static final byte FlagClass = 3;
        public static final byte JoinedClass = 4;
        public static final byte SeparateClass = 5;
        public static final byte RemainingArgsClass = 6;
        public static final byte RemainingArgsJoinedClass = 7;
        public static final byte CommaJoinedClass = 8;
        public static final byte MultiArgClass = 9;
        public static final byte JoinedOrSeparateClass = 10;
        public static final byte JoinedAndSeparateClass = 11;
    }
}

