/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.support.NativeTrace;
import org.clank.support.literal_constants;
import org.llvm.adt.StringRef;
import org.llvm.support.AllocatorBase;
import org.llvm.support.MallocAllocator;
import org.llvm.support.raw_ostream;

public final class StatisticsADTSupport {
    private StatisticsADTSupport() {
    }

    public static void clearStatistics() {
        StringRef.clearStatistics();
        raw_ostream.clearStatistics();
        MallocAllocator.clearStatistics();
    }

    public static long PrintStats(raw_ostream out) {
        out.$out("---org.llvm.adt and support Statistics---\n");
        long Value = StringRef.PrintStats(out);
        Value += raw_ostream.PrintStats(out);
        AllocatorBase.DumpDebugTrace(out);
        StatisticsADTSupport.dumpStatisticValue(out, "TotalLlvmADTSupportValue", Value += MallocAllocator.PrintStats(out));
        return Value;
    }

    public static void dumpStatisticValue(raw_ostream out, String valueName, long value) {
        out.$out(String.format("==== %32s: %20s", valueName, NativeTrace.formatNumber((long)value))).$out(literal_constants.$LF);
        out.flush();
        NativeTrace.dumpStatisticValue((String)valueName, (long)value);
    }
}

