/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.aliases.DenseMapBaseIntInt;
import org.llvm.adt.aliases.DenseMapInfoInt;
import org.llvm.support.llvm;

public class SmallDenseMapIntInt
extends DenseMapBaseIntInt<SmallDenseMapIntInt>
implements Native.assignable<SmallDenseMapIntInt>,
Destructors.ClassWithDestructor {
    private std_pair.pairIntInt[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;
    private final type.ref<std_pair.pairIntInt[]> BucketsRef = new type.ref<std_pair.pairIntInt[]>(){

        public std_pair.pairIntInt[] $deref() {
            return SmallDenseMapIntInt.this.Buckets;
        }

        public std_pair.pairIntInt[] $set(std_pair.pairIntInt[] value) {
            SmallDenseMapIntInt.access$002(SmallDenseMapIntInt.this, value);
            return value;
        }
    };
    private final uint.ref NumBucketsRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapIntInt.this.NumBuckets;
        }

        public int $set(int value) {
            SmallDenseMapIntInt.this.NumBuckets = value;
            return SmallDenseMapIntInt.this.NumBuckets;
        }
    };
    private final uint.ref NumEntriesRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapIntInt.this.NumEntries;
        }

        public int $set(int value) {
            SmallDenseMapIntInt.this.NumEntries = value;
            return SmallDenseMapIntInt.this.NumEntries;
        }
    };
    private final uint.ref NumTombstonesRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapIntInt.this.NumTombstones;
        }

        public int $set(int value) {
            SmallDenseMapIntInt.this.NumTombstones = value;
            return SmallDenseMapIntInt.this.NumTombstones;
        }
    };

    public SmallDenseMapIntInt(DenseMapInfoInt keyInfo, int defaultValue) {
        this(keyInfo, 0, defaultValue);
    }

    public SmallDenseMapIntInt(DenseMapInfoInt keyInfo, int NumInitBuckets, int defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public SmallDenseMapIntInt(SmallDenseMapIntInt other) {
        super(other.keyInfoT, other.defaultValue);
        this.init(0);
        this.copyFrom(other);
    }

    public SmallDenseMapIntInt(DenseMapInfoInt keyInfo, type.iterator<?, std_pair.pairIntInt> I, type.iterator<?, std_pair.pairIntInt> E, int defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        this.destroyAll();
    }

    public void swap(SmallDenseMapIntInt RHS) {
        std.swap(this.BucketsRef, RHS.BucketsRef);
        std.swap((uint.ref)this.NumEntriesRef, (uint.ref)RHS.NumEntriesRef);
        std.swap((uint.ref)this.NumTombstonesRef, (uint.ref)RHS.NumTombstonesRef);
        std.swap((uint.ref)this.NumBucketsRef, (uint.ref)RHS.NumBucketsRef);
    }

    public SmallDenseMapIntInt $assign(SmallDenseMapIntInt other) {
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(SmallDenseMapIntInt other) {
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(int InitBuckets) {
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(int AtLeast) {
        int OldNumBuckets = this.NumBuckets;
        std_pair.pairIntInt[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)llvm.NextPowerOf2(AtLeast - 1)));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        int OldNumEntries = this.NumEntries;
        this.destroyAll();
        int NewNumBuckets = 0;
        if (OldNumEntries != 0) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std_pair.pairIntInt> getBuckets() {
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std_pair.pairIntInt[] $Buckets() {
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        return this.NumBuckets;
    }

    private boolean allocateBuckets(int Num) {
        this.NumBuckets = Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std_pair.pairIntInt[] bucketsArray = new std_pair.pairIntInt[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = new std_pair.pairIntInt();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    public String toString() {
        return "DenseMap{Buckets=[\n" + Arrays.toString(this.Buckets) + "\n], NumEntries=" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + '}';
    }

    static /* synthetic */ std_pair.pairIntInt[] access$002(SmallDenseMapIntInt x0, std_pair.pairIntInt[] x1) {
        x0.Buckets = x1;
        return x1;
    }
}

