/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntryUInt;
import org.llvm.adt.aliases.StringMapIteratorUInt;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMapUInt
extends StringMapImpl
implements Destructors.ClassWithDestructor,
Iterable<StringMapEntryUInt> {
    private NativeMemory.Allocator Allocator;
    private final int defaultValue;
    private final boolean isDataPointerLike;

    public StringMapUInt(int defaultValue) {
        super(StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapUInt(int InitialSize, int defaultValue) {
        super(InitialSize, StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapUInt(NativeMemory.Allocator A, int defaultValue) {
        super(StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
    }

    public StringMapUInt(int InitialSize, NativeMemory.Allocator A, int defaultValue) {
        super(InitialSize, StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
    }

    public StringMapUInt(StringMapUInt RHS, int defaultValue) {
        super(StringMapEntryUInt.$sizeof_StringMapEntryUInt());
        this.defaultValue = defaultValue;
        this.isDataPointerLike = false;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMapUInt(JavaDifferentiators.JD.Move _dparam, StringMapUInt RHS) {
        super((StringMapImpl)std.move((Object)RHS));
        this.Allocator = RHS.Allocator;
        this.defaultValue = RHS.defaultValue;
        this.isDataPointerLike = false;
    }

    public StringMapUInt $assign(StringMapUInt RHS) {
        super.swap(RHS);
        assert (RHS.isDataPointerLike == this.isDataPointerLike) : RHS.isDataPointerLike + " vs. " + this.isDataPointerLike;
        NativeMemory.Allocator tmp = this.Allocator;
        this.Allocator = RHS.Allocator;
        RHS.Allocator = tmp;
        return this;
    }

    public NativeMemory.Allocator getAllocator() {
        return this.Allocator;
    }

    public StringMapIteratorUInt begin() {
        return new StringMapIteratorUInt(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIteratorUInt end() {
        return new StringMapIteratorUInt(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIteratorUInt find(StringRef Key) {
        int Bucket2 = this.FindKey(Key);
        if (Bucket2 == -1) {
            return this.end();
        }
        return new StringMapIteratorUInt(this.TheTable, Bucket2, true);
    }

    public StringMapIteratorUInt find(String Key) {
        return this.find(new StringRef(Key));
    }

    public StringMapIteratorUInt find(char.ptr Key) {
        int Bucket2 = this.FindKey(Key, std.strlen((char.ptr)Key));
        if (Bucket2 == -1) {
            return this.end();
        }
        return new StringMapIteratorUInt(this.TheTable, Bucket2, true);
    }

    public int lookup(StringRef Key) {
        return this.lookup(Key.data(), Key.size());
    }

    public int lookup(char.ptr Key, int KeyLen) {
        int Bucket2 = this.FindKey(Key, KeyLen);
        if (Bucket2 != -1) {
            return ((StringMapEntryUInt)this.TheTable[Bucket2]).getValue();
        }
        return Native.$tryClone((int)this.defaultValue);
    }

    public int $at(String Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public int $at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public int $at(char.ptr Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public uint.ref ref$at(String Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public uint.ref ref$at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public uint.ref ref$at(char.ptr Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public int $set(StringRef Key, int Val) {
        this.GetOrCreateValue((StringRef)Key, (int)0).second = Val;
        return this.GetOrCreateValue((StringRef)Key, (int)0).second;
    }

    public int $set(String Key, int Val) {
        this.GetOrCreateValue((String)Key, (int)0).second = Val;
        return this.GetOrCreateValue((String)Key, (int)0).second;
    }

    public int $set(char.ptr Key, int Val) {
        this.GetOrCreateValue((char.ptr)Key, (int)std.strlen((char.ptr)Key), (int)0).second = Val;
        return this.GetOrCreateValue((char.ptr)Key, (int)std.strlen((char.ptr)Key), (int)0).second;
    }

    public int count(StringRef Key) {
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public std_pair.pairTypeBool<StringMapIteratorUInt> insert(std_pair.pairTypeUInt<StringRef> KV) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = ((StringRef)KV.first).data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = ((StringRef)KV.first).size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapUInt.getTombstoneVal()) {
            return std.make_pair_T_bool((Object)new StringMapIteratorUInt(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket2 == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket2 = StringMapEntryUInt.Create(keyData, keyLength, FullHashValue, this.Allocator, (Integer)std.move((Object)KV.second));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair_T_bool((Object)new StringMapIteratorUInt(this.TheTable, BucketNo, false), (boolean)true);
    }

    public boolean insert(StringMapEntryUInt KeyValue) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapUInt.getTombstoneVal()) {
            return false;
        }
        if (Bucket2 == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket2 = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket2 = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public StringMapEntryUInt GetOrCreateValue(StringRef Key, int Val) {
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public StringMapEntryUInt GetOrCreateValue(String Key, int Val) {
        return this.GetOrCreateValue(new StringRef(Key), Val);
    }

    public StringMapEntryUInt GetOrCreateValue(char.ptr Key, int Len, int Val) {
        int FullHashValue = llvm.HashString(Key, Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapUInt.getTombstoneVal()) {
            return (StringMapEntryUInt)Bucket2;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((int)Val);
        }
        StringMapEntryUInt NewItem = StringMapEntryUInt.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket2 == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket2 = NewItem;
        this.RehashTable();
        return (StringMapEntryUInt)Bucket2;
    }

    private StringMapEntryUInt GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, int Val) {
        int FullHashValue = llvm.HashString(Key, KeyStIndex, Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        StringMapEntryBase Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMapUInt.getTombstoneVal()) {
            return (StringMapEntryUInt)Bucket2;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone((int)Val);
        }
        StringMapEntryUInt NewItem = StringMapEntryUInt.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket2 == StringMapUInt.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket2 = NewItem;
        this.RehashTable();
        return (StringMapEntryUInt)Bucket2;
    }

    public StringMapEntryUInt GetOrCreateValue(StringRef Key) {
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public StringMapEntryUInt GetOrCreateValue(String Key) {
        return this.GetOrCreateValue(new StringRef(Key), this.defaultValue);
    }

    public StringMapEntryUInt GetOrCreateValue(char.ptr Key) {
        return this.GetOrCreateValue(Key, std.strlen((char.ptr)Key), this.defaultValue);
    }

    public StringMapEntryUInt GetOrCreateValue(char.ptr Key, int Len) {
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public StringMapEntryUInt GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(StringMapEntryUInt KeyValue) {
        this.RemoveKey(KeyValue);
    }

    public void erase(StringMapIteratorUInt I) {
        StringMapEntryUInt V = I.$star();
        this.remove(V);
        V.Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        StringMapIteratorUInt I = this.find(Key);
        if (Native.$eq_iter((abstract_iterator)I, (abstract_iterator)this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        this.clear();
        std.free((Object)this.TheTable);
        Destructors.$destroy((Object)this.Allocator);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringMapIteratorUInt B = this.begin();
        StringMapIteratorUInt E = this.end();
        while (B.$noteq(E)) {
            out.append("{").append(B.$star().first()).append("=>").append(B.$star().getValue()).append("}\n");
            B.$preInc();
        }
        return out.toString();
    }

    @Override
    public Iterator<StringMapEntryUInt> iterator() {
        return new JavaIterator((type.iterator)this.begin(), (type.iterator)this.end());
    }
}

