/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.cl.impl;

import java.util.Comparator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRefChar;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.cl.ClGlobals;
import org.llvm.cl.DenseMapInfoOption;
import org.llvm.cl.DenseMapInfoOptionCategory;
import org.llvm.cl.FormattingFlags;
import org.llvm.cl.NumOccurrencesFlag;
import org.llvm.cl.Option;
import org.llvm.cl.OptionCategory;
import org.llvm.cl.OptionHidden;
import org.llvm.cl.ValueExpected;
import org.llvm.cl.desc;
import org.llvm.cl.impl.CategorizedHelpPrinter;
import org.llvm.cl.impl.HelpPrinter;
import org.llvm.cl.impl.HelpPrinterWrapper;
import org.llvm.cl.impl.VersionPrinter;
import org.llvm.cl.opt;
import org.llvm.cl.optBoolean;
import org.llvm.cl.parserBoolean;
import org.llvm.support.ErrorOr;
import org.llvm.support.ManagedStatic;
import org.llvm.support.ManagedStaticInfo;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.StringSaver;
import org.llvm.support.llvm;
import org.llvm.support.sys.ManagedStaticInfoImpl;
import org.llvm.support.sys.sys;

public final class CommandLineStatics {
    private static final String PREMAIN = "<premain>";
    public static final char.ptr ProgramName;
    public static char.ptr ProgramOverview;
    public static ManagedStatic<std.vectorCharPtr> MoreHelp;
    public static boolean OptionListChanged;
    public static Option RegisteredOptionList;
    private static final ManagedStaticInfo<SmallPtrSet<OptionCategory>> StaticOptionCatSet;
    public static ManagedStatic<SmallPtrSet<OptionCategory>> RegisteredOptionCategories;
    private static final NativeCallback.BoolPredicate<Option> isGroupingCallback;
    private static final NativeCallback.BoolPredicate<Option> isPrefixedOrGroupingCallback;
    public static int MaxOptWidth;
    private static final Comparator<std_pair.pair<char.ptr, Option>> OptNameCompareCallback;
    public static HelpPrinter UncategorizedNormalPrinter;
    public static HelpPrinter UncategorizedHiddenPrinter;
    public static CategorizedHelpPrinter CategorizedNormalPrinter;
    public static CategorizedHelpPrinter CategorizedHiddenPrinter;
    public static HelpPrinterWrapper WrappedNormalPrinter;
    public static HelpPrinterWrapper WrappedHiddenPrinter;
    public static opt<Boolean> HLOp;
    public static opt<Boolean> HLHOp;
    public static opt<Boolean> PrintOptions;
    public static opt<Boolean> PrintAllOptions;
    public static NativeCallback.Void2Void OverrideVersionPrinter;
    public static std.vector<NativeCallback.Void2Void> ExtraVersionPrinters;
    public static VersionPrinter VersionPrinterInstance;

    public static void MarkOptionsChanged() {
        OptionListChanged = true;
    }

    public static boolean CommaSeparateAndAddOccurrence(Option Handler, int pos, StringRef ArgName, StringRef Value) {
        return CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, pos, ArgName, Value, false);
    }

    public static boolean CommaSeparateAndAddOccurrence(Option Handler, int pos, StringRef ArgName, StringRef Value, boolean MultiArg) {
        if ((Handler.getMiscFlags() & 1) != 0) {
            StringRef Val = new StringRef(Value);
            int Pos = Val.find((byte)44);
            while (Pos != StringRef.npos) {
                if (Handler.addOccurrence(pos, ArgName, Val.substr(0, Pos), MultiArg)) {
                    return true;
                }
                Val.$assign$substr(Pos + 1);
                Value.substr(Pos + 1);
                Pos = Val.find((byte)44);
            }
            Value.$assign(Val);
        }
        return Handler.addOccurrence(pos, ArgName, Value, MultiArg);
    }

    public static boolean ExpandResponseFile(char.ptr FName, StringSaver Saver, ClGlobals.TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> NewArgv) {
        return CommandLineStatics.ExpandResponseFile(FName, Saver, Tokenizer, NewArgv, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ExpandResponseFile(char.ptr FName, StringSaver Saver, ClGlobals.TokenizerCallback Tokenizer, SmallVectorImpl<char.ptr> NewArgv, boolean MarkEOLs) {
        std.string UTF8Buf = null;
        try {
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> MemBufOrErr = MemoryBuffer.getFile(new Twine(FName));
            if (!MemBufOrErr.$bool()) {
                boolean bl = false;
                return bl;
            }
            MemoryBuffer MemBuf = (MemoryBuffer)MemBufOrErr.get().$star();
            StringRef Str = new StringRef(MemBuf.getBufferStart(), MemBuf.getBufferSize());
            ArrayRefChar BufRef = new ArrayRefChar(MemBuf.getBufferStart(), MemBuf.getBufferEnd());
            UTF8Buf = new std.string();
            if (llvm.hasUTF16ByteOrderMark(new ArrayRefChar(BufRef))) {
                if (!llvm.convertUTF16ToUTF8String(new ArrayRefChar(BufRef), UTF8Buf)) {
                    boolean bl = false;
                    return bl;
                }
                Str.$assign(new StringRef(UTF8Buf));
            }
            Tokenizer.$call(new StringRef(Str), Saver, NewArgv, MarkEOLs);
            boolean bl = true;
            return bl;
        }
        finally {
            if (UTF8Buf != null) {
                UTF8Buf.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GetOptionInfo(SmallVectorImpl<Option> PositionalOpts, SmallVectorImpl<Option> SinkOpts, StringMap<Option> OptionsMap) {
        SmallVector<char.ptr> OptionNames = null;
        try {
            boolean HadErrors = false;
            OptionNames = new SmallVector<char.ptr>(16, (char.ptr)null);
            Option CAOpt = null;
            for (Option O = RegisteredOptionList; O != null; O = O.getNextRegisteredOption()) {
                O.getExtraOptionNames(OptionNames);
                if (O.ArgStr.$at(0) != 0) {
                    OptionNames.push_back(O.ArgStr);
                }
                int e = OptionNames.size();
                for (int i = 0; i != e; ++i) {
                    if (OptionsMap.insert((std_pair.pair<StringRef, Option>)std.make_pair((Object)new StringRef((char.ptr)((char.ptr)OptionNames.$at((int)i))), (Object)O)).second) continue;
                    llvm.errs().$out(ProgramName).$out(NativePointer.$((String)": CommandLine Error: Option '")).$out((char.ptr)OptionNames.$at(i)).$out(NativePointer.$((String)"' registered more than once!\n"));
                    HadErrors = true;
                }
                OptionNames.clear();
                if (O.getFormattingFlag() == FormattingFlags.Positional) {
                    PositionalOpts.push_back(O);
                    continue;
                }
                if ((O.getMiscFlags() & 4) != 0) {
                    SinkOpts.push_back(O);
                    continue;
                }
                if (O.getNumOccurrencesFlag() != NumOccurrencesFlag.ConsumeAfter) continue;
                if (CAOpt != null) {
                    O.error(new Twine(NativePointer.$((String)"Cannot specify more than one option with cl::ConsumeAfter!")));
                    HadErrors = true;
                }
                CAOpt = O;
            }
            if (CAOpt != null) {
                PositionalOpts.push_back(CAOpt);
            }
            std.reverse((Object)PositionalOpts.begin(), (Object)PositionalOpts.end());
            if (HadErrors) {
                llvm.report_fatal_error(NativePointer.$((String)"inconsistency in registered CommandLine options"));
            }
        }
        finally {
            if (OptionNames != null) {
                OptionNames.$destroy();
            }
        }
    }

    public static Option LookupOption(StringRef Arg, StringRef Value, StringMap<Option> OptionsMap) {
        if (Arg.empty()) {
            return null;
        }
        int EqualPos = Arg.find(NativePointer.$((char)'='));
        if (EqualPos == StringRef.npos) {
            StringMapIterator I = (StringMapIterator)Native.$tryClone(OptionsMap.find(Arg));
            return I.$noteq(OptionsMap.end()) ? (Option)((StringMapEntry)I.$arrow()).second : null;
        }
        StringMapIterator I = (StringMapIterator)Native.$tryClone(OptionsMap.find(Arg.substr(0, EqualPos)));
        if (I.$eq(OptionsMap.end())) {
            return null;
        }
        Value.$assign(Arg.substr(EqualPos + 1));
        Arg.$assign$substr(0, EqualPos);
        return (Option)((StringMapEntry)I.$arrow()).second;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Option LookupNearestOption(StringRef Arg, StringMap<Option> OptionsMap, std.string NearestString) {
        if (Arg.empty()) {
            return null;
        }
        std_pair.pair<StringRef, StringRef> SplitArg = Arg.split('=');
        StringRef LHS = (StringRef)SplitArg.first;
        StringRef RHS = (StringRef)SplitArg.second;
        Option Best = null;
        int BestDistance = 0;
        StringMapIterator it = (StringMapIterator)Native.$tryClone(OptionsMap.begin());
        StringMapIterator ie = (StringMapIterator)Native.$tryClone(OptionsMap.end());
        while (it.$noteq(ie)) {
            SmallVector<char.ptr> OptionNames = null;
            try {
                Option O = (Option)((StringMapEntry)it.$arrow()).second;
                OptionNames = new SmallVector<char.ptr>(16, (char.ptr)null);
                O.getExtraOptionNames(OptionNames);
                if (O.ArgStr.$at(0) != 0) {
                    OptionNames.push_back(O.ArgStr);
                }
                boolean PermitValue = O.getValueExpectedFlag() != ValueExpected.ValueDisallowed;
                StringRef Flag = PermitValue ? LHS : Arg;
                int e = OptionNames.size();
                for (int i = 0; i != e; ++i) {
                    StringRef Name = new StringRef((char.ptr)OptionNames.$at(i));
                    int Distance = new StringRef(Name).edit_distance(Flag, true, BestDistance);
                    if (Best != null && Distance >= BestDistance) continue;
                    Best = O;
                    BestDistance = Distance;
                    if (RHS.empty() || !PermitValue) {
                        NearestString.$assign((char.ptr)OptionNames.$at(i));
                        continue;
                    }
                    NearestString.$assign(std.$add_str((std.string)std.$add_str_T((std.string)new std.string((char.ptr)OptionNames.$at(i)), (String)"="), (std.string)RHS.str()));
                }
            }
            finally {
                if (OptionNames != null) {
                    OptionNames.$destroy();
                }
            }
            it.$preInc();
        }
        return Best;
    }

    public static boolean ProvideOption(Option Handler, StringRef ArgName, StringRef Value, int argc, type.ptr<char.ptr> argv, int.ref i) {
        int NumAdditionalVals = Handler.getNumAdditionalVals();
        switch (Handler.getValueExpectedFlag()) {
            case ValueRequired: {
                if (Value.data() != null) break;
                if (i.$deref() + 1 >= argc) {
                    return Handler.error(new Twine("requires a value!"));
                }
                Value.$assign(new StringRef((char.ptr)argv.$at(i.$set(i.$deref() + 1))));
                break;
            }
            case ValueDisallowed: {
                if (NumAdditionalVals > 0) {
                    return Handler.error(new Twine("multi-valued option specified with ValueDisallowed modifier!"));
                }
                if (Value.data() == null) break;
                return Handler.error(llvm.$add_Twine(llvm.$add_Twine(new Twine("does not allow a value! '"), new Twine(Value)), new Twine("' specified.")));
            }
        }
        if (NumAdditionalVals == 0) {
            return CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, i.$deref(), ArgName, Value);
        }
        boolean MultiArg = false;
        if (Value.data() != null) {
            if (CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, i.$deref(), ArgName, Value, MultiArg)) {
                return true;
            }
            --NumAdditionalVals;
            MultiArg = true;
        }
        while (NumAdditionalVals > 0) {
            if (i.$deref() + 1 >= argc) {
                return Handler.error(new Twine("not enough values!"));
            }
            Value.$assign(new StringRef((char.ptr)argv.$at(i.$set(i.$deref() + 1))));
            if (CommandLineStatics.CommaSeparateAndAddOccurrence(Handler, i.$deref(), ArgName, Value, MultiArg)) {
                return true;
            }
            MultiArg = true;
            --NumAdditionalVals;
        }
        return false;
    }

    public static boolean ProvidePositionalOption(Option Handler, StringRef Arg, int i) {
        int.ref Dummy = NativePointer.create_int$ref((int)i);
        return CommandLineStatics.ProvideOption(Handler, new StringRef(Handler.ArgStr), Arg, 0, null, Dummy);
    }

    public static boolean isGrouping(Option O) {
        return O.getFormattingFlag() == FormattingFlags.Grouping;
    }

    public static boolean isPrefixedOrGrouping(Option O) {
        return CommandLineStatics.isGrouping(O) || O.getFormattingFlag() == FormattingFlags.Prefix;
    }

    public static Option getOptionPred(StringRef Name, int.ref Length, NativeCallback.BoolPredicate<Option> Pred, StringMap<Option> OptionsMap) {
        StringMapIterator OMI = (StringMapIterator)Native.$tryClone(OptionsMap.find(Name));
        while (OMI.$eq(OptionsMap.end()) && Name.size() > 1) {
            Name.$assign$substr(0, Name.size() - 1);
            OMI.$assign(OptionsMap.find(Name));
        }
        if (OMI.$noteq(OptionsMap.end()) && Pred.$call(((StringMapEntry)OMI.$arrow()).second)) {
            Length.$set(Name.size());
            return (Option)((StringMapEntry)OMI.$arrow()).second;
        }
        return null;
    }

    public static Option HandlePrefixedOrGroupedOption(StringRef Arg, StringRef Value, bool.ref ErrorParsing, StringMap<Option> OptionsMap) {
        if (Arg.size() == 1) {
            return null;
        }
        int.ref $Length = NativePointer.create_int$ref((int)0);
        Option PGOpt = CommandLineStatics.getOptionPred(Arg, $Length, isPrefixedOrGroupingCallback, OptionsMap);
        int Length = $Length.$deref();
        if (PGOpt == null) {
            return null;
        }
        if (PGOpt.getFormattingFlag() == FormattingFlags.Prefix) {
            Value.$assign(Arg.substr(Length));
            Arg.$assign$substr(0, Length);
            assert (OptionsMap.count(Arg) != 0 && ((StringMapEntry)OptionsMap.find((StringRef)Arg).$arrow()).second == PGOpt);
            return PGOpt;
        }
        assert (CommandLineStatics.isGrouping(PGOpt)) : "Broken getOptionPred!";
        do {
            StringRef OneArgName = Arg.substr(0, Length);
            Arg.$assign$substr(Length);
            assert (PGOpt.getValueExpectedFlag() != ValueExpected.ValueRequired) : "Option can not be cl::Grouping AND cl::ValueRequired!";
            int.ref Dummy = NativePointer.create_int$ref((int)0);
            boolean _ErrorParsing = ErrorParsing.$deref();
            ErrorParsing.$set(ErrorParsing.$deref() | (_ErrorParsing |= CommandLineStatics.ProvideOption(PGOpt, OneArgName, new StringRef(), 0, null, Dummy)));
            $Length.$set(Length);
            PGOpt = CommandLineStatics.getOptionPred(Arg, $Length, isGroupingCallback, OptionsMap);
            Length = $Length.$deref();
        } while (PGOpt != null && Length != Arg.size());
        return PGOpt;
    }

    public static boolean RequiresValue(Option O) {
        return O.getNumOccurrencesFlag() == NumOccurrencesFlag.Required || O.getNumOccurrencesFlag() == NumOccurrencesFlag.OneOrMore;
    }

    public static boolean EatsUnboundedNumberOfValues(Option O) {
        return O.getNumOccurrencesFlag() == NumOccurrencesFlag.ZeroOrMore || O.getNumOccurrencesFlag() == NumOccurrencesFlag.OneOrMore;
    }

    public static boolean isWhitespace(byte C) {
        return std.strchr((CharSequence)" \t\n\r\f\u000b", (int)C) != null;
    }

    public static boolean isQuote(byte C) {
        return C == NativePointer.$((char)'\"') || C == NativePointer.$((char)'\'');
    }

    public static boolean isGNUSpecial(byte C) {
        return std.strchr((CharSequence)"\\\"' ", (int)C) != null;
    }

    public static int parseBackslash(StringRef Src, int I, SmallString Token2) {
        boolean FollowedByDoubleQuote;
        int E = Src.size();
        int BackslashCount = 0;
        do {
            ++BackslashCount;
        } while (++I != E && Src.$at(I) == 92);
        boolean bl = FollowedByDoubleQuote = I != E && Src.$at(I) == NativePointer.$((char)'\"');
        if (FollowedByDoubleQuote) {
            Token2.append(BackslashCount / 2, NativePointer.$((char)'\\'));
            if (BackslashCount % 2 == 0) {
                return I - 1;
            }
            Token2.push_back(NativePointer.$((char)'\"'));
            return I;
        }
        Token2.append(BackslashCount, NativePointer.$((char)'\\'));
        return I - 1;
    }

    public static char.ptr getValueStr(Option O, char.ptr DefaultMsg) {
        if (O.ValueStr.$at(0) == 0) {
            return DefaultMsg;
        }
        return O.ValueStr;
    }

    public static void printHelpStr(StringRef HelpStr, int Indent, int FirstLineIndentedBy) {
        std_pair.pair<StringRef, StringRef> Split = HelpStr.split('\n');
        llvm.outs().indent(Indent - FirstLineIndentedBy).$out(" - ").$out((StringRef)Split.first).$out(NativePointer.$LF);
        while (!((StringRef)Split.second).empty()) {
            Split.$assign(((StringRef)Split.second).split('\n'));
            llvm.outs().indent(Indent).$out((StringRef)Split.first).$out(NativePointer.$LF);
        }
    }

    public static boolean parseDouble(Option O, StringRef Arg, type.ref<Double> Value) {
        NativeTrace.traceNotImplemented((String)"CommandLineStatics.parseDouble");
        SmallString TmpStr = new SmallString(Arg.begin(), Arg.end(), 32);
        char.ptr ArgStart = Native.$tryClone((char.ptr)TmpStr.c_str());
        char.ptr End = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)0, (byte[])new byte[0]));
        Value.$set((Object)std.strtod((char.ptr)ArgStart, (type.ptr)End.$addr()));
        if (End.$star() != 0) {
            return O.error(llvm.$add_Twine(llvm.$add_T_StringRef("'", Arg), new Twine("' value invalid for floating point argument!")));
        }
        return false;
    }

    public static int OptNameCompare(Object LHS, Object RHS) {
        return std.strcmp((char.ptr)((char.ptr)((std_pair.pair)LHS).first), (char.ptr)((char.ptr)((std_pair.pair)RHS).first));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortOpts(StringMap<Option> OptMap, SmallVectorImpl<std_pair.pair<char.ptr, Option>> Opts, boolean ShowHidden) {
        SmallPtrSet<Option> OptionSet = null;
        try {
            OptionSet = new SmallPtrSet<Option>(new DenseMapInfoOption(), 128);
            StringMapIterator I = (StringMapIterator)Native.$tryClone(OptMap.begin());
            StringMapIterator E = (StringMapIterator)Native.$tryClone(OptMap.end());
            while (I.$noteq(E)) {
                if (((Option)((StringMapEntry)I.$arrow()).second).getOptionHiddenFlag() != OptionHidden.ReallyHidden && (((Option)((StringMapEntry)I.$arrow()).second).getOptionHiddenFlag() != OptionHidden.Hidden || ShowHidden) && OptionSet.insert(((StringMapEntry)I.$arrow()).second).second) {
                    Opts.push_back((std_pair.pair<char.ptr, Option>)new std_pair.pair((Object)((StringMapEntry)I.$arrow()).getKey().data(), ((StringMapEntry)I.$arrow()).second));
                }
                I.$preInc();
            }
            std.qsort(Opts.data(), (int)Opts.size(), (int)-1, OptNameCompareCallback);
        }
        finally {
            if (OptionSet != null) {
                OptionSet.$destroy();
            }
        }
    }

    static {
        byte[] array2 = NativePointer.new$char((int)80, (byte[])new byte[0]);
        for (int i = 0; i < PREMAIN.length(); ++i) {
            array2[i] = (byte)PREMAIN.charAt(i);
        }
        array2[PREMAIN.length()] = 0;
        ProgramName = NativePointer.create_char$ptr((byte[])array2);
        ProgramOverview = null;
        MoreHelp = new ManagedStatic<std.vectorCharPtr>(sys.StaticStdVectorCharPtr);
        OptionListChanged = false;
        RegisteredOptionList = null;
        StaticOptionCatSet = new ManagedStaticInfoImpl<SmallPtrSet<OptionCategory>>(){

            @Override
            protected SmallPtrSet<OptionCategory> create() {
                return new SmallPtrSet<OptionCategory>(new DenseMapInfoOptionCategory(), 16);
            }
        };
        RegisteredOptionCategories = new ManagedStatic<SmallPtrSet<OptionCategory>>(StaticOptionCatSet);
        isGroupingCallback = new NativeCallback.BoolPredicate<Option>(){

            public boolean $call(Option param) {
                return CommandLineStatics.isGrouping(param);
            }
        };
        isPrefixedOrGroupingCallback = new NativeCallback.BoolPredicate<Option>(){

            public boolean $call(Option param) {
                return CommandLineStatics.isPrefixedOrGrouping(param);
            }
        };
        MaxOptWidth = 8;
        OptNameCompareCallback = new Comparator<std_pair.pair<char.ptr, Option>>(){

            @Override
            public int compare(std_pair.pair<char.ptr, Option> LHS, std_pair.pair<char.ptr, Option> RHS) {
                return CommandLineStatics.OptNameCompare(LHS, RHS);
            }
        };
        UncategorizedNormalPrinter = new HelpPrinter(false);
        UncategorizedHiddenPrinter = new HelpPrinter(true);
        CategorizedNormalPrinter = new CategorizedHelpPrinter(false);
        CategorizedHiddenPrinter = new CategorizedHelpPrinter(true);
        WrappedNormalPrinter = new HelpPrinterWrapper(UncategorizedNormalPrinter, CategorizedNormalPrinter);
        WrappedHiddenPrinter = new HelpPrinterWrapper(UncategorizedHiddenPrinter, CategorizedHiddenPrinter);
        HLOp = new optBoolean(new parserBoolean(), true, false, new Object[]{"help-list", new desc("Display list of available options (-help-list-hidden for more)"), ClGlobals.location(UncategorizedNormalPrinter), OptionHidden.Hidden, ValueExpected.ValueDisallowed});
        HLHOp = new optBoolean(new parserBoolean(), true, false, new Object[]{"help-list-hidden", new desc("Display list of all available options"), ClGlobals.location(UncategorizedHiddenPrinter), OptionHidden.Hidden, ValueExpected.ValueDisallowed});
        PrintOptions = new optBoolean(Boolean.FALSE, new Object[]{"print-options", new desc("Print non-default options after command line parsing"), OptionHidden.Hidden, ClGlobals.init(false)});
        PrintAllOptions = new optBoolean(Boolean.FALSE, new Object[]{"print-all-options", new desc("Print all option values after command line parsing"), OptionHidden.Hidden, ClGlobals.init(false)});
        OverrideVersionPrinter = null;
        ExtraVersionPrinters = null;
        VersionPrinterInstance = new VersionPrinter();
    }
}

