/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support.sys;

import java.util.Random;
import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.llvm.adt.NoneType;
import org.llvm.adt.Optional;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.SpecificBumpPtrAllocator;
import org.llvm.support.impl.ProcessStatics;
import org.llvm.support.llvm;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;
import org.llvm.support.unix.impl.FDCloser;

public class Process {
    private static final Random randomGenerator = new Random();

    public static int getPageSize() {
        int page_size = std.getpagesize();
        return page_size;
    }

    public static int GetMallocUsage() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void GetTimeUsage(TimeValue elapsed, TimeValue user_time, TimeValue sys_time) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static void PreventCoreFiles() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static Optional<std.string> GetEnv(StringRef Name) {
        std.string NameStr = Name.str();
        char.ptr Val = Native.$tryClone((char.ptr)std.getenv((char.ptr)NameStr.c_str()));
        if (Val == null) {
            return new Optional<std.string>(NoneType.None);
        }
        return new Optional<std.string>(new std.string(Val));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<std.string> FindInEnvPath(std.string EnvName, std.string FileName) {
        Optional<std.string> FoundPath = null;
        SmallVector<StringRef> Dirs = null;
        try {
            FoundPath = new Optional<std.string>();
            Optional<std.string> OptPath = Process.GetEnv(new StringRef(EnvName));
            if (!OptPath.hasValue()) {
                Optional<std.string> optional = new Optional<std.string>(FoundPath);
                return optional;
            }
            byte[] EnvPathSeparatorStr = NativePointer.new$char((int)2, (byte[])new byte[]{sys.EnvPathSeparator, 0});
            Dirs = new SmallVector<StringRef>(8, new StringRef());
            llvm.SplitString(new StringRef(OptPath.getValue()), Dirs, new StringRef(EnvPathSeparatorStr));
            for (StringRef Dir : Dirs) {
                SmallVectorImplChar FilePath = null;
                try {
                    if (Dir.empty()) continue;
                    FilePath = new SmallString(new StringRef(Dir), 128);
                    path.append((SmallString)FilePath, FileName);
                    if (!fs.exists(new Twine(((SmallString)FilePath).$StringRef()))) continue;
                    FoundPath.$assign(((SmallString)FilePath).str().$basic_string());
                    break;
                }
                finally {
                    if (FilePath == null) continue;
                    FilePath.$destroy();
                }
            }
            Optional optional = new Optional(FoundPath);
            return optional;
        }
        finally {
            if (Dirs != null) {
                Dirs.$destroy();
            }
            if (FoundPath != null) {
                FoundPath.$destroy();
            }
        }
    }

    public static std_errors.error_code GetArgumentVector(SmallVectorImpl<char.ptr> ArgsOut, ArrayRef<char.ptr> ArgsIn, SpecificBumpPtrAllocator $Prm2) {
        ArgsOut.append((type.iterator<?, char.ptr>)ArgsIn.begin(), (type.iterator<?, char.ptr>)ArgsIn.end());
        return new std_errors.error_code();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std_errors.error_code FixupStandardFileDescriptors() {
        FDCloser FDC = null;
        try {
            int[] StandardFDs;
            int.ref NullFD = NativePointer.create_int$ref((int)-1);
            FDC = new FDCloser(NullFD);
            for (int StandardFD : StandardFDs = new int[]{0, 1, 2}) {
                io.stat st = new io.stat();
                std.setErrno((int)0);
                while (std.fstat((int)StandardFD, (io.stat)st) < 0) {
                    assert (std.errno() != 0) : "expected errno to be set if fstat failed!";
                    if (std.errno() == 9) break;
                    if (std.errno() == 4) continue;
                    std_errors.error_code error_code3 = new std_errors.error_code(std.errno(), std.generic_category());
                    return error_code3;
                }
                if (std.errno() == 0) continue;
                assert (std.errno() == 9) : "expected errno to have EBADF at this point!";
                if (NullFD.$deref() < 0) {
                    while (NullFD.$set(std.open((char.iterator)NativePointer.$((String)"/dev/null"), (int)2, (int[])new int[0])) < 0) {
                        if (std.errno() == 4) continue;
                        std_errors.error_code error_code4 = new std_errors.error_code(std.errno(), std.generic_category());
                        return error_code4;
                    }
                }
                if (NullFD.$deref() == StandardFD) {
                    FDC.keepOpen();
                    continue;
                }
                if (std.dup2((int)NullFD.$deref(), (int)StandardFD) >= 0) continue;
                std_errors.error_code error_code2 = new std_errors.error_code(std.errno(), std.generic_category());
                return error_code2;
            }
            std_errors.error_code error_code3 = new std_errors.error_code();
            return error_code3;
        }
        finally {
            if (FDC != null) {
                FDC.$destroy();
            }
        }
    }

    public static std_errors.error_code SafelyCloseFileDescriptor(int FD) {
        int ErrnoFromClose = 0;
        if (std.close((int)FD) < 0) {
            ErrnoFromClose = std.errno();
        }
        int EC = 0;
        if (ErrnoFromClose != 0) {
            return new std_errors.error_code(ErrnoFromClose, std.generic_category());
        }
        return new std_errors.error_code(EC, std.generic_category());
    }

    public static boolean StandardInIsUserInput() {
        return Process.FileDescriptorIsDisplayed(0);
    }

    public static boolean StandardOutIsDisplayed() {
        return Process.FileDescriptorIsDisplayed(1);
    }

    public static boolean StandardErrIsDisplayed() {
        return Process.FileDescriptorIsDisplayed(2);
    }

    public static boolean FileDescriptorIsDisplayed(int fd) {
        return std.isatty((int)fd) != 0;
    }

    public static boolean FileDescriptorHasColors(int fd) {
        return Process.FileDescriptorIsDisplayed(fd) && ProcessStatics.terminalHasColors(fd);
    }

    public static int StandardOutColumns() {
        if (!Process.StandardOutIsDisplayed()) {
            return 0;
        }
        return ProcessStatics.getColumns(1);
    }

    public static int StandardErrColumns() {
        if (!Process.StandardErrIsDisplayed()) {
            return 0;
        }
        return ProcessStatics.getColumns(2);
    }

    public static boolean StandardOutHasColors() {
        return Process.FileDescriptorHasColors(1);
    }

    public static boolean StandardErrHasColors() {
        return Process.FileDescriptorHasColors(2);
    }

    public static void UseANSIEscapeCodes(boolean $Prm0) {
    }

    public static boolean ColorNeedsFlush() {
        return false;
    }

    public static char.ptr OutputColor(int code, boolean bold, boolean bg) {
        return ProcessStatics.colorcodes[bg ? 1 : 0][bold ? 1 : 0][code & 7];
    }

    public static char.ptr OutputBold(boolean bg) {
        return NativePointer.$((String)"\u001b[1m");
    }

    public static char.ptr OutputReverse() {
        return NativePointer.$((String)"\u001b[7m");
    }

    public static char.ptr ResetColor() {
        return NativePointer.$((String)"\u001b[0m");
    }

    public static int GetRandomNumber() {
        return randomGenerator.nextInt(Integer.MAX_VALUE);
    }

    public String toString() {
        return "";
    }
}

