/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.custom.CustomAttributeCompletionItem;
import org.netbeans.modules.html.custom.CustomTagCompletionItem;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.custom.conf.Configuration;
import org.netbeans.modules.html.custom.conf.Tag;
import org.netbeans.modules.html.custom.hints.CheckerElementVisitor;
import org.netbeans.modules.html.custom.hints.CustomElementHint;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.HtmlSource;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class CustomHtmlExtension
extends HtmlExtension {
    private Pair<HtmlSource, Configuration> cache;

    public boolean isCustomTag(Named element, HtmlSource source) {
        return this.getConfiguration(source).getTagsNames().contains(element.name().toString());
    }

    public boolean isCustomAttribute(org.netbeans.modules.html.editor.lib.api.elements.Attribute attribute, HtmlSource source) {
        return this.getConfiguration(source).getAttributesNames().contains(attribute.name().toString());
    }

    private Configuration getConfiguration(HtmlSource source) {
        if (this.cache == null) {
            FileObject sourceFileObject = source.getSourceFileObject();
            Project project = sourceFileObject == null ? null : FileOwnerQuery.getOwner((FileObject)sourceFileObject);
            Configuration conf = project == null ? Configuration.EMPTY : Configuration.get(project);
            this.cache = Pair.of((Object)source, (Object)conf);
            return (Configuration)this.cache.second();
        }
        if (source == this.cache.first()) {
            return (Configuration)this.cache.second();
        }
        this.cache = null;
        return this.getConfiguration(source);
    }

    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, int caretOffset) {
        Snapshot snapshot;
        int embeddedCaretOffset;
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        Node root = result.root("filtered_code");
        Element found = ElementUtils.findByPhysicalRange((Node)root, (int)(embeddedCaretOffset = (snapshot = result.getSnapshot()).getEmbeddedOffset(caretOffset)), (boolean)false);
        if (found != null) {
            switch (found.type()) {
                case OPEN_TAG: 
                case CLOSE_TAG: {
                    Named named = (Named)found;
                    String elementName = named.name().toString();
                    Configuration conf = Configuration.get(snapshot.getSource().getFileObject());
                    if (!conf.getTagsNames().contains(elementName)) break;
                    hints.add(new CustomElementHint(elementName, context, new OffsetRange(snapshot.getOriginalOffset(found.from()), snapshot.getOriginalOffset(found.to()))));
                }
            }
        }
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        Node root = result.root("filtered_code");
        Snapshot snapshot = result.getSnapshot();
        Configuration conf = Configuration.get(snapshot.getSource().getFileObject());
        ElementUtils.visitChildren((Node)root, (ElementVisitor)CheckerElementVisitor.getChecker(context, conf, snapshot, hints));
    }

    public List<CompletionItem> completeOpenTags(HtmlExtension.CompletionContext context) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        FileObject file = context.getResult().getSnapshot().getSource().getFileObject();
        Configuration conf = Configuration.EMPTY;
        if (file != null) {
            conf = Configuration.get(file);
        }
        for (Tag t : conf.getTags()) {
            String tagName = t.getName();
            if (!tagName.startsWith(context.getPrefix())) continue;
            items.add((CompletionItem)new CustomTagCompletionItem(t, context.getCCItemStartOffset()));
        }
        return items;
    }

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext context) {
        String tagName;
        Element node = context.getCurrentNode();
        if (node.type() != ElementType.OPEN_TAG) {
            return Collections.emptyList();
        }
        OpenTag ot = (OpenTag)node;
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        Configuration conf = Configuration.get(context.getResult().getSnapshot().getSource().getFileObject());
        Tag t = conf.getTag(tagName = ((OpenTag)node).name().toString());
        if (t != null) {
            for (Attribute a : t.getAttributes()) {
                String aName = a.getName();
                if (ot.getAttribute(aName) != null || !aName.startsWith(context.getPrefix())) continue;
                items.add((CompletionItem)new CustomAttributeCompletionItem(a, context.getCCItemStartOffset()));
            }
        }
        for (Attribute a : conf.getAttributes()) {
            String aName;
            Collection<String> contexts = a.getContexts();
            if (!contexts.isEmpty() && !contexts.contains(tagName) || ot.getAttribute(aName = a.getName()) != null || !aName.startsWith(context.getPrefix())) continue;
            items.add((CompletionItem)new CustomAttributeCompletionItem(a, context.getCCItemStartOffset()));
        }
        return items;
    }
}

