/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.Bundle;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategyPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SendEmailPanel
extends JPanel
implements ChangeListener {
    public static final String IS_VALID = "SendEmailPanel_isValid";
    private final ServiceLocatorStrategyPanel slcPanel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String errorMsg = null;
    private JLabel jndiNameLabel;
    private JTextField jndiNameTextField;
    private JLabel scanningLabel;
    private JPanel serviceLocatorPanel;

    public SendEmailPanel(String lastLocator, ClasspathInfo cpInfo) {
        this.initComponents();
        this.changeSupport.addChangeListener((ChangeListener)this);
        this.scanningLabel.setVisible(SourceUtils.isScanInProgress());
        this.slcPanel = new ServiceLocatorStrategyPanel(lastLocator, cpInfo);
        this.serviceLocatorPanel.add((Component)this.slcPanel, "Center");
        this.slcPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SendEmailPanel.this.changeSupport.fireChange();
            }
        });
        this.jndiNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.fireChange();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.fireChange();
            }

            private void fireChange() {
                SendEmailPanel.this.changeSupport.fireChange();
            }
        });
    }

    public String getServiceLocator() {
        return this.slcPanel.classSelected();
    }

    public String getJndiName() {
        return this.jndiNameTextField.getText();
    }

    private void initComponents() {
        this.jndiNameLabel = new JLabel();
        this.jndiNameTextField = new JTextField();
        this.serviceLocatorPanel = new JPanel();
        this.scanningLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jndiNameLabel, (String)NbBundle.getBundle(SendEmailPanel.class).getString("LBL_jndiName"));
        this.jndiNameTextField.setColumns(30);
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        this.scanningLabel.setFont(new Font("Dialog", 2, 12));
        Mnemonics.setLocalizedText((JLabel)this.scanningLabel, (String)NbBundle.getMessage(SendEmailPanel.class, (String)"LBL_ScanningInProgress"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serviceLocatorPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jndiNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jndiNameTextField, -2, 1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.scanningLabel).addGap(0, 73, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jndiNameLabel).addComponent(this.jndiNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.serviceLocatorPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.scanningLabel, -2, 15, -2)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SendEmailPanel.class, (String)"ACSD_SpecifyMailResource"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SendEmailPanel.class, (String)"ACSD_SpecifyMailResource"));
    }

    protected boolean isEmptyJndiName() {
        return this.jndiNameTextField.getText().trim().equals("");
    }

    String getErrorMessage() {
        if (!this.verifyComponents()) {
            return this.errorMsg;
        }
        if (!this.slcPanel.verifyComponents()) {
            return this.slcPanel.getErrorMessage();
        }
        return null;
    }

    private boolean verifyComponents() {
        if (this.isEmptyJndiName()) {
            this.errorMsg = Bundle.sendEmailPanel_error_empty_jndi_name();
            return false;
        }
        this.errorMsg = null;
        return true;
    }

    public boolean valid() {
        return this.verifyComponents() && this.slcPanel.verifyComponents();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.scanningLabel.setVisible(SourceUtils.isScanInProgress());
        if (this.valid()) {
            this.firePropertyChange(IS_VALID, false, true);
        } else {
            this.firePropertyChange(IS_VALID, true, false);
        }
    }
}

