/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.cnd.mixeddev.MixedDevUtils;
import org.netbeans.modules.cnd.mixeddev.java.QualifiedNamePart;
import org.netbeans.modules.cnd.mixeddev.java.ResolveJavaContextTask;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaClassInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaFieldInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaMethodInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaParameterInfo;
import org.netbeans.modules.cnd.mixeddev.java.model.JavaTypeInfo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class JavaContextSupport {
    private static final int TIMEOUT = 1000;
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = EnumSet.of(JavaTokenId.IDENTIFIER);

    public static <T> T resolveContext(FileObject fObj, ResolveJavaContextTask<T> task, boolean immediately) {
        if (fObj != null && fObj.isValid() && fObj.isData()) {
            return JavaContextSupport.resolveContext(JavaSource.forFileObject((FileObject)fObj), task, immediately);
        }
        return null;
    }

    public static <T> T resolveContext(Document doc, ResolveJavaContextTask<T> task, boolean immediately) {
        if (doc != null) {
            return JavaContextSupport.resolveContext(JavaSource.forDocument((Document)doc), task, immediately);
        }
        return null;
    }

    private static <T> T resolveContext(JavaSource js, ResolveJavaContextTask<T> task, boolean immediately) {
        if (js != null) {
            try {
                if (immediately) {
                    js.runUserActionTask(task, true);
                    return task.getResult();
                }
                Future f = js.runWhenScanFinished(task, true);
                f.get(1000L, TimeUnit.SECONDS);
                if (f.isDone()) {
                    return task.getResult();
                }
            }
            catch (IOException ioEx) {
                Exceptions.printStackTrace((Throwable)ioEx);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int[] getIdentifierSpan(final Document doc, final int offset, final Token<JavaTokenId>[] token) {
        if (JavaContextSupport.getFileObject(doc) == null) {
            return null;
        }
        final int[][] ret = new int[][]{null};
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)th, (int)offset);
                if (ts == null) {
                    return;
                }
                ts.move(offset);
                if (!ts.moveNext()) {
                    return;
                }
                Token t = ts.token();
                if (JavaTokenId.JAVADOC_COMMENT == t.id()) {
                    return;
                }
                if (!USABLE_TOKEN_IDS.contains(t.id())) {
                    ts.move(offset - 1);
                    if (!ts.moveNext()) {
                        return;
                    }
                    t = ts.token();
                    if (!USABLE_TOKEN_IDS.contains(t.id())) {
                        return;
                    }
                }
                if (token != null) {
                    token[0] = t;
                }
                ret[0] = new int[]{ts.offset(), ts.offset() + t.length()};
            }
        });
        return ret[0];
    }

    public static boolean isMethod(TreePath path) {
        return path != null && path.getLeaf().getKind() == Tree.Kind.METHOD;
    }

    public static boolean isClass(TreePath path) {
        return path != null && path.getLeaf() != null && path.getLeaf().getKind() == Tree.Kind.CLASS;
    }

    public static boolean isInterface(TreePath path) {
        return path != null && path.getLeaf() != null && path.getLeaf().getKind() == Tree.Kind.INTERFACE;
    }

    public static boolean isClassOrInterface(TreePath path) {
        return JavaContextSupport.isClass(path) || JavaContextSupport.isInterface(path);
    }

    public static boolean isField(TreePath path) {
        return path != null && path.getLeaf() != null && path.getLeaf().getKind() == Tree.Kind.VARIABLE && JavaContextSupport.isClassOrInterface(path.getParentPath());
    }

    public static JavaClassInfo createClassInfo(CompilationController controller, TreePath clsTreePath) {
        assert (JavaContextSupport.isClassOrInterface(clsTreePath));
        List<QualifiedNamePart> qualifiedName = JavaContextSupport.getQualifiedName(clsTreePath);
        String simpleName = qualifiedName.size() > 0 ? qualifiedName.get(qualifiedName.size() - 1).getText().toString() : "<not_initialized>";
        return new JavaClassInfo(simpleName, qualifiedName);
    }

    public static JavaMethodInfo createMethodInfo(CompilationController controller, TreePath mtdTreePath) {
        assert (mtdTreePath.getLeaf().getKind() == Tree.Kind.METHOD);
        ArrayList<JavaParameterInfo> parameters = new ArrayList<JavaParameterInfo>();
        MethodTree mtdTree = (MethodTree)mtdTreePath.getLeaf();
        for (VariableTree variableTree : mtdTree.getParameters()) {
            parameters.add(JavaContextSupport.createParameterInfo(controller, variableTree));
        }
        List<QualifiedNamePart> qualifiedName = JavaContextSupport.getQualifiedName(mtdTreePath);
        String string = qualifiedName.size() > 0 ? qualifiedName.get(qualifiedName.size() - 1).getText().toString() : "<not_initialized>";
        return new JavaMethodInfo(string, qualifiedName, parameters, JavaContextSupport.createTypeInfo(controller, mtdTree.getReturnType()), JavaContextSupport.isOverloaded(mtdTreePath, string), JavaContextSupport.isFinal(mtdTreePath), JavaContextSupport.isStatic(mtdTreePath), JavaContextSupport.isNative(mtdTreePath));
    }

    public static JavaFieldInfo createFieldInfo(CompilationController controller, TreePath fieldTreePath) {
        assert (fieldTreePath.getLeaf().getKind() == Tree.Kind.VARIABLE);
        VariableTree varTree = (VariableTree)fieldTreePath.getLeaf();
        List<QualifiedNamePart> qualifiedName = JavaContextSupport.getQualifiedName(fieldTreePath);
        String simpleName = qualifiedName.size() > 0 ? qualifiedName.get(qualifiedName.size() - 1).getText().toString() : "<not_initialized>";
        return new JavaFieldInfo(simpleName, qualifiedName, JavaContextSupport.createTypeInfo(controller, varTree.getType()), JavaContextSupport.isFinal(fieldTreePath), JavaContextSupport.isStatic(fieldTreePath));
    }

    public static JavaParameterInfo createParameterInfo(CompilationController controller, VariableTree paramTree) {
        return new JavaParameterInfo(paramTree.getName(), JavaContextSupport.createTypeInfo(controller, paramTree.getType()), JavaContextSupport.isFinal(paramTree.getModifiers()));
    }

    public static JavaTypeInfo createTypeInfo(CompilationController controller, Tree type) {
        if (type != null) {
            TreePath typePath = controller.getTrees().getPath(controller.getCompilationUnit(), type);
            switch (type.getKind()) {
                case CLASS: {
                    Element elem = controller.getTrees().getElement(typePath);
                    if (!(elem instanceof TypeElement)) break;
                    TypeElement typeElem = (TypeElement)elem;
                    return new JavaTypeInfo(typeElem.getSimpleName(), JavaContextSupport.getQualifiedName(typeElem), 0);
                }
                case IDENTIFIER: {
                    Element elem = controller.getTrees().getElement(typePath);
                    if (!(elem instanceof TypeElement)) break;
                    TypeElement typeElem = (TypeElement)elem;
                    return new JavaTypeInfo(typeElem.getSimpleName(), JavaContextSupport.getQualifiedName(typeElem), 0);
                }
                case MEMBER_SELECT: {
                    Element elem = controller.getTrees().getElement(typePath);
                    if (!(elem instanceof TypeElement)) break;
                    TypeElement typeElem = (TypeElement)elem;
                    return new JavaTypeInfo(typeElem.getSimpleName(), JavaContextSupport.getQualifiedName(typeElem), 0);
                }
                case ARRAY_TYPE: {
                    ArrayTypeTree arrayType = (ArrayTypeTree)type;
                    JavaTypeInfo inner = JavaContextSupport.createTypeInfo(controller, arrayType.getType());
                    if (inner == null) break;
                    return new JavaTypeInfo(inner.getName(), inner.getQualifiedName(), inner.getArrayDepth() + 1);
                }
                case PRIMITIVE_TYPE: {
                    CharSequence primitiveName = JavaContextSupport.convertKind(((PrimitiveTypeTree)type).getPrimitiveTypeKind());
                    return new JavaTypeInfo(primitiveName, Arrays.asList(new QualifiedNamePart(primitiveName, QualifiedNamePart.Kind.PRIMITIVE)), 0);
                }
                default: {
                    return new JavaTypeInfo("<NOT_SUPPORTED_KIND_" + (Object)((Object)type.getKind()) + ">", Collections.emptyList(), 0);
                }
            }
        }
        return null;
    }

    public static String renderQualifiedName(List<QualifiedNamePart> qualName) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (QualifiedNamePart part : qualName) {
            if (!first) {
                switch (part.getKind()) {
                    case PACKAGE: {
                        sb.append("/");
                        break;
                    }
                    case CLASS: 
                    case INTERFACE: {
                        sb.append("/");
                        break;
                    }
                    case VARIABLE: 
                    case METHOD: {
                        sb.append("/");
                        break;
                    }
                    case NESTED_CLASS: 
                    case NESTED_INTERFACE: {
                        sb.append("$");
                    }
                }
            }
            sb.append(part.getText());
            first = false;
        }
        return sb.toString();
    }

    static List<QualifiedNamePart> getQualifiedName(CompilationController controller, Tree tree) {
        TreePath treePath = controller.getTrees().getPath(controller.getCompilationUnit(), tree);
        return JavaContextSupport.getQualifiedName(treePath);
    }

    static List<QualifiedNamePart> getQualifiedName(TreePath treePath) {
        ArrayList<QualifiedNamePart> qualifiedName = new ArrayList<QualifiedNamePart>();
        TreePath currentPath = treePath;
        do {
            switch (currentPath.getLeaf().getKind()) {
                case METHOD: {
                    qualifiedName.add(0, new QualifiedNamePart(((MethodTree)currentPath.getLeaf()).getName(), QualifiedNamePart.Kind.METHOD));
                    break;
                }
                case VARIABLE: {
                    qualifiedName.add(0, new QualifiedNamePart(((VariableTree)currentPath.getLeaf()).getName(), QualifiedNamePart.Kind.VARIABLE));
                    break;
                }
                case INTERFACE: {
                    if (currentPath.getParentPath() != null && currentPath.getParentPath().getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
                        qualifiedName.add(0, new QualifiedNamePart(((ClassTree)currentPath.getLeaf()).getSimpleName(), QualifiedNamePart.Kind.NESTED_INTERFACE));
                        break;
                    }
                    qualifiedName.add(0, new QualifiedNamePart(((ClassTree)currentPath.getLeaf()).getSimpleName(), QualifiedNamePart.Kind.INTERFACE));
                    break;
                }
                case CLASS: {
                    if (currentPath.getParentPath() != null && currentPath.getParentPath().getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
                        qualifiedName.add(0, new QualifiedNamePart(((ClassTree)currentPath.getLeaf()).getSimpleName(), QualifiedNamePart.Kind.NESTED_CLASS));
                        break;
                    }
                    qualifiedName.add(0, new QualifiedNamePart(((ClassTree)currentPath.getLeaf()).getSimpleName(), QualifiedNamePart.Kind.CLASS));
                    break;
                }
                case COMPILATION_UNIT: {
                    List<CharSequence> dotExpression = JavaContextSupport.renderExpression(((CompilationUnitTree)currentPath.getLeaf()).getPackageName());
                    qualifiedName.add(0, new QualifiedNamePart(MixedDevUtils.stringize(dotExpression, "/"), QualifiedNamePart.Kind.PACKAGE));
                    break;
                }
            }
        } while ((currentPath = currentPath.getParentPath()) != null);
        return qualifiedName;
    }

    static List<QualifiedNamePart> getQualifiedName(TypeElement typeElement) {
        ArrayList<QualifiedNamePart> qualifiedName = new ArrayList<QualifiedNamePart>();
        block5: for (Element current = typeElement; current != null; current = current.getEnclosingElement()) {
            switch (current.getKind()) {
                case CLASS: {
                    if (current.getNestingKind().isNested()) {
                        qualifiedName.add(0, new QualifiedNamePart(current.getSimpleName(), QualifiedNamePart.Kind.NESTED_CLASS));
                        continue block5;
                    }
                    qualifiedName.add(0, new QualifiedNamePart(current.getSimpleName(), QualifiedNamePart.Kind.CLASS));
                    continue block5;
                }
                case INTERFACE: {
                    if (current.getNestingKind().isNested()) {
                        qualifiedName.add(0, new QualifiedNamePart(current.getSimpleName(), QualifiedNamePart.Kind.NESTED_INTERFACE));
                        continue block5;
                    }
                    qualifiedName.add(0, new QualifiedNamePart(current.getSimpleName(), QualifiedNamePart.Kind.INTERFACE));
                    continue block5;
                }
                case PACKAGE: {
                    PackageElement pkgElem = (PackageElement)current;
                    String packageName = pkgElem.getQualifiedName().toString();
                    qualifiedName.add(0, new QualifiedNamePart(packageName.replaceAll("\\.", "/"), QualifiedNamePart.Kind.PACKAGE));
                }
            }
        }
        return qualifiedName;
    }

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }

    private static CharSequence convertKind(TypeKind kind) {
        switch (kind) {
            case BYTE: {
                return "byte";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case CHAR: {
                return "char";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case SHORT: {
                return "short";
            }
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case VOID: {
                return "void";
            }
        }
        throw new UnsupportedOperationException("Unexpected type kind: " + (Object)((Object)kind));
    }

    private static List<CharSequence> renderExpression(ExpressionTree expr) {
        if (expr != null) {
            ArrayList<CharSequence> exprParts = new ArrayList<CharSequence>();
            do {
                switch (expr.getKind()) {
                    case MEMBER_SELECT: {
                        exprParts.add(0, ((MemberSelectTree)expr).getIdentifier());
                        expr = ((MemberSelectTree)expr).getExpression();
                        break;
                    }
                    case IDENTIFIER: {
                        exprParts.add(0, ((IdentifierTree)expr).getName());
                        expr = null;
                        break;
                    }
                    default: {
                        expr = null;
                    }
                }
            } while (expr != null);
            return exprParts;
        }
        return Collections.emptyList();
    }

    private static boolean isOverloaded(TreePath mtdTreePath, String mtdName) {
        if (Tree.Kind.METHOD.equals((Object)mtdTreePath.getLeaf().getKind())) {
            boolean searchNative = ((MethodTree)mtdTreePath.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.NATIVE);
            if (Tree.Kind.CLASS.equals((Object)mtdTreePath.getParentPath().getLeaf().getKind())) {
                int counter = 0;
                ClassTree cls = (ClassTree)mtdTreePath.getParentPath().getLeaf();
                for (Tree tree : cls.getMembers()) {
                    MethodTree method;
                    if (!Tree.Kind.METHOD.equals((Object)tree.getKind()) || !mtdName.equals((method = (MethodTree)tree).getName().toString()) || searchNative != method.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) continue;
                    ++counter;
                }
                if (counter > 1) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFinal(TreePath tp) {
        ModifiersTree mt = null;
        if (Tree.Kind.METHOD.equals((Object)tp.getLeaf().getKind())) {
            MethodTree method = (MethodTree)tp.getLeaf();
            mt = method.getModifiers();
        } else if (Tree.Kind.VARIABLE.equals((Object)tp.getLeaf().getKind())) {
            VariableTree var = (VariableTree)tp.getLeaf();
            mt = var.getModifiers();
        }
        return JavaContextSupport.isFinal(mt);
    }

    private static boolean isFinal(ModifiersTree mt) {
        return mt != null ? mt.getFlags().contains((Object)Modifier.FINAL) : false;
    }

    private static boolean isStatic(TreePath tp) {
        ModifiersTree mt = null;
        if (Tree.Kind.METHOD.equals((Object)tp.getLeaf().getKind())) {
            MethodTree method = (MethodTree)tp.getLeaf();
            mt = method.getModifiers();
        } else if (Tree.Kind.VARIABLE.equals((Object)tp.getLeaf().getKind())) {
            VariableTree var = (VariableTree)tp.getLeaf();
            mt = var.getModifiers();
        }
        return JavaContextSupport.isStatic(mt);
    }

    private static boolean isStatic(ModifiersTree mt) {
        return mt != null ? mt.getFlags().contains((Object)Modifier.STATIC) : false;
    }

    private static boolean isNative(TreePath tp) {
        if (Tree.Kind.METHOD.equals((Object)tp.getLeaf().getKind())) {
            MethodTree method = (MethodTree)tp.getLeaf();
            return method.getModifiers().getFlags().contains((Object)Modifier.NATIVE);
        }
        return false;
    }

    private JavaContextSupport() {
        throw new AssertionError((Object)"Not instantiable!");
    }
}

