/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model.ui;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.metro.model.MetroConfigLoader;
import org.netbeans.modules.websvc.metro.model.ui.TubesEditor;
import org.netbeans.modules.websvc.spi.wseditor.WSEditorProvider;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class TubesEditorProvider
implements WSEditorProvider {
    public WSEditor createWSEditor(Lookup nodeLookup) {
        FileObject srcRoot = (FileObject)nodeLookup.lookup(FileObject.class);
        if (srcRoot != null) {
            Project prj = FileOwnerQuery.getOwner((FileObject)srcRoot);
            JaxWsModel jaxWsModel = (JaxWsModel)prj.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                return new TubesEditor(prj);
            }
            JaxWsService service = (JaxWsService)nodeLookup.lookup(JaxWsService.class);
            if (service != null) {
                JAXWSLightSupport jaxWsSupport = (JAXWSLightSupport)nodeLookup.lookup(JAXWSLightSupport.class);
                if (jaxWsSupport != null) {
                    return new TubesEditor(jaxWsSupport, service, prj);
                }
                jaxWsSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)srcRoot);
                if (jaxWsSupport != null) {
                    return new TubesEditor(jaxWsSupport, service, prj);
                }
            }
        } else {
            FileObject wsdlFolder;
            JaxWsService service = (JaxWsService)nodeLookup.lookup(JaxWsService.class);
            JAXWSLightSupport jaxWsSupport = (JAXWSLightSupport)nodeLookup.lookup(JAXWSLightSupport.class);
            if (service != null && jaxWsSupport != null && (wsdlFolder = jaxWsSupport.getWsdlFolder(false)) != null) {
                Project prj = FileOwnerQuery.getOwner((FileObject)wsdlFolder);
                return new TubesEditor(jaxWsSupport, service, prj);
            }
        }
        return null;
    }

    public boolean enable(Node node) {
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo == null) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return false;
        }
        if (new MetroConfigLoader().isMetroConfigSupported(p)) {
            Client client = (Client)node.getLookup().lookup(Client.class);
            if (client != null) {
                return true;
            }
            Service service = (Service)node.getLookup().lookup(Service.class);
            if (service != null) {
                return true;
            }
            JaxWsService jaxService = (JaxWsService)node.getLookup().lookup(JaxWsService.class);
            if (jaxService != null) {
                return true;
            }
        }
        return false;
    }
}

