/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.projectui.wizard.ide;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProjectUtilities {
    private ProjectUtilities() {
    }

    public static void makeProjectTabVisible() {
    }

    public static void selectAndExpandProject(final Project p) {
        SwingUtilities.invokeLater(new Runnable(){
            final String ID_LOGICAL = "projectTabLogical_tc";
            final TopComponent ptLogial = WindowManager.getDefault().findTopComponent("projectTabLogical_tc");

            @Override
            public void run() {
                if (this.ptLogial instanceof ExplorerManager.Provider) {
                    Node root = ((ExplorerManager.Provider)this.ptLogial).getExplorerManager().getRootContext();
                    Node projNode = null;
                    for (Node n : root.getChildren().getNodes()) {
                        Project prj = (Project)n.getLookup().lookup(Project.class);
                        if (prj == null || !prj.getProjectDirectory().equals(p.getProjectDirectory())) continue;
                        projNode = n;
                        break;
                    }
                    if (projNode == null) {
                        projNode = root.getChildren().findChild(ProjectUtils.getInformation((Project)p).getName());
                    }
                    if (projNode != null) {
                        try {
                            ((ExplorerManager.Provider)this.ptLogial).getExplorerManager().setSelectedNodes(new Node[]{projNode});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    public static void openAndSelectNewObject(final DataObject newDo) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                Node node = newDo.getNodeDelegate();
                Action a = node.getPreferredAction();
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(node.getLookup());
                }
                if (a != null) {
                    a.actionPerformed(new ActionEvent(node, 1001, ""));
                }
            }
        });
    }

    public static class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean show) {
            this.show = show;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor wc) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                wc.run();
            } else {
                SwingUtilities.invokeLater(wc);
            }
        }

        @Override
        public void run() {
            try {
                JFrame f = (JFrame)WindowManager.getDefault().getMainWindow();
                Component c = f.getGlassPane();
                c.setVisible(this.show);
                c.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException npe) {
                Exceptions.printStackTrace((Throwable)npe);
            }
        }
    }
}

