/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.sync.FileData;
import org.netbeans.modules.cnd.remote.sync.RfsListenerSupportImpl;
import org.netbeans.modules.cnd.remote.sync.SharabilityFilter;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.setup.support.HostUpdatesRegistry;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.ShellScriptRunner;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class FileCollector {
    private final List<File> files;
    private final List<File> buildResults;
    private final RemoteUtil.PrefixedLogger logger;
    private final RemotePathMap mapper;
    private final SharabilityFilter filter;
    private final FileData fileData;
    private final ExecutionEnvironment execEnv;
    private final PrintWriter err;
    private final Set<File> remoteUpdates = new HashSet<File>();
    private final Map<String, String> canonicalToAbsolute = new HashMap<String, String>();
    private final List<FileCollectorInfo> filesToFeed = new ArrayList<FileCollectorInfo>(512);
    private String timeStampFile;
    private static final RequestProcessor RP = new RequestProcessor("FileCollector", 1);

    public FileCollector(File[] files, List<File> buildResults, RemoteUtil.PrefixedLogger logger, RemotePathMap mapper, SharabilityFilter filter, FileData fileData, ExecutionEnvironment execEnv, PrintWriter err) {
        this.files = new ArrayList<File>(files.length);
        this.files.addAll(Arrays.asList(files));
        this.buildResults = new ArrayList<File>(buildResults);
        this.logger = logger;
        this.mapper = mapper;
        this.filter = filter;
        this.fileData = fileData;
        this.execEnv = execEnv;
        this.err = err;
    }

    public List<FileCollectorInfo> getFiles() {
        return this.filesToFeed;
    }

    public void gatherFiles() {
        String toRemoteFilePathName;
        long time = System.currentTimeMillis();
        HashSet<File> topDirs = new HashSet<File>();
        DupsPreventer<File> dupsPreventer = new DupsPreventer<File>();
        for (File file : this.files) {
            if ((file = CndFileUtils.normalizeFile((File)file)).isDirectory()) {
                String toRemoteFilePathName2 = this.mapper.getRemotePath(file.getAbsolutePath());
                FileCollector.addFileGatheringInfo(this.filesToFeed, file, toRemoteFilePathName2);
                File[] children = file.listFiles(this.filter);
                if (children != null) {
                    for (File child : children) {
                        FileCollector.gatherFiles(child, toRemoteFilePathName2, this.filter, this.filesToFeed, dupsPreventer);
                    }
                }
                topDirs.add(file);
                continue;
            }
            File parentFile = file.getAbsoluteFile().getParentFile();
            toRemoteFilePathName = this.mapper.getRemotePath(parentFile.getAbsolutePath());
            if (!topDirs.contains(parentFile)) {
                topDirs.add(parentFile);
                if (dupsPreventer.check(parentFile)) {
                    FileCollector.addFileGatheringInfo(this.filesToFeed, parentFile, toRemoteFilePathName);
                }
            }
            FileCollector.gatherFiles(file, toRemoteFilePathName, this.filter, this.filesToFeed, dupsPreventer);
        }
        Collection<File> parents = this.gatherParents(topDirs);
        for (File file : parents) {
            if (!dupsPreventer.check(file = CndFileUtils.normalizeFile((File)file))) continue;
            toRemoteFilePathName = this.mapper.getRemotePath(file.getAbsolutePath());
            FileCollector.addFileGatheringInfo(this.filesToFeed, file, toRemoteFilePathName);
        }
        this.logger.log(Level.FINE, "gathered %d files in %d ms", this.filesToFeed.size(), System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        this.checkLinks();
        this.logger.log(Level.FINE, "checking links took %d ms", System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        Collections.sort(this.filesToFeed, new Comparator<FileCollectorInfo>(){

            @Override
            public int compare(FileCollectorInfo f1, FileCollectorInfo f2) {
                if (f1.file.isDirectory() || f2.file.isDirectory()) {
                    if (f1.file.isDirectory() && f2.file.isDirectory()) {
                        return f1.remotePath.compareTo(f2.remotePath);
                    }
                    return f1.file.isDirectory() ? -1 : 1;
                }
                long delta = f1.file.lastModified() - f2.file.lastModified();
                return delta == 0L ? 0 : (delta < 0L ? -1 : 1);
            }
        });
        this.logger.log(Level.FINE, "sorting file list took %d ms", System.currentTimeMillis() - time);
    }

    private static void gatherFiles(File file, String base, FileFilter filter, List<FileCollectorInfo> files, DupsPreventer<File> dupsPreventer) {
        if (dupsPreventer.check(file)) {
            File[] children;
            String remotePath = FileCollector.isEmpty(base) ? file.getName() : base + '/' + file.getName();
            files.add(new FileCollectorInfo(file, remotePath));
            if (file.isDirectory() && (children = file.listFiles(filter)) != null) {
                for (File child : children) {
                    String newBase = FileCollector.isEmpty(base) ? file.getName() : base + "/" + file.getName();
                    FileCollector.gatherFiles(child, newBase, filter, files, dupsPreventer);
                }
            }
        }
    }

    private static FileCollectorInfo addFileGatheringInfo(List<FileCollectorInfo> filesToFeed, File file, String remoteFilePathName) {
        FileCollectorInfo info = new FileCollectorInfo(file, remoteFilePathName);
        filesToFeed.add(info);
        return info;
    }

    private Collection<File> gatherParents(Collection<File> files) {
        HashSet<File> parents = new HashSet<File>();
        for (File file : files) {
            this.gatherParents(file, parents);
        }
        return parents;
    }

    private void gatherParents(File file, Set<File> parents) {
        File parent = file.getAbsoluteFile().getParentFile();
        if (parent != null && parent.getParentFile() != null) {
            parents.add(parent);
            this.gatherParents(parent, parents);
        }
    }

    private void checkLinks() {
        if (Utilities.isWindows()) {
            return;
        }
        int cnt = 0;
        int max = 16;
        Collection<FileCollectorInfo> filesToCheck = new ArrayList<FileCollectorInfo>(this.filesToFeed);
        while (!(filesToCheck = this.checkLinks(filesToCheck, this.filesToFeed)).isEmpty() && cnt++ < 16) {
        }
        this.logger.log(Level.FINE, "checkLinks done in %d passes", cnt);
        if (!filesToCheck.isEmpty()) {
            this.logger.log(Level.INFO, "checkLinks exited by count. Cyclic symlinks?", new Object[0]);
        }
    }

    private Collection<FileCollectorInfo> checkLinks(final Collection<FileCollectorInfo> filesToCheck, List<FileCollectorInfo> filesToAdd) {
        NativeProcess process;
        HashSet<FileCollectorInfo> addedInfos = new HashSet<FileCollectorInfo>();
        NativeProcessBuilder pb = NativeProcessBuilder.newLocalProcessBuilder();
        pb.setExecutable("sh");
        pb.setArguments(new String[]{"-c", "xargs ls -ld | grep '^l'"});
        try {
            process = pb.call();
        }
        catch (IOException ex) {
            this.logger.log(Level.INFO, "Error when checking links: %s", ex.getMessage());
            return addedInfos;
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedWriter requestWriter = null;
                try {
                    requestWriter = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), "UTF-8"));
                    for (FileCollectorInfo info : filesToCheck) {
                        String path = "\"" + info.file.getAbsolutePath() + "\"";
                        requestWriter.append(path);
                        requestWriter.newLine();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    if (requestWriter != null) {
                        try {
                            requestWriter.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                }
            }
        });
        RP.post(new Runnable(){

            @Override
            public void run() {
                BufferedReader errorReader = null;
                try {
                    errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), "UTF-8"));
                    String errLine = errorReader.readLine();
                    while (errLine != null) {
                        FileCollector.this.logger.log(Level.INFO, errLine, new Object[0]);
                        errLine = errorReader.readLine();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    if (errorReader != null) {
                        try {
                            errorReader.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                }
            }
        });
        HashMap<String, FileCollectorInfo> map = new HashMap<String, FileCollectorInfo>(filesToCheck.size());
        for (FileCollectorInfo info : filesToCheck) {
            map.put(info.file.getAbsolutePath(), info);
        }
        BufferedReader outputReader = null;
        try {
            outputReader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            boolean errorReported = false;
            String line = outputReader.readLine();
            while (line != null) {
                String localLinkTarget;
                String[] parts = line.split(" +");
                if (parts.length <= 4 && !errorReported) {
                    errorReported = true;
                    this.logger.log(Level.WARNING, "Unexpected ls output: %s", line);
                }
                if ((localLinkTarget = parts[parts.length - 1]).endsWith("/")) {
                    localLinkTarget = localLinkTarget.substring(0, localLinkTarget.length() - 1);
                }
                String linkPath = parts[parts.length - 3];
                FileCollectorInfo info = (FileCollectorInfo)map.get(linkPath);
                CndUtils.assertNotNull((Object)info, (String)("Null FileGatheringInfo for " + linkPath));
                if (info != null) {
                    File localLinkTargetFile;
                    this.logger.log(Level.FINEST, "\tcheckLinks: %s -> %s", linkPath, localLinkTarget);
                    File linkParentFile = CndFileUtils.createLocalFile((String)linkPath).getParentFile();
                    if (CndPathUtilities.isPathAbsolute((CharSequence)localLinkTarget)) {
                        String remoteLinkTarget = this.mapper.getRemotePath(localLinkTarget, false);
                        info.setLinkTarget(remoteLinkTarget);
                        localLinkTargetFile = CndFileUtils.createLocalFile((String)localLinkTarget);
                    } else {
                        info.setLinkTarget(localLinkTarget);
                        localLinkTargetFile = CndFileUtils.createLocalFile((File)linkParentFile, (String)localLinkTarget);
                    }
                    localLinkTargetFile = CndFileUtils.normalizeFile((File)localLinkTargetFile);
                    FileCollectorInfo targetInfo = (FileCollectorInfo)map.get(localLinkTargetFile.getAbsolutePath());
                    if (targetInfo == null) {
                        String remotePath = this.mapper.getRemotePath(localLinkTargetFile.getAbsolutePath(), false);
                        targetInfo = FileCollector.addFileGatheringInfo(filesToAdd, localLinkTargetFile, remotePath);
                        addedInfos.add(targetInfo);
                    }
                }
                line = outputReader.readLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (outputReader != null) {
            try {
                outputReader.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return addedInfos;
    }

    private boolean isBsdBased() {
        HostInfo.OSFamily os;
        try {
            os = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv).getOSFamily();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            return false;
        }
        catch (ConnectionManager.CancellationException ex) {
            return false;
        }
        switch (os) {
            case MACOSX: 
            case FREEBSD: {
                return true;
            }
            case SUNOS: 
            case LINUX: 
            case WINDOWS: 
            case UNKNOWN: {
                return false;
            }
        }
        throw new AssertionError((Object)os.name());
    }

    public boolean initNewFilesDiscovery() {
        String remoteSyncRoot = RemotePathMap.getRemoteSyncRoot(this.execEnv);
        ProcessUtils.ExitStatus res = this.isBsdBased() ? ProcessUtils.execute((ExecutionEnvironment)this.execEnv, (String)"mktemp", (String[])new String[]{remoteSyncRoot + "/XXXXXXXX"}) : ProcessUtils.execute((ExecutionEnvironment)this.execEnv, (String)"mktemp", (String[])new String[]{"-p", remoteSyncRoot});
        if (res.isOK()) {
            this.timeStampFile = res.getOutputString().trim();
            return true;
        }
        this.timeStampFile = null;
        String errMsg = NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Running_Command", (Object)("mktemp -p " + remoteSyncRoot), (Object)this.execEnv, (Object)res.getErrorString(), (Object)res.exitCode, (Object[])new Object[0]);
        this.logger.log(Level.INFO, errMsg, new Object[0]);
        if (this.err != null) {
            this.err.printf("%s%n", errMsg);
        }
        return false;
    }

    public String getCanonicalToAbsolute(String remoteFile) {
        return this.canonicalToAbsolute.get(remoteFile);
    }

    public void putCanonicalToAbsolute(String remoteCanonicalPath, String remotePath) {
        this.canonicalToAbsolute.put(remoteCanonicalPath, remotePath);
    }

    void addUpdate(File localFile) {
        this.remoteUpdates.add(localFile);
    }

    public void shutDownNewFilesDiscovery() {
        try {
            if (!this.remoteUpdates.isEmpty()) {
                HostUpdatesRegistry.register(this.remoteUpdates, this.execEnv, this.fileData.getDataFile().getParent());
                this.logger.log(Level.FINE, "registered  %d updated files", this.remoteUpdates.size());
            }
            if (this.timeStampFile != null) {
                CommonTasksSupport.rmFile((ExecutionEnvironment)this.execEnv, (String)this.timeStampFile, (Writer)this.err).get();
            }
        }
        catch (InterruptedIOException | InterruptedException exception) {
        }
        catch (IOException ex) {
            this.logger.log(Level.INFO, "Error discovering newer files at remote host", ex);
        }
        catch (ExecutionException ex) {
            this.logger.log(Level.INFO, "Error discovering newer files at remote host", ex);
        }
        catch (Throwable thr) {
            thr.printStackTrace(System.err);
        }
        this.logger.log(Level.FINE, "registering %d updated files", this.remoteUpdates.size());
    }

    public void runNewFilesDiscovery(boolean srcOnly) throws IOException, InterruptedException, ConnectionManager.CancellationException {
        if (this.timeStampFile == null) {
            return;
        }
        long time = System.currentTimeMillis();
        int oldSize = this.remoteUpdates.size();
        StringBuilder remoteDirs = new StringBuilder();
        ArrayList<File> filesAndBuildResults = new ArrayList<File>(this.files.size() + this.buildResults.size());
        filesAndBuildResults.addAll(this.files);
        filesAndBuildResults.addAll(this.buildResults);
        for (File file : filesAndBuildResults) {
            if (!file.isDirectory() && !this.buildResults.contains(file)) continue;
            String rPath = this.mapper.getRemotePath(file.getAbsolutePath(), false);
            if (rPath == null) {
                this.logger.log(Level.INFO, "Can't get remote path for %s at %s", file.getAbsolutePath(), this.execEnv);
                continue;
            }
            if (remoteDirs.length() > 0) {
                remoteDirs.append(' ');
            }
            remoteDirs.append('\"');
            remoteDirs.append(rPath);
            remoteDirs.append('\"');
        }
        StringBuilder extOptions = new StringBuilder();
        if (srcOnly) {
            ArrayList<Collection> values = new ArrayList<Collection>();
            values.add(MIMEExtensions.get((String)"text/x-c").getValues());
            values.add(MIMEExtensions.get((String)"text/x-c++").getValues());
            values.add(MIMEExtensions.get((String)"text/x-h").getValues());
            for (Collection v : values) {
                for (String ext : v) {
                    if (extOptions.length() > 0) {
                        extOptions.append(" -o ");
                    }
                    extOptions.append("-name \"*.");
                    extOptions.append(ext);
                    extOptions.append("\"");
                }
            }
            if (extOptions.length() > 0) {
                extOptions.append(" -o ");
            }
            extOptions.append(" -name Makefile");
            for (File file : this.buildResults) {
                extOptions.append(" -o -name ").append(file.getName());
            }
        }
        String script = String.format("for F in `find %s %s -newer %s`; do test -f $F &&  echo $F;  done;", remoteDirs, extOptions.toString(), this.timeStampFile);
        final AtomicInteger lineCnt = new AtomicInteger();
        LineProcessor lp = new LineProcessor(){

            public void processLine(String remoteFile) {
                String localPath;
                lineCnt.incrementAndGet();
                FileCollector.this.logger.log(Level.FINEST, " Updates check: %s", remoteFile);
                String realPath = (String)FileCollector.this.canonicalToAbsolute.get(remoteFile);
                if (realPath != null) {
                    remoteFile = realPath;
                }
                if ((localPath = FileCollector.this.mapper.getLocalPath(remoteFile)) == null) {
                    FileCollector.this.logger.log(Level.FINE, "Can't find local path for %s", remoteFile);
                } else {
                    File localFile = CndFileUtils.createLocalFile((String)localPath);
                    boolean add = false;
                    if (FileCollector.this.buildResults.contains(localFile)) {
                        add = true;
                    } else if ((FileCollector.this.fileData == null || FileCollector.this.fileData.getFileInfo(localFile) == null) && FileCollector.this.filter.accept(localFile)) {
                        add = true;
                    }
                    if (add) {
                        FileCollector.this.remoteUpdates.add(localFile);
                        RfsListenerSupportImpl.getInstanmce(FileCollector.this.execEnv).fireFileChanged(localFile, remoteFile);
                    }
                }
            }

            public void reset() {
            }

            public void close() {
            }
        };
        ShellScriptRunner ssr = new ShellScriptRunner(this.execEnv, script, lp);
        ssr.setErrorProcessor((LineProcessor)new ShellScriptRunner.LoggerLineProcessor(this.getClass().getSimpleName()));
        int rc = ssr.execute();
        if (rc != 0) {
            this.logger.log(Level.FINE, "Error %d running script \"%s\" at %s", rc, script, this.execEnv);
        }
        this.logger.log(Level.FINE, "New files discovery at %s took %d ms; %d lines processed; %d additional new files were discovered", this.execEnv, System.currentTimeMillis() - time, lineCnt.get(), this.remoteUpdates.size() - oldSize);
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static class FileCollectorInfo {
        public final File file;
        public final String remotePath;
        private String linkTarget;
        private FileCollectorInfo linkTargetInfo;

        public FileCollectorInfo(File file, String remotePath) {
            this.file = file;
            this.remotePath = remotePath;
            CndUtils.assertTrue((boolean)remotePath.startsWith("/"), (String)"Non-absolute remote path: ", (Object)remotePath);
            this.linkTarget = null;
        }

        public String toString() {
            return (this.isLink() ? "L " : (this.file.isDirectory() ? "D " : "F ")) + this.file.getPath() + " -> " + this.remotePath;
        }

        public boolean isLink() {
            return this.linkTarget != null;
        }

        public String getLinkTarget() {
            return this.linkTarget;
        }

        public void setLinkTarget(String link) {
            this.linkTarget = link;
        }

        public FileCollectorInfo getLinkTargetInfo() {
            return this.linkTargetInfo;
        }

        public void setLinkTargetInfo(FileCollectorInfo linkTargetInfo) {
            this.linkTargetInfo = linkTargetInfo;
        }
    }

    private static class DupsPreventer<T> {
        Set<T> set = new HashSet<T>();

        private DupsPreventer() {
        }

        public boolean check(T t) {
            if (this.set.contains(t)) {
                return false;
            }
            this.set.add(t);
            return true;
        }
    }
}

