/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteException;
import org.netbeans.modules.cnd.remote.support.RemoteLogger;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.RfsLocalController;
import org.netbeans.modules.cnd.remote.sync.RfsSetupProvider;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.setup.support.RemoteSyncNotifier;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class RfsSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker {
    private static final RequestProcessor RP = new RequestProcessor("RFS Sync Worker", 20);
    private RfsLocalController localController;
    private RemoteProcessController remoteController;
    private String remoteDir;
    private ErrorReader errorReader;
    private static final String exitFlagFile = System.getProperty("cnd.rfs.controller.exit.flag.file");

    public RfsSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, FileObject privProjectStorageDir, List<FSPath> paths, List<FSPath> buildResults) {
        super(executionEnvironment, out, err, privProjectStorageDir, paths, buildResults);
    }

    public boolean startup(Map<String, String> env2add) {
        boolean success;
        block13: {
            if (SyncUtils.isDoubleRemote(this.executionEnvironment, this.fileSystem)) {
                RemoteSyncNotifier.getInstance().warnDoubleRemote(this.executionEnvironment, this.fileSystem);
                return false;
            }
            RemotePathMap mapper = RemotePathMap.getPathMap(this.executionEnvironment);
            this.remoteDir = mapper.getRemotePath("/", false);
            if (this.remoteDir == null) {
                if (this.err != null) {
                    this.err.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                return false;
            }
            success = false;
            try {
                Future mkDir;
                if (this.out != null) {
                    this.out.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                if ((Integer)(mkDir = CommonTasksSupport.mkDir((ExecutionEnvironment)this.executionEnvironment, (String)this.remoteDir, (Writer)this.err)).get() != 0) {
                    throw new IOException("Can not create directory " + this.remoteDir);
                }
                success = this.startupImpl(env2add);
            }
            catch (RemoteException ex) {
                this.printErr(ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                RemoteUtil.LOGGER.finest(ex.getMessage());
            }
            catch (InterruptedException ex) {
                RemoteUtil.LOGGER.finest(ex.getMessage());
            }
            catch (InterruptedIOException ex) {
                RemoteUtil.LOGGER.finest(ex.getMessage());
            }
            catch (ExecutionException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                if (this.err != null) {
                    this.err.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
                }
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                if (this.err == null) break block13;
                this.err.printf("%s%n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
            }
        }
        return success;
    }

    private void printErr(Exception ex) throws MissingResourceException {
        RemoteUtil.LOGGER.finest(ex.getMessage());
        if (this.err != null) {
            String message = NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage());
            this.err.printf("%s%n", message);
            this.err.printf("%s%n", message);
        }
    }

    private boolean startupImpl(Map<String, String> env2add) throws IOException, InterruptedException, ExecutionException, RemoteException, ConnectionManager.CancellationException {
        String ldLibraryPath;
        String remoteControllerPath;
        try {
            remoteControllerPath = RfsSetupProvider.getControllerPath(this.executionEnvironment);
            CndUtils.assertTrue((remoteControllerPath != null ? 1 : 0) != 0);
            ldLibraryPath = RfsSetupProvider.getLdLibraryPath(this.executionEnvironment);
            CndUtils.assertTrue((ldLibraryPath != null ? 1 : 0) != 0);
        }
        catch (ParseException ex) {
            throw new ExecutionException(ex);
        }
        NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
        this.remoteControllerCleanup();
        pb.setExecutable(remoteControllerPath);
        pb.setWorkingDirectory(this.remoteDir);
        String rfsTrace = System.getProperty("cnd.rfs.controller.trace");
        if (rfsTrace != null) {
            pb.getEnvironment().put("RFS_CONTROLLER_TRACE", rfsTrace);
        }
        if (exitFlagFile != null) {
            pb.getEnvironment().put("RFS_CONTROLLER_EXIT_FLAG_FILE", exitFlagFile);
        }
        NativeProcess remoteControllerProcess = pb.call();
        this.remoteController = new RemoteProcessController(remoteControllerProcess);
        this.errorReader = new ErrorReader(remoteControllerProcess.getErrorStream(), this.err);
        RP.post((Runnable)this.errorReader);
        InputStream rcInputStream = remoteControllerProcess.getInputStream();
        OutputStream rcOutputStream = remoteControllerProcess.getOutputStream();
        BufferedReader rcInputStreamReader = ProcessUtils.getReader((InputStream)rcInputStream, (boolean)this.executionEnvironment.isRemote());
        PrintWriter rcOutputStreamWriter = ProcessUtils.getWriter((OutputStream)rcOutputStream, (boolean)this.executionEnvironment.isRemote());
        this.localController = new RfsLocalController(this.executionEnvironment, this.files, this.buildResults, this.remoteController, rcInputStreamReader, rcOutputStreamWriter, this.err, this.privProjectStorageDir);
        if (!this.localController.init()) {
            remoteControllerProcess.destroy();
            return false;
        }
        String line = rcInputStreamReader.readLine();
        if (line == null || !line.startsWith("PORT ")) {
            if (line == null) {
                int rc = remoteControllerProcess.waitFor();
                throw new ExecutionException(String.format("Remote controller failed; rc=%d%n", rc), null);
            }
            String message = String.format("Protocol error: read \"%s\" expected \"%s\"%n", line, "PORT <port-number>");
            System.err.printf(message, new Object[0]);
            remoteControllerProcess.destroy();
            throw new ExecutionException(message, null);
        }
        String port = line.substring(5);
        RemoteUtil.LOGGER.log(Level.FINE, "Remote Controller listens port {0}", port);
        RP.post((Runnable)((Object)this.localController));
        String preload = RfsSetupProvider.getPreloadName(this.executionEnvironment);
        CndUtils.assertTrue((preload != null ? 1 : 0) != 0);
        if (Boolean.getBoolean("cnd.rfs.discover")) {
            preload = "libdiscover.so:" + preload;
            String studioPath = System.getProperty("cnd.rfs.discover.studio.path", "/opt/solarisstudio12.5");
            ldLibraryPath = studioPath + "/lib/compilers:" + studioPath + "/lib/compilers/amd64:" + ldLibraryPath;
            String discoverFile = System.getProperty("cnd.rfs.discover.file", "/tmp/rfs_preload.%p.log");
            env2add.put("SUNW_DISCOVER_OPTIONS", "-w " + discoverFile);
        }
        env2add.put("LD_PRELOAD", preload);
        String ldLibPathVar = "LD_LIBRARY_PATH";
        String oldLdLibPath = MacroMap.forExecEnv((ExecutionEnvironment)this.executionEnvironment).get(ldLibPathVar);
        if (oldLdLibPath != null) {
            ldLibraryPath = ldLibraryPath + ":" + oldLdLibPath;
        }
        env2add.put(ldLibPathVar, ldLibraryPath);
        env2add.put("RFS_CONTROLLER_DIR", this.remoteDir);
        env2add.put("RFS_CONTROLLER_PORT", port);
        this.addRemoteEnv(env2add, "cnd.rfs.preload.sleep", "RFS_PRELOAD_SLEEP");
        this.addRemoteEnv(env2add, "cnd.rfs.preload.log", "RFS_PRELOAD_LOG");
        this.addRemoteEnv(env2add, "cnd.rfs.controller.log", "RFS_CONTROLLER_LOG");
        this.addRemoteEnv(env2add, "cnd.rfs.controller.port", "RFS_CONTROLLER_PORT");
        this.addRemoteEnv(env2add, "cnd.rfs.controller.host", "RFS_CONTROLLER_HOST");
        this.addRemoteEnv(env2add, "cnd.rfs.preload.trace", "RFS_PRELOAD_TRACE");
        RemoteUtil.LOGGER.fine("Setting environment:");
        return true;
    }

    private void addRemoteEnv(Map<String, String> env2add, String localJavaPropertyName, String remoteEnvVarName) {
        String value = System.getProperty(localJavaPropertyName, null);
        if (value != null) {
            env2add.put(remoteEnvVarName, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        RfsLocalController lc;
        RfsSyncWorker rfsSyncWorker = this;
        synchronized (rfsSyncWorker) {
            lc = this.localController;
        }
        this.remoteControllerCleanup();
        this.localControllerCleanup();
        this.refreshRemoteFs();
        lc.waitShutDownFinished();
    }

    public boolean cancel() {
        return false;
    }

    private void refreshRemoteFs() {
        RemotePathMap mapper = RemotePathMap.getPathMap(this.executionEnvironment);
        ArrayList<String> remoteDirs = new ArrayList<String>(this.files.length);
        for (File file : this.files) {
            String path;
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file == null || (path = mapper.getRemotePath(file.getAbsolutePath())) == null) continue;
            remoteDirs.add(path);
        }
        FileSystemProvider.scheduleRefresh((ExecutionEnvironment)this.executionEnvironment, remoteDirs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localControllerCleanup() {
        RfsSyncWorker rfsSyncWorker = this;
        synchronized (rfsSyncWorker) {
            this.localController = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteControllerCleanup() {
        RemoteProcessController rc;
        ErrorReader r = this.errorReader;
        if (r != null) {
            r.stop();
        }
        RfsSyncWorker rfsSyncWorker = this;
        synchronized (rfsSyncWorker) {
            rc = this.remoteController;
            this.remoteController = null;
        }
        if (rc != null) {
            rc.stop();
        }
    }

    static class RemoteProcessController {
        private final NativeProcess remoteControllerProcess;
        private final AtomicBoolean stopped = new AtomicBoolean(false);

        RemoteProcessController(NativeProcess remoteControllerProcess) {
            this.remoteControllerProcess = remoteControllerProcess;
        }

        boolean isAlive() {
            return ProcessUtils.isAlive((Process)this.remoteControllerProcess);
        }

        boolean isStopped() {
            return this.stopped.get();
        }

        private void stopViaFlag() {
            try {
                ExecutionEnvironment env = this.remoteControllerProcess.getExecutionEnvironment();
                RemoteLogger.info("Stopping remote controller via flag: {0}", exitFlagFile);
                CommonTasksSupport.mkDir((ExecutionEnvironment)env, (String)exitFlagFile, null).get();
                RemoteLogger.info("Waiting for remote controller to finish... ", new Object[0]);
                this.remoteControllerProcess.waitFor();
                RemoteLogger.info("Remote controller has finished", new Object[0]);
                RemoteLogger.info("Remvoing flag file: {0}", exitFlagFile);
                CommonTasksSupport.rmDir((ExecutionEnvironment)env, (String)exitFlagFile, (boolean)true, null);
                RemoteLogger.info("Stopping remote controller via flag: {0}", exitFlagFile);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace(System.err);
            }
            catch (ExecutionException ex) {
                ex.printStackTrace(System.err);
            }
        }

        void stop() {
            this.stopped.set(true);
            if (exitFlagFile != null) {
                this.stopViaFlag();
                return;
            }
            this.remoteControllerProcess.destroy();
        }
    }

    private static class ErrorReader
    implements Runnable {
        private final InputStream errorStream;
        private final PrintWriter errorWriter;
        private final AtomicBoolean stopped;

        public ErrorReader(InputStream errorStream, PrintWriter errorWriter) {
            this.errorStream = errorStream;
            this.errorWriter = errorWriter;
            this.stopped = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            BufferedReader errorReader = null;
            try {
                String line;
                errorReader = new BufferedReader(new InputStreamReader(this.errorStream, "UTF-8"));
                while ((line = errorReader.readLine()) != null) {
                    if (this.stopped.get()) {
                        break;
                    }
                    if (this.errorWriter != null) {
                        this.errorWriter.println(line);
                    }
                    RemoteUtil.LOGGER.fine(line);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (errorReader != null) {
                    try {
                        errorReader.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            }
        }

        private void stop() {
            this.stopped.set(true);
        }
    }
}

