/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.FileFilter;
import java.util.logging.Level;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FileObjectFilter;
import org.openide.filesystems.FileObject;

public final class SharabilityFilter
implements FileFilter,
FileObjectFilter {
    private static final boolean TRACE_SHARABILITY = Boolean.getBoolean("cnd.remote.trace.sharability");

    @Override
    public final boolean accept(File file) {
        File parent;
        if (file.getName().equals("private") && (parent = file.getParentFile()) != null && parent.getName().equals("nbproject")) {
            return true;
        }
        int sharability = SharabilityQuery.getSharability((File)file);
        if (TRACE_SHARABILITY) {
            RemoteUtil.LOGGER.log(Level.INFO, "{0} sharability is {1}", new Object[]{file.getAbsolutePath(), SharabilityFilter.sharabilityToString(sharability)});
        }
        switch (sharability) {
            case 2: {
                return false;
            }
            case 0: 
            case 1: 
            case 3: {
                return true;
            }
        }
        CndUtils.assertTrueInConsole((boolean)false, (String)("Unexpected sharability value: " + sharability));
        return true;
    }

    public final boolean accept(FileObject file) {
        FileObject parent;
        if (file.getNameExt().equals("private") && (parent = file.getParent()) != null && parent.getNameExt().equals("nbproject")) {
            return true;
        }
        SharabilityQuery.Sharability sharability = SharabilityQuery.getSharability((FileObject)file);
        if (TRACE_SHARABILITY) {
            RemoteUtil.LOGGER.log(Level.INFO, "{0} sharability is {1}", new Object[]{file.getPath(), SharabilityFilter.sharabilityToString(sharability)});
        }
        switch (sharability) {
            case NOT_SHARABLE: {
                return false;
            }
            case MIXED: 
            case SHARABLE: 
            case UNKNOWN: {
                return true;
            }
        }
        CndUtils.assertTrueInConsole((boolean)false, (String)("Unexpected sharability value: " + sharability));
        return true;
    }

    private static String sharabilityToString(int sharability) {
        switch (sharability) {
            case 2: {
                return "NOT_SHARABLE";
            }
            case 3: {
                return "MIXED";
            }
            case 1: {
                return "SHARABLE";
            }
            case 0: {
                return "UNKNOWN";
            }
        }
        return "UNEXPECTED: " + sharability;
    }

    private static String sharabilityToString(SharabilityQuery.Sharability sharability) {
        switch (sharability) {
            case NOT_SHARABLE: {
                return "NOT_SHARABLE";
            }
            case MIXED: {
                return "MIXED";
            }
            case SHARABLE: {
                return "SHARABLE";
            }
            case UNKNOWN: {
                return "UNKNOWN";
            }
        }
        return "UNEXPECTED: " + sharability;
    }
}

