/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.compiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.toolchain.support.CompilerDefinition;
import org.netbeans.modules.cnd.toolchain.ui.compiler.CodeAssistancePanelController;
import org.netbeans.modules.cnd.toolchain.ui.compiler.ParserSettingsPanel;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PredefinedPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor("Reset Compiler Settings", 2);
    private IncludesPanel includesPanel;
    private DefinitionsPanel definitionsPanel;
    private AbstractCompiler compiler;
    private final ParserSettingsPanel parserSettingsPanel;
    private ExecutionEnvironment env;
    private boolean settingsReseted = false;
    private JPanel includes;
    private JLabel jLabel1;
    private JPanel macros;
    private JButton resetButton;

    public PredefinedPanel(AbstractCompiler compiler, ParserSettingsPanel parserSettingsPanel, ExecutionEnvironment env) {
        this.initComponents();
        this.compiler = compiler;
        this.parserSettingsPanel = parserSettingsPanel;
        this.env = env;
        this.updatePanels(false);
        this.resetButton.getAccessibleContext().setAccessibleDescription(PredefinedPanel.getString("RESET_BUTTON_AD"));
    }

    private void updatePanels(final boolean reset) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (reset) {
                    PredefinedPanel.this.compiler.resetCompilerDefinitions();
                }
                final List includesList = PredefinedPanel.this.compiler.getSystemIncludeDirectories();
                final List definesList = PredefinedPanel.this.compiler.getSystemPreprocessorSymbols();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PredefinedPanel.this.includesPanel != null) {
                            PredefinedPanel.this.includes.remove((Component)((Object)PredefinedPanel.this.includesPanel));
                        }
                        PredefinedPanel.this.includes.add((Component)((Object)(PredefinedPanel.this.includesPanel = new IncludesPanel(includesList, PredefinedPanel.this.env))));
                        if (definesList instanceof CompilerDefinition) {
                            ((CompilerDefinition)definesList).sort();
                        } else {
                            Collections.sort(definesList, new Comparator<String>(){

                                @Override
                                public int compare(String s1, String s2) {
                                    return s1.compareToIgnoreCase(s2);
                                }
                            });
                        }
                        if (PredefinedPanel.this.definitionsPanel != null) {
                            PredefinedPanel.this.macros.remove((Component)((Object)PredefinedPanel.this.definitionsPanel));
                        }
                        PredefinedPanel.this.macros.add((Component)((Object)(PredefinedPanel.this.definitionsPanel = new DefinitionsPanel(definesList))));
                        if (reset) {
                            PredefinedPanel.this.parserSettingsPanel.setModified(true);
                            PredefinedPanel.this.settingsReseted = true;
                        }
                        PredefinedPanel.this.validate();
                        PredefinedPanel.this.repaint();
                    }
                });
            }
        });
    }

    public boolean save() {
        boolean wasChanges = this.settingsReseted;
        this.settingsReseted = false;
        if (this.includesPanel != null && this.definitionsPanel != null) {
            List tmpIncludes = this.includesPanel.getListData();
            wasChanges |= this.compiler.setSystemIncludeDirectories(tmpIncludes);
            List definitions = this.definitionsPanel.getListData();
            wasChanges |= this.compiler.setSystemPreprocessorSymbols(definitions);
        }
        return wasChanges;
    }

    public void update() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("update for PredefinedPanel " + this.compiler.getName());
        }
        this.updatePanels(false);
    }

    public void updateCompiler(AbstractCompiler compiler, ExecutionEnvironment env) {
        this.compiler = compiler;
        this.env = env;
        this.updatePanels(false);
    }

    private void initComponents() {
        this.includes = new JPanel();
        this.macros = new JPanel();
        this.jLabel1 = new JLabel();
        this.resetButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.includes.setOpaque(false);
        this.includes.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.includes, gridBagConstraints);
        this.macros.setOpaque(false);
        this.macros.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.macros, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/compiler/Bundle");
        this.jLabel1.setText(bundle.getString("CODE_ASSISTANCE_COMMENT"));
        this.jLabel1.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)bundle.getString("RESET_BUTTON_TXT"));
        this.resetButton.setOpaque(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PredefinedPanel.this.resetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.resetButton, gridBagConstraints);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.updatePanels(true);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(PredefinedPanel.class, (String)s);
    }

    boolean isChanged() {
        boolean isChanged = this.settingsReseted;
        if (this.includesPanel != null) {
            isChanged |= !this.compiler.getSystemIncludeDirectories().equals(this.includesPanel.getListData());
        }
        if (this.definitionsPanel != null) {
            isChanged |= !this.compiler.getSystemPreprocessorSymbols().equals(this.definitionsPanel.getListData());
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isChanged for PredefinedPanel " + this.compiler.getName() + " is " + isChanged);
        }
        return isChanged;
    }

    boolean isDataValid() {
        boolean isDataValid = true;
        if (this.includesPanel != null) {
            isDataValid &= this.includesPanel.isDataValid();
        }
        if (this.definitionsPanel != null) {
            isDataValid &= this.definitionsPanel.isDataValid();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isDataValid for PredefinedPanel " + this.compiler.getName() + " is " + isDataValid);
        }
        return isDataValid;
    }

    void cancel() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("cancel for PredefinedPanel " + this.compiler.getName());
        }
    }

    private static final class MyDefaultListCellRenderer
    extends DefaultListCellRenderer {
        private final CompilerDefinition defs;
        private final String toolTipSuffix;

        MyDefaultListCellRenderer(CompilerDefinition defs, String toolTipSuffix) {
            this.defs = defs;
            this.toolTipSuffix = toolTipSuffix;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            boolean showToolTip = false;
            if (this.defs != null && this.defs.isUserAdded(index)) {
                label.setIcon(this.getLibraryIcon());
                showToolTip = true;
            }
            label.setText(value.toString());
            if (showToolTip) {
                String message = NbBundle.getMessage(PredefinedPanel.class, (String)("UserAdded.tooltip.text." + this.toolTipSuffix), (Object)value.toString());
                label.setToolTipText(message);
            } else {
                label.setToolTipText(null);
            }
            return label;
        }

        private ImageIcon getLibraryIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/toolchain/ui/compiler/key.png", (boolean)false);
        }
    }

    private static class DefinitionsPanel
    extends ListEditorPanel<String> {
        private CompilerDefinition defs;

        public DefinitionsPanel(List<String> objects) {
            super(objects);
            if (objects instanceof CompilerDefinition) {
                this.defs = (CompilerDefinition)objects;
                this.setCustomCellRenderer(new MyDefaultListCellRenderer(this.defs, "macro"));
            }
            this.getDefaultButton().setVisible(false);
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            this.getCopyButton().setVisible(false);
        }

        public String addAction() {
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDef"), PredefinedPanel.getString("AddDialogTitle"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            String def = notifyDescriptor.getInputText().trim();
            if (def.length() != 0) {
                if (this.defs != null) {
                    this.defs.setUserAdded(true, this.getListDataSize());
                }
                return def;
            }
            return null;
        }

        public String getListLabelText() {
            return PredefinedPanel.getString("MacroDefinitionsTxt");
        }

        public char getListLabelMnemonic() {
            return PredefinedPanel.getString("MacroDefinitionsMn").charAt(0);
        }

        public String getAddButtonText() {
            return PredefinedPanel.getString("AddButtonTxt");
        }

        public char getAddButtonMnemonics() {
            return PredefinedPanel.getString("MAddButtonMn").charAt(0);
        }

        public char getRenameButtonMnemonics() {
            return PredefinedPanel.getString("MEditButtonMn").charAt(0);
        }

        public String getRenameButtonText() {
            return PredefinedPanel.getString("EditButtonTxt");
        }

        public void editAction(String o, int i) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDef"), PredefinedPanel.getString("EditDialogTitle"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText().trim();
            if (this.defs != null) {
                this.defs.setUserAdded(true, i);
            }
            this.replaceElement(o, newS, i);
        }

        public char getRemoveButtonMnemonics() {
            return PredefinedPanel.getString("MRemoveButtonMn").charAt(0);
        }

        public void removeAction(String o, int i) {
            if (this.defs != null) {
                this.defs.setUserAdded(false, i);
                for (int j = i; j < this.getListDataSize() - 1; ++j) {
                    boolean userAdded = this.defs.isUserAdded(j + 1);
                    this.defs.setUserAdded(userAdded, j);
                    this.defs.setUserAdded(false, j + 1);
                }
            }
        }
    }

    private static class IncludesPanel
    extends ListEditorPanel<String> {
        private CompilerDefinition defs;
        private final ExecutionEnvironment env;

        public IncludesPanel(List<String> objects, ExecutionEnvironment env) {
            super(objects);
            this.env = env;
            if (objects instanceof CompilerDefinition) {
                this.defs = (CompilerDefinition)objects;
                this.setCustomCellRenderer(new MyDefaultListCellRenderer(this.defs, "include"));
            }
            this.getDefaultButton().setVisible(false);
        }

        public String addAction() {
            JFileChooser fileChooser;
            int ret;
            String chooser_key = "IncludesPanel";
            String seed = RemoteFileChooserUtil.getCurrentChooserFile((String)"IncludesPanel", (ExecutionEnvironment)this.env);
            if (seed == null) {
                seed = System.getProperty("user.home");
            }
            if ((ret = (fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)this.env, (String)PredefinedPanel.getString("SelectDirectoryTxt"), (String)PredefinedPanel.getString("SelectTxt"), (int)1, null, (String)seed, (boolean)true)).showOpenDialog((Component)((Object)this))) == 1) {
                return null;
            }
            File selectedFile = fileChooser.getSelectedFile();
            String itemPath = selectedFile.getPath();
            RemoteFileChooserUtil.setCurrentChooserFile((String)"IncludesPanel", (String)(selectedFile.isFile() ? selectedFile.getParentFile().getPath() : itemPath), (ExecutionEnvironment)this.env);
            if (this.defs != null) {
                this.defs.setUserAdded(true, this.getListDataSize());
            }
            return itemPath;
        }

        public String getListLabelText() {
            return PredefinedPanel.getString("IncludeDirectoriesTxt");
        }

        public char getListLabelMnemonic() {
            return PredefinedPanel.getString("IncludeDirectoriesMn").charAt(0);
        }

        public String getAddButtonText() {
            return PredefinedPanel.getString("AddButtonTxt");
        }

        public char getAddButtonMnemonics() {
            return PredefinedPanel.getString("IAddButtonMn").charAt(0);
        }

        public char getCopyButtonMnemonics() {
            return PredefinedPanel.getString("ICopyButtonMn").charAt(0);
        }

        public String copyAction(String o) {
            if (this.defs != null) {
                this.defs.setUserAdded(true, this.getListDataSize());
            }
            return o;
        }

        public String getRenameButtonText() {
            return PredefinedPanel.getString("EditButtonTxt");
        }

        public char getRenameButtonMnemonics() {
            return PredefinedPanel.getString("EditButtonMn").charAt(0);
        }

        public void editAction(String o, int i) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDir"), PredefinedPanel.getString("EditDialogTitle"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText().trim();
            if (this.defs != null) {
                this.defs.setUserAdded(true, i);
            }
            this.replaceElement(o, newS, i);
        }

        public char getRemoveButtonMnemonics() {
            return PredefinedPanel.getString("IRemoveButtonMn").charAt(0);
        }

        public void removeAction(String o, int i) {
            if (this.defs != null) {
                this.defs.setUserAdded(false, i);
                for (int j = i; j < this.getListDataSize() - 1; ++j) {
                    boolean userAdded = this.defs.isUserAdded(j + 1);
                    this.defs.setUserAdded(userAdded, j);
                    this.defs.setUserAdded(false, j + 1);
                }
            }
        }

        public char getUpButtonMnemonics() {
            return PredefinedPanel.getString("IUpButtonMn").charAt(0);
        }

        public void upAction(int from) {
            if (this.defs != null) {
                boolean fromValue = this.defs.isUserAdded(from);
                boolean toValue = this.defs.isUserAdded(from - 1);
                this.defs.setUserAdded(fromValue, from - 1);
                this.defs.setUserAdded(toValue, from);
            }
        }

        public char getDownButtonMnemonics() {
            return PredefinedPanel.getString("IDownButtonMn").charAt(0);
        }

        public void downAction(int from) {
            if (this.defs != null) {
                boolean fromValue = this.defs.isUserAdded(from);
                boolean toValue = this.defs.isUserAdded(from + 1);
                this.defs.setUserAdded(fromValue, from + 1);
                this.defs.setUserAdded(toValue, from);
            }
        }
    }
}

