/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.InputReader;
import org.netbeans.api.extexecution.input.InputReaderTask;
import org.netbeans.api.extexecution.input.InputReaders;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class JBOutputSupport {
    private static final Logger LOGGER = Logger.getLogger(JBOutputSupport.class.getName());
    private static final ExecutionDescriptor DESCRIPTOR = new ExecutionDescriptor().frontWindow(true).inputVisible(true);
    private static final Map<InstanceProperties, JBOutputSupport> INSTANCE_CACHE = new HashMap<InstanceProperties, JBOutputSupport>();
    private static final ExecutorService PROFILER_SERVICE = Executors.newCachedThreadPool();
    private static final ExecutorService LOG_FILE_SERVICE = Executors.newCachedThreadPool();
    private static final Pattern JBOSS_7_STARTED_ML = Pattern.compile(".*JBoss AS 7(\\..*)* \\d+ms .*");
    private final InstanceProperties props;
    private boolean started;
    private boolean failed;
    private Future<Integer> processTask;
    private Future<?> profileCheckTask;
    private InputReaderTask fileTask;

    private JBOutputSupport(InstanceProperties props) {
        this.props = props;
    }

    public static synchronized JBOutputSupport getInstance(InstanceProperties props, boolean create) {
        JBOutputSupport instance = INSTANCE_CACHE.get(props);
        if (instance == null && create) {
            instance = new JBOutputSupport(props);
            INSTANCE_CACHE.put(props, instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InputOutput io, final Process serverProcess, final boolean profiler) {
        this.reset();
        ExecutionDescriptor descriptor = DESCRIPTOR.inputOutput(io);
        descriptor = descriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)new StartLineProcessor(profiler))});
            }
        });
        descriptor = descriptor.errProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, InputProcessors.bridge((LineProcessor)new StartLineProcessor(profiler))});
            }
        });
        descriptor = descriptor.postExecution(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<JBOutputSupport> clazz = JBOutputSupport.class;
                synchronized (JBOutputSupport.class) {
                    INSTANCE_CACHE.remove(JBOutputSupport.this.props);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        ExecutionService service = ExecutionService.newService((Callable)new Callable<Process>(){

            @Override
            public Process call() throws Exception {
                return serverProcess;
            }
        }, (ExecutionDescriptor)descriptor, (String)this.props.getProperty("displayName"));
        Future localProcessTask = service.run();
        JBOutputSupport jBOutputSupport = this;
        synchronized (jBOutputSupport) {
            if (profiler) {
                this.profileCheckTask = PROFILER_SERVICE.submit(new ProfilerCheckTask());
            }
            this.processTask = localProcessTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(InputOutput io, File file) {
        this.reset();
        InputReader reader = InputReaders.forFile((File)file, (Charset)Charset.defaultCharset());
        InputReaderTask localFileTask = InputReaderTask.newTask((InputReader)reader, (InputProcessor)InputProcessors.printing((OutputWriter)io.getOut(), (boolean)false));
        LOG_FILE_SERVICE.submit((Runnable)localFileTask);
        JBOutputSupport jBOutputSupport = this;
        synchronized (jBOutputSupport) {
            this.fileTask = localFileTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object;
        try {
            object = this;
            synchronized (object) {
                if (this.processTask != null) {
                    this.processTask.cancel(true);
                } else if (this.fileTask != null) {
                    this.fileTask.cancel();
                }
                if (this.profileCheckTask != null) {
                    this.profileCheckTask.cancel(true);
                }
                this.started = false;
                this.failed = false;
                this.processTask = null;
                this.profileCheckTask = null;
                this.fileTask = null;
            }
        }
        finally {
            object = JBOutputSupport.class;
            synchronized (JBOutputSupport.class) {
                INSTANCE_CACHE.remove(this.props);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
    }

    public boolean waitForStart(long timeout) throws TimeoutException, InterruptedException {
        JBOutputSupport jBOutputSupport = this;
        synchronized (jBOutputSupport) {
            if (this.processTask == null) {
                return this.fileTask != null;
                {
                }
            }
            while (!this.started && !this.failed) {
                this.wait(timeout);
            }
            if (this.started) {
                return true;
            }
            if (this.failed) {
                return false;
            }
            if (this.profileCheckTask != null) {
                this.profileCheckTask.cancel(true);
            }
            throw new TimeoutException("Expired timeout " + timeout + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStop(long timeout) throws TimeoutException, InterruptedException, ExecutionException {
        Future<Integer> localProcessTask;
        JBOutputSupport jBOutputSupport = this;
        synchronized (jBOutputSupport) {
            localProcessTask = this.processTask;
        }
        if (localProcessTask == null) {
            return;
        }
        localProcessTask.get(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        JBOutputSupport jBOutputSupport = this;
        synchronized (jBOutputSupport) {
            if (this.fileTask != null) {
                this.fileTask.cancel();
            }
            if (this.started) {
                LOGGER.log(Level.INFO, "Instance {0} started again without proper stop", this.props.getProperty("displayName"));
            }
            this.started = false;
            this.failed = false;
            this.processTask = null;
            this.profileCheckTask = null;
            this.fileTask = null;
        }
    }

    private static boolean isProfilerReady() {
        int state = ProfilerSupport.getState();
        return state == 2 || state == 3 || state == 4;
    }

    private static boolean isProfilerInactive() {
        return ProfilerSupport.getState() == 0;
    }

    private class ProfilerCheckTask
    implements Runnable {
        private ProfilerCheckTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (JBOutputSupport.isProfilerReady()) {
                    JBOutputSupport jBOutputSupport = JBOutputSupport.this;
                    synchronized (jBOutputSupport) {
                        JBOutputSupport.this.started = true;
                        JBOutputSupport.this.notifyAll();
                        break;
                    }
                }
                if (JBOutputSupport.isProfilerInactive()) {
                    JBOutputSupport jBOutputSupport = JBOutputSupport.this;
                    synchronized (jBOutputSupport) {
                        JBOutputSupport.this.failed = true;
                        JBOutputSupport.this.notifyAll();
                        break;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                    break;
                }
            }
        }
    }

    private class StartLineProcessor
    implements LineProcessor {
        private final boolean profiler;
        private boolean check = true;

        public StartLineProcessor(boolean profiler) {
            this.profiler = profiler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            if (!this.check) {
                return;
            }
            JBOutputSupport jBOutputSupport = JBOutputSupport.this;
            synchronized (jBOutputSupport) {
                if (JBOutputSupport.this.started) {
                    this.check = false;
                    return;
                }
            }
            if (this.profiler) {
                if (JBOutputSupport.isProfilerReady()) {
                    jBOutputSupport = JBOutputSupport.this;
                    synchronized (jBOutputSupport) {
                        JBOutputSupport.this.started = true;
                        JBOutputSupport.this.notifyAll();
                    }
                    this.check = false;
                } else if (JBOutputSupport.isProfilerInactive()) {
                    jBOutputSupport = JBOutputSupport.this;
                    synchronized (jBOutputSupport) {
                        JBOutputSupport.this.failed = true;
                        JBOutputSupport.this.notifyAll();
                    }
                    this.check = false;
                }
            }
            if (line.indexOf("Starting JBoss (MX MicroKernel)") > -1 || line.indexOf("Starting JBoss (Microcontainer)") > -1 || line.indexOf("Starting JBossAS") > -1) {
                LOGGER.log(Level.FINER, "STARTING message fired");
            } else if ((line.indexOf("JBoss (MX MicroKernel)") > -1 || line.indexOf("JBoss (Microcontainer)") > -1 || line.indexOf("JBossAS") > -1 || line.indexOf("JBoss AS") > -1) && line.indexOf("Started in") > -1 || line.indexOf("started in") > -1 || line.indexOf("started (with errors) in") > -1 || JBOSS_7_STARTED_ML.matcher(line).matches()) {
                LOGGER.log(Level.FINER, "STARTED message fired");
                jBOutputSupport = JBOutputSupport.this;
                synchronized (jBOutputSupport) {
                    JBOutputSupport.this.started = true;
                    JBOutputSupport.this.notifyAll();
                }
                this.check = false;
            } else if (line.indexOf("Shutdown complete") > -1) {
                jBOutputSupport = JBOutputSupport.this;
                synchronized (jBOutputSupport) {
                    JBOutputSupport.this.failed = true;
                    JBOutputSupport.this.notifyAll();
                }
                this.check = false;
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

