/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ForeignKeyListNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Ordering;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class IndexColumnNode
extends BaseNode {
    private static final String ICONDOWN = "org/netbeans/modules/db/resources/indexDown.gif";
    private static final String ICONUP = "org/netbeans/modules/db/resources/indexUp.gif";
    private static final String FOLDER = "IndexColumn";
    private String name = "";
    private String icon = "";
    private int position = 0;
    private MetadataElementHandle<IndexColumn> indexColumnHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static IndexColumnNode create(NodeDataLookup dataLookup, NodeProvider provider) {
        IndexColumnNode node = new IndexColumnNode(dataLookup, provider);
        node.setup();
        return node;
    }

    private IndexColumnNode(NodeDataLookup lookup, NodeProvider provider) {
        super(lookup, FOLDER, provider);
        this.indexColumnHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        IndexColumn column = (IndexColumn)IndexColumnNode.this.indexColumnHandle.resolve(metaData);
                        IndexColumnNode.this.name = column.getName();
                        if (column.getOrdering() == Ordering.DESCENDING) {
                            IndexColumnNode.this.icon = IndexColumnNode.ICONUP;
                        } else {
                            IndexColumnNode.this.icon = IndexColumnNode.ICONDOWN;
                        }
                        IndexColumnNode.this.position = column.getPosition();
                        IndexColumnNode.this.updateProperties(column);
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(IndexColumn column) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        this.addProperty("Position", "PositionDescription", Integer.class, false, column.getPosition());
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getIconBase() {
        return this.icon;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ForeignKeyListNode.class, (String)"ND_Column");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IndexColumnNode.class);
    }
}

