/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.samples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class SampleProjectGenerator {
    public static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/web-project/3";
    public static final String JSPC_CLASSPATH = "jspc.classpath";
    private static final List<Set<String>> EQUIVALENT_SERVERS = new ArrayList<Set<String>>();

    private SampleProjectGenerator() {
    }

    public static FileObject createProjectFromTemplate(FileObject template, File projectLocation, String name) throws IOException {
        assert (template != null && projectLocation != null && name != null);
        FileObject prjLoc = SampleProjectGenerator.createProjectFolder(projectLocation);
        if (template.getExt().endsWith("zip")) {
            SampleProjectGenerator.unzip(template.getInputStream(), prjLoc);
            try {
                File projXml = FileUtil.toFile((FileObject)prjLoc.getFileObject("nbproject/project.xml"));
                Document doc = XMLUtil.parse((InputSource)new InputSource(projXml.toURI().toString()), (boolean)false, (boolean)true, null, null);
                NodeList nlist = doc.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                if (nlist != null) {
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        Node n = nlist.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element e = (Element)n;
                        SampleProjectGenerator.replaceText(e, name);
                    }
                    SampleProjectGenerator.saveXml(doc, prjLoc, "nbproject/project.xml");
                }
                SampleProjectGenerator.configureServer(prjLoc);
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
            prjLoc.refresh(false);
        }
        return prjLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureServer(FileObject prjLoc) throws IOException {
        FileObject projProps = prjLoc.getFileObject("nbproject/project.properties");
        if (projProps == null || !projProps.canRead() || !projProps.canWrite()) {
            return;
        }
        BufferedInputStream is = new BufferedInputStream(projProps.getInputStream());
        Properties props = new Properties();
        try {
            props.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        boolean changed = false;
        String server = props.getProperty("j2ee.server.type");
        if (Deployment.getDefault().getInstancesOfServer(server).length == 0) {
            block6: for (Set<String> servers : EQUIVALENT_SERVERS) {
                if (!servers.contains(server)) continue;
                for (String serverCandidate : servers) {
                    if (serverCandidate.equals(server) || Deployment.getDefault().getInstancesOfServer(serverCandidate).length <= 0) continue;
                    props.setProperty("j2ee.server.type", serverCandidate);
                    changed = true;
                    continue block6;
                }
            }
        }
        if (changed) {
            BufferedOutputStream os = new BufferedOutputStream(projProps.getOutputStream());
            try {
                props.store(os, null);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    private static FileObject createProjectFolder(File projectFolder) throws IOException {
        FileObject projLoc;
        Stack<String> nameStack = new Stack<String>();
        while ((projLoc = FileUtil.toFileObject((File)projectFolder)) == null) {
            nameStack.push(projectFolder.getName());
            projectFolder = projectFolder.getParentFile();
        }
        while (!nameStack.empty()) {
            projLoc = projLoc.createFolder((String)nameStack.pop());
            assert (projLoc != null);
        }
        return projLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, FileObject targetFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(source);
        try {
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                if (ent.isDirectory()) {
                    FileUtil.createFolder((FileObject)targetFolder, (String)ent.getName());
                    continue;
                }
                FileObject destFile = FileUtil.createData((FileObject)targetFolder, (String)ent.getName());
                FileLock lock = destFile.lock();
                try {
                    OutputStream out = destFile.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)zip, (OutputStream)out);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private static void replaceText(Element parent, String name) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            text.setNodeValue(name);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try {
            OutputStream os = xml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    static {
        LinkedHashSet<String> gf = new LinkedHashSet<String>();
        gf.add("gfv3ee6");
        gf.add("gfv3ee6wc");
        EQUIVALENT_SERVERS.add(gf);
    }
}

