/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.actions.SyncDocumentRegion;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class InstantRenamePerformer
implements DocumentListener,
KeyListener,
FocusListener {
    private static final String POSITION_BAG = "CndInstantRenamePerformer";
    private SyncDocumentRegion region;
    private Document doc;
    private JTextComponent target;
    private final PositionsBag bag;
    private boolean inSync;
    private static InstantRenamePerformer instance = null;
    private static final AttributeSet COLORING = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.red});

    InstantRenamePerformer(JTextComponent target, Collection<CsmReference> highlights, int caretOffset) throws BadLocationException {
        this.target = target;
        this.doc = target.getDocument();
        MutablePositionRegion mainRegion = null;
        ArrayList<MutablePositionRegion> regions = new ArrayList<MutablePositionRegion>();
        this.bag = new PositionsBag(this.doc);
        for (CsmReference h : highlights) {
            AttributeSet attribs;
            Position end;
            Position start = NbDocument.createPosition((Document)this.doc, (int)h.getStartOffset(), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion current = new MutablePositionRegion(start, end = NbDocument.createPosition((Document)this.doc, (int)h.getEndOffset(), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(current, caretOffset)) {
                mainRegion = current;
                attribs = InstantRenamePerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext");
            } else {
                regions.add(current);
                attribs = InstantRenamePerformer.getSyncedTextBlocksHighlight("synchronized-text-blocks-ext-slave");
            }
            Color foreground = (Color)attribs.getAttribute(StyleConstants.Foreground);
            Color background = (Color)attribs.getAttribute(StyleConstants.Background);
            AttributeSet attribsAll = InstantRenamePerformer.createAttributeSet(StyleConstants.Background, background, EditorStyleConstants.LeftBorderLineColor, foreground, EditorStyleConstants.RightBorderLineColor, foreground, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
            this.bag.addHighlight(start, end, attribsAll);
        }
        if (mainRegion == null) {
            Logger.getLogger(InstantRenamePerformer.class.getName()).log(Level.WARNING, "No highlight contains the caret ({0}; highlights={1})", new Object[]{caretOffset, highlights});
            if (regions.size() > 0) {
                mainRegion = (MutablePositionRegion)regions.get(0);
                int mainDistance = Integer.MAX_VALUE;
                for (MutablePositionRegion r : regions) {
                    int distance = caretOffset < r.getStartOffset() ? r.getStartOffset() - caretOffset : caretOffset - r.getEndOffset();
                    if (distance >= mainDistance) continue;
                    mainRegion = r;
                    mainDistance = distance;
                }
            } else {
                return;
            }
        }
        regions.add(0, mainRegion);
        this.region = new SyncDocumentRegion(this.doc, regions);
        if (this.doc instanceof BaseDocument) {
            BaseDocument bdoc = (BaseDocument)this.doc;
            bdoc.addPostModificationDocumentListener((DocumentListener)this);
        }
        target.addFocusListener(this);
        target.addKeyListener(this);
        target.putClientProperty(InstantRenamePerformer.class, this);
        InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        target.select(mainRegion.getStartOffset(), mainRegion.getEndOffset());
    }

    private static String getString(String key) {
        return NbBundle.getMessage(InstantRenamePerformer.class, (String)key);
    }

    public static void invokeInstantRename(JTextComponent target) {
        try {
            Collection<CsmReference> changePoints;
            int caret = target.getCaretPosition();
            Document doc = target.getDocument();
            DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
            CsmFile file = CsmUtilities.getCsmFile((DataObject)dobj, (boolean)false, (boolean)false);
            if (file == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)InstantRenamePerformer.getString("no-instant-rename"));
                return;
            }
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(file, doc, caret);
            if (ref == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)InstantRenamePerformer.getString("no-instant-rename"));
                return;
            }
            boolean doFullRename = true;
            if (InstantRenamePerformer.allowInstantRename(ref, dobj.getPrimaryFile()) && !(changePoints = InstantRenamePerformer.computeChangePoints(ref)).isEmpty()) {
                doFullRename = false;
                InstantRenamePerformer.doInstantRename(changePoints, target, caret);
            }
            if (doFullRename) {
                InstantRenamePerformer.doFullRename(dobj, target, ref);
            }
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static boolean allowInstantRename(CsmReference ref, FileObject fo) {
        if (CsmRefactoringUtils.isRefactorable(fo)) {
            return InstantRenamePerformer.allowInstantRename(ref);
        }
        return false;
    }

    static boolean allowInstantRename(CsmReference ref) {
        CsmReferenceResolver.Scope scope = CsmReferenceResolver.getDefault().fastCheckScope(ref);
        if (scope == CsmReferenceResolver.Scope.LOCAL) {
            return true;
        }
        if (scope == CsmReferenceResolver.Scope.FILE_LOCAL) {
            return CsmIncludeHierarchyResolver.getDefault().getFiles(ref.getContainingFile()).isEmpty();
        }
        return false;
    }

    private static void doFullRename(DataObject dobj, JTextComponent target, CsmReference ref) {
        EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        Node n = dobj.getNodeDelegate();
        if (n == null) {
            Utilities.setStatusBoldText((JTextComponent)target, (String)InstantRenamePerformer.getString("no-instant-rename"));
            return;
        }
        InstanceContent ic = new InstanceContent();
        if (ec != null) {
            ic.add((Object)ec);
        }
        ic.add((Object)n);
        ic.add((Object)ref);
        AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
        Action a = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)actionContext);
        a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    private static void doInstantRename(Collection<CsmReference> changePoints, JTextComponent target, int caret) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(target, changePoints, caret);
    }

    static Collection<CsmReference> computeChangePoints(CsmReference ref) {
        CsmObject resolved = ref.getReferencedObject();
        if (resolved == null) {
            return Collections.emptyList();
        }
        CsmFile file = ref.getContainingFile();
        Collection out = CsmReferenceRepository.getDefault().getReferences(resolved, file, CsmReferenceKind.ALL, Interrupter.DUMMY);
        return out;
    }

    public static void invokeInstantRename(JTextComponent target, ChangeInfo changeInfo) throws BadLocationException {
        ArrayList<CsmReference> highlights = new ArrayList<CsmReference>(changeInfo.size());
        int size = changeInfo.size();
        int caretOffset = -1;
        for (int i = 0; i < size; ++i) {
            ChangeInfo.Change change = changeInfo.get(i);
            highlights.add(new RefImpl(change));
            if (caretOffset >= 0) continue;
            caretOffset = change.getEnd().getOffset();
        }
        InstantRenamePerformer.performInstantRename(target, highlights, caretOffset);
    }

    public static synchronized void performInstantRename(JTextComponent target, Collection<CsmReference> highlights, int caretOffset) throws BadLocationException {
        if (instance != null) {
            instance.release();
        }
        UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{"INSTANT_RENAME"});
        instance = new InstantRenamePerformer(target, highlights, caretOffset);
    }

    private boolean isIn(MutablePositionRegion region, int caretOffset) {
        return region.getStartOffset() <= caretOffset && caretOffset <= region.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        this.updateOnInsertRemove();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.updateOnInsertRemove();
    }

    private void updateOnInsertRemove() {
        this.inSync = true;
        JTextComponent aTarget = this.target;
        if (this.region.sync(0)) {
            InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        } else {
            this.release();
        }
        this.inSync = false;
        aTarget.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.release();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void caretUpdate(CaretEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        JTextComponent aTarget;
        if (!CndLexerUtilities.isCppIdentifierPart((int)e.getKeyChar()) && (aTarget = this.target) != null) {
            aTarget.getToolkit().beep();
            e.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && e.getModifiers() == 0 || e.getKeyCode() == 10 && e.getModifiers() == 0) {
            this.release();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private synchronized void release() {
        if (this.target == null) {
            return;
        }
        this.target.putClientProperty(InstantRenamePerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).removePostModificationDocumentListener((DocumentListener)this);
        }
        this.target.removeKeyListener(this);
        this.target.removeFocusListener(this);
        InstantRenamePerformer.getHighlightsBag(this.doc).clear();
        this.region = null;
        this.doc = null;
        this.target = null;
        instance = null;
    }

    private static AttributeSet createAttributeSet(Object ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = keyValuePairs.length / 2 - 1; i >= 0; --i) {
            Object attrKey = keyValuePairs[2 * i];
            Object attrValue = keyValuePairs[2 * i + 1];
            if (attrKey == null || attrValue == null) continue;
            list.add(attrKey);
            list.add(attrValue);
        }
        return AttributesUtilities.createImmutable((Object[])list.toArray());
    }

    private static AttributeSet getSyncedTextBlocksHighlight(String name) {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet as = fcs != null ? fcs.getFontColors(name) : null;
        return as == null ? COLORING : as;
    }

    public static PositionsBag getHighlightsBag(Document doc) {
        PositionsBag bag = (PositionsBag)doc.getProperty(POSITION_BAG);
        if (bag == null) {
            bag = new PositionsBag(doc);
            doc.putProperty(POSITION_BAG, bag);
        }
        return bag;
    }

    private static class RefImpl
    implements CsmReference {
        private final ChangeInfo.Change change;

        public RefImpl(ChangeInfo.Change change) {
            this.change = change;
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.UNKNOWN;
        }

        public CsmObject getReferencedObject() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmObject getOwner() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmObject getClosestTopLevelObject() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getStartOffset() {
            return this.change.getStart().getOffset();
        }

        public int getEndOffset() {
            return this.change.getEnd().getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class RenameDeletedTextInterceptor
    implements DeletedTextInterceptor {
        public boolean beforeRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
            Object getObject = context.getComponent().getClientProperty(InstantRenamePerformer.class);
            if (getObject instanceof InstantRenamePerformer) {
                InstantRenamePerformer instantRenamePerformer = (InstantRenamePerformer)getObject;
                MutablePositionRegion region = instantRenamePerformer.region.getRegion(0);
                return context.isBackwardDelete() && region.getStartOffset() == context.getOffset() || !context.isBackwardDelete() && region.getEndOffset() == context.getOffset();
            }
            return false;
        }

        public void remove(DeletedTextInterceptor.Context context) throws BadLocationException {
        }

        public void afterRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        }

        public void cancelled(DeletedTextInterceptor.Context context) {
        }

        public static class Factory
        implements DeletedTextInterceptor.Factory {
            public DeletedTextInterceptor createDeletedTextInterceptor(MimePath mimePath) {
                return new RenameDeletedTextInterceptor();
            }
        }
    }

    private static class CancelInstantRenameUndoableEdit
    extends AbstractUndoableEdit {
        private final Reference<InstantRenamePerformer> performer;

        public CancelInstantRenameUndoableEdit(InstantRenamePerformer performer) {
            this.performer = new WeakReference<InstantRenamePerformer>(performer);
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            InstantRenamePerformer perf = this.performer.get();
            if (perf != null) {
                perf.release();
            }
        }
    }
}

