/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import javax.swing.JButton;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.refactoring.actions.RefactoringKind;
import org.netbeans.modules.cnd.refactoring.hints.AssignmentVariableFix;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceVariablePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ExtendedAssignmentVariableFix
extends AssignmentVariableFix {
    private int numDuplicates;
    private final RefactoringKind kind = RefactoringKind.CREATE_VARIABLE;
    private String type;

    public ExtendedAssignmentVariableFix(CsmExpression expression, Document doc, FileObject fo) {
        super(expression, doc, fo);
    }

    public String getKeyExt() {
        switch (this.kind) {
            case CREATE_CONSTANT: {
                return "IntroduceConstant";
            }
            case CREATE_VARIABLE: {
                return "IntroduceVariable";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getText() {
        return NbBundle.getMessage(ExtendedAssignmentVariableFix.class, (String)("FIX_" + this.getKeyExt()));
    }

    @Override
    protected boolean isInstanceRename() {
        return false;
    }

    @Override
    protected String getType() {
        return this.type;
    }

    @Override
    protected String suggestName() {
        this.type = super.getType();
        String guessedName = super.suggestName();
        JButton btnOk = new JButton(NbBundle.getMessage(ExtendedAssignmentVariableFix.class, (String)"LBL_Ok"));
        JButton btnCancel = new JButton(NbBundle.getMessage(ExtendedAssignmentVariableFix.class, (String)"LBL_Cancel"));
        IntroduceVariablePanel panel = new IntroduceVariablePanel(this.numDuplicates, this.type, guessedName, this.kind == RefactoringKind.CREATE_CONSTANT, btnOk);
        String caption = NbBundle.getMessage(ExtendedAssignmentVariableFix.class, (String)("CAP_" + this.getKeyExt()));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
            return null;
        }
        guessedName = panel.getVariableName();
        this.type = panel.getType();
        return guessedName;
    }
}

