/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.ui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.impl.SampleManager;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class CreateDatabasePanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(CreateDatabasePanel.class.getName());
    private DialogDescriptor descriptor;
    private Dialog dialog;
    private final DatabaseServer server;
    private final DatabaseComboModel databaseComboModel;
    private DatabaseConnection dbconn;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox chkGrantAccess;
    private JComboBox comboDatabaseName;
    private JComboBox comboUsers;
    private JLabel messageLabel;
    private JLabel nameLabel;
    private JProgressBar progressBar;
    private JLabel progressLabel;

    private boolean validatePanel(String databaseName) {
        if (this.descriptor == null) {
            return false;
        }
        String error = null;
        this.comboUsers.setEnabled(this.isGrantAccess());
        if (Utils.isEmpty(databaseName)) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_SpecifyDatabase");
        }
        if (this.isGrantAccess() && (this.comboUsers.getSelectedItem() == null || Utils.isEmpty(((DatabaseUser)this.comboUsers.getSelectedItem()).getUser()))) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatbasePanel.MSG_NoGrantUserSelected");
        }
        try {
            if (this.server.databaseExists(databaseName)) {
                error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_DatabaseAlreadyExists", (Object)databaseName);
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (error != null) {
            this.messageLabel.setText(error);
            this.okButton.setEnabled(false);
        } else {
            this.messageLabel.setText(" ");
            this.okButton.setEnabled(true);
        }
        return error == null;
    }

    private void startProgress() {
        this.setProgress(true);
    }

    private void stopProgress() {
        this.setProgress(false);
    }

    private void setProgress(final boolean start) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateDatabasePanel.this.comboDatabaseName.setEnabled(!start);
                CreateDatabasePanel.this.okButton.setEnabled(CreateDatabasePanel.this.okButton.isEnabled() && !start);
                if (!start) {
                    CreateDatabasePanel.this.cancelButton.setEnabled(true);
                }
                CreateDatabasePanel.this.progressBar.setVisible(start);
                CreateDatabasePanel.this.progressLabel.setVisible(start);
                CreateDatabasePanel.this.progressBar.setIndeterminate(start);
                CreateDatabasePanel.this.resize();
            }
        });
    }

    public DatabaseConnection showCreateDatabaseDialog() throws DatabaseException {
        assert (SwingUtilities.isEventDispatchThread());
        this.okButton = new JButton(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.CTL_OKButton"));
        this.okButton.getAccessibleContext().setAccessibleDescription(this.okButton.getAccessibleContext().getAccessibleName());
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.CTL_CancelButton"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(this.cancelButton.getAccessibleContext().getAccessibleName());
        ActionListener listener = new ActionListener(){
            RequestProcessor.Task task;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(CreateDatabasePanel.this.okButton)) {
                    if (this.task != null && !this.task.isFinished()) {
                        return;
                    }
                    CreateDatabasePanel.this.startProgress();
                    this.task = RequestProcessor.getDefault().create(new Runnable(){

                        @Override
                        public void run() {
                            CreateDatabasePanel.this.createDatabase();
                            if (CreateDatabasePanel.this.isGrantAccess()) {
                                CreateDatabasePanel.this.grantAccess();
                            }
                        }
                    });
                    this.task.addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            CreateDatabasePanel.this.stopProgress();
                            CreateDatabasePanel.this.dialog.dispose();
                        }
                    });
                    this.task.schedule(0);
                } else if (e.getSource().equals(CreateDatabasePanel.this.cancelButton)) {
                    CreateDatabasePanel.this.dialog.dispose();
                }
            }
        };
        this.okButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        String title = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.LBL_CreateDatabaseTitle");
        this.descriptor = new DialogDescriptor((Object)this, title, true, (Object[])new JButton[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, HelpCtx.findHelp(CreateDatabasePanel.class), null);
        this.descriptor.setClosingOptions(new Object[0]);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        String acsd = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.ACSD_CreateNewDatabasePanel");
        this.dialog.getAccessibleContext().setAccessibleDescription(acsd);
        this.stopProgress();
        this.descriptor.setValid(this.validatePanel(this.getDatabaseName()));
        this.dialog.setVisible(true);
        return this.dbconn;
    }

    private void grantAccess() {
        String dbname = this.getDatabaseName();
        DatabaseUser user = (DatabaseUser)this.comboUsers.getSelectedItem();
        assert (user != null);
        this.server.grantFullDatabaseRights(dbname, user);
    }

    private void createDatabase() {
        this.dbconn = null;
        String dbname = this.getDatabaseName();
        boolean dbCreated = false;
        try {
            if (!this.ensureConnected()) {
                return;
            }
            if (!CreateDatabasePanel.checkExistingDatabase(this.server, dbname)) {
                return;
            }
            this.server.createDatabase(dbname);
            int timeout = 30;
            while (timeout-- > 0 && !this.server.databaseExists(dbname)) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINEST, ex.getMessage(), ex);
                }
            }
            dbCreated = this.server.databaseExists(dbname);
            if (dbCreated) {
                this.dbconn = CreateDatabasePanel.createConnection(this.server, dbname);
            }
            if (this.dbconn == null) {
                return;
            }
            boolean create = false;
            if (SampleManager.isSample(dbname)) {
                create = !this.databaseComboModel.isSelectedSample() ? Utils.displayYesNoDialog(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.MSG_ConfirmCreateSample", (Object)dbname)) : true;
            }
            if (create) {
                this.cancelButton.setEnabled(false);
                SampleManager.createSample(dbname, this.dbconn);
            }
        }
        catch (DatabaseException ex) {
            CreateDatabasePanel.displayCreateFailure(this.server, ex, dbname, dbCreated);
            this.dbconn = null;
        }
    }

    private boolean ensureConnected() throws DatabaseException {
        try {
            this.server.validateConnection();
        }
        catch (DatabaseException dbe) {
            LOGGER.log(Level.INFO, null, dbe);
            Utils.displayError(dbe.getMessage(), (Exception)((Object)dbe));
        }
        if (this.server.isConnected()) {
            return true;
        }
        try {
            this.server.reconnect();
        }
        catch (TimeoutException te) {
            Utils.displayError(te.getMessage(), te);
            LOGGER.log(Level.INFO, null, te);
        }
        return this.server.isConnected();
    }

    private static void displayCreateFailure(DatabaseServer server, DatabaseException ex, String dbname, boolean dbCreated) {
        LOGGER.log(Level.INFO, null, ex);
        Utils.displayError(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_CreateFailed"), (Exception)((Object)ex));
        if (dbCreated) {
            NotifyDescriptor.Confirmation ndesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_DeleteCreatedDatabase", (Object)dbname), NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.STR_DeleteCreatedDatabaseTitle"), 0);
            Object response = DialogDisplayer.getDefault().notify((NotifyDescriptor)ndesc);
            if (response == NotifyDescriptor.YES_OPTION) {
                server.dropDatabase(dbname);
            }
        }
    }

    private static boolean checkExistingDatabase(DatabaseServer server, String dbname) throws DatabaseException {
        if (!server.databaseExists(dbname)) {
            return true;
        }
        NotifyDescriptor.Message ndesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.MSG_DatabaseAlreadyExists", (Object)dbname));
        ndesc.setTitle(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.STR_DatabaseExistsTitle"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)ndesc);
        return false;
    }

    private static DatabaseConnection createConnection(DatabaseServer server, String dbname) throws DatabaseException {
        List<DatabaseConnection> conns = DatabaseUtils.findDatabaseConnections(server.getURL(dbname));
        if (!conns.isEmpty()) {
            return conns.get(0);
        }
        DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)DatabaseUtils.getJDBCDriver(), (String)server.getURL(dbname), (String)server.getUser(), null, (String)server.getPassword(), (boolean)false);
        ConnectionManager.getDefault().addConnection(dbconn);
        ConnectionManager.getDefault().connect(dbconn);
        return dbconn;
    }

    public CreateDatabasePanel(DatabaseServer server) throws DatabaseException {
        this.server = server;
        this.initComponents();
        this.databaseComboModel = new DatabaseComboModel();
        this.comboDatabaseName.setModel(this.databaseComboModel);
        this.comboDatabaseName.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent event) {
                String keyStr = Character.toString(event.getKeyChar()).trim();
                String dbname = Utils.isEmpty(keyStr) ? CreateDatabasePanel.this.comboDatabaseName.getEditor().getItem().toString().trim() : keyStr;
                CreateDatabasePanel.this.validatePanel(dbname);
            }

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyReleased(KeyEvent event) {
                String keyStr = Character.toString(event.getKeyChar()).trim();
                if (!Utils.isEmpty(keyStr)) {
                    String dbname = CreateDatabasePanel.this.comboDatabaseName.getEditor().getItem().toString().trim();
                    CreateDatabasePanel.this.validatePanel(dbname);
                }
            }
        });
        this.comboUsers.setModel(new UsersComboModel(server));
        if (this.comboUsers.getItemCount() == 0) {
            this.comboUsers.setVisible(false);
            this.chkGrantAccess.setVisible(false);
        } else {
            this.comboUsers.setSelectedIndex(0);
            this.setGrantAccess(false);
        }
        this.setBackground(this.getBackground());
        this.messageLabel.setBackground(this.getBackground());
        this.messageLabel.setText(" ");
    }

    private void resize() {
        this.revalidate();
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    private String getDatabaseName() {
        String dbname = (String)this.comboDatabaseName.getSelectedItem();
        if (dbname != null) {
            dbname = dbname.trim();
        }
        return dbname;
    }

    private void setGrantAccess(boolean grant) {
        this.chkGrantAccess.setSelected(grant);
        this.comboUsers.setEnabled(grant);
    }

    private boolean isGrantAccess() {
        return this.chkGrantAccess.isSelected();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.chkGrantAccess = new JCheckBox();
        this.comboDatabaseName = new JComboBox();
        this.comboUsers = new JComboBox();
        this.messageLabel = new JLabel();
        this.progressLabel = new JLabel();
        this.nameLabel.setLabelFor(this.comboDatabaseName);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.nameLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkGrantAccess, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.chkGrantAccess.text"));
        this.chkGrantAccess.setToolTipText(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.chkGrantAccess.AccessibleContext.accessibleDescription"));
        this.chkGrantAccess.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CreateDatabasePanel.this.chkGrantAccessItemStateChanged(evt);
            }
        });
        this.comboDatabaseName.setEditable(true);
        this.comboDatabaseName.setToolTipText(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboDatabaseName.AccessibleContext.accessibleDescription"));
        this.comboDatabaseName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CreateDatabasePanel.this.comboDatabaseNameItemStateChanged(evt);
            }
        });
        this.comboUsers.setToolTipText(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboUsers.AccessibleContext.accessibleDescription"));
        this.comboUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateDatabasePanel.this.comboUsersActionPerformed(evt);
            }
        });
        this.messageLabel.setForeground(new Color(255, 0, 51));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.messageLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateDatabasePanel.progressLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.chkGrantAccess, GroupLayout.Alignment.TRAILING, -1, 173, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.comboUsers, 0, 323, Short.MAX_VALUE).addComponent(this.comboDatabaseName, 0, 323, Short.MAX_VALUE))).addComponent(this.messageLabel, -1, 508, Short.MAX_VALUE).addComponent(this.progressBar, -1, 508, Short.MAX_VALUE).addComponent(this.progressLabel, -1, 508, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.comboDatabaseName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkGrantAccess).addComponent(this.comboUsers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.comboDatabaseName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboDatabaseName.AccessibleContext.accessibleName"));
        this.comboDatabaseName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboDatabaseName.AccessibleContext.accessibleDescription"));
        this.comboUsers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboUsers.AccessibleContext.accessibleName"));
        this.comboUsers.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.comboUsers.AccessibleContext.accessibleDescription"));
    }

    private void comboDatabaseNameItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.validatePanel(evt.getItem().toString().trim());
        }
    }

    private void chkGrantAccessItemStateChanged(ItemEvent evt) {
        this.comboUsers.setEnabled(this.isGrantAccess());
    }

    private void comboUsersActionPerformed(ActionEvent evt) {
    }

    private static class UsersComboModel
    implements ComboBoxModel {
        private List<DatabaseUser> users = new ArrayList<DatabaseUser>();
        private DatabaseUser selected;

        public UsersComboModel(DatabaseServer server) throws DatabaseException {
            try {
                this.users.addAll(server.getUsers());
                DatabaseUser rootUser = null;
                for (DatabaseUser user : this.users) {
                    if (user.getUser() == null || !user.getUser().equals("root")) continue;
                    rootUser = user;
                    break;
                }
                if (this.users.size() > 0) {
                    this.selected = this.users.get(0);
                }
                if (rootUser != null) {
                    this.users.remove(rootUser);
                }
            }
            catch (DatabaseException dbe) {
                if (!server.isConnected()) {
                    throw dbe;
                }
                LOGGER.log(Level.INFO, null, dbe);
                this.users.clear();
            }
        }

        @Override
        public void setSelectedItem(Object item) {
            if (item == null || item.toString().trim().length() == 0) {
                return;
            }
            assert (item instanceof DatabaseUser) : item + "[" + item.getClass() + "] must be instanceof DatabaseUser";
            if (item instanceof DatabaseUser) {
                this.selected = (DatabaseUser)item;
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.users.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.users.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener arg0) {
        }

        @Override
        public void removeListDataListener(ListDataListener arg0) {
        }
    }

    private static class DatabaseComboModel
    implements ComboBoxModel {
        private final List<String> sampleNames = SampleManager.getSampleNames();
        private static final String SAMPLE_PREFIX = NbBundle.getMessage(CreateDatabasePanel.class, (String)"CreateNewDatabasePanel.STR_SampleDatabase") + ": ";
        private String selected = null;

        private DatabaseComboModel() {
        }

        @Override
        public void setSelectedItem(Object item) {
            this.selected = (String)item;
        }

        public boolean isSelectedSample() {
            return this.selected != null && this.selected.startsWith(SAMPLE_PREFIX);
        }

        @Override
        public Object getSelectedItem() {
            if (this.isSelectedSample()) {
                return this.selected.replace(SAMPLE_PREFIX, "");
            }
            if (this.selected != null) {
                return this.selected;
            }
            return "";
        }

        @Override
        public int getSize() {
            return this.sampleNames.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (index < 0) {
                return null;
            }
            return SAMPLE_PREFIX + this.sampleNames.get(index).toString();
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
        }
    }
}

