/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.highlight.error.HighlightProvider;
import org.netbeans.modules.cnd.highlight.semantic.debug.InterrupterImpl;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.parsing.spi.support.CancelSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class HighlightProviderTaskFactory
extends TaskFactory {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");

    public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
        return Collections.singletonList(new ErrorsHighlighter());
    }

    private static final class ErrorsHighlighter
    extends IndexingAwareParserResultTask<Parser.Result> {
        private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
        private InterrupterImpl interrupter = new InterrupterImpl();
        private Parser.Result lastParserResult;

        public ErrorsHighlighter() {
            super(TaskIndexingMode.ALLOWED_DURING_SCAN);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Parser.Result result, SchedulerEvent event) {
            ErrorsHighlighter errorsHighlighter = this;
            synchronized (errorsHighlighter) {
                if (this.lastParserResult == result) {
                    return;
                }
                this.interrupter.cancel();
                this.interrupter = new InterrupterImpl();
                if (this.cancel.isCancelled()) {
                    this.lastParserResult = null;
                    return;
                }
                this.lastParserResult = result;
            }
            long time = 0L;
            try {
                FileObject fo = result.getSnapshot().getSource().getFileObject();
                if (fo == null) {
                    return;
                }
                CsmFile csmFile = CsmFileInfoQuery.getDefault().getCsmFile(result);
                if (csmFile == null) {
                    return;
                }
                Document doc = result.getSnapshot().getSource().getDocument(false);
                if (doc == null) {
                    return;
                }
                DataObject dobj = DataObject.find((FileObject)fo);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "HighlightProviderTaskFactory started");
                    time = System.currentTimeMillis();
                }
                HighlightProvider.getInstance().update(csmFile, doc, dobj, this.interrupter);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "HighlightProviderTaskFactory finished for {0}ms", System.currentTimeMillis() - time);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            ErrorsHighlighter errorsHighlighter = this;
            synchronized (errorsHighlighter) {
                this.interrupter.cancel();
                this.lastParserResult = null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "HighlightProviderTaskFactory canceled");
            }
        }

        public Class<? extends Scheduler> getSchedulerClass() {
            return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
        }

        public int getPriority() {
            return 3000;
        }
    }
}

