/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.model;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Filter;
import java.util.AbstractList;
import java.util.Iterator;

public class FilteredMemberList
extends AbstractList<Symbol> {
    private final Scope scope;

    public FilteredMemberList(Scope scope) {
        this.scope = scope;
    }

    @Override
    public int size() {
        int cnt = 0;
        for (Symbol sym : this.scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (FilteredMemberList.unwanted(sym)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public Symbol get(int index) {
        for (Symbol sym : this.scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (FilteredMemberList.unwanted(sym) || index-- != 0) continue;
            return sym;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this.scope.getSymbols(new Filter<Symbol>(){

            @Override
            public boolean accepts(Symbol t) {
                return !FilteredMemberList.unwanted(t);
            }
        }, Scope.LookupKind.NON_RECURSIVE).iterator();
    }

    private static boolean unwanted(Symbol s) {
        return s == null || (s.flags() & 0x1000L) != 0L;
    }
}

