/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.common.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.modules.j2me.common.ant.LibletUtils;

public class CopyLibletsTask
extends Task {
    private static final String LIB = "lib";
    private static final String JAR_EXT = ".jar";
    private static final String JAD_EXT = ".jad";
    private Path runtimePath;

    public void setRuntimeClassPath(Path path) {
        assert (path != null);
        this.runtimePath = path;
    }

    public Path getRuntimeClassPath() {
        return this.runtimePath;
    }

    public void execute() throws BuildException {
        if (this.runtimePath == null) {
            throw new BuildException("RuntimeClassPath must be set.");
        }
        String[] pathElements = this.runtimePath.list();
        ArrayList<File> filesToCopy = new ArrayList<File>();
        Map<String, Boolean> libletsInProject = LibletUtils.loadLibletsInProject(this.getProject());
        for (String element : pathElements) {
            File libFolder;
            if (!element.toLowerCase().endsWith(JAR_EXT)) continue;
            String jadFilePath = element.substring(0, element.lastIndexOf(JAR_EXT)).concat(JAD_EXT);
            File jarFile = new File(element);
            File jadFile = new File(jadFilePath);
            if (jadFile.exists()) {
                Map<Object, Object> manifestAttributes = LibletUtils.getJarManifestAttributes(element);
                if (libletsInProject.get(LibletUtils.getLibletDetails(manifestAttributes)).booleanValue()) continue;
                filesToCopy.add(jarFile);
                filesToCopy.add(jadFile);
            }
            if (!(libFolder = new File(jarFile.getParent(), LIB)).exists()) continue;
            filesToCopy.add(libFolder);
        }
        if (!filesToCopy.isEmpty()) {
            File distDir = this.getProject().resolveFile(this.getProject().getProperty("dist.dir"));
            File libFolder = new File(distDir, LIB);
            if (!libFolder.exists()) {
                libFolder.mkdir();
                this.log("Create lib folder " + libFolder.toString() + ".", 3);
            }
            assert (libFolder.canWrite());
            FileUtils utils = FileUtils.getFileUtils();
            for (File fileToCopy : filesToCopy) {
                if (fileToCopy.isDirectory()) {
                    if (fileToCopy.list().length <= 0) continue;
                    File innerLibFolder = new File(libFolder, LIB);
                    if (!innerLibFolder.exists()) {
                        innerLibFolder.mkdir();
                        this.log("Create lib folder for LIBlet " + innerLibFolder.toString() + ".", 3);
                    }
                    Copy cp = (Copy)this.getProject().createTask("copy");
                    cp.setTodir(innerLibFolder);
                    FileSet fset = new FileSet();
                    fset.setDir(fileToCopy);
                    cp.addFileset(fset);
                    cp.execute();
                    continue;
                }
                File jadFile = new File(libFolder, fileToCopy.getName());
                try {
                    utils.copyFile(fileToCopy, jadFile, null, true);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
    }
}

