/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import org.eclipse.jgit.lib.RepositoryState;
import org.netbeans.libs.git.jgit.Utils;

public enum GitRepositoryState {
    BARE{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return false;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Bare");
        }
    }
    ,
    SAFE{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Safe");
        }
    }
    ,
    MERGING{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return false;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Merging");
        }
    }
    ,
    MERGING_RESOLVED{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Merged");
        }
    }
    ,
    CHERRY_PICKING{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return false;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_CherryPicking");
        }
    }
    ,
    CHERRY_PICKING_RESOLVED{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_CherryPickingResolved");
        }
    }
    ,
    REBASING{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Rebasing");
        }
    }
    ,
    APPLY{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Apply");
        }
    }
    ,
    BISECTING{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Bisecting");
        }
    };


    public abstract boolean canCheckout();

    public abstract boolean canCommit();

    public abstract boolean canResetHead();

    static GitRepositoryState getStateFor(RepositoryState state) {
        switch (state) {
            case APPLY: {
                return APPLY;
            }
            case BARE: {
                return BARE;
            }
            case BISECTING: {
                return BISECTING;
            }
            case MERGING: 
            case REVERTING: {
                return MERGING;
            }
            case CHERRY_PICKING: {
                return CHERRY_PICKING;
            }
            case CHERRY_PICKING_RESOLVED: {
                return CHERRY_PICKING_RESOLVED;
            }
            case MERGING_RESOLVED: 
            case REVERTING_RESOLVED: {
                return MERGING_RESOLVED;
            }
            case REBASING: 
            case REBASING_INTERACTIVE: 
            case REBASING_MERGE: 
            case REBASING_REBASING: {
                return REBASING;
            }
            case SAFE: {
                return SAFE;
            }
        }
        throw new IllegalStateException(state.getDescription());
    }
}

