/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.openide.util.NbBundle;

public final class CsmDefineHyperlinkProvider
extends CsmHyperlinkProvider {
    @Override
    protected void performAction(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        this.goToDeclaration(doc, target, offset, type);
    }

    @Override
    protected boolean isValidToken(TokenItem<TokenId> token, HyperlinkType type) {
        return CsmDefineHyperlinkProvider.isSupportedToken(token, type);
    }

    public static boolean isSupportedToken(TokenItem<TokenId> token, HyperlinkType type) {
        if (token != null) {
            if (type == HyperlinkType.ALT_HYPERLINK && ("whitespace".equals(token.id().primaryCategory()) || "comment".equals(token.id().primaryCategory()))) {
                return false;
            }
            if (token.id() instanceof CppTokenId) {
                switch ((CppTokenId)token.id()) {
                    case PREPROCESSOR_IDENTIFIER: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goToDeclaration(Document doc, JTextComponent target, int offset, HyperlinkType type) {
        if (!this.preJump(doc, target, offset, "opening-csm-element", type)) {
            return false;
        }
        try {
            CsmCacheManager.enter();
            TokenItem<TokenId> jumpToken = this.getJumpToken();
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
            CsmObject primary = this.findTargetObject(doc, jumpToken, offset, false);
            CsmOffsetable item = this.toJumpObject(primary, csmFile, offset);
            UIGesturesSupport.submit((String)"USG_CND_HYPERLINK", (Object[])new Object[]{type});
            boolean bl = this.postJump(item, "goto_source_source_not_found", "cannot-open-csm-element");
            return bl;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    @Override
    CsmObject findTargetObject(Document doc, TokenItem<TokenId> jumpToken, int offset, boolean toOffsetable) {
        CsmObject csmObject;
        assert (jumpToken != null);
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        CsmObject csmObject2 = csmObject = file == null ? null : ReferencesSupport.findDefine(doc, file, jumpToken, offset);
        if (csmObject != null) {
            return toOffsetable ? this.toJumpObject(csmObject, file, offset) : csmObject;
        }
        return super.findTargetObject(doc, jumpToken, offset, toOffsetable);
    }

    @Override
    protected String getTooltipText(Document doc, TokenItem<TokenId> token, int offset, HyperlinkType type) {
        CsmObject item;
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (file != null && (item = ReferencesSupport.findDefine(doc, file, token, offset)) != null) {
            return NbBundle.getMessage(CsmDefineHyperlinkProvider.class, (String)"DSC_MacroParameterTooltip", (Object)((CsmOffsetable)item).getText());
        }
        return super.getTooltipText(doc, token, offset, type);
    }
}

