/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmRangeForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmReturnStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public class CsmStatementResolver {
    private CsmStatementResolver() {
    }

    public static boolean findInnerObject(CsmStatement stmt, int offset, CsmContext context) {
        if (stmt == null) {
            if (CsmUtilities.DEBUG) {
                System.out.println("STATEMENT is null");
            }
            return false;
        }
        if (!CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("Offset " + offset + " is not in statement " + stmt);
            }
            return false;
        }
        CsmContextUtilities.updateContext((CsmObject)stmt, offset, context);
        CsmStatement.Kind kind = stmt.getKind();
        boolean found = true;
        switch (kind) {
            case COMPOUND: {
                found = CsmStatementResolver.findInnerCompound((CsmCompoundStatement)stmt, offset, context);
                break;
            }
            case IF: {
                found = CsmStatementResolver.findInnerIf((CsmIfStatement)stmt, offset, context);
                break;
            }
            case TRY_CATCH: {
                found = CsmStatementResolver.findInnerTry((CsmTryCatchStatement)stmt, offset, context);
                break;
            }
            case CATCH: {
                found = CsmStatementResolver.findInnerCatch((CsmExceptionHandler)stmt, offset, context);
                break;
            }
            case DECLARATION: {
                found = CsmStatementResolver.findInnerDeclaration((CsmDeclarationStatement)stmt, offset, context);
                break;
            }
            case WHILE: 
            case DO_WHILE: {
                found = CsmStatementResolver.findInnerWhile((CsmLoopStatement)stmt, offset, context);
                break;
            }
            case FOR: {
                found = CsmStatementResolver.findInnerFor((CsmForStatement)stmt, offset, context);
                break;
            }
            case RANGE_FOR: {
                found = CsmStatementResolver.findInnerRange((CsmRangeForStatement)stmt, offset, context);
                break;
            }
            case SWITCH: {
                found = CsmStatementResolver.findInnerSwitch((CsmSwitchStatement)stmt, offset, context);
                break;
            }
            case EXPRESSION: {
                found = CsmStatementResolver.findInnerExpression(((CsmExpressionStatement)stmt).getExpression(), offset, context);
                break;
            }
            case RETURN: {
                found = CsmStatementResolver.findInnerExpression(((CsmReturnStatement)stmt).getReturnExpression(), offset, context);
                break;
            }
            case BREAK: 
            case CASE: 
            case CONTINUE: 
            case DEFAULT: 
            case GOTO: 
            case LABEL: {
                break;
            }
            default: {
                if (!CsmUtilities.DEBUG) break;
                System.out.println("unexpected statement kind");
            }
        }
        return found;
    }

    private static boolean findInnerCompound(CsmCompoundStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        if (stmt != null) {
            for (CsmStatement curSt : stmt.getStatements()) {
                if (!CsmStatementResolver.findInnerObject(curSt, offset, context)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean findInnerTry(CsmTryCatchStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        if (CsmStatementResolver.findInnerObject(stmt.getTryStatement(), offset, context)) {
            return true;
        }
        for (CsmExceptionHandler handler : stmt.getHandlers()) {
            if (!CsmStatementResolver.findInnerObject((CsmStatement)handler, offset, context)) continue;
            return true;
        }
        return false;
    }

    private static boolean findInnerCatch(CsmExceptionHandler stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        return CsmStatementResolver.findInnerCompound((CsmCompoundStatement)stmt, offset, context);
    }

    private static boolean findInnerIf(CsmIfStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)stmt, (CsmObject)stmt.getCondition()) && CsmOffsetUtilities.isInObject((CsmObject)stmt.getCondition(), offset)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("in CONDITION of if statement ");
            }
            CsmContextUtilities.updateContextObject((CsmObject)stmt.getCondition(), offset, context);
            CsmStatementResolver.findInnerExpression(stmt.getCondition().getExpression(), offset, context);
            return true;
        }
        if (CsmStatementResolver.findInnerObject(stmt.getThen(), offset, context)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("in THEN: ");
            }
            return true;
        }
        if (CsmStatementResolver.findInnerObject(stmt.getElse(), offset, context)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("in ELSE: ");
            }
            return true;
        }
        return false;
    }

    private static boolean findInnerDeclaration(CsmDeclarationStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in declaration statement when called";
        List decls = stmt.getDeclarators();
        CsmDeclaration decl = (CsmDeclaration)CsmOffsetUtilities.findObject(decls, context, offset);
        if (!(decl == null || decls.size() != 1 && CsmOffsetUtilities.sameOffsets((CsmObject)stmt, (CsmObject)decl))) {
            CsmClassifier classifier;
            if (CsmUtilities.DEBUG) {
                System.out.println("we have declarator " + decl);
            }
            if ((CsmKindUtilities.isTypedef((CsmObject)decl) || CsmKindUtilities.isTypeAlias((CsmObject)decl)) && CsmOffsetUtilities.isInObject((CsmObject)decl, (CsmObject)(classifier = ((CsmTypedef)decl).getType().getClassifier())) && !CsmOffsetUtilities.sameOffsets((CsmObject)decl, (CsmObject)classifier)) {
                decl = classifier;
            }
            if (CsmKindUtilities.isEnum((CsmObject)decl)) {
                CsmStatementResolver.findInnerEnum((CsmEnum)decl, offset, context);
            } else if (CsmKindUtilities.isClass((CsmObject)decl)) {
                CsmStatementResolver.findInnerClass((CsmClass)decl, offset, context);
            } else if (CsmKindUtilities.isFunction((CsmObject)decl)) {
                CsmCompoundStatement body;
                CsmFunctionDefinition funDef;
                CsmFunction fun = (CsmFunction)decl;
                CsmFunctionParameterList paramList = fun.getParameterList();
                if (paramList != null) {
                    CsmParameter param = (CsmParameter)CsmOffsetUtilities.findObject(paramList.getParameters(), context, offset);
                    if (CsmOffsetUtilities.isInObject((CsmObject)paramList, offset) || param != null && !CsmOffsetUtilities.sameOffsets((CsmObject)fun, (CsmObject)param)) {
                        context.add((CsmScope)fun);
                        if (param != null) {
                            CsmType type = param.getType();
                            if (!CsmOffsetUtilities.sameOffsets((CsmObject)param, (CsmObject)type) && CsmOffsetUtilities.isInObject((CsmObject)type, offset)) {
                                context.setLastObject((CsmObject)type);
                            } else {
                                context.setLastObject((CsmObject)param);
                            }
                        }
                    }
                }
                if ((CsmKindUtilities.isFunctionDefinition((CsmObject)fun) || CsmKindUtilities.isLambda((CsmObject)fun)) && (!CsmOffsetUtilities.sameOffsets((CsmObject)(funDef = (CsmFunctionDefinition)fun), (CsmObject)(body = funDef.getBody())) || body.getStartOffset() != body.getEndOffset()) && CsmOffsetUtilities.isInObject((CsmObject)body, offset)) {
                    CsmContextUtilities.updateContext((CsmObject)fun, offset, context);
                    if (CsmStatementResolver.findInnerObject((CsmStatement)body, offset, context)) {
                        CsmContextUtilities.updateContext((CsmObject)body, offset, context);
                        CsmObject found = context.getLastObject();
                        if (!CsmOffsetUtilities.sameOffsets((CsmObject)body, found)) {
                            context.setLastObject(found);
                            return true;
                        }
                    }
                }
            } else if (CsmKindUtilities.isVariable((CsmObject)decl)) {
                CsmStatementResolver.findInnerExpression(((CsmVariable)decl).getInitialValue(), offset, context);
            }
            return true;
        }
        return false;
    }

    private static boolean findInnerEnum(CsmEnum enumm, int offset, CsmContext context) {
        CsmContextUtilities.updateContext((CsmObject)enumm, offset, context);
        CsmEnumerator enumerator = (CsmEnumerator)CsmOffsetUtilities.findObject(enumm.getEnumerators(), context, offset);
        if (enumerator != null && !CsmOffsetUtilities.sameOffsets((CsmObject)enumm, (CsmObject)enumerator)) {
            CsmContextUtilities.updateContext((CsmObject)enumerator, offset, context);
        }
        return true;
    }

    private static boolean findInnerClass(CsmClass clazz, int offset, CsmContext context) {
        CsmContextUtilities.updateContext((CsmObject)clazz, offset, context);
        CsmMember member = (CsmMember)CsmOffsetUtilities.findObject(clazz.getMembers(), context, offset);
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)clazz, (CsmObject)member)) {
            if (CsmKindUtilities.isClass((CsmObject)member)) {
                CsmStatementResolver.findInnerClass((CsmClass)member, offset, context);
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)member)) {
                CsmContextUtilities.updateContext((CsmObject)member, offset, context);
                CsmCompoundStatement body = ((CsmFunctionDefinition)member).getBody();
                if (!CsmOffsetUtilities.sameOffsets((CsmObject)member, (CsmObject)body)) {
                    CsmStatementResolver.findInnerObject((CsmStatement)body, offset, context);
                }
            }
        }
        return true;
    }

    private static boolean findInnerWhile(CsmLoopStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)stmt, (CsmObject)stmt.getCondition()) && CsmOffsetUtilities.isInObject((CsmObject)stmt.getCondition(), offset)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("in condition of loop statement isPostCheck()=" + stmt.isPostCheck());
            }
            CsmContextUtilities.updateContextObject((CsmObject)stmt.getCondition(), offset, context);
            CsmStatementResolver.findInnerExpression(stmt.getCondition().getExpression(), offset, context);
            return true;
        }
        return CsmStatementResolver.findInnerObject(stmt.getBody(), offset, context);
    }

    private static boolean findInnerFor(CsmForStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        if (CsmStatementResolver.findInnerObject(stmt.getInitStatement(), offset, context)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("in INIT of for statement");
            }
            return true;
        }
        if (CsmOffsetUtilities.isInObject((CsmObject)stmt.getIterationExpression(), offset)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("in ITERATION  of for statement");
            }
            CsmExpression iterationExpression = stmt.getIterationExpression();
            CsmContextUtilities.updateContextObject((CsmObject)iterationExpression, offset, context);
            if (CsmStatementResolver.findInnerExpression(iterationExpression, offset, context)) {
                return true;
            }
            return true;
        }
        if (CsmOffsetUtilities.isInObject((CsmObject)stmt.getCondition(), offset)) {
            if (CsmUtilities.DEBUG) {
                System.out.println("in CONDITION of for statement ");
            }
            CsmCondition condition = stmt.getCondition();
            CsmContextUtilities.updateContextObject((CsmObject)condition, offset, context);
            if (CsmStatementResolver.findInnerExpression(condition.getExpression(), offset, context)) {
                return true;
            }
            return true;
        }
        return CsmStatementResolver.findInnerObject(stmt.getBody(), offset, context);
    }

    private static boolean findInnerRange(CsmRangeForStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        if (CsmStatementResolver.findInnerObject((CsmStatement)stmt.getDeclaration(), offset, context)) {
            return true;
        }
        if (CsmOffsetUtilities.isInObject((CsmObject)stmt.getInitializer(), offset)) {
            CsmExpression initializerExpression = stmt.getInitializer();
            CsmContextUtilities.updateContextObject((CsmObject)initializerExpression, offset, context);
            if (CsmStatementResolver.findInnerExpression(initializerExpression, offset, context)) {
                return true;
            }
            return true;
        }
        return CsmStatementResolver.findInnerObject(stmt.getBody(), offset, context);
    }

    private static boolean findInnerSwitch(CsmSwitchStatement stmt, int offset, CsmContext context) {
        assert (CsmOffsetUtilities.isInObject((CsmObject)stmt, offset)) : "we must be in statement when called";
        if (!CsmOffsetUtilities.sameOffsets((CsmObject)stmt, (CsmObject)stmt.getCondition()) && CsmOffsetUtilities.isInObject((CsmObject)stmt.getCondition(), offset)) {
            CsmContextUtilities.updateContextObject((CsmObject)stmt.getCondition(), offset, context);
            return true;
        }
        return CsmStatementResolver.findInnerObject(stmt.getBody(), offset, context);
    }

    static boolean findInnerExpression(CsmExpression expr, int offset, CsmContext context) {
        if (expr != null) {
            for (CsmStatement csmStatement : expr.getLambdas()) {
                CsmObject found;
                CsmDeclarationStatement lambda = (CsmDeclarationStatement)csmStatement;
                if (CsmOffsetUtilities.sameOffsets((CsmObject)expr, (CsmObject)lambda) && lambda.getStartOffset() == lambda.getEndOffset() || !CsmOffsetUtilities.isInObject((CsmObject)lambda, offset) || !CsmStatementResolver.findInnerObject((CsmStatement)lambda, offset, context) || CsmOffsetUtilities.sameOffsets((CsmObject)lambda, found = context.getLastObject())) continue;
                CsmContextUtilities.updateContextObject(found, offset, context);
                return true;
            }
        }
        return false;
    }
}

