/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorDebug;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.support.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.spi.model.services.CsmReferenceStorage;
import org.netbeans.modules.cnd.utils.cache.TextCache;

public class ReferenceImpl
extends DocOffsetableImpl
implements CsmReference {
    private final TokenItem<TokenId> token;
    private CsmObject target = null;
    private CsmContext context = null;
    private CsmObject owner = null;
    private CsmObject closestTopLevelObject = null;
    private boolean findDone = false;
    private boolean restoreDone = false;
    private final int offset;
    private CsmReferenceKind kind;
    private FileReferencesContext fileReferencesContext;
    private long lastFileVersion;

    public ReferenceImpl(CsmFile file, BaseDocument doc, int offset, TokenItem<TokenId> token, CsmReferenceKind kind) {
        super(doc, file, token.offset() < 0 ? offset : token.offset());
        this.token = token;
        this.offset = offset;
        this.kind = kind;
        this.lastFileVersion = -1L;
    }

    public CsmObject getReferencedObject() {
        CsmObject out = this.getReferencedObjectImpl();
        if (!CsmBaseUtilities.isValid((CsmObject)out) && this.getFileVersion() != this.lastFileVersion) {
            this.cleanup();
            out = this.getReferencedObjectImpl();
        }
        return out;
    }

    private void cleanup() {
        this.target = null;
        this.lastFileVersion = -1L;
        this.findDone = false;
        this.restoreDone = false;
        this.closestTopLevelObject = null;
        this.owner = null;
    }

    private long getFileVersion() {
        return CsmFileInfoQuery.getDefault().getFileVersion(this.getContainingFile());
    }

    private CsmObject getReferencedObjectImpl() {
        if (!this.findDone && this.isValid()) {
            this.restoreIfPossible();
            if (this.target == null) {
                this.lastFileVersion = this.getFileVersion();
                this.target = ReferencesSupport.instance().findReferencedObject(this.getContainingFile(), this.getDocument(), this.offset, this.token, this.fileReferencesContext);
                if (this.target != null) {
                    this.initOwner();
                    this.initKind(this.target);
                    this.initClosestTopLevelObject();
                    if (!CsmFileInfoQuery.getDefault().isDocumentBasedFile(this.getContainingFile()) && this.getDocument().getProperty((Object)"macro-expansion-view-document") == null) {
                        CsmReferenceStorage.getDefault().put((CsmReference)this, this.target);
                    }
                }
            }
            this.findDone = true;
        }
        return this.target;
    }

    private void initOwner() {
        if (this.owner == null) {
            this.initContext();
            this.owner = this.context.getLastObject();
        }
    }

    private synchronized void restoreIfPossible() {
        if (!this.restoreDone) {
            CsmReference candidate = null;
            if (this.getDocument().getProperty((Object)"macro-expansion-view-document") == null) {
                candidate = CsmReferenceStorage.getDefault().get((CsmOffsetable)this);
            }
            if (candidate != null) {
                this.lastFileVersion = this.getFileVersion();
                this.target = candidate.getReferencedObject();
                if (this.target == null) {
                    Logger.getLogger("xRef").log(Level.FINE, "Reference {0}\n doesn''t have target in candidate {1}\n", new Object[]{this, candidate});
                }
                CsmReferenceKind aKind = candidate.getKind();
                assert (this.kind == null || this.kind == aKind) : this.kind + " vs. " + aKind;
                this.kind = aKind;
                CsmObject anOwner = candidate.getOwner();
                assert (this.owner == null || anOwner == null || this.owner.equals(anOwner)) : this.owner + " vs. " + anOwner;
                if (this.owner == null) {
                    this.owner = anOwner;
                }
                if (this.closestTopLevelObject == null) {
                    this.closestTopLevelObject = candidate.getClosestTopLevelObject();
                }
            }
            this.restoreDone = true;
        }
    }

    public CsmObject getOwner() {
        if (this.owner == null && this.isValid()) {
            this.restoreIfPossible();
            this.initOwner();
        }
        return this.owner;
    }

    @Override
    public CharSequence getText() {
        CharSequence cs = this.token.text();
        if (cs == null) {
            return "";
        }
        return TextCache.getManager().getString(cs);
    }

    public String toString() {
        return "'" + EditorDebug.debugString((String)this.getText().toString()) + "', tokenID=" + this.token.id().toString().toLowerCase(Locale.getDefault()) + ", offset=" + this.offset + " [" + super.getStartPosition() + "-" + super.getEndPosition() + "]";
    }

    final void setTarget(CsmObject target) {
        this.lastFileVersion = this.getFileVersion();
        this.target = target;
    }

    final CsmObject getTarget() {
        return this.target;
    }

    final int getOffset() {
        return this.offset;
    }

    final TokenItem<TokenId> getToken() {
        return this.token;
    }

    final CsmReferenceKind getKindImpl() {
        return this.kind;
    }

    public CsmReferenceKind getKind() {
        if (this.kind == null) {
            this.restoreIfPossible();
            this.initKind(this.target);
        }
        return this.kind;
    }

    private void initKind(CsmObject anTarget) {
        if (this.kind == null) {
            CsmReferenceKind outKind = CsmReferenceKind.UNKNOWN;
            CsmObject anOwner = this.getOwner();
            if (CsmKindUtilities.isType((CsmObject)anOwner) || CsmKindUtilities.isInheritance((CsmObject)anOwner)) {
                outKind = ReferencesSupport.getReferenceUsageKind(this);
            } else if (CsmKindUtilities.isInclude((CsmObject)anOwner)) {
                outKind = CsmReferenceKind.DIRECT_USAGE;
            } else {
                CsmObject csmObject = anTarget = anTarget == null ? this.getReferencedObject() : anTarget;
                if (anTarget == null) {
                    outKind = ReferencesSupport.getReferenceUsageKind(this);
                } else {
                    CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)anTarget, (boolean)true);
                    CsmObject targetDecl = decDef[0];
                    CsmObject targetDef = decDef[1];
                    assert (targetDecl != null);
                    outKind = CsmReferenceKind.DIRECT_USAGE;
                    if (anOwner != null) {
                        outKind = CsmKindUtilities.isClassForwardDeclaration((CsmObject)this.owner) || CsmClassifierResolver.getDefault().isForwardClassifier(this.owner) ? CsmReferenceKind.DIRECT_USAGE : (anOwner.equals(targetDef) ? CsmReferenceKind.DEFINITION : (CsmReferenceSupport.sameDeclaration((CsmObject)anOwner, (CsmObject)targetDecl) ? CsmReferenceKind.DECLARATION : ReferencesSupport.getReferenceUsageKind(this)));
                    }
                }
            }
            this.kind = outKind;
        }
    }

    void setFileReferencesContext(FileReferencesContext fileReferencesContext) {
        this.fileReferencesContext = fileReferencesContext;
    }

    public CsmObject getClosestTopLevelObject() {
        if (this.closestTopLevelObject == null && this.isValid()) {
            this.restoreIfPossible();
            this.initClosestTopLevelObject();
        }
        return this.closestTopLevelObject;
    }

    private void initClosestTopLevelObject() {
        if (this.closestTopLevelObject == null && this.isValid()) {
            this.initContext();
            CsmObject lastObject = this.context.getLastObject();
            if (CsmKindUtilities.isType((CsmObject)lastObject) || CsmKindUtilities.isTemplateParameter((CsmObject)lastObject)) {
                lastObject = this.context.getLastScope();
            }
            this.closestTopLevelObject = CsmBaseUtilities.findClosestTopLevelObject((CsmObject)lastObject);
        }
    }

    private void initContext() {
        if (this.context == null) {
            this.context = CsmOffsetResolver.findContext(this.getContainingFile(), this.offset, this.fileReferencesContext);
        }
    }
}

