/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.preprocessor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmFontColorManager;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

public class CsmPreprocessorDirectiveCompletionItem
implements CompletionItem {
    private final int substitutionOffset;
    private final int priority;
    private final String sortItemText;
    private final boolean supportInstantSubst;
    private static final int PRIORITY = 15;
    private final String appendItemText;
    private final String htmlItemText;

    private CsmPreprocessorDirectiveCompletionItem(int substitutionOffset, int priority, String sortItemText, String appendItemText, String htmlItemText, boolean supportInstantSubst) {
        this.substitutionOffset = substitutionOffset;
        this.priority = priority;
        this.supportInstantSubst = supportInstantSubst;
        this.sortItemText = sortItemText;
        this.appendItemText = appendItemText;
        this.htmlItemText = htmlItemText;
    }

    public static CsmPreprocessorDirectiveCompletionItem createItem(int substitutionOffset, int priority, String item) {
        String coloredItemText;
        String appendItemText;
        String sortItemText;
        int newLine = item.indexOf("\n");
        if (newLine > 0) {
            sortItemText = item.substring(0, newLine).replace("#", "");
            String noNewLine = item.replace("\n", "-").replace("#", "");
            appendItemText = item.substring(newLine);
            coloredItemText = CndUtils.isUnitTestMode() ? noNewLine : CsmDisplayUtilities.addHTMLColor((String)noNewLine, (AttributeSet)CsmFontColorManager.instance().getColorAttributes("text/x-c++", FontColorProvider.Entity.PREPROCESSOR_DIRECTIVE));
        } else {
            appendItemText = "";
            sortItemText = item;
            coloredItemText = CndUtils.isUnitTestMode() ? sortItemText : CsmDisplayUtilities.addHTMLColor((String)sortItemText, (AttributeSet)CsmFontColorManager.instance().getColorAttributes("text/x-c++", FontColorProvider.Entity.PREPROCESSOR_DIRECTIVE));
        }
        return new CsmPreprocessorDirectiveCompletionItem(substitutionOffset, 15, sortItemText, appendItemText, coloredItemText, true);
    }

    public String getItemText() {
        return this.sortItemText + this.appendItemText;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        JTextComponent component;
        int caretOffset;
        int len;
        if (evt.getID() == 400 && (len = (caretOffset = (component = (JTextComponent)evt.getSource()).getSelectionEnd()) - this.substitutionOffset) < 0) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (this.supportInstantSubst) {
            this.defaultAction(component);
            return true;
        }
        return false;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(true), (String)this.getRightHtmlText(true), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getLeftHtmlText(false));
        out.append(this.getRightHtmlText(false));
        return out.toString();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public CharSequence getSortText() {
        return this.sortItemText;
    }

    public CharSequence getInsertPrefix() {
        return this.sortItemText;
    }

    protected ImageIcon getIcon() {
        return CsmImageLoader.getPreprocessorDirectiveIcon();
    }

    protected String getLeftHtmlText(boolean html) {
        return html ? this.htmlItemText : this.getItemText();
    }

    protected String getRightHtmlText(boolean html) {
        return "";
    }

    protected void substituteText(final JTextComponent c, final int offset, final int origLen) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        doc.runAtomicAsUser(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        if (origLen > 0) {
                            doc.remove(offset, origLen);
                        }
                        String itemText = CsmPreprocessorDirectiveCompletionItem.this.getItemText();
                        doc.insertString(offset, itemText, null);
                        if (c == null) break block6;
                        int setDot = offset + CsmPreprocessorDirectiveCompletionItem.this.getInsertPrefix().length();
                        c.setCaretPosition(setDot);
                        if (CsmPreprocessorDirectiveCompletionItem.this.appendItemText.length() <= 0) break block6;
                        Indent indent = Indent.get((Document)doc);
                        indent.lock();
                        try {
                            indent.reindent(offset, offset + itemText.length());
                        }
                        finally {
                            indent.unlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

