/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.BrowseFolders;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.MappingPanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.MappingsTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTablePanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MappingsTablePanel
extends DefaultTablePanel {
    private MappingsTableModel model;
    private HibernateCfgDataObject configDataObject;

    public MappingsTablePanel(HibernateCfgDataObject dObj, final MappingsTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.configDataObject = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MappingsTablePanel.this.configDataObject.modelUpdatedFromUI();
                int row = MappingsTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = this.add ? -1 : MappingsTablePanel.this.getTable().getSelectedRow();
            final MappingPanel dialogPanel = new MappingPanel(MappingsTablePanel.this.configDataObject);
            if (!this.add) {
                String resourceName = (String)MappingsTablePanel.this.model.getValueAt(row, 0);
                String fileName = (String)MappingsTablePanel.this.model.getValueAt(row, 1);
                String jarName = (String)MappingsTablePanel.this.model.getValueAt(row, 2);
                String packageName = (String)MappingsTablePanel.this.model.getValueAt(row, 3);
                String className = (String)MappingsTablePanel.this.model.getValueAt(row, 4);
                dialogPanel.initValues(resourceName, fileName, jarName, packageName, className);
            }
            this.addActionListeners(dialogPanel);
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(SecurityTablePanel.class, (String)"LBL_Mapping"), this.add){

                protected String validate() {
                    String resourceName = dialogPanel.getResourceName();
                    String fileName = dialogPanel.getFileName();
                    String jarName = dialogPanel.getJarName();
                    String packageName = dialogPanel.getPackageName();
                    String className = dialogPanel.getClassName();
                    if (resourceName.length() == 0 && fileName.length() == 0 && jarName.length() == 0 && packageName.length() == 0 && className.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Mapping_Empty");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(dialogPanel.isDataValid());
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getResourceTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getFileTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getJarTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getPacakgeTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getClassTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getResourceTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getFileTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getJarTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getPacakgeTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getClassTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                MappingsTablePanel.this.configDataObject.modelUpdatedFromUI();
                String resourceName = dialogPanel.getResourceName();
                String fileName = dialogPanel.getFileName();
                String jarName = dialogPanel.getJarName();
                String packageName = dialogPanel.getPackageName();
                String className = dialogPanel.getClassName();
                if (this.add) {
                    MappingsTablePanel.this.model.addRow(new String[]{resourceName, fileName, jarName, packageName, className});
                } else {
                    MappingsTablePanel.this.model.editRow(row, new String[]{resourceName, fileName, jarName, packageName, className});
                }
            }
        }

        private void addActionListeners(final MappingPanel dialogPanel) {
            dialogPanel.addPackageButtonListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = Util.getJavaSourceGroups(MappingsTablePanel.this.configDataObject);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String className = Util.getResourcePath(groups, fo, '.', true);
                            dialogPanel.getPacakgeTextField().setText(className);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            dialogPanel.addClassButtonActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = Util.getJavaSourceGroups(MappingsTablePanel.this.configDataObject);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String className = Util.getResourcePath(groups, fo);
                            dialogPanel.getClassTextField().setText(className);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

