/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerSupport;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.node.DockerInstanceChildFactory;
import org.netbeans.modules.docker.ui.node.DockerInstanceNode;
import org.netbeans.modules.docker.ui.node.NodeClosingFactory;
import org.netbeans.modules.docker.ui.node.StatefulDockerInstance;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class DockerChildFactory
extends NodeClosingFactory<StatefulDockerInstance>
implements ChangeListener {
    private static final RequestProcessor REFRESH_PROCESSOR = new RequestProcessor("Docker node update/refresh", 5);
    private final DockerSupport registry;

    public DockerChildFactory(DockerSupport registry) {
        this.registry = registry;
    }

    public void init() {
        REFRESH_PROCESSOR.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DockerChildFactory dockerChildFactory = DockerChildFactory.this;
                synchronized (dockerChildFactory) {
                    DockerChildFactory.this.registry.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)DockerChildFactory.this, (Object)DockerChildFactory.this.registry));
                    DockerChildFactory.this.updateState(new ChangeEvent(DockerChildFactory.this.registry));
                }
            }
        });
    }

    @Override
    public void stateChanged(final ChangeEvent e) {
        REFRESH_PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                DockerChildFactory.this.updateState(e);
            }
        });
    }

    private synchronized void updateState(ChangeEvent e) {
        this.refresh();
    }

    protected final void refresh() {
        this.refresh(false);
    }

    protected Node createNodeForKey(StatefulDockerInstance key) {
        return new DockerInstanceNode(key, new DockerInstanceChildFactory(key));
    }

    protected boolean createKeys(List<StatefulDockerInstance> toPopulate) {
        ArrayList fresh = new ArrayList(this.registry.getInstances());
        Collections.sort(fresh, UiUtils.getInstanceComparator());
        for (DockerInstance i : fresh) {
            toPopulate.add(new StatefulDockerInstance(i));
        }
        return true;
    }
}

