/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.classpath.BootClassPathImplementation;
import org.netbeans.modules.groovy.grailsproject.classpath.ProjectClassPathImplementation;
import org.netbeans.modules.groovy.grailsproject.classpath.SourcePathImplementation;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ClassPathProviderImpl
implements ClassPathProvider {
    private final GrailsProject project;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[9];
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(SourceRoots sourceRoots, SourceRoots testSourceRoots, GrailsProject project) {
        this.project = project;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
    }

    private synchronized FileObject getDir(String propname) {
        FileObject fo = this.dirCache.get(propname);
        return fo;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir("build.classes.dir");
    }

    private FileObject getBuildJar() {
        return this.getDir("dist.jar");
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir("build.test.classes.dir");
    }

    private int getType(FileObject file) {
        FileObject root;
        int i;
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 0;
        }
        srcPath = this.getTestSrcDir();
        for (i = 0; i < srcPath.length; ++i) {
            root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 1;
        }
        FileObject dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getBuildJar();
        if (dir != null && dir.equals(file)) {
            return 4;
        }
        dir = this.getBuildTestClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getCompileTimeClasspath(type);
    }

    private synchronized ClassPath getCompileTimeClasspath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[2 + type];
        if (cp == null) {
            this.cache[2 + type] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathImplementation.forProject(this.project));
        }
        return cp;
    }

    private synchronized ClassPath getRunTimeClasspath(FileObject file) {
        int type = this.getType(file);
        if (type < 0 || type > 4) {
            return null;
        }
        if (type > 1) {
            type -= 2;
        }
        ClassPath cp = this.cache[4 + type];
        return cp;
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    private synchronized ClassPath getSourcepath(int type) {
        if (type < 0 || type > 1) {
            return null;
        }
        ClassPath cp = this.cache[type];
        if (cp == null) {
            switch (type) {
                case 0: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)SourcePathImplementation.forProject(this.project, this.sourceRoots));
                    break;
                }
                case 1: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)SourcePathImplementation.forProject(this.project, this.testSourceRoots));
                }
            }
        }
        this.cache[type] = cp;
        return cp;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath cp = this.cache[7];
        if (cp == null) {
            this.cache[7] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)BootClassPathImplementation.forProject(this.project));
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getCompileTimeClasspath(0), this.getCompileTimeClasspath(1)};
            return l;
        }
        if ("classpath/source".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(1)};
            return l;
        }
        assert (false);
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/boot".equals(type)) {
            return this.getBootClassPath();
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        assert (false);
        return null;
    }
}

