/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.groovy.grailsproject.ui.customizer.GeneralCustomizerPanel;
import org.netbeans.modules.groovy.grailsproject.ui.customizer.GrailsProjectProperties;
import org.netbeans.modules.groovy.grailsproject.ui.customizer.LibrariesCustomizerPanel;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class GrailsProjectCustomizerProvider
implements CustomizerProvider {
    public static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-groovy-grailsproject/Customizer";
    private static final String GENERAL_CATEGORY = "GeneralCategory";
    private static final String LIBRARIES_CATEGORY = "LibrariesCategory";
    private static final String DEBUG_CATEGORY = "DebugCategory";
    private final Project project;

    public GrailsProjectCustomizerProvider(Project project) {
        this.project = project;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        GrailsProjectProperties uiProperties = new GrailsProjectProperties(this.project);
        Lookup context = Lookups.fixed((Object[])new Object[]{this.project, uiProperties});
        OptionListener optionListener = new OptionListener(this.project);
        StoreListener storeListener = new StoreListener(uiProperties);
        Dialog dialog = ProjectCustomizer.createCustomizerDialog((String)CUSTOMIZER_FOLDER_PATH, (Lookup)context, (String)preselectedCategory, (ActionListener)optionListener, (ActionListener)storeListener, null);
        dialog.addWindowListener(optionListener);
        dialog.setTitle(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        dialog.setVisible(true);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createGeneral() {
        return new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup context) {
                return ProjectCustomizer.Category.create((String)GrailsProjectCustomizerProvider.GENERAL_CATEGORY, (String)NbBundle.getMessage(GrailsProjectCustomizerProvider.class, (String)"LBL_GeneralSettings"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                return new GeneralCustomizerPanel((GrailsProjectProperties)context.lookup(GrailsProjectProperties.class));
            }
        };
    }

    public static ProjectCustomizer.CompositeCategoryProvider createLibraries() {
        return new ProjectCustomizer.CompositeCategoryProvider(){

            public ProjectCustomizer.Category createCategory(Lookup context) {
                return ProjectCustomizer.Category.create((String)GrailsProjectCustomizerProvider.LIBRARIES_CATEGORY, (String)NbBundle.getMessage(GrailsProjectCustomizerProvider.class, (String)"LBL_Libraries"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            }

            public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
                return new LibrariesCustomizerPanel((GrailsProjectProperties)context.lookup(GrailsProjectProperties.class));
            }
        };
    }

    private class StoreListener
    implements ActionListener {
        private final GrailsProjectProperties uiProperties;

        StoreListener(GrailsProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.uiProperties.save();
        }
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;

        OptionListener(Project project) {
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }
    }
}

