/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.callgraph;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.callgraph.CallImpl;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class VariableImpl
implements Function {
    private static final Map<CsmDeclaration.Kind, CsmDeclaration.Kind> preferredIcons = new HashMap<CsmDeclaration.Kind, CsmDeclaration.Kind>();
    private final CsmOffsetableDeclaration variable;
    private String htmlDisplayName = "";
    private String scopeName = null;
    private final PositionBounds positions;

    public VariableImpl(CsmOffsetableDeclaration variable) {
        this.variable = variable;
        this.positions = CsmUtilities.createPositionBounds((CsmOffsetable)variable);
    }

    public String getName() {
        return this.variable.getName().toString();
    }

    public String getScopeName() {
        if (this.scopeName == null) {
            this.scopeName = "";
            try {
                CsmClass cls;
                if (CsmKindUtilities.isField((CsmObject)this.variable) && (cls = ((CsmField)this.variable).getContainingClass()) != null && cls.getName().length() > 0) {
                    this.scopeName = cls.getName().toString() + "::";
                }
            }
            catch (AssertionError ex) {
                ((Throwable)((Object)ex)).printStackTrace(System.err);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.scopeName;
    }

    public CsmOffsetableDeclaration getVariable() {
        return this.variable;
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName.length() == 0) {
            this.htmlDisplayName = this.createHtmlDisplayName();
        }
        return this.htmlDisplayName;
    }

    private String createHtmlDisplayName() {
        String displayName = this.variable.getName().toString();
        try {
            CsmClass cls;
            if (CsmKindUtilities.isField((CsmObject)this.variable) && (cls = ((CsmField)this.variable).getContainingClass()) != null && cls.getName().length() > 0) {
                String name = CsmDisplayUtilities.htmlize((CharSequence)cls.getName().toString());
                String in = NbBundle.getMessage(CallImpl.class, (String)"LBL_inClass");
                return displayName + "<font color='!textInactiveText'>  " + in + " " + name;
            }
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return displayName;
    }

    public String getDescription() {
        return this.getScopeName() + this.getName();
    }

    public Image getIcon() {
        try {
            return CsmImageLoader.getImage((CsmObject)this.variable, preferredIcons);
        }
        catch (AssertionError ex) {
            ((Throwable)((Object)ex)).printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    public void open() {
        CsmUtilities.openSource((PositionBounds)this.positions);
    }

    public boolean equals(Object obj) {
        if (this.variable != null && obj instanceof VariableImpl) {
            return this.variable.equals(((VariableImpl)obj).getVariable());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.variable != null) {
            return this.variable.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isVurtual() {
        return false;
    }

    public Function.Kind kind() {
        if (CsmKindUtilities.isVariable((CsmObject)this.variable) && CsmKindUtilities.isFunctionPointerType((CsmObject)((CsmVariable)this.variable).getType())) {
            return Function.Kind.FUNCTION_POINTER;
        }
        return Function.Kind.VARIABLE;
    }

    static {
        preferredIcons.put(CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION);
    }
}

