/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;

public final class NbDateRange
implements Comparable<NbDateRange> {
    private final DateRange delegate;

    NbDateRange(DateRange delegate) {
        this.delegate = delegate;
    }

    public NbDateRange(Calendar startDate, Calendar endDate) {
        this(new DateRange(startDate, endDate));
    }

    public NbDateRange(Calendar time) {
        this(new DateRange(time));
    }

    public NbDateRange(IssueScheduleInfo info) {
        this(NbDateRange.toDateRange(info));
    }

    @Override
    public int compareTo(NbDateRange o) {
        return this.getDelegate().compareTo(o.getDelegate());
    }

    public Calendar getStartDate() {
        return this.delegate.getStartDate();
    }

    public Calendar getEndDate() {
        return this.delegate.getEndDate();
    }

    DateRange getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NbDateRange)) {
            return false;
        }
        return this.delegate.equals((Object)((NbDateRange)obj).getDelegate());
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public IssueScheduleInfo toSchedulingInfo() {
        Calendar startDate = this.getStartDate();
        Calendar endDate = this.getEndDate();
        int difference = (int)((endDate.getTimeInMillis() - startDate.getTimeInMillis()) / 1000L / 3600L / 24L) + 1;
        return new IssueScheduleInfo(startDate.getTime(), difference);
    }

    private static DateRange toDateRange(IssueScheduleInfo info) {
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(info.getDate());
        endDate.setTime(new Date(info.getDate().getTime() + (long)((info.getInterval() * 24 * 3600 - 1) * 1000)));
        return new DateRange(startDate, endDate);
    }
}

